/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.HyperCDP;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import java.util.List;

public class RollbackSnapshotCgSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6601077027821310024L;
    private String deviceId;
    private String srcCgGroupID;
    private int protectType;

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        this.updateProcessNameParams(new String[]{this.getSrcCgGroupID()});
        String restoreSpeed = (String)context.getRecoveryPlan().getGlobalSettings().get("ROLLBACK_RATE");
        if (this.protectType == ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue()) {
            IStorageHyperCDPGroupManager storageHyperCDPGroupManager = StorageHyperCDPGroupManagerProxy.getInstance().getStorageHyperCDPGroupMgrByDevId(this.getDeviceId());
            storageHyperCDPGroupManager.restore(this.getDeviceId(), this.getSrcCgGroupID(), restoreSpeed);
            IStorageHyperCDPManager storageHyperCDPManager = StorageHyperCDPManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.getDeviceId());
            List hyperCDPList = storageHyperCDPManager.getHyperCDPByCGId(this.getDeviceId(), this.getSrcCgGroupID());
            for (HyperCDP hyperCDP : hyperCDPList) {
                context.getProcessResult().addProcessResult(RecoveryProcessResult.getRollbackSnapshotResultKey((String)this.getDeviceId(), (String)String.valueOf(hyperCDP.getSrcResourceId()), (String)hyperCDP.getSnapshotId()), true);
            }
        } else if (this.protectType == ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue()) {
            IStorageSnapshotGroupManager storageSnapshotGroupManager = StorageSnapshotGroupManagerProxy.getInstance().getStorageSnapshotGroupMgrByDevId(this.getDeviceId());
            storageSnapshotGroupManager.restore(this.getDeviceId(), this.getSrcCgGroupID(), restoreSpeed);
            IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.getDeviceId());
            List snapshotList = proxy.querySnapshots(this.getDeviceId(), XveMOType.SNAPSHOT_CONSISTENCY_GROUP, this.getSrcCgGroupID());
            for (Snapshot snapshot : snapshotList) {
                context.getProcessResult().addProcessResult(RecoveryProcessResult.getRollbackSnapshotResultKey((String)this.getDeviceId(), (String)String.valueOf(snapshot.getSrcResourceId()), (String)snapshot.getSnapshotId()), true);
            }
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSrcCgGroupID() {
        return this.srcCgGroupID;
    }

    public void setSrcCgGroupID(String srcCgGroupID) {
        this.srcCgGroupID = srcCgGroupID;
    }

    public int getProtectType() {
        return this.protectType;
    }

    public void setProtectType(int protectType) {
        this.protectType = protectType;
    }
}

