/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process.snapshot;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.snapshot.CreateSnapshotBackupCopyProcessor;
import com.huawei.ism.drm.storage.recovery.process.snapshot.CreateSnapshotBackupCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.util.RecoveryProcessorContextUtil;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateSourceSnapshotBackupCopyProcessor
extends CreateSnapshotBackupCopyProcessor {
    private static final long serialVersionUID = -1839159257468617267L;
    private static final Log LOGGER = LogFactory.getInstance(CreateSourceSnapshotBackupCopyProcessor.class);

    @Override
    protected void executeSubProcessors(RecoveryProcessorContext context) {
        super.executeSubProcessors(context);
        this.activeSnapshot(context, this.getChildProc());
    }

    @Override
    protected Set<RecoveryProcessor> createProcessors(RecoveryProcessorContext context) {
        context.setAttribute("batch_active_snapshot", (Object)"true");
        HashSet<RecoveryProcessor> mapping = new HashSet<RecoveryProcessor>();
        List<String> wwnList = RecoveryProcessorContextUtil.getStorageWwn(context);
        if (this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            mapping.addAll(this.buildCreateSnapshotSubProcessorFromHyperMetroPair(wwnList));
        }
        if (mapping.isEmpty()) {
            mapping.addAll(this.buildCreateSnapshotSubProcessorFromReplication(wwnList));
        }
        return mapping;
    }

    @Override
    protected Set<CreateSnapshotBackupCopySubProcessor> buildCreateSnapshotSubProcessorFromReplication(List<String> wwnList) {
        if (wwnList.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<CreateSnapshotBackupCopySubProcessor> devSnAndLunMapping = new HashSet<CreateSnapshotBackupCopySubProcessor>();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List pairs = storageService.queryReplicationPairsByMasterLunWWN(wwnList, true);
        if (this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            devSnAndLunMapping.addAll(this.loadDevSnAndLunIdMappingFromSourceLocation(pairs));
        }
        return devSnAndLunMapping;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.snapshot.CreateSourceSnapshotBackupCopyProcessor.des");
    }

    private void activeSnapshot(RecoveryProcessorContext context, Set<RecoveryProcessor> createSnapshotSubProcessors) {
        createSnapshotSubProcessors.stream().map(CreateSnapshotBackupCopySubProcessor.class::cast).collect(Collectors.groupingBy(CreateSnapshotBackupCopySubProcessor::getDevSn)).forEach((key, value) -> this.activeSnapshot((String)key, value.stream().map(CreateSnapshotBackupCopySubProcessor::getSnapshotId).collect(Collectors.toList())));
    }

    private void activeSnapshot(String devSn, List<String> snapshotIds) {
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String deviceType = recoveryService.getStorageType(devSn);
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        long startTime = System.currentTimeMillis();
        OperationResult operationResult = proxy.activeSnapshotAfterStop(devSn, snapshotIds);
        LOGGER.info((Object)"Active snapshot cost time: devSn=%s, costTime=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), System.currentTimeMillis() - startTime});
        if (operationResult != null && !operationResult.isSuccess()) {
            this.updateProcessDetail("lego.err." + operationResult.getErrorCode(), operationResult.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else if (operationResult != null) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            LOGGER.info((Object)"Result for ActiveSnapshot is null.");
        }
    }
}

