/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.service.fusion;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReplicationManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.atomic.IStorageReplicationAtomicService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public interface IStorageReplicationFusionService
extends IStorageReplicationManager,
IStorageReplicationAtomicService {
    public static final Log logger = LogFactory.getInstance(IStorageReplicationFusionService.class);
    public static final String STANDBY = "110";

    public static void updateDRRingIdOfPairInGroups(Collection<ReplicationRelation> groups) {
        Collection<ReplicationRelation> members = IStorageReplicationFusionService.getDRRingReplicationRelations(groups);
        for (ReplicationRelation member : members) {
            IStorageReplicationFusionService.updateDRRingIdOfPairInGroup(member);
        }
    }

    public static Collection<ReplicationRelation> getDRRingReplicationRelations(Collection<ReplicationRelation> relations) {
        HashSet<ReplicationRelation> results = new HashSet<ReplicationRelation>();
        for (ReplicationRelation relation : relations) {
            if (relation == null || relation.getDrRingId() == null) continue;
            results.add(relation);
        }
        return results;
    }

    public static void updateDRRingIdOfPairInGroup(ReplicationRelation group) {
        if (group == null) {
            return;
        }
        String drRingId = group.getDrRingId();
        String sn = group.getDevSn();
        String cgId = group.getReplicationId();
        if (drRingId == null || sn == null) {
            return;
        }
        HibernateTemplate temp = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        List pairs = temp.find("from ReplicationPair as pair where pair.consistentGroupId = ? and pair.devSn = ?", (Object[])new String[]{cgId, sn});
        if (!VerifyUtil.isEmpty((Collection)pairs)) {
            for (ReplicationPair replicationPair : pairs) {
                replicationPair.setDrRingId(drRingId);
                temp.update((Object)replicationPair);
            }
        }
    }

    public static boolean isSuccess(OperationResult result) {
        return null != result && result.isSuccess();
    }

    public ReplicationRelation getReplication(String var1, String var2, String var3, boolean var4);

    public void dispatchCommand(String var1, String var2, Object var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void updateSyncInfo(List<ReplicationTargetLun> tgtLunList) {
        if (VerifyUtil.isEmpty(tgtLunList)) {
            logger.error((Object)"tgtLunList is null");
            return;
        }
        String devsn = tgtLunList.iterator().next().getDevSn();
        OperationLock lock = DeviceOperationLock.getLock((String)devsn);
        if (!lock.tryLock()) {
            logger.info((Object)"The device (devsn: %s)  is locked, due to the storage device may be refreshing", new Object[]{devsn});
            return;
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        String hql = "update ReplicationTargetLun set pairStatus=:pairStatus, progressRatio=:progressRatio where uuid=:uuid";
        String uuid = null;
        try {
            session.beginTransaction();
            for (ReplicationTargetLun tgtLun : tgtLunList) {
                String tgtLunId = tgtLun.getTgtLunId();
                String devSn = tgtLun.getDevSn();
                String tgtDevSn = tgtLun.getTgtDevSN();
                uuid = DrmStorageUtil.generateTargetLunMoUuid((String)tgtLunId, (String)XveMOType.REMOTEREPLICATIONMEMBERLUN.name(), (String)devSn, (String)tgtDevSn, (String)tgtLun.getReplicationPairId());
                Integer pairStatus = tgtLun.getPairStatus();
                Integer progressRatio = tgtLun.getProgressRatio();
                Query query = session.createQuery(hql);
                query.setInteger("pairStatus", pairStatus.intValue());
                query.setParameter("progressRatio", (Object)progressRatio);
                query.setString("uuid", uuid);
                query.executeUpdate();
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession((Session)session);
            logger.error((Object)("Exception while updating targetLun synchronizing status/progress, uuid:" + uuid + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
            lock.unTryLock();
        }
    }

    default public OperationResult processCommand(String deviceId, String operationName, String url, JSONObject bodyJson) {
        OperationResult operationResult;
        try {
            this.dispatchCommand(deviceId, url, bodyJson);
            operationResult = new OperationResult(operationName, true, true, "", new String[]{deviceId});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Processing command failed. url:" + url + ", CmdDevId:" + deviceId), (Throwable)e, 90160758784001L);
            operationResult = new OperationResult(operationName, true, false, String.valueOf(e.getErrorCode()), new String[]{deviceId});
        }
        catch (Exception e) {
            logger.error((Object)("Processing command failed. url:" + url + ", CmdDevId:" + deviceId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            operationResult = new OperationResult(operationName, true, false, String.valueOf(-1L), new String[]{deviceId});
        }
        return operationResult;
    }

    default public OperationResult syncOnce(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        OperationResult result;
        logger.debug((Object)"sync replication pair or cg start. sourceArrayId=%s, targetArrayId=%s, replicationId=%s, isConsistentGroup=%s", new Object[]{sourceArrayId, targetArrayId, replicationId, isConsistentGroup});
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        VerifyUtil.checkObject((Object)relation);
        if (null != relation.getRunningState() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() == NumberUtil.convertToInteger((Object)relation.getRunningState()).intValue()) {
            logger.debug((Object)"replication relation is SYNCHRONIZING. Skip synchronous.");
            if (relation instanceof ReplicationGroup) {
                return new OperationResult("ism.business.replication.syncReplicationGroup", true, true, "", new String[]{relation.getDevSn()});
            }
            return new OperationResult("ism.business.replication.syncReplicationPair", true, true, "", new String[]{relation.getDevSn()});
        }
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"ID", (Object)replicationId);
        if (relation instanceof ReplicationGroup) {
            bodyJson.put((Object)"TYPE", (Object)String.valueOf(XveMOType.CONSISTENTGROUP.getValue()));
            result = this.processCommand(relation.getDevSn(), "ism.business.replication.syncReplicationGroup", "/SYNCHRONIZE_CONSISTENCY_GROUP", bodyJson);
        } else {
            bodyJson.put((Object)"TYPE", (Object)String.valueOf(XveMOType.REPLICATIONPAIR.getValue()));
            result = this.processCommand(relation.getDevSn(), "ism.business.replication.syncReplicationPair", "/REPLICATIONPAIR/sync", bodyJson);
        }
        logger.debug((Object)"sync replication pair or cg finished. replication[Id=%s]  sync result is %s", new Object[]{replicationId, IStorageReplicationFusionService.isSuccess(result)});
        return result;
    }

    default public OperationResult splitReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        logger.debug((Object)"split replication start. sourceArrayId=%s, targetArrayId=%s, replicationId=%s, isConsistentGroup=%s", new Object[]{sourceArrayId, targetArrayId, replicationId, isConsistentGroup});
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        VerifyUtil.checkObject((Object)relation);
        String operation = relation instanceof ReplicationGroup ? "ism.business.replication.splitReplicationGroup" : "ism.business.replication.splitReplicationPair";
        ReplicationRelation replicaStatus = this.queryReplicationRelation(relation.getDevSn(), replicationId, isConsistentGroup);
        if (null == replicaStatus) {
            OperationResult result = new OperationResult(operation, true, false, new String[]{replicationId});
            logger.error((Object)"query replication[Id=%s, devSn=%s, isCG=%s] failed, replicaStatus is null.", new Object[]{replicationId, relation.getDevSn(), isConsistentGroup});
            return result;
        }
        if (replicaStatus.getRunningState().equals(STANDBY)) {
            logger.error((Object)"replicaStatus is standby. Skip split. devSn=%s, replicationId=%s.", new Object[]{replicaStatus.getDevSn(), replicationId});
            OperationResult result = new OperationResult(operation, true, true, new String[]{replicaStatus.getDevSn()});
            return result;
        }
        if (null != relation.getRunningState() && XveEuumDefineParent.RUNNING_STATUS_E.SPLIT.getValue() == NumberUtil.convertToInteger((Object)relation.getRunningState()).intValue()) {
            logger.debug((Object)"replication relation is split. Skip split.");
            if (relation instanceof ReplicationGroup) {
                return new OperationResult("ism.business.replication.splitReplicationGroup", true, true, "", new String[]{relation.getDevSn()});
            }
            return new OperationResult("ism.business.replication.splitReplicationPair", true, true, "", new String[]{relation.getDevSn()});
        }
        OperationResult result = relation instanceof ReplicationGroup ? this.splitReplicationGroup(relation.getDevSn(), replicationId) : this.splitReplicationPair(relation.getDevSn(), replicationId);
        logger.debug((Object)"split replication finished. replication[Id=%s]  split result is %s", new Object[]{replicationId, IStorageReplicationFusionService.isSuccess(result)});
        return result;
    }

    default public OperationResult switchReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        OperationResult result;
        logger.debug((Object)"switch replication start. sourceArrayId=%s, targetArrayId=%s, replicationId=%s, isConsistentGroup=%s", new Object[]{sourceArrayId, targetArrayId, replicationId, isConsistentGroup});
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        VerifyUtil.checkObject((Object)relation);
        if (relation instanceof ReplicationGroup) {
            result = this.splitReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
            if (IStorageReplicationFusionService.isSuccess(result) && IStorageReplicationFusionService.isSuccess(result = this.setLunWriteProtection(relation.getDevSn(), replicationId, isConsistentGroup, 3))) {
                result = this.switchReplicationGroup(relation.getDevSn(), replicationId);
            }
        } else {
            result = this.splitReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
            if (IStorageReplicationFusionService.isSuccess(result) && IStorageReplicationFusionService.isSuccess(result = this.setLunWriteProtection(relation.getDevSn(), replicationId, isConsistentGroup, 3))) {
                result = this.switchReplicationPair(relation.getDevSn(), replicationId);
            }
        }
        logger.debug((Object)"switch replication finished. replication[Id=%s]  split result is %s", new Object[]{replicationId, IStorageReplicationFusionService.isSuccess(result)});
        return result;
    }

    default public OperationResult forceSwitchReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        logger.debug((Object)"force switch replication. sourceArrayId=%s, targetArrayId=%s, replicationId=%s, isConsistentGroup=%s", new Object[]{sourceArrayId, targetArrayId, replicationId, isConsistentGroup});
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        VerifyUtil.checkObject((Object)relation);
        relation.setDevSn(targetArrayId);
        this.splitReplication(targetArrayId, targetArrayId, replicationId, isConsistentGroup);
        return this.setLunWriteProtection(relation.getDevSn(), replicationId, isConsistentGroup, 3);
    }

    default public OperationResult setSecondaryLunReadWrite(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        logger.debug((Object)"set secondary lun ReadWrite. sourceArrayId=%s, targetArrayId=%s, replicationId=%s, isConsistentGroup=%s", new Object[]{sourceArrayId, targetArrayId, replicationId, isConsistentGroup});
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        VerifyUtil.checkObject((Object)relation);
        relation.setDevSn(targetArrayId);
        OperationResult result = this.splitReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        if (IStorageReplicationFusionService.isSuccess(result)) {
            logger.debug((Object)"set secondary lun ReadWrite. split replication success.");
            result = this.setLunWriteProtection(relation.getDevSn(), replicationId, isConsistentGroup, 3);
        }
        return result;
    }

    default public OperationResult reverseReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        logger.debug((Object)"reverse replication. sourceArrayId=%s, targetArrayId=%s, replicationId=%s, isConsistentGroup=%s", new Object[]{sourceArrayId, targetArrayId, replicationId, isConsistentGroup});
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        VerifyUtil.checkObject((Object)relation);
        String cmdDevSN = relation.getDevSn();
        return isConsistentGroup ? this.switchReplicationGroup(cmdDevSN, replicationId) : this.switchReplicationPair(cmdDevSN, replicationId);
    }

    @Override
    default public OperationResult splitReplicationGroup(String sn, String replicationId) {
        logger.debug((Object)"send split replication group command to sn[%s]: cgId=%s .", new Object[]{sn, replicationId});
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"ID", (Object)replicationId);
        bodyJson.put((Object)"TYPE", (Object)String.valueOf(XveMOType.CONSISTENTGROUP.getValue()));
        return this.processCommand(sn, "ism.business.replication.splitReplicationGroup", "/SPLIT_CONSISTENCY_GROUP", bodyJson);
    }

    default public void refresh(String sn, List<String> ids, boolean isCg) {
        logger.info((Object)("Enter refresh repliations, sn=" + sn + ", ids=" + ids + ", isCg=" + isCg));
        if (VerifyUtil.isEmpty((String)sn) || VerifyUtil.isEmpty(ids)) {
            logger.info((Object)"sn or id list is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageUnit storageUnit = (StorageUnit)moDao.getMo(StorageUnit.class, "devSn", (Object)sn);
        ArrayList<ReplicationRelation> replications = new ArrayList<ReplicationRelation>();
        ArrayList<String> uuids = new ArrayList<String>();
        for (String id : ids) {
            ReplicationRelation replication = this.queryReplicationRelation(sn, id, isCg);
            if (null == replication) {
                logger.warn((Object)("replication not exsit, id=" + id));
                continue;
            }
            replications.add(replication);
            replication.setParentMo((ManagedObject)storageUnit);
            replication.setTopMoUuid(storageUnit.getTopMoUuid());
            uuids.add(replication.getUuid());
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", sn);
        props.put("replicationId", ids.toArray());
        props.put("relationType", isCg ? 1 : 0);
        List replicationsInDb = moDao.findMoBy(ReplicationRelation.class, props);
        ArrayList<Long> deletedMoIds = new ArrayList<Long>();
        for (ReplicationRelation rel : replicationsInDb) {
            if (uuids.contains(rel.getUuid())) continue;
            deletedMoIds.add(rel.getMoId());
        }
        logger.info((Object)("Replications to be removed, moids=" + deletedMoIds));
        moDao.deleteMoWithoutMsg(deletedMoIds);
        logger.info((Object)("Replications to be saved, " + replications));
        for (ReplicationRelation rel : replications) {
            moDao.addMoAndSubMoWithoutMsg((ManagedObject)rel, new HashMap());
        }
        if (isCg) {
            IStorageReplicationFusionService.updateDRRingIdOfPairInGroups(replications);
        }
        logger.info((Object)"Exit refresh repliations.");
    }

    default public OperationResult setLunWriteProtection(String commandDevSN, String replicationId, boolean isConsistentGroup, int secResAccess) {
        OperationResult result;
        logger.debug((Object)"set lun write protection start. commandDevSN=%s, replicationId=%s, isConsistentGroup=%s, secResAccess=%d", new Object[]{commandDevSN, replicationId, isConsistentGroup, secResAccess});
        ReplicationRelation repRelation = this.queryReplicationRelation(commandDevSN, replicationId, isConsistentGroup);
        if (null == repRelation) {
            logger.error((Object)"set lun write protection fail. replication[id=%s, devSn=%s, isCG=%s] is null.", new Object[]{replicationId, commandDevSN, isConsistentGroup});
            OperationResult result2 = new OperationResult("ism.business.replication.query", true, false, String.valueOf(1073948466L), new String[0]);
            return result2;
        }
        Integer localResType = repRelation.getLocalResType();
        if (null != localResType && 40 == localResType) {
            logger.debug((Object)"localResType is  file system");
            result = this.setTargetFileSystemAccessAttr(commandDevSN, replicationId, isConsistentGroup, secResAccess);
        } else {
            result = this.setTargetLunAccessAttr(commandDevSN, replicationId, isConsistentGroup, secResAccess);
        }
        logger.debug((Object)"set lun write protection finished. replication[Id=%s] set write protection result is %s", new Object[]{replicationId, IStorageReplicationFusionService.isSuccess(result)});
        return result;
    }

    default public OperationResult setTargetLunAccessAttr(String commandDevSN, String replicationId, boolean isConsistentGroup, int secResAccess) {
        logger.debug((Object)"set target lun access attr. commandDevSN=%s, replicationId=%s, isConsistentGroup=%s, secResAccess=%d", new Object[]{commandDevSN, replicationId, isConsistentGroup, secResAccess});
        OperationResult result = isConsistentGroup ? this.setReplicationGroupTargetLunAccessAttr(commandDevSN, replicationId, secResAccess) : this.setReplicationPairTargetLunAccessAttr(commandDevSN, replicationId, secResAccess);
        logger.debug((Object)"set target lun access attr finished. replication[Id=%s] set write protection result is %s", new Object[]{replicationId, IStorageReplicationFusionService.isSuccess(result)});
        return result;
    }

    default public OperationResult setReplicationGroupTargetLunAccessAttr(String sn, String id, int secResAccess) {
        logger.debug((Object)"send set replication group target lun access attr command to sn[%s]: cgId=%s, attr=%d .", new Object[]{sn, id, secResAccess});
        JSONObject data = new JSONObject();
        data.put((Object)"ID", (Object)id);
        data.put((Object)"SECRESACCESS", (Object)String.valueOf(secResAccess));
        data.put((Object)"TYPE", (Object)String.valueOf(XveMOType.CONSISTENTGROUP.getValue()));
        return this.processCommand(sn, "ism.business.replication.setTargetResAccessAttr", "/CONSISTENTGROUP/" + id, data);
    }

    default public OperationResult setReplicationPairTargetLunAccessAttr(String sn, String id, int secResAccess) {
        logger.debug((Object)"send set replication pair target lun access attr command to sn[%s]: pairId=%s, attr=%d .", new Object[]{sn, id, secResAccess});
        JSONObject data = new JSONObject();
        data.put((Object)"ID", (Object)id);
        data.put((Object)"SECRESACCESS", (Object)String.valueOf(secResAccess));
        data.put((Object)"TYPE", (Object)String.valueOf(XveMOType.REPLICATIONPAIR.getValue()));
        return this.processCommand(sn, "ism.business.replication.setTargetResAccessAttr", "/REPLICATIONPAIR/" + id, data);
    }

    default public OperationResult setTargetFileSystemAccessAttr(String commandDevSN, String replicationId, boolean isConsistentGroup, int secResAccess) {
        logger.debug((Object)"set target file system access attr. commandDevSN=%s, replicationId=%s, isConsistentGroup=%s, secResAccess=%d", new Object[]{commandDevSN, replicationId, isConsistentGroup, secResAccess});
        StringBuilder requestURI = new StringBuilder();
        JSONObject data = new JSONObject();
        data.put((Object)"ID", (Object)replicationId);
        if (isConsistentGroup) {
            data.put((Object)"TYPE", (Object)String.valueOf(XveMOType.CONSISTENTGROUP.getValue()));
            requestURI.append("/CONSISTENTGROUP/");
        } else {
            data.put((Object)"TYPE", (Object)String.valueOf(XveMOType.REPLICATIONPAIR.getValue()));
            requestURI.append("/REPLICATIONPAIR/");
        }
        if (2 == secResAccess) {
            requestURI.append("SET_SECODARY_WRITE_LOCK");
        } else if (3 == secResAccess) {
            requestURI.append("CANCEL_SECODARY_WRITE_LOCK");
        } else {
            logger.error((Object)"set target file system access attr fail, secResAccess is illegal. commandDevSN=%s, replicationId=%s, isConsistentGroup=%s, secResAccess=%d", new Object[]{commandDevSN, replicationId, isConsistentGroup, secResAccess});
            throw new LegoUnsupportedOperationException("The operation is not supported. Attr:" + secResAccess);
        }
        OperationResult result = this.processCommand(commandDevSN, "ism.business.replication.setTargetResAccessAttr", requestURI.toString(), data);
        logger.debug((Object)"set target file system access attr finished. replication[Id=%s] set write protection result is %s.", new Object[]{replicationId, result.isSuccess()});
        return result;
    }

    @Override
    default public OperationResult splitReplicationPair(String sn, String id) {
        logger.debug((Object)"send split replication pair command to sn[%s]. pairId=%s .", new Object[]{sn, id});
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"ID", (Object)id);
        bodyJson.put((Object)"TYPE", (Object)String.valueOf(XveMOType.REPLICATIONPAIR.getValue()));
        return this.processCommand(sn, "ism.business.replication.splitReplicationPair", "/REPLICATIONPAIR/split", bodyJson);
    }

    @Override
    default public OperationResult switchReplicationGroup(String sn, String replicationId) {
        logger.debug((Object)"send switch replication group command to sn[%s]:cgId=%s .", new Object[]{sn, replicationId});
        JSONObject data = new JSONObject();
        data.put((Object)"TYPE", (Object)String.valueOf(XveMOType.CONSISTENTGROUP.getValue()));
        data.put((Object)"ID", (Object)replicationId);
        return this.processCommand(sn, "ism.business.replication.switchReplicationPair", "/SWITCH_GROUP_ROLE", data);
    }

    @Override
    default public OperationResult switchReplicationPair(String sn, String id) {
        logger.debug((Object)"send switch replication pair command to sn[%s]: pairId =%s .", new Object[]{sn, id});
        JSONObject data = new JSONObject();
        data.put((Object)"TYPE", (Object)String.valueOf(XveMOType.REPLICATIONPAIR.getValue()));
        data.put((Object)"ID", (Object)id);
        return this.processCommand(sn, "ism.business.replication.switchReplicationPair", "/REPLICATIONPAIR/switch", data);
    }

    default public List<ReplicationPair> queryReplicationPairByCgId(String devSN, String cgId) {
        throw new UnsupportedOperationException();
    }

    default public void refresh(String sn, List<String> ids) {
        logger.info((Object)"refresh lun of repliations.");
    }
}

