/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.topology.HyperMetroGlobalTopoBuilder;
import com.huawei.ism.drm.topo.builder.GeneralGlobalTopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-20##Global-Topology-24##Global-Topology-32")
public class ArrayRepHyperMetorGlobalTopoBuilder
extends HyperMetroGlobalTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(ArrayRepHyperMetorGlobalTopoBuilder.class);

    @Override
    public void buildTopo(TopoBaseContext context) {
        GeneralGlobalTopoBuilder arrayRepBuilder = this.createGeneralGlobalTopoBuilder();
        arrayRepBuilder.buildTopo(context);
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectGroup protectGroupAllInfo = context.getProtectGroupService().getProtectGroupByID(protectGroup.getUuid());
        ArrayList<Node> storageNodeList = new ArrayList();
        Object obj = context.find((Object)"hyperValutArrayList");
        if (!VerifyUtil.isEmpty((Object)obj)) {
            storageNodeList = (List)obj;
        } else if (this.buildStorageNodeList(context, layout, protectGroupAllInfo, storageNodeList)) {
            return;
        }
        this.createHyperMetroLink(context, protectGroupAllInfo, layout, storageNodeList);
    }

    private boolean buildStorageNodeList(TopoBaseContext context, ElementBox layout, ProtectGroup protectGroupAllInfo, List<Node> storageNodeList) {
        Set replicas = protectGroupAllInfo.getReplicaList();
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)CommonUtil.getFirstElement((Collection)replicas);
        if (VerifyUtil.isEmpty((Object)pgReplica)) {
            LOGGER.error((Object)("the replicas is null, pgUUID is: " + protectGroupAllInfo.getUuid()));
            return true;
        }
        Map<String, ProtectObjectReplica> poReplicaByDevSn = this.classifyPoReplicaByDevSn(pgReplica.getReplicas());
        for (Map.Entry<String, ProtectObjectReplica> entry : poReplicaByDevSn.entrySet()) {
            ProtectObjectReplica poReplica = entry.getValue();
            if (VerifyUtil.isEmpty((Object)poReplica)) {
                LOGGER.error((Object)"the poReplica is null, pgReplicaUUID is: %s", new Object[]{pgReplica.getId()});
                return true;
            }
            if (!this.buildStorageNode(context, layout, storageNodeList, poReplica)) continue;
            return true;
        }
        return poReplicaByDevSn.isEmpty();
    }

    private boolean buildStorageNode(TopoBaseContext context, ElementBox layout, List<Node> storageNodeList, ProtectObjectReplica poReplica) {
        List<String> lunIdList;
        RelicaStorageInfo storageInfo = (RelicaStorageInfo)CommonUtil.getFirstElement((Collection)poReplica.getStorageInfos());
        String targetArraySn = storageInfo.getStorageProviderSN();
        if (VerifyUtil.isEmpty((Object)storageInfo)) {
            LOGGER.error((Object)"the storageInfo is null, poReplicaUUID is: %s", new Object[]{poReplica.getId()});
            return true;
        }
        String targetLunId = storageInfo.getStorageId();
        DrResource targetResource = this.getDrResourceInContext(context, targetArraySn);
        Site site = this.getSiteInContext(context, targetResource.getSiteId());
        List targetLunList = this.getResourceListFromDB(site, targetArraySn, lunIdList = Collections.singletonList(targetLunId));
        if (VerifyUtil.isEmpty((Collection)targetLunList)) {
            LOGGER.error((Object)("The targetLun is null: targetArraySn=" + targetArraySn + ", targetLunId=" + targetLunId));
            return true;
        }
        Lun targetLun = null;
        for (StorageResource resource : targetLunList) {
            if (!(resource instanceof Lun)) continue;
            targetLun = (Lun)resource;
            break;
        }
        if (VerifyUtil.isEmpty(targetLun)) {
            LOGGER.error((Object)"The resource is not Lun: targetArraySn=%s, targetLunId=%s", new Object[]{targetArraySn, targetLunId});
            return true;
        }
        List lunList = context.getStorageService().getStorageResourceByWwn(new String[]{targetLun.getWwn()});
        lunList = Optional.ofNullable(lunList).orElseGet(ArrayList::new);
        for (StorageResource lun : lunList) {
            if (!(lun instanceof Lun)) continue;
            String devSn = lun.getDevSn();
            DrStorage drStorage = (DrStorage)this.getDrResourceInContext(context, devSn);
            Node storageNode = this.createStorage(context, context.getProtectGroup(), drStorage, layout);
            storageNodeList.add(storageNode);
        }
        return false;
    }

    private Map<String, ProtectObjectReplica> classifyPoReplicaByDevSn(Set<ProtectObjectReplica> replicas) {
        HashMap<String, ProtectObjectReplica> poReplicaByDevSn = new HashMap<String, ProtectObjectReplica>();
        for (ProtectObjectReplica poReplica : replicas) {
            RelicaStorageInfo storageInfo = (RelicaStorageInfo)CommonUtil.getFirstElement((Collection)poReplica.getStorageInfos());
            String devSnKey = storageInfo.getSrcStorageProviderSN() + ":" + storageInfo.getStorageProviderSN();
            if (poReplicaByDevSn.containsKey(devSnKey)) continue;
            poReplicaByDevSn.put(devSnKey, poReplica);
        }
        return poReplicaByDevSn;
    }

    protected GeneralGlobalTopoBuilder createGeneralGlobalTopoBuilder() {
        return new GeneralGlobalTopoBuilder();
    }
}

