/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.topology.ArrayReplicationTopoBuilder;
import com.huawei.ism.drm.storage.topology.HyperMetroGlobalTopoBuilder;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.topo.builder.GeneralGlobalTopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-35##Global-Topology-36##Global-Topology-58##Global-Topology-59##Global-Topology-40##Global-Topology-41##Global-Topology-42##Global-Topology-43")
public class WholeGeneral4DCGlobalTopoBuilder
extends HyperMetroGlobalTopoBuilder {
    private static final Log logger = LogFactory.getInstance(WholeGeneral4DCGlobalTopoBuilder.class);

    @Override
    public void buildTopo(TopoBaseContext context) {
        GeneralGlobalTopoBuilder arrayRepBuilder = new GeneralGlobalTopoBuilder();
        arrayRepBuilder.buildTopo(context);
        ProtectGroup protectGroup = context.getProtectGroup();
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        List<StorageResource> lunList = this.get4DCHyperMetroLunList(context);
        if (VerifyUtil.isEmpty(lunList)) {
            logger.error((Object)"lunList is null");
            return;
        }
        List<String> siteIdList = this.getSiteIdList(context, lunList);
        ArrayList<Node> storageNodeList = new ArrayList<Node>();
        for (StorageResource lun : lunList) {
            List hostNodeList;
            if (!(lun instanceof Lun)) continue;
            String devSn = lun.getDevSn();
            DrStorage drStorage = (DrStorage)this.getDrResourceInContext(context, devSn);
            Node storageNode = this.createStorage(context, context.getProtectGroup(), drStorage, layout);
            storageNodeList.add(storageNode);
            if (!PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType()) || !ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)protectGroup) || VerifyUtil.isEmpty((Collection)(hostNodeList = context.getVmEsxNode()))) continue;
            for (Node hostNode : hostNodeList) {
                this.setHostNodeClient(context, siteIdList, hostNode);
                this.createHostStorageLink(context, hostNode, storageNode, true);
            }
        }
        this.createHyperMetroLink(context, protectGroup, layout, storageNodeList);
    }

    private List<StorageResource> get4DCHyperMetroLunList(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectGroup protectGroupAllInfo = context.getProtectGroupService().getProtectGroupByID(protectGroup.getUuid());
        Set<String> hyperMetroDevSNs = this.getHyperMetroDevSNs(protectGroup);
        if (VerifyUtil.isEmpty(hyperMetroDevSNs)) {
            logger.error((Object)"hyperMetroDevSNs is null");
            return null;
        }
        Set pgReplicas = protectGroupAllInfo.getReplicaList();
        ArrayReplicationTopoBuilder arrayReplicationTopoBuilder = new ArrayReplicationTopoBuilder();
        List<ReplicaRelation> relations = arrayReplicationTopoBuilder.transform(protectGroupAllInfo, pgReplicas);
        List storageResources = new ArrayList();
        Site hyperMetroSite = new Site();
        String hyperMetroDevSN = "";
        for (ReplicaRelation replicaRelation : relations) {
            HashMap<String, List<String>> hyperMetroDevSNLunIdListMap;
            hyperMetroDevSN = this.checkHyperMetroDevSNs(hyperMetroDevSNs, replicaRelation, hyperMetroDevSNLunIdListMap = new HashMap<String, List<String>>());
            if (VerifyUtil.isEmpty((String)hyperMetroDevSN) || VerifyUtil.isEmpty(hyperMetroDevSNLunIdListMap)) continue;
            DrStorage hyperMetroStorage = (DrStorage)this.getDrResource(hyperMetroDevSN);
            String hyperMetroSiteId = hyperMetroStorage.getSiteId();
            hyperMetroSite = context.getSiteService().getSiteById(hyperMetroSiteId);
            List listResourceID = (List)hyperMetroDevSNLunIdListMap.get(hyperMetroDevSN);
            storageResources = this.getResourceListFromDB(hyperMetroSite, hyperMetroDevSN, listResourceID);
            break;
        }
        if (VerifyUtil.isEmpty((String)hyperMetroDevSN) || VerifyUtil.isEmpty((Object)hyperMetroSite)) {
            logger.error((Object)"hyperMetroDevSN or hyperMetroSite is null");
            return null;
        }
        HashSet<String> wwnSet = new HashSet<String>();
        for (StorageResource storageResource : storageResources) {
            if (!(storageResource instanceof Lun)) continue;
            Lun lun = (Lun)storageResource;
            wwnSet.add(lun.getWwn());
            break;
        }
        List<StorageResource> list = this.queryLunByWwn(context, wwnSet, hyperMetroSite);
        return list;
    }

    private Set<String> getHyperMetroDevSNs(ProtectGroup protectGroup) {
        List siteInfoList;
        Set<String> hyperMetroDevSNs = new HashSet<String>();
        if (!PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType())) {
            return hyperMetroDevSNs;
        }
        String siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO");
        if (null != siteInfoListStr && null != (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class))) {
            for (SiteInfo siteInfo : siteInfoList) {
                Set devSnSet = siteInfo.getDevSnSet();
                if (2 != devSnSet.size()) continue;
                hyperMetroDevSNs = devSnSet;
                break;
            }
        }
        return hyperMetroDevSNs;
    }

    private List<StorageResource> queryLunByWwn(TopoBaseContext context, Set<String> wwnSet, Site hyperMetroSite) {
        if (VerifyUtil.isEmpty(wwnSet)) {
            logger.error((Object)"wwnSet is null");
            return null;
        }
        List lunList = 0 == hyperMetroSite.getSiteType() ? context.getStorageService().getStorageResourceByWwn(wwnSet.toArray(new String[wwnSet.size()])) : context.getStorageService().getResourceByWwnFromRemote(hyperMetroSite, new ArrayList<String>(wwnSet));
        return lunList;
    }

    private String checkHyperMetroDevSNs(Set<String> hyperMetroDevSNs, ReplicaRelation relation, Map<String, List<String>> hyperMetroDevSNLunIdListMap) {
        String hyperMetroDevSNLast = "";
        String srcSN = relation.getSourceSN();
        String trgSN = relation.getTargetSN();
        for (String hyperMetroDevSN : hyperMetroDevSNs) {
            if (hyperMetroDevSN.equals(srcSN)) {
                hyperMetroDevSNLunIdListMap.put(hyperMetroDevSN, relation.getSourceLuns());
                hyperMetroDevSNLast = hyperMetroDevSN;
                break;
            }
            if (!hyperMetroDevSN.equals(trgSN)) continue;
            hyperMetroDevSNLunIdListMap.put(hyperMetroDevSN, relation.getTargetLuns());
            hyperMetroDevSNLast = hyperMetroDevSN;
            break;
        }
        return hyperMetroDevSNLast;
    }
}

