/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.protection.replica.builder.IReplicationBuilder;
import com.huawei.ism.drm.kube.protection.replica.builder.PersistentVolumeBuilder;
import com.huawei.ism.drm.kube.protection.replica.builder.ResourceSetBuilder;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.stream.Collectors;

public class KubeBuilderUtil {
    private static final Log LOGGER = LogFactory.getInstance(KubeBuilderUtil.class);

    public static KubeSchedulePolicy buildSchedulePolicy(Schedule schedule) {
        KubeSchedulePolicy policy = new KubeSchedulePolicy();
        policy.setName(KubeResourceNameGenerator.generate());
        int periodType = schedule.getPeriodType();
        switch (periodType) {
            case 4: {
                KubeBuilderUtil.buildMonthPolicy(schedule, policy);
                break;
            }
            case 3: {
                KubeBuilderUtil.buildWeeklyPolicy(schedule, policy);
                break;
            }
            case 2: {
                KubeBuilderUtil.buildDailyPolicy(schedule, policy);
                break;
            }
            case 1: {
                KubeBuilderUtil.buildHourPolicy(schedule, policy);
                break;
            }
            case 5: {
                KubeBuilderUtil.buildTimeWaitPolicy(schedule, policy);
                break;
            }
            default: {
                LOGGER.error((Object)"Not support type:%s", new Object[]{String.valueOf(periodType)});
                throw new LegoCheckedException(1073947393L);
            }
        }
        return policy;
    }

    private static void buildTimeWaitPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        int syncType = schedule.getSyncType();
        if (syncType == 1) {
            policy.setTimeWait(KubeEnumDefine.TimeWaitType.AFTER_SYNC_BEGINS);
        } else if (syncType == 2) {
            policy.setTimeWait(KubeEnumDefine.TimeWaitType.AFTER_SYNC_ENDS);
        } else {
            LOGGER.error((Object)"The timeWait type value: %s is error", new Object[]{String.valueOf(syncType)});
            throw new LegoCheckedException(2117645L);
        }
        policy.setSeconds(NumberUtil.convertToInteger((Object)schedule.getSeconds()).intValue());
    }

    private static void buildHourPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        policy.setPolicyType(KubeEnumDefine.PolicyType.HOURS);
        policy.setMinutes(NumberUtil.convertToInteger((Object)schedule.getMinutes()).intValue());
        if (!VerifyUtil.isEmpty((Object)schedule.getRetentionPolicy())) {
            policy.setRetain(schedule.getRetentionPolicy().getLatestCopies());
        }
    }

    private static void buildDailyPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        policy.setPolicyType(KubeEnumDefine.PolicyType.DAILY);
        policy.setTime(schedule.getHours() + ":" + schedule.getMinutes());
        if (!VerifyUtil.isEmpty((Object)schedule.getRetentionPolicy())) {
            policy.setRetain(schedule.getRetentionPolicy().getDailyCopies());
        }
    }

    private static void buildWeeklyPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        String daysOfWeek = schedule.getDaysOfWeek();
        String[] days = daysOfWeek.split(",");
        policy.setWeeklyDays(Arrays.stream(days).map(item -> KubeEnumDefine.DayOfWeek.getValue((int)NumberUtil.convertToInteger((Object)item))).collect(Collectors.toList()));
        policy.setPolicyType(KubeEnumDefine.PolicyType.WEEKLY);
        policy.setTime(schedule.getHours() + ":" + schedule.getMinutes());
        if (!VerifyUtil.isEmpty((Object)schedule.getRetentionPolicy())) {
            policy.setRetain(schedule.getRetentionPolicy().getWeeklyCopies());
        }
    }

    private static void buildMonthPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        policy.setPolicyType(KubeEnumDefine.PolicyType.MONTHLY);
        String dayOfMonth = schedule.getDaysOfMonth();
        String[] days = dayOfMonth.split(",");
        policy.setMonthlyDates(Arrays.stream(days).map(NumberUtil::convertToInteger).collect(Collectors.toList()));
        policy.setTime(schedule.getHours() + ":" + schedule.getMinutes());
        if (!VerifyUtil.isEmpty((Object)schedule.getRetentionPolicy())) {
            policy.setRetain(schedule.getRetentionPolicy().getMonthlyCopyies());
        }
    }

    public static IReplicationBuilder getReplicationBuilder(ProtectGroup protectGroup) {
        ProtectObject protectObject = (ProtectObject)protectGroup.getPolist().iterator().next();
        if (protectObject.getPoType() == 20) {
            return new ResourceSetBuilder();
        }
        if (protectObject.getPoType() == 21) {
            return new PersistentVolumeBuilder();
        }
        LOGGER.error((Object)"Not support type %s.", new Object[]{String.valueOf(protectGroup.getPoType())});
        throw new LegoCheckedException(0x300001L);
    }
}

