/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;

public class ProtectionPlanRollbackTask
implements IRollbackItem {
    private static final Log LOGGER = LogFactory.getInstance(ProtectionPlanRollbackTask.class);
    private final String kubeSn;
    private final String name;

    public ProtectionPlanRollbackTask(String kubeSn, String name) {
        this.kubeSn = kubeSn;
        this.name = name;
    }

    public boolean execute() {
        if (VerifyUtil.isEmpty((String)this.kubeSn) || VerifyUtil.isEmpty((String)this.name)) {
            LOGGER.error((Object)"Rollback protectPlan failed. Param invalid.");
            return false;
        }
        LOGGER.warn((Object)"Rollback protectPlan %s,", new Object[]{this.name});
        KubeProtectionPlan kubeProtectionPlan = new KubeProtectionPlan();
        kubeProtectionPlan.setName(this.name);
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        iKubeHandler.deleteProtectionPlan(this.kubeSn, Collections.singletonList(kubeProtectionPlan));
        int maxTime = 12;
        for (int retryTime = 0; retryTime < maxTime; ++retryTime) {
            CommUtil.pauseThread((long)5000L);
            if (!iKubeHandler.checkProtectionPlanExist(this.kubeSn, this.name)) {
                return true;
            }
            iKubeHandler.deleteProtectionPlan(this.kubeSn, Collections.singletonList(kubeProtectionPlan));
        }
        LOGGER.error((Object)"Delete protectionPlan:%s failed.", new Object[]{this.name});
        return true;
    }
}

