/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collections;
import org.hibernate.Session;

public class ResourceRollBackTask
implements IRollbackItem {
    private static final Log LOGGER = LogFactory.getInstance(ResourceRollBackTask.class);
    private final String kubeSn;
    private final String name;
    private String namespace = "";
    private final KubeEnumDefine.RollBackType type;

    public ResourceRollBackTask(String kubeSn, String name, String namespace, KubeEnumDefine.RollBackType type) {
        this(kubeSn, name, type);
        this.namespace = namespace;
    }

    public ResourceRollBackTask(String kubeSn, String name, KubeEnumDefine.RollBackType type) {
        this.kubeSn = kubeSn;
        this.name = name;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        if (VerifyUtil.isEmpty((String)this.kubeSn) || VerifyUtil.isEmpty((String)this.name) || VerifyUtil.isEmpty((Object)this.type)) {
            LOGGER.error((Object)"Roll back resource failed. Param invalid.");
            return false;
        }
        LOGGER.warn((Object)"Roll back kube resource name: %s for type: %s", new Object[]{this.name, this.type.getValue()});
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        switch (this.type) {
            case SC: {
                StorageClassInfo storageClassInfo = new StorageClassInfo();
                storageClassInfo.setName(this.name);
                return iKubeHandler.deleteStorageClass(this.kubeSn, Collections.singletonList(storageClassInfo));
            }
            case PVC: {
                PersistentVolumeClaimInfo claimInfo = new PersistentVolumeClaimInfo();
                claimInfo.setName(this.name);
                claimInfo.setNameSpace(this.namespace);
                return iKubeHandler.deletePersistentVolumeClaim(this.kubeSn, Collections.singletonList(claimInfo));
            }
            case NAMESPACE: {
                return iKubeHandler.deleteNamespace(this.kubeSn, this.name);
            }
            case RESOURCE_SET: {
                IKubeService kubeService = (IKubeService)ServiceLocator.getInstance().getService(IKubeService.class);
                ResourceSetInfo info = kubeService.getResourceSetByName(this.kubeSn, this.name);
                kubeService.deleteKubeResourceSetByName(this.kubeSn, this.name);
                Session session = null;
                try {
                    session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                    session.beginTransaction();
                    session.delete((Object)info);
                    session.getTransaction().commit();
                }
                catch (Exception e) {
                    try {
                        DBOperationUtil.rollbackSession((Session)session);
                        ExceptionUtil.rethrowException((Throwable)e, (String)"Delete resourceSet failed.", (long)1073947739L, (String[])new String[0], (Log)LOGGER);
                    }
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                    DBOperationUtil.closeSession((Session)session);
                }
                DBOperationUtil.closeSession((Session)session);
                return true;
            }
            case VOLUME_SET: {
                return iKubeHandler.deleteVolumeSet(this.kubeSn, this.name);
            }
            case BACKUP_INSTANCE: {
                return this.isBackupInstanceDelete(this.kubeSn, iKubeHandler, this.name);
            }
        }
        LOGGER.error((Object)"The roll back type is error: %s", new Object[]{this.type.getValue()});
        return false;
    }

    private boolean isBackupInstanceDelete(String kubeSn, IKubeHandler kubeHandler, String backupInstanceName) {
        block1: {
            long curTime;
            long startTime = System.currentTimeMillis();
            long waitTime = 180000L;
            do {
                kubeHandler.deleteBackupInstance(kubeSn, backupInstanceName);
                CommUtil.pauseThread((long)3000L);
                if (!kubeHandler.checkInstanceExist(kubeSn, backupInstanceName)) break block1;
            } while ((curTime = System.currentTimeMillis()) - startTime <= waitTime);
            LOGGER.error((Object)"Delete backupInstance fail.");
        }
        return true;
    }
}

