/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.util;

import com.huawei.ism.drm.kube.connection.KubeConnection;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.BackupLocationInfo;
import com.huawei.ism.drm.kube.sdk.model.ClusterInfo;
import com.huawei.ism.drm.kube.sdk.model.KubeBackup;
import com.huawei.ism.drm.kube.sdk.model.KubeBackupJob;
import com.huawei.ism.drm.kube.sdk.model.KubeEvent;
import com.huawei.ism.drm.kube.sdk.model.KubePersistentVolume;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionJob;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeRecoveryJob;
import com.huawei.ism.drm.kube.sdk.model.KubeRecoveryPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeResource;
import com.huawei.ism.drm.kube.sdk.model.KubeResourceSetPVC;
import com.huawei.ism.drm.kube.sdk.model.KubeRestoreJob;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubeVolumeSet;
import com.huawei.ism.drm.kube.sdk.model.MetadataPairInfo;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.PodResource;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.bo.HookBO;
import com.huawei.ism.drm.kube.sdk.model.bo.LabelBO;
import com.huawei.ism.drm.kube.sdk.model.bo.NamespaceBO;
import com.huawei.ism.drm.kube.sdk.model.bo.PersistentVolumeBO;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRestoreJobStatus;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.huawei.xuanwu.v1.Backup;
import io.huawei.xuanwu.v1.BackupInstance;
import io.huawei.xuanwu.v1.BackupInstanceSpec;
import io.huawei.xuanwu.v1.BackupInstanceStatus;
import io.huawei.xuanwu.v1.BackupJob;
import io.huawei.xuanwu.v1.BackupJobSpec;
import io.huawei.xuanwu.v1.BackupJobStatus;
import io.huawei.xuanwu.v1.BackupLocation;
import io.huawei.xuanwu.v1.BackupLocationSpec;
import io.huawei.xuanwu.v1.BackupSpec;
import io.huawei.xuanwu.v1.BackupStatus;
import io.huawei.xuanwu.v1.Cluster;
import io.huawei.xuanwu.v1.ClusterSpec;
import io.huawei.xuanwu.v1.Hook;
import io.huawei.xuanwu.v1.ProtectionJob;
import io.huawei.xuanwu.v1.ProtectionJobSpec;
import io.huawei.xuanwu.v1.ProtectionJobStatus;
import io.huawei.xuanwu.v1.ProtectionPlan;
import io.huawei.xuanwu.v1.ProtectionPlanSpec;
import io.huawei.xuanwu.v1.ProtectionPlanStatus;
import io.huawei.xuanwu.v1.RecoveryJob;
import io.huawei.xuanwu.v1.RecoveryJobSpec;
import io.huawei.xuanwu.v1.RecoveryJobStatus;
import io.huawei.xuanwu.v1.RecoveryPlan;
import io.huawei.xuanwu.v1.RecoveryPlanSpec;
import io.huawei.xuanwu.v1.ResourceDetail;
import io.huawei.xuanwu.v1.ResourceDetailStatus;
import io.huawei.xuanwu.v1.ResourceSet;
import io.huawei.xuanwu.v1.ResourceSetSpec;
import io.huawei.xuanwu.v1.ResourceSetStatus;
import io.huawei.xuanwu.v1.RestoreJob;
import io.huawei.xuanwu.v1.RestoreJobSpec;
import io.huawei.xuanwu.v1.RestoreJobStatus;
import io.huawei.xuanwu.v1.SchedulePolicy;
import io.huawei.xuanwu.v1.SchedulePolicySpec;
import io.huawei.xuanwu.v1.ScheduleTimeWait;
import io.huawei.xuanwu.v1.StorageBackendClaim;
import io.huawei.xuanwu.v1.StorageBackendClaimStatus;
import io.huawei.xuanwu.v1.StorageBackendContent;
import io.huawei.xuanwu.v1.StorageBackendContentStatus;
import io.huawei.xuanwu.v1.VolumeSet;
import io.huawei.xuanwu.v1.VolumeSetSpec;
import io.huawei.xuanwu.v1.clusterspec.ApiServer;
import io.huawei.xuanwu.v1.protectionplanspec.LocalStorageBackend;
import io.huawei.xuanwu.v1.protectionplanspec.RemoteStorageBackend;
import io.huawei.xuanwu.v1.resourcedetailstatus.Resources;
import io.huawei.xuanwu.v1.resourcesetspec.ExcludeResources;
import io.huawei.xuanwu.v1.resourcesetspec.IncludeResources;
import io.huawei.xuanwu.v1.schedulepolicyspec.DailyPolicy;
import io.huawei.xuanwu.v1.schedulepolicyspec.HourlyPolicy;
import io.huawei.xuanwu.v1.schedulepolicyspec.MonthlyPolicy;
import io.huawei.xuanwu.v1.schedulepolicyspec.WeeklyPolicy;
import io.huawei.xuanwu.v1.volumesetspec.MetadataPair;
import io.huawei.xuanwu.v1.volumesetspec.VolumePairs;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class KubeConvertUtil {
    public static final Set<String> SUPPORT_RESOURCE_TYPE = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("pod");
            this.add("deployment");
            this.add("service");
            this.add("replicaset");
            this.add("daemonset");
            this.add("statefulset");
        }
    });
    private static final Log LOGGER = LogFactory.getInstance(KubeConvertUtil.class);
    private static final String LOCATION_PROVIDER_NAME = "xuanwu.volume.provider";
    private static final String SOURCE_BACKEND_NAME = "sourceBackendName";
    private static final String BACKUP_BACKEND_NAME = "backupBackendName";
    private static final String RESTORE_BACKEND_NAME = "restoreBackendName";
    private static final String REMOTE_DEVICES_SN = "RemoteDevicesSN";
    private static final BigDecimal DIVIDE_BYTE_TO_GB = new BigDecimal(0x40000000);

    public static HookBO transHook(Hook hook) {
        HookBO hookBO = new HookBO();
        hookBO.setName(hook.getMetadata().getName());
        return hookBO;
    }

    public static PersistentVolumeBO transPersistentVolume(PersistentVolume persistentVolume) {
        PersistentVolumeBO persistentVolumeBO = new PersistentVolumeBO();
        persistentVolumeBO.setId(persistentVolume.getMetadata().getUid());
        persistentVolumeBO.setName(persistentVolume.getMetadata().getName());
        persistentVolumeBO.setLabels(KubeConvertUtil.transLabels(persistentVolume));
        persistentVolumeBO.setStatus(persistentVolume.getStatus().getPhase());
        PersistentVolumeSpec spec = persistentVolume.getSpec();
        if (!VerifyUtil.isEmpty((Object)spec)) {
            CSIPersistentVolumeSource csi = spec.getCsi();
            if (!VerifyUtil.isEmpty((Object)csi) && !VerifyUtil.isEmpty((Map)csi.getVolumeAttributes())) {
                persistentVolumeBO.setStorageName((String)csi.getVolumeAttributes().get("backend"));
            }
            persistentVolumeBO.setStorageClass(spec.getStorageClassName());
            ObjectReference claimRef = spec.getClaimRef();
            if (claimRef != null) {
                persistentVolumeBO.setPvcNamespace(claimRef.getNamespace());
                persistentVolumeBO.setPvcName(claimRef.getName());
            }
            persistentVolumeBO.setCapacity(KubeConvertUtil.getPVCapacity(spec));
        }
        return persistentVolumeBO;
    }

    public static NamespaceBO transNamespace(Namespace namespace) {
        NamespaceBO namespaceBO = new NamespaceBO();
        namespaceBO.setName(namespace.getMetadata().getName());
        namespaceBO.setStatus(namespace.getStatus().getPhase());
        return namespaceBO;
    }

    public static Namespace transToNamespaceForKube(NamespaceBO namespaceBO) {
        Namespace namespace = new Namespace();
        ObjectMeta meta = new ObjectMeta();
        meta.setName(namespaceBO.getName());
        namespace.setMetadata(meta);
        return namespace;
    }

    public static ResourceSetInfo transToResourceSet(ResourceSet resourceSet, String devSn) {
        ResourceSetInfo rs = new ResourceSetInfo();
        rs.setName(resourceSet.getMetadata().getName());
        rs.setNamespace(((ResourceSetSpec)resourceSet.getSpec()).getNamespace());
        rs.setId(resourceSet.getMetadata().getUid());
        rs.setLabels(JSONObject.fromObject(((ResourceSetSpec)resourceSet.getSpec()).getLabels()).toString());
        rs.setIncludeResources(JSONArray.fromObject(((ResourceSetSpec)resourceSet.getSpec()).getIncludeResources()).toString());
        rs.setExcludeResources(JSONArray.fromObject(((ResourceSetSpec)resourceSet.getSpec()).getExcludeResources()).toString());
        rs.setKubeId(devSn);
        String detail = Optional.ofNullable(resourceSet.getStatus()).map(ResourceSetStatus::getResourceDetails).orElse("");
        rs.setResourceDetailName(detail);
        rs.setStatus(((ResourceSetStatus)resourceSet.getStatus()).getStatus());
        return rs;
    }

    public static void resetRsIncludePods(ResourceDetail detail, ResourceSetInfo info, KubeConnection connection, String nameSpace) {
        List<Pod> pods = connection.getList(Pod.class, nameSpace);
        HashMap<String, List<Pod>> podMap = new HashMap<String, List<Pod>>();
        for (Pod pod : pods) {
            if (VerifyUtil.isEmpty((Map)pod.getMetadata().getLabels())) continue;
            Set keys = pod.getMetadata().getLabels().keySet();
            for (String key : keys) {
                String keyAndValue = key + (String)pod.getMetadata().getLabels().get(key);
                List podList = podMap.computeIfAbsent(keyAndValue, kv -> new ArrayList());
                podList.add(pod);
            }
        }
        HashSet<PodResource> includePods = new HashSet<PodResource>();
        List<Resources> resources = Optional.ofNullable(detail.getStatus()).map(ResourceDetailStatus::getResources).orElse(Collections.emptyList());
        KubeConvertUtil.buildPodsByResource(connection, nameSpace, resources, podMap, includePods);
        info.setProtectResources(((Object)includePods).toString());
    }

    private static void buildPodsByResource(KubeConnection connection, String nameSpace, List<Resources> resources, Map<String, List<Pod>> podMap, Set<PodResource> includePods) {
        block16: for (Resources resource : resources) {
            PodResource kubeIncludeReource = new PodResource();
            switch (resource.getKind().toLowerCase(Locale.ROOT)) {
                case "pod": {
                    kubeIncludeReource.setName(resource.getName());
                    kubeIncludeReource.setKind(resource.getKind());
                    kubeIncludeReource.setApiVersion(resource.getApiVersion());
                    kubeIncludeReource.setNameSpace(resource.getNamespace());
                    kubeIncludeReource.setLowerLevelPod(resource.getName());
                    includePods.add(kubeIncludeReource);
                    continue block16;
                }
                case "deployment": {
                    KubeConvertUtil.buildDeploymentPod(connection, nameSpace, podMap, includePods, resource);
                    continue block16;
                }
                case "service": {
                    KubeConvertUtil.buildServicePod(connection, nameSpace, podMap, includePods, resource);
                    continue block16;
                }
                case "replicaset": {
                    KubeConvertUtil.buildReplicaSetPod(connection, nameSpace, podMap, includePods, resource);
                    continue block16;
                }
                case "daemonset": {
                    KubeConvertUtil.buildDaemonSetPod(connection, nameSpace, podMap, includePods, resource);
                    continue block16;
                }
                case "statefulset": {
                    KubeConvertUtil.buildStatefulSetPod(connection, nameSpace, podMap, includePods, resource);
                    continue block16;
                }
            }
            LOGGER.debug((Object)"Resource kind: %s is not match.", new Object[]{resource.getKind()});
        }
    }

    private static void buildStatefulSetPod(KubeConnection connection, String nameSpace, Map<String, List<Pod>> podMap, Set<PodResource> includePods, Resources resource) {
        Optional<StatefulSet> tatefulSetOpt = connection.get(StatefulSet.class, nameSpace, resource.getName());
        if (tatefulSetOpt.isPresent()) {
            StatefulSet statefulSet = tatefulSetOpt.get();
            Map labelMap = statefulSet.getSpec().getSelector().getMatchLabels();
            KubeConvertUtil.buildIncludePods(includePods, podMap, resource, labelMap);
        }
    }

    private static void buildDaemonSetPod(KubeConnection connection, String nameSpace, Map<String, List<Pod>> podMap, Set<PodResource> includePods, Resources resource) {
        Optional<DaemonSet> daemonSetOpt = connection.get(DaemonSet.class, nameSpace, resource.getName());
        if (daemonSetOpt.isPresent()) {
            DaemonSet daemonSet = daemonSetOpt.get();
            Map labelMap = daemonSet.getSpec().getSelector().getMatchLabels();
            KubeConvertUtil.buildIncludePods(includePods, podMap, resource, labelMap);
        }
    }

    private static void buildReplicaSetPod(KubeConnection connection, String nameSpace, Map<String, List<Pod>> podMap, Set<PodResource> includePods, Resources resource) {
        Optional<ReplicaSet> replicaSetOpt = connection.get(ReplicaSet.class, nameSpace, resource.getName());
        if (replicaSetOpt.isPresent()) {
            ReplicaSet replicaSet = replicaSetOpt.get();
            Map labelMap = replicaSet.getSpec().getSelector().getMatchLabels();
            KubeConvertUtil.buildIncludePods(includePods, podMap, resource, labelMap);
        }
    }

    private static void buildServicePod(KubeConnection connection, String nameSpace, Map<String, List<Pod>> podMap, Set<PodResource> includePods, Resources resource) {
        Optional<Service> serviceOpt = connection.get(Service.class, nameSpace, resource.getName());
        if (serviceOpt.isPresent()) {
            Service service = serviceOpt.get();
            Map labelMap = service.getSpec().getSelector();
            KubeConvertUtil.buildIncludePods(includePods, podMap, resource, labelMap);
        }
    }

    private static void buildDeploymentPod(KubeConnection connection, String nameSpace, Map<String, List<Pod>> podMap, Set<PodResource> includePods, Resources resource) {
        Optional<Deployment> deploymentOpt = connection.get(Deployment.class, nameSpace, resource.getName());
        if (deploymentOpt.isPresent()) {
            Deployment deployment = deploymentOpt.get();
            Map labelMap = deployment.getSpec().getSelector().getMatchLabels();
            KubeConvertUtil.buildIncludePods(includePods, podMap, resource, labelMap);
        }
    }

    private static void buildIncludePods(Set<PodResource> includePods, Map<String, List<Pod>> podMap, Resources resource, Map<String, String> labelMap) {
        if (VerifyUtil.isEmpty(labelMap)) {
            return;
        }
        for (String labelKey : labelMap.keySet()) {
            if (!podMap.containsKey(labelKey + labelMap.get(labelKey))) continue;
            for (Pod pod : podMap.get(labelKey + labelMap.get(labelKey))) {
                PodResource kubeIncludeReource = KubeConvertUtil.buildNewPodResource(resource, pod);
                kubeIncludeReource.setKind(resource.getKind());
                kubeIncludeReource.setName(resource.getName());
                includePods.add(kubeIncludeReource);
                if (!"service".equals(resource.getKind().toLowerCase(Locale.ROOT)) || !VerifyUtil.isEmpty((Collection)pod.getMetadata().getOwnerReferences())) continue;
                PodResource kubeIncludeServiceReource = KubeConvertUtil.buildNewPodResource(resource, pod);
                kubeIncludeServiceReource.setName(pod.getMetadata().getName());
                kubeIncludeServiceReource.setKind("Pod");
                includePods.add(kubeIncludeServiceReource);
            }
        }
    }

    private static PodResource buildNewPodResource(Resources resource, Pod pod) {
        PodResource kubeIncludeReource = new PodResource();
        kubeIncludeReource.setApiVersion(resource.getApiVersion());
        kubeIncludeReource.setNameSpace(resource.getNamespace());
        kubeIncludeReource.setLowerLevelPod(pod.getMetadata().getName());
        return kubeIncludeReource;
    }

    public static Optional<KubeStorage> transStorageBackendClaim(StorageBackendClaim storageBackendClaim, List<StorageBackendContent> storageBackendContents, String devSn) {
        String boundContentName = ((StorageBackendClaimStatus)storageBackendClaim.getStatus()).getBoundContentName();
        Optional<StorageBackendContent> sbcOpt = storageBackendContents.stream().filter(content -> content.getMetadata().getName().equals(boundContentName)).findAny();
        if (!sbcOpt.isPresent()) {
            return Optional.empty();
        }
        StorageBackendContent sbct = sbcOpt.get();
        KubeStorage storage = new KubeStorage();
        storage.setKubeId(devSn);
        storage.setId(storageBackendClaim.getMetadata().getUid());
        storage.setName(storageBackendClaim.getMetadata().getName());
        storage.setDeviceSn(((StorageBackendContentStatus)sbct.getStatus()).getSn());
        storage.setNamespace(storageBackendClaim.getMetadata().getNamespace());
        storage.setStatus(!VerifyUtil.isEmpty((Object)((StorageBackendContentStatus)sbct.getStatus()).getOnline()) && ((StorageBackendContentStatus)sbct.getStatus()).getOnline() != false ? ((StorageBackendClaimStatus)storageBackendClaim.getStatus()).getPhase() : "UnBound");
        storage.setOnline(Boolean.TRUE.equals(((StorageBackendContentStatus)sbct.getStatus()).getOnline()));
        KubeConvertUtil.setRemoteDevicesSn(sbct, storage);
        return Optional.of(storage);
    }

    private static void setRemoteDevicesSn(StorageBackendContent storageBackendContent, KubeStorage storage) {
        Map<String, String> map = ((StorageBackendContentStatus)storageBackendContent.getStatus()).getSpecification();
        if (!VerifyUtil.isEmpty(map) && map.containsKey(REMOTE_DEVICES_SN)) {
            String remoteSns = map.get(REMOTE_DEVICES_SN);
            if (VerifyUtil.isEmpty((String)remoteSns)) {
                return;
            }
            String[] array = remoteSns.split(";");
            storage.setRemoteDeviceSNs(Arrays.asList(array));
        }
    }

    public static <T extends HasMetadata> List<LabelBO> transLabels(T clazz) {
        return KubeConvertUtil.transLabels(clazz.getMetadata().getLabels(), clazz.getMetadata().getNamespace());
    }

    public static <T extends HasMetadata> List<LabelBO> transLabels(Map<String, String> labelMap, String nameSpace) {
        if (VerifyUtil.isEmpty(labelMap)) {
            return Collections.emptyList();
        }
        ArrayList<LabelBO> list = new ArrayList<LabelBO>();
        for (Map.Entry<String, String> entry : labelMap.entrySet()) {
            LabelBO labelBO = new LabelBO();
            labelBO.setName(entry.getKey() + ":" + entry.getValue());
            labelBO.setNameSpace(nameSpace);
            list.add(labelBO);
        }
        return list;
    }

    public static StorageClassInfo transToSCInfo(StorageClass storageClass) {
        StorageClassInfo classInfo = new StorageClassInfo();
        classInfo.setId(storageClass.getMetadata().getUid());
        classInfo.setName(storageClass.getMetadata().getName());
        classInfo.setCreationTimestamp(storageClass.getMetadata().getCreationTimestamp());
        classInfo.setResourceVersion(storageClass.getMetadata().getResourceVersion());
        classInfo.setProvisioner(storageClass.getProvisioner());
        classInfo.setReclaimPolicy(storageClass.getReclaimPolicy());
        classInfo.setVolumeBindingMode(storageClass.getVolumeBindingMode());
        classInfo.setParameters(Optional.ofNullable(storageClass.getParameters()).orElse(Collections.emptyMap()));
        classInfo.setCanAllowVolumeExpansion(storageClass.getAllowVolumeExpansion());
        return classInfo;
    }

    public static PersistentVolumeClaimInfo transToPVCInfo(PersistentVolumeClaim volumeClaim) {
        PersistentVolumeClaimInfo info = new PersistentVolumeClaimInfo();
        info.setName(volumeClaim.getMetadata().getName());
        info.setId(volumeClaim.getMetadata().getUid());
        info.setNameSpace(volumeClaim.getMetadata().getNamespace());
        info.setAccessModes(volumeClaim.getSpec().getAccessModes());
        info.setVolumeName(volumeClaim.getSpec().getVolumeName());
        volumeClaim.getSpec().getResources().getRequests().get("storage");
        Map map = Optional.ofNullable(volumeClaim.getSpec()).map(PersistentVolumeClaimSpec::getResources).map(ResourceRequirements::getRequests).orElse(new HashMap());
        if (map.containsKey("storage")) {
            Quantity quantity = (Quantity)map.get("storage");
            String amount = quantity.getAmount();
            String format = quantity.getFormat();
            info.setAmount(amount);
            info.setFormat(format);
        }
        if (!VerifyUtil.isEmpty((String)volumeClaim.getMetadata().getDeletionTimestamp())) {
            info.setStatus("Terminating");
        } else {
            info.setStatus(volumeClaim.getStatus().getPhase());
        }
        info.setStorageClassName(volumeClaim.getSpec().getStorageClassName());
        info.setVolumeMode(volumeClaim.getSpec().getVolumeMode());
        if (!VerifyUtil.isEmpty((Map)volumeClaim.getMetadata().getLabels())) {
            Map labelMap = volumeClaim.getMetadata().getLabels();
            ArrayList<String> labelList = new ArrayList<String>(labelMap.size());
            for (String key : labelMap.keySet()) {
                labelList.add(key + ":" + (String)labelMap.get(key));
            }
            info.setLabels(((Object)labelList).toString());
            info.setLabelMap(volumeClaim.getMetadata().getLabels());
        }
        return info;
    }

    public static ResourceSet transToResourceSet(ResourceSetInfo info) {
        List<IncludeResources> includeResources;
        List<ExcludeResources> excludeResources;
        ResourceSetSpec spec = new ResourceSetSpec();
        spec.setNamespace(info.getNamespace());
        Map<String, String> map = KubeConvertUtil.getLabels(info.getLabels());
        if (map.size() > 0) {
            spec.setLabels(map);
        }
        if (!VerifyUtil.isEmpty(excludeResources = KubeConvertUtil.getExcludeResources(info.getExcludeResources()))) {
            spec.setExcludeResources(excludeResources);
        }
        if (!VerifyUtil.isEmpty(includeResources = KubeConvertUtil.getIncludeResources(info.getIncludeResources())) && VerifyUtil.isEmpty(excludeResources)) {
            spec.setIncludeResources(includeResources);
        }
        if (info.isSkipValidation()) {
            spec.setSkipValidation(true);
        }
        ResourceSet resourceSet = new ResourceSet();
        resourceSet.setSpec(spec);
        ObjectMeta meta = new ObjectMeta();
        meta.setName(info.getName());
        resourceSet.setMetadata(meta);
        return resourceSet;
    }

    public static SchedulePolicy transToSchedulePolicy(KubeSchedulePolicy kubeSchedulePolicy) {
        ObjectMeta meta = new ObjectMeta();
        meta.setName(kubeSchedulePolicy.getName());
        SchedulePolicy policy = new SchedulePolicy();
        policy.setMetadata(meta);
        Optional<SchedulePolicySpec> optSpec = KubeConvertUtil.getSchedulePolicy(kubeSchedulePolicy);
        policy.setPolicy(optSpec.orElse(null));
        policy.setTimedWait(KubeConvertUtil.getScheduleTimeWait(kubeSchedulePolicy).orElse(null));
        return policy;
    }

    public static KubeSchedulePolicy transToPolicy(SchedulePolicy policy) {
        KubeSchedulePolicy kubeSchedulePolicy = new KubeSchedulePolicy();
        kubeSchedulePolicy.setName(policy.getMetadata().getName());
        return kubeSchedulePolicy;
    }

    public static PodResource transPodResource(Pod pod) {
        PodResource podResource = new PodResource();
        podResource.setName(pod.getMetadata().getName());
        if (!VerifyUtil.isEmpty((Object)pod.getSpec()) && !VerifyUtil.isEmpty((Collection)pod.getSpec().getVolumes())) {
            podResource.setClaims(pod.getSpec().getVolumes().stream().filter(volume -> !VerifyUtil.isEmpty((Object)volume.getPersistentVolumeClaim()) && !VerifyUtil.isEmpty((String)volume.getPersistentVolumeClaim().getClaimName())).map(volume -> volume.getPersistentVolumeClaim().getClaimName()).collect(Collectors.toList()));
        }
        podResource.setNameSpace(pod.getMetadata().getNamespace());
        return podResource;
    }

    private static Optional<ScheduleTimeWait> getScheduleTimeWait(KubeSchedulePolicy schedulePolicy) {
        if (VerifyUtil.isEmpty((Object)schedulePolicy.getTimeWait())) {
            LOGGER.info((Object)"Not timewait policy.");
            return Optional.empty();
        }
        int seconds = schedulePolicy.getSeconds();
        KubeConvertUtil.checkSeconds(seconds);
        ScheduleTimeWait scheduleTimeWait = new ScheduleTimeWait();
        scheduleTimeWait.setSeconds(seconds);
        scheduleTimeWait.setTimedWaitType(schedulePolicy.getTimeWait().getValue());
        return Optional.of(scheduleTimeWait);
    }

    private static void checkSeconds(int seconds) {
        if (seconds < 15 || seconds > 86400) {
            LOGGER.error((Object)"The input seconds: %s is error.", new Object[]{String.valueOf(seconds)});
            throw new LegoCheckedException(1073947393L);
        }
        if (seconds > 60 && seconds % 60 != 0) {
            LOGGER.error((Object)"The seconds: %s is not matched.", new Object[]{String.valueOf(seconds)});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static Optional<SchedulePolicySpec> getSchedulePolicy(KubeSchedulePolicy schedulePolicy) {
        if (VerifyUtil.isEmpty((Object)schedulePolicy.getPolicyType())) {
            LOGGER.info((Object)"Not policy type.");
            return Optional.empty();
        }
        KubeConvertUtil.checkRetain(schedulePolicy.getRetain());
        SchedulePolicySpec tmpPolicy = new SchedulePolicySpec();
        switch (schedulePolicy.getPolicyType()) {
            case DAILY: {
                KubeConvertUtil.setDailyPolicy(schedulePolicy, tmpPolicy);
                break;
            }
            case HOURS: {
                KubeConvertUtil.setHoursPolicy(schedulePolicy, tmpPolicy);
                break;
            }
            case WEEKLY: {
                KubeConvertUtil.setWeeklyPolicy(schedulePolicy, tmpPolicy);
                break;
            }
            case MONTHLY: {
                KubeConvertUtil.setMonthlyPolicy(schedulePolicy, tmpPolicy);
                break;
            }
            default: {
                LOGGER.error((Object)"The policyType: %s is not matched!", new Object[]{schedulePolicy.getPolicyType().getValue()});
                throw new LegoCheckedException(-1L);
            }
        }
        return Optional.of(tmpPolicy);
    }

    private static void setMonthlyPolicy(KubeSchedulePolicy schedulePolicy, SchedulePolicySpec tmpPolicy) {
        MonthlyPolicy monthlyPolicy = new MonthlyPolicy();
        monthlyPolicy.setDates(schedulePolicy.getMonthlyDates());
        if (schedulePolicy.getRetain() != 0) {
            monthlyPolicy.setRetain(schedulePolicy.getRetain());
        }
        String monthTime = schedulePolicy.getTime();
        monthlyPolicy.setTime(monthTime);
        tmpPolicy.setMonthly(monthlyPolicy);
    }

    private static void setWeeklyPolicy(KubeSchedulePolicy schedulePolicy, SchedulePolicySpec tmpPolicy) {
        WeeklyPolicy weeklyPolicy = new WeeklyPolicy();
        if (schedulePolicy.getRetain() != 0) {
            weeklyPolicy.setRetain(schedulePolicy.getRetain());
        }
        String weekTime = KubeConvertUtil.getTime(schedulePolicy);
        weeklyPolicy.setTime(weekTime);
        weeklyPolicy.setDays(schedulePolicy.getWeeklyDays());
        tmpPolicy.setWeekly(weeklyPolicy);
    }

    private static void setHoursPolicy(KubeSchedulePolicy schedulePolicy, SchedulePolicySpec tmpPolicy) {
        HourlyPolicy hourlyPolicy = new HourlyPolicy();
        int min = schedulePolicy.getMinutes();
        KubeConvertUtil.checkMin(min);
        hourlyPolicy.setMinutes(min);
        if (schedulePolicy.getRetain() != 0) {
            hourlyPolicy.setRetain(schedulePolicy.getRetain());
        }
        tmpPolicy.setHourly(hourlyPolicy);
    }

    private static void setDailyPolicy(KubeSchedulePolicy schedulePolicy, SchedulePolicySpec tmpPolicy) {
        String dayTime = KubeConvertUtil.getTime(schedulePolicy);
        DailyPolicy dailyPolicy = new DailyPolicy();
        dailyPolicy.setTime(dayTime);
        if (schedulePolicy.getRetain() != 0) {
            dailyPolicy.setRetain(schedulePolicy.getRetain());
        }
        tmpPolicy.setDaily(dailyPolicy);
    }

    private static String getTime(KubeSchedulePolicy schedulePolicy) {
        String time = schedulePolicy.getTime();
        VerifyUtil.checkStrs((String[])new String[]{time});
        return time;
    }

    private static void checkRetain(int retain) {
        if (retain == 0) {
            return;
        }
        if (retain < 1 || retain > 256) {
            LOGGER.error((Object)"The input retain num is error.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkMin(int min) {
        if (min < 0 || min > 60) {
            LOGGER.error((Object)"The input min num is error.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static BackupInstance transToBackupInstance(BackupInstanceInfo info) {
        ObjectMeta meta = new ObjectMeta();
        meta.setName(info.getName());
        BackupInstance instance = new BackupInstance();
        instance.setSpec(KubeConvertUtil.getBackupInstanceSpec(info));
        instance.setMetadata(meta);
        return instance;
    }

    public static BackupInstanceInfo transToBackupInstanceInfo(BackupInstance backupInstance) {
        BackupInstanceInfo backupInstanceInfo = new BackupInstanceInfo();
        backupInstanceInfo.setName(backupInstance.getMetadata().getName());
        BackupInstanceSpec spec = (BackupInstanceSpec)backupInstance.getSpec();
        backupInstanceInfo.setResourceSetName(spec.getResourceSetName());
        backupInstanceInfo.setBackupPolicyNames(spec.getBackupPolicyNames());
        backupInstanceInfo.setMetadataBackupLocation(spec.getMetadataBackupLocation());
        backupInstanceInfo.setVolumeBackupLocation(spec.getVolumeBackupLocation());
        backupInstanceInfo.setPreHookName(spec.getPreHookName());
        backupInstanceInfo.setPostHookName(spec.getPostHookName());
        backupInstanceInfo.setEnable(spec.getEnable().booleanValue());
        BackupInstanceStatus status = (BackupInstanceStatus)backupInstance.getStatus();
        if (status != null) {
            backupInstanceInfo.setStatus(status.getStatus());
            backupInstanceInfo.setBackupPolicyNamesInStatus(status.getBackupPolicyNames());
        }
        return backupInstanceInfo;
    }

    private static BackupInstanceSpec getBackupInstanceSpec(BackupInstanceInfo info) {
        if (info.isParamsAnyBlank()) {
            LOGGER.error((Object)info.toString());
            throw new LegoCheckedException(1073947393L);
        }
        BackupInstanceSpec spec = new BackupInstanceSpec();
        spec.setResourceSetName(info.getResourceSetName());
        spec.setBackupPolicyNames(info.getBackupPolicyNames());
        spec.setMetadataBackupLocation(info.getMetadataBackupLocation());
        spec.setVolumeBackupLocation(info.getVolumeBackupLocation());
        spec.setEnable(info.isEnable());
        spec.setPreHookName(info.getPreHookName());
        spec.setPostHookName(info.getPostHookName());
        spec.setReclaimPolicy(BackupInstanceSpec.ReclaimPolicy.DELETE);
        String cdrBackupSpeed = KubeEnumDefine.SpeedType.getCdrRestoreSpeed((String)String.valueOf(info.getBackupSpeed()));
        spec.setBackupSpeed(BackupInstanceSpec.BackupSpeed.getBackupSpeed(cdrBackupSpeed));
        spec.setEnableConsistentSnapshot(info.isEnableConsistentSnapshot());
        return spec;
    }

    public static BackupLocation transToBackupLocation(BackupLocationInfo info) {
        ObjectMeta meta = new ObjectMeta();
        meta.setName(info.getName());
        BackupLocationSpec spec = new BackupLocationSpec();
        spec.setProviderName(LOCATION_PROVIDER_NAME);
        spec.setConfig(KubeConvertUtil.getLocationConfigMap(info));
        BackupLocation location = new BackupLocation();
        location.setMetadata(meta);
        location.setSpec(spec);
        return location;
    }

    public static BackupLocationInfo transToBackupLocationInfo(BackupLocation backupLocation) {
        BackupLocationInfo backupLocationInfo = new BackupLocationInfo();
        backupLocationInfo.setName(backupLocation.getMetadata().getName());
        Map<String, String> configMap = ((BackupLocationSpec)backupLocation.getSpec()).getConfig();
        if (VerifyUtil.isEmpty(configMap)) {
            return backupLocationInfo;
        }
        backupLocationInfo.setSourceBackendName(configMap.get(SOURCE_BACKEND_NAME));
        backupLocationInfo.setBackupBackendName(configMap.get(BACKUP_BACKEND_NAME));
        backupLocationInfo.setRestoreBackendName(configMap.get(RESTORE_BACKEND_NAME));
        return backupLocationInfo;
    }

    private static Map<String, String> getLocationConfigMap(BackupLocationInfo info) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(SOURCE_BACKEND_NAME, info.getSourceBackendName());
        configMap.put(BACKUP_BACKEND_NAME, info.getBackupBackendName());
        configMap.put(RESTORE_BACKEND_NAME, info.getRestoreBackendName());
        configMap.put("backupType", info.getBackupType().getValue());
        return configMap;
    }

    private static Map<String, String> getLabels(String labelStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (VerifyUtil.isEmpty((String)labelStr)) {
            return map;
        }
        ArrayList labels = new ArrayList();
        Map labelMap = (Map)JSONObject.toBean((String)labelStr, Map.class);
        labelMap.forEach((mapKey, mapValue) -> labels.add(mapKey + ":" + mapValue));
        labels.stream().map(String::trim).collect(Collectors.toList()).forEach(str -> {
            String key = str.split(":")[0];
            String value = str.split(":")[1];
            if (!VerifyUtil.isEmpty((String)key) && !VerifyUtil.isEmpty((String)value)) {
                map.put(key, value);
            }
        });
        return map;
    }

    private static List<ExcludeResources> getExcludeResources(String objects) {
        if (VerifyUtil.isEmpty((String)objects)) {
            return Collections.emptyList();
        }
        JSONArray array = JSONArray.fromObject((Object)objects);
        List excludeResources = JSONArray.toCollection((JSONArray)array, ExcludeResources.class);
        excludeResources.forEach(resource -> KubeConvertUtil.checkResourceKind(resource.getKind(), resource.getName()));
        return excludeResources;
    }

    private static List<IncludeResources> getIncludeResources(String objects) {
        if (VerifyUtil.isEmpty((String)objects)) {
            return Collections.emptyList();
        }
        JSONArray array = JSONArray.fromObject((Object)objects);
        List includeResources = JSONArray.toCollection((JSONArray)array, IncludeResources.class);
        includeResources.forEach(resource -> KubeConvertUtil.checkResourceKind(resource.getKind(), resource.getName()));
        return includeResources;
    }

    private static void checkResourceKind(String kind, String resourceName) {
        if (VerifyUtil.isEmpty((String)kind)) {
            LOGGER.error((Object)"The kind is empty, resourceName: %s", new Object[]{resourceName});
            throw new LegoCheckedException(1073947393L);
        }
        if (!SUPPORT_RESOURCE_TYPE.contains(kind.toLowerCase(Locale.ROOT))) {
            LOGGER.error((Object)"The kind is not support, resourceName: %s, kind: %s", new Object[]{resourceName, kind});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static List<KubeResourceSetPVC> transToResourceSetPVC(ResourceDetail resourceDetail) {
        List resources = Optional.ofNullable(resourceDetail.getStatus()).map(ResourceDetailStatus::getResources).orElse(Collections.emptyList());
        String name = Optional.ofNullable(resourceDetail.getMetadata()).map(ObjectMeta::getName).orElse(null);
        if (VerifyUtil.isEmpty(resources)) {
            LOGGER.error((Object)"Not find any resource for trans by name: %s", new Object[]{name});
            return Collections.emptyList();
        }
        return resources.stream().filter(resource -> Objects.equals(resource.getKind(), "PersistentVolumeClaim")).map(KubeConvertUtil::transToPVC).collect(Collectors.toList());
    }

    private static KubeResourceSetPVC transToPVC(Resources resources) {
        KubeResourceSetPVC resourceSetPVC = new KubeResourceSetPVC();
        resourceSetPVC.setName(resources.getName());
        resourceSetPVC.setNamespace(resources.getNamespace());
        return resourceSetPVC;
    }

    public static Optional<KubePersistentVolume> transToKubePVs(PersistentVolume persistentVolume) {
        KubePersistentVolume kubePV = new KubePersistentVolume();
        PersistentVolumeSpec spec = persistentVolume.getSpec();
        if (spec != null) {
            CSIPersistentVolumeSource csi = Optional.ofNullable(spec.getCsi()).orElse(new CSIPersistentVolumeSource());
            kubePV.setVolumeHandle(csi.getVolumeHandle());
            kubePV.setDriver(csi.getDriver());
            if (!VerifyUtil.isEmpty((Map)csi.getVolumeAttributes())) {
                kubePV.setBackend((String)csi.getVolumeAttributes().get("backend"));
            }
            kubePV.setVolumeMode(spec.getVolumeMode());
            String claimName = Optional.ofNullable(spec.getClaimRef()).map(ObjectReference::getName).orElse(null);
            String namespace = Optional.ofNullable(spec.getClaimRef()).map(ObjectReference::getNamespace).orElse(null);
            kubePV.setClaim(namespace + "/" + claimName);
            Optional.ofNullable(spec.getStorageClassName()).ifPresent(arg_0 -> ((KubePersistentVolume)kubePV).setStorageClass(arg_0));
            kubePV.setCapacity(KubeConvertUtil.getPVCapacity(spec));
        }
        String id = Optional.ofNullable(persistentVolume.getMetadata()).map(ObjectMeta::getUid).orElse(null);
        kubePV.setId(id);
        String name = Optional.ofNullable(persistentVolume.getMetadata()).map(ObjectMeta::getName).orElse(null);
        kubePV.setName(name);
        return Optional.of(kubePV);
    }

    private static double getPVCapacity(PersistentVolumeSpec spec) {
        Quantity capacity = ((Map)Optional.ofNullable(spec.getCapacity()).orElse(new HashMap())).getOrDefault("storage", new Quantity("0"));
        BigDecimal value = Quantity.getAmountInBytes((Quantity)capacity).divide(DIVIDE_BYTE_TO_GB, 2, RoundingMode.HALF_DOWN);
        return value.doubleValue();
    }

    public static Optional<KubeRecoveryPlan> transToKubeRecoveryPlan(RecoveryPlan recoveryPlan) {
        KubeRecoveryPlan kubeRecoveryPlan = new KubeRecoveryPlan();
        String name = Optional.ofNullable(recoveryPlan.getMetadata()).map(ObjectMeta::getName).orElse(null);
        kubeRecoveryPlan.setName(name);
        String protectionName = Optional.ofNullable(recoveryPlan.getSpec()).map(RecoveryPlanSpec::getProtectionPlanName).orElse(null);
        kubeRecoveryPlan.setProtectionPlanName(protectionName);
        String role = Optional.ofNullable(recoveryPlan.getSpec()).map(RecoveryPlanSpec::getRole).orElse(null);
        kubeRecoveryPlan.setRole(role);
        String postHookName = Optional.ofNullable(recoveryPlan.getSpec()).map(RecoveryPlanSpec::getPostHookName).orElse(null);
        kubeRecoveryPlan.setPostHookName(postHookName);
        return Optional.of(kubeRecoveryPlan);
    }

    public static PersistentVolumeClaim transToPVCInKube(PersistentVolumeClaimInfo claimInfo) {
        if (claimInfo.isParamsAnyBlank()) {
            LOGGER.error((Object)claimInfo.toString());
            throw new LegoCheckedException(1073947393L);
        }
        PersistentVolumeClaim pvc = new PersistentVolumeClaim();
        ObjectMeta meta = new ObjectMeta();
        meta.setName(claimInfo.getName());
        meta.setNamespace(claimInfo.getNameSpace());
        meta.setLabels(claimInfo.getLabelMap());
        pvc.setMetadata(meta);
        PersistentVolumeClaimSpec spec = new PersistentVolumeClaimSpec();
        spec.setAccessModes(claimInfo.getAccessModes());
        spec.setStorageClassName(claimInfo.getStorageClassName());
        spec.setVolumeMode(claimInfo.getVolumeMode());
        ResourceRequirements requirements = new ResourceRequirements();
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        Quantity quantity = new Quantity();
        quantity.setAmount(claimInfo.getAmount());
        quantity.setFormat(claimInfo.getFormat());
        requests.put("storage", quantity);
        requirements.setRequests(requests);
        spec.setResources(requirements);
        pvc.setSpec(spec);
        return pvc;
    }

    public static StorageClass transToStorageClass(StorageClassInfo classInfo) {
        ObjectMeta meta = new ObjectMeta();
        meta.setName(classInfo.getName());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("createByBcmAt", String.valueOf(System.currentTimeMillis()));
        meta.setLabels(labels);
        StorageClass storageClass = new StorageClass();
        storageClass.setMetadata(meta);
        storageClass.setProvisioner(classInfo.getProvisioner());
        storageClass.setReclaimPolicy(classInfo.getReclaimPolicy());
        storageClass.setVolumeBindingMode(classInfo.getVolumeBindingMode());
        storageClass.setAllowVolumeExpansion(classInfo.getCanAllowVolumeExpansion());
        storageClass.setParameters(classInfo.getParameters());
        return storageClass;
    }

    public static RecoveryPlan transToRecoveryPlan(KubeRecoveryPlan kubeRecoveryPlan) {
        if (kubeRecoveryPlan.isParamsAnyBlank()) {
            LOGGER.error((Object)kubeRecoveryPlan.toString());
            throw new LegoCheckedException(1073947393L);
        }
        ObjectMeta meta = new ObjectMeta();
        meta.setName(kubeRecoveryPlan.getName());
        RecoveryPlan recoveryPlan = new RecoveryPlan();
        recoveryPlan.setMetadata(meta);
        RecoveryPlanSpec spec = new RecoveryPlanSpec();
        spec.setRole(kubeRecoveryPlan.getRole());
        spec.setProtectionPlanName(kubeRecoveryPlan.getProtectionPlanName());
        spec.setPostHookName(kubeRecoveryPlan.getPostHookName());
        recoveryPlan.setSpec(spec);
        return recoveryPlan;
    }

    public static VolumeSet tansToVolumeSet(KubeVolumeSet kubeVolumeSet) {
        ObjectMeta meta = new ObjectMeta();
        meta.setName(kubeVolumeSet.getName());
        VolumeSet volumeSet = new VolumeSet();
        volumeSet.setMetadata(meta);
        VolumeSetSpec spec = new VolumeSetSpec();
        VolumeSetSpec.Role role = kubeVolumeSet.getRoleType() == KubeEnumDefine.RoleType.PROTECTED ? VolumeSetSpec.Role.PROTECTED : VolumeSetSpec.Role.RECOVERY;
        spec.setRole(role);
        MetadataPairInfo pairInfo = kubeVolumeSet.getMetadataPairInfo();
        spec.setMetadataPair(KubeConvertUtil.tranToMetadataPair(pairInfo));
        List<VolumePairs> volumePairs = kubeVolumeSet.getVolumePairs().stream().map(KubeConvertUtil::transToVolumePairs).collect(Collectors.toList());
        spec.setVolumePairs(volumePairs);
        volumeSet.setSpec(spec);
        return volumeSet;
    }

    public static KubeVolumeSet tansToKubeVolumeSet(VolumeSet volumeSet) {
        KubeVolumeSet kubeVolumeSet = new KubeVolumeSet();
        ObjectMeta meta = volumeSet.getMetadata();
        if (!VerifyUtil.isEmpty((Object)meta)) {
            kubeVolumeSet.setName(meta.getName());
        }
        VolumeSetSpec spec = (VolumeSetSpec)volumeSet.getSpec();
        MetadataPairInfo info = new MetadataPairInfo();
        if (!VerifyUtil.isEmpty((Object)spec)) {
            kubeVolumeSet.setRoleType(spec.getRole() == VolumeSetSpec.Role.PROTECTED ? KubeEnumDefine.RoleType.PROTECTED : KubeEnumDefine.RoleType.RECOVERY);
            MetadataPair metadataPair = spec.getMetadataPair();
            info.setPrimaryPVName(metadataPair.getPrimaryPVName());
            info.setSecondaryPVName(metadataPair.getSecondaryPVName());
            info.setPvcMeta(metadataPair.getPVCMeta());
            List<VolumePairs> volumePairs = spec.getVolumePairs();
            ArrayList<MetadataPairInfo> infos = new ArrayList<MetadataPairInfo>(volumePairs.size());
            for (VolumePairs pair : volumePairs) {
                MetadataPairInfo curInfo = new MetadataPairInfo();
                curInfo.setPvcMeta(pair.getPVCMeta());
                curInfo.setPrimaryPVName(pair.getPrimaryPVName());
                curInfo.setSecondaryPVName(pair.getSecondaryPVName());
                infos.add(curInfo);
            }
            kubeVolumeSet.setVolumePairs(infos);
        }
        kubeVolumeSet.setMetadataPairInfo(info);
        return kubeVolumeSet;
    }

    private static VolumePairs transToVolumePairs(MetadataPairInfo info) {
        VolumePairs pair = new VolumePairs();
        pair.setPVCMeta(info.getPvcMeta());
        pair.setPrimaryPVName(info.getPrimaryPVName());
        pair.setSecondaryPVName(info.getSecondaryPVName());
        return pair;
    }

    private static MetadataPair tranToMetadataPair(MetadataPairInfo info) {
        MetadataPair pair = new MetadataPair();
        pair.setPVCMeta(info.getPvcMeta());
        pair.setPrimaryPVName(info.getPrimaryPVName());
        pair.setSecondaryPVName(info.getSecondaryPVName());
        return pair;
    }

    public static RestoreJob tansToRestoreJob(KubeRestoreJob kubeRestoreJob) {
        if (kubeRestoreJob.isParamsAnyBlank()) {
            LOGGER.error((Object)kubeRestoreJob.toString());
            throw new LegoCheckedException(1073947393L);
        }
        ObjectMeta meta = new ObjectMeta();
        meta.setName(kubeRestoreJob.getName());
        RestoreJob restoreJob = new RestoreJob();
        restoreJob.setMetadata(meta);
        restoreJob.setSpec(KubeConvertUtil.getRestoreJobSpec(kubeRestoreJob));
        return restoreJob;
    }

    public static KubeRestoreJob tansToBcmRestoreJob(RestoreJob restoreJob) {
        KubeRestoreJob kubeRestoreJob = new KubeRestoreJob();
        kubeRestoreJob.setId(restoreJob.getMetadata().getUid());
        kubeRestoreJob.setName(restoreJob.getMetadata().getName());
        kubeRestoreJob.setTargetNameSpace(restoreJob.getMetadata().getNamespace());
        kubeRestoreJob.setBackupName(((RestoreJobSpec)restoreJob.getSpec()).getBackupName());
        kubeRestoreJob.setRestorePrefix(((RestoreJobSpec)restoreJob.getSpec()).getRestorePrefix());
        kubeRestoreJob.setPreserveClusterIpAddr(((RestoreJobSpec)restoreJob.getSpec()).getPreserveClusterIpAddr().booleanValue());
        kubeRestoreJob.setPreserveNodePort(((RestoreJobSpec)restoreJob.getSpec()).getPreserveNodePort().booleanValue());
        RestoreJobStatus status = (RestoreJobStatus)restoreJob.getStatus();
        if (status == null) {
            kubeRestoreJob.setStage(KubeRestoreJobStatus.Stage.INITIAL);
            kubeRestoreJob.setState(KubeRestoreJobStatus.State.NEW);
        } else {
            kubeRestoreJob.setStage(KubeRestoreJobStatus.Stage.getStage((String)((RestoreJobStatus)restoreJob.getStatus()).getStage().getValue()));
            kubeRestoreJob.setState(KubeRestoreJobStatus.State.getState((String)((RestoreJobStatus)restoreJob.getStatus()).getState().getValue()));
        }
        return kubeRestoreJob;
    }

    public static ProtectionJob tansToProtectionJob(KubeProtectionJob kubeProtectionJob) {
        ObjectMeta meta = new ObjectMeta();
        meta.setName(kubeProtectionJob.getName());
        meta.setLabels(kubeProtectionJob.getLabels());
        ProtectionJobSpec protectionJobSpec = new ProtectionJobSpec();
        protectionJobSpec.setProtectionPlanName(kubeProtectionJob.getProtectionPlanName());
        ProtectionJob protectionJob = new ProtectionJob();
        protectionJob.setMetadata(meta);
        protectionJob.setSpec(protectionJobSpec);
        return protectionJob;
    }

    public static BackupJob tansToBackupJob(KubeBackupJob kubeBackupJob) {
        ObjectMeta meta = new ObjectMeta();
        meta.setName(kubeBackupJob.getName());
        meta.setLabels(kubeBackupJob.getLabels());
        BackupJobSpec backupJobSpec = new BackupJobSpec();
        backupJobSpec.setBackupInstanceName(kubeBackupJob.getBackupInstanceName());
        BackupJob backupJob = new BackupJob();
        backupJob.setMetadata(meta);
        backupJob.setSpec(backupJobSpec);
        return backupJob;
    }

    public static KubeBackupJob tansToBcmBackupJob(BackupJob backupJob) {
        BackupJobStatus status;
        KubeBackupJob bcmBackupJob = new KubeBackupJob();
        bcmBackupJob.setId(backupJob.getMetadata().getUid());
        bcmBackupJob.setName(backupJob.getMetadata().getName());
        BackupJobSpec spec = (BackupJobSpec)backupJob.getSpec();
        if (spec != null) {
            bcmBackupJob.setBackupInstanceName(spec.getBackupInstanceName());
        }
        if ((status = (BackupJobStatus)backupJob.getStatus()) != null) {
            bcmBackupJob.setStatus(status.getBackupStatus());
            bcmBackupJob.setStage(status.getBackupStage());
            bcmBackupJob.setCreateTimestamp(status.getCreateTimestamp());
            bcmBackupJob.setLastUpdateTimestamp(status.getLastUpdateTimestamp());
        }
        bcmBackupJob.setLabels(backupJob.getMetadata().getLabels());
        return bcmBackupJob;
    }

    public static KubeProtectionJob tansToBcmProtectionJob(ProtectionJob protectionJob) {
        KubeProtectionJob bcmProtectionJob = new KubeProtectionJob();
        bcmProtectionJob.setId(protectionJob.getMetadata().getUid());
        bcmProtectionJob.setName(protectionJob.getMetadata().getName());
        bcmProtectionJob.setProtectionPlanName(((ProtectionJobSpec)protectionJob.getSpec()).getProtectionPlanName());
        ProtectionJobStatus status = (ProtectionJobStatus)protectionJob.getStatus();
        if (status != null) {
            bcmProtectionJob.setStatus(status.getProtectionStatus());
            bcmProtectionJob.setStage(status.getProtectionStage());
            bcmProtectionJob.setCreateTimestamp(status.getStartTimestamp());
            bcmProtectionJob.setLastUpdateTimestamp(status.getLastUpdateTimestamp());
            bcmProtectionJob.setCreateTimestamp(status.getStartTimestamp());
        }
        bcmProtectionJob.setLabels(protectionJob.getMetadata().getLabels());
        bcmProtectionJob.setProtectionPlanName(((ProtectionJobSpec)protectionJob.getSpec()).getProtectionPlanName());
        return bcmProtectionJob;
    }

    public static KubeBackup transToBcmBackup(Backup backup) {
        KubeBackup bcmBackup = new KubeBackup();
        bcmBackup.setId(backup.getMetadata().getUid());
        bcmBackup.setName(backup.getMetadata().getName());
        BackupStatus status = (BackupStatus)backup.getStatus();
        if (status != null) {
            bcmBackup.setStartTimestamp(status.getStartTimestamp());
            bcmBackup.setCompletionTimestamp(status.getCompletionTimestamp());
            bcmBackup.setStatus(status.getState().getValue());
        }
        bcmBackup.setLocation(Optional.ofNullable(backup.getSpec()).map(BackupSpec::getVolumeBackupLocations).orElse(Collections.emptyList()));
        return bcmBackup;
    }

    private static RestoreJobSpec getRestoreJobSpec(KubeRestoreJob kubeRestoreJob) {
        RestoreJobSpec spec = new RestoreJobSpec();
        spec.setBackupName(kubeRestoreJob.getBackupName());
        spec.setTargetNameSpace(kubeRestoreJob.getTargetNameSpace());
        spec.setRestorePrefix(kubeRestoreJob.getRestorePrefix());
        spec.setPostHookName(kubeRestoreJob.getPostHookName());
        spec.setRestoreSpeed(kubeRestoreJob.getRestoreSpeed());
        spec.setPreserveNodePort(kubeRestoreJob.isPreserveNodePort());
        spec.setPreserveClusterIpAddr(kubeRestoreJob.isPreserveClusterIpAddr());
        return spec;
    }

    public static ProtectionPlan transToProtectPlan(KubeProtectionPlan kubePlan) {
        if (kubePlan.isParamsAnyBlank()) {
            LOGGER.error((Object)kubePlan.toString());
            throw new LegoCheckedException(1073947393L);
        }
        ObjectMeta meta = new ObjectMeta();
        meta.setName(kubePlan.getName());
        ProtectionPlanSpec spec = KubeConvertUtil.getProtectionPlanSpec(kubePlan);
        ProtectionPlan plan = new ProtectionPlan();
        plan.setMetadata(meta);
        plan.setSpec(spec);
        return plan;
    }

    public static KubeProtectionPlan transToKubeProtectPlan(ProtectionPlan protectionPlan) {
        KubeProtectionPlan plan = new KubeProtectionPlan();
        plan.setName(protectionPlan.getMetadata().getName());
        ProtectionPlanSpec spec = (ProtectionPlanSpec)protectionPlan.getSpec();
        plan.setResourceSet(spec.getResourceSet());
        plan.setVolumeSet(spec.getVolumeSet());
        KubeEnumDefine.RoleType roleType = spec.getRole() == ProtectionPlanSpec.Role.PROTECTED ? KubeEnumDefine.RoleType.PROTECTED : KubeEnumDefine.RoleType.RECOVERY;
        plan.setRoleType(roleType);
        plan.setProtectionPolicies(spec.getProtectionPolicies());
        plan.setEnableVolumeConsistency(spec.getEnableVolumeConsistency().booleanValue());
        plan.setLocalCluster(spec.getLocalCluster());
        plan.setRemoteCluster(spec.getRemoteCluster());
        plan.setLocalSBCSn(spec.getLocalStorageBackend().getStorageBackendClaimSN());
        plan.setLocalSBCName(spec.getLocalStorageBackend().getStorageBackendClaimName());
        plan.setRemoteSBCSn(spec.getRemoteStorageBackend().getStorageBackendClaimSN());
        plan.setRemoteSBCName(spec.getRemoteStorageBackend().getStorageBackendClaimName());
        plan.setPreHook(spec.getPreHook());
        plan.setPostHook(spec.getPostHook());
        plan.setEnable(spec.getEnable().booleanValue());
        plan.setRetainVolumePair(spec.getRetainVolumePair().booleanValue());
        plan.setRebuildSwitch(spec.getRebuildSwitch().booleanValue());
        plan.setProtectionPolicies(((ProtectionPlanSpec)protectionPlan.getSpec()).getProtectionPolicies());
        if (!VerifyUtil.isEmpty((Object)protectionPlan.getStatus())) {
            plan.setStatus(KubeEnumDefine.CDRProtectGroupStatus.getStatus((String)((ProtectionPlanStatus)protectionPlan.getStatus()).getStatus()));
            plan.setProtectionPoliciesInstatus(((ProtectionPlanStatus)protectionPlan.getStatus()).getProtectionPolicies());
            plan.setProtectionSchedulesInStatus(((ProtectionPlanStatus)protectionPlan.getStatus()).getProtectionSchedules());
        }
        return plan;
    }

    private static ProtectionPlanSpec getProtectionPlanSpec(KubeProtectionPlan kubePlan) {
        ProtectionPlanSpec spec = new ProtectionPlanSpec();
        if (!VerifyUtil.isEmpty((String)kubePlan.getResourceSet())) {
            spec.setResourceSet(kubePlan.getResourceSet());
        }
        spec.setVolumeSet(kubePlan.getVolumeSet());
        ProtectionPlanSpec.Role role = kubePlan.getRoleType() == KubeEnumDefine.RoleType.PROTECTED ? ProtectionPlanSpec.Role.PROTECTED : ProtectionPlanSpec.Role.RECOVERY;
        spec.setRole(role);
        spec.setProtectionPolicies(kubePlan.getProtectionPolicies());
        spec.setEnableVolumeConsistency(kubePlan.isEnableVolumeConsistency());
        spec.setLocalCluster(kubePlan.getLocalCluster());
        spec.setRemoteCluster(kubePlan.getRemoteCluster());
        LocalStorageBackend localStorageBackend = new LocalStorageBackend();
        localStorageBackend.setStorageBackendClaimSN(kubePlan.getLocalSBCSn());
        localStorageBackend.setStorageBackendClaimName(kubePlan.getLocalSBCName());
        spec.setLocalStorageBackend(localStorageBackend);
        RemoteStorageBackend remoteStorageBackend = new RemoteStorageBackend();
        remoteStorageBackend.setStorageBackendClaimSN(kubePlan.getRemoteSBCSn());
        remoteStorageBackend.setStorageBackendClaimName(kubePlan.getRemoteSBCName());
        spec.setRemoteStorageBackend(remoteStorageBackend);
        if (!VerifyUtil.isEmpty((String)kubePlan.getPreHook())) {
            spec.setPreHook(kubePlan.getPreHook());
        }
        if (!VerifyUtil.isEmpty((String)kubePlan.getPostHook())) {
            spec.setPostHook(kubePlan.getPostHook());
        }
        spec.setEnable(kubePlan.isEnable());
        spec.setRetainTargetVolume(kubePlan.isRetainVolumePair());
        spec.setRebuildSwitch(kubePlan.isRebuildSwitch());
        spec.setVolumeSpeed(ProtectionPlanSpec.VolumeSpeed.getVolumeSpeed(kubePlan.getVolumeSpeed().getValue()));
        return spec;
    }

    public static KubeSchedulePolicy transToSchedulePolicyInfo(SchedulePolicy policy) {
        KubeSchedulePolicy policyInfo = new KubeSchedulePolicy();
        policyInfo.setName(policy.getMetadata().getName());
        policyInfo.setId(policy.getMetadata().getUid());
        SchedulePolicySpec policySpec = (SchedulePolicySpec)policy.getPolicy();
        if (KubeConvertUtil.checkPolicySpecExist(policySpec)) {
            KubeConvertUtil.setPolicy(policyInfo, policySpec);
        } else if (!VerifyUtil.isEmpty(policy.getTimedWait())) {
            policyInfo.setTimeWait(KubeEnumDefine.TimeWaitType.getTimeWaitType((String)((ScheduleTimeWait)policy.getTimedWait()).getTimedWaitType()));
            policyInfo.setSeconds(((ScheduleTimeWait)policy.getTimedWait()).getSeconds().intValue());
        } else {
            LOGGER.error((Object)"The received object is error.");
            throw new LegoCheckedException(2117645L);
        }
        return policyInfo;
    }

    private static boolean checkPolicySpecExist(SchedulePolicySpec policySpec) {
        if (VerifyUtil.isEmpty((Object)policySpec)) {
            return false;
        }
        boolean isDailyOrHourlyPolicyExist = !VerifyUtil.isEmpty((Object)policySpec.getDaily()) || !VerifyUtil.isEmpty((Object)policySpec.getHourly());
        boolean isWeeklyOrMonthlyPolicyExist = !VerifyUtil.isEmpty((Object)policySpec.getWeekly()) || !VerifyUtil.isEmpty((Object)policySpec.getMonthly());
        return isDailyOrHourlyPolicyExist || isWeeklyOrMonthlyPolicyExist;
    }

    public static PersistentVolumeClaimInfo transToPersistentVolumeClaimInfo(PersistentVolumeClaim persistentVolumeClaim) {
        PersistentVolumeClaimInfo persistentVolumeClaimInfo = new PersistentVolumeClaimInfo();
        persistentVolumeClaimInfo.setName(persistentVolumeClaim.getMetadata().getName());
        persistentVolumeClaimInfo.setNameSpace(persistentVolumeClaim.getMetadata().getNamespace());
        persistentVolumeClaimInfo.setApiVersion(persistentVolumeClaim.getApiVersion());
        persistentVolumeClaimInfo.setKind(persistentVolumeClaim.getKind());
        persistentVolumeClaimInfo.setAdditionalProperties(persistentVolumeClaim.getAdditionalProperties());
        persistentVolumeClaimInfo.setId(persistentVolumeClaim.getMetadata().getUid());
        persistentVolumeClaimInfo.setStorageClassName(persistentVolumeClaim.getSpec().getStorageClassName());
        return persistentVolumeClaimInfo;
    }

    public static PersistentVolumeClaim transToPersistentVolumeClaim(PersistentVolumeClaimInfo persistentVolumeClaimInfo) {
        ObjectMeta meta = new ObjectMeta();
        meta.setName(persistentVolumeClaimInfo.getName());
        meta.setUid(persistentVolumeClaimInfo.getId());
        meta.setNamespace(persistentVolumeClaimInfo.getNameSpace());
        PersistentVolumeClaim persistentVolumeClaim = new PersistentVolumeClaim();
        persistentVolumeClaim.setMetadata(meta);
        persistentVolumeClaim.setAdditionalProperties(persistentVolumeClaimInfo.getAdditionalProperties());
        persistentVolumeClaim.setKind(persistentVolumeClaimInfo.getKind());
        persistentVolumeClaim.setApiVersion(persistentVolumeClaimInfo.getApiVersion());
        return persistentVolumeClaim;
    }

    private static void setPolicy(KubeSchedulePolicy policyInfo, SchedulePolicySpec policySpec) {
        if (!VerifyUtil.isEmpty((Object)policySpec.getDaily())) {
            policyInfo.setPolicyType(KubeEnumDefine.PolicyType.DAILY);
            policyInfo.setRetain(policySpec.getDaily().getRetain().intValue());
            policyInfo.setTime(policySpec.getDaily().getTime());
            return;
        }
        if (!VerifyUtil.isEmpty((Object)policySpec.getHourly())) {
            policyInfo.setPolicyType(KubeEnumDefine.PolicyType.HOURS);
            policyInfo.setRetain(policySpec.getHourly().getRetain().intValue());
            policyInfo.setMinutes(policySpec.getHourly().getMinutes().intValue());
            return;
        }
        if (!VerifyUtil.isEmpty((Object)policySpec.getWeekly())) {
            policyInfo.setPolicyType(KubeEnumDefine.PolicyType.WEEKLY);
            policyInfo.setRetain(policySpec.getWeekly().getRetain().intValue());
            policyInfo.setWeeklyDays(policySpec.getWeekly().getDays());
            policyInfo.setTime(policySpec.getWeekly().getTime());
            return;
        }
        if (!VerifyUtil.isEmpty((Object)policySpec.getMonthly())) {
            policyInfo.setPolicyType(KubeEnumDefine.PolicyType.MONTHLY);
            policyInfo.setRetain(policySpec.getMonthly().getRetain().intValue());
            policyInfo.setMonthlyDates(policySpec.getMonthly().getDates());
            policyInfo.setTime(policySpec.getMonthly().getTime());
        }
    }

    public static Cluster transToCluster(ClusterInfo clusterInfo) {
        ApiServer apiServer = new ApiServer();
        apiServer.setUrl(clusterInfo.getUrl());
        ClusterSpec spec = new ClusterSpec();
        spec.setLocal(clusterInfo.isLocal());
        spec.setApiServer(apiServer);
        ObjectMeta meta = new ObjectMeta();
        meta.setName(clusterInfo.getName());
        Cluster cluster = new Cluster();
        cluster.setSpec(spec);
        cluster.setMetadata(meta);
        return cluster;
    }

    public static KubeEvent transKubeEvent(Event event) {
        KubeEvent kubeEvent = new KubeEvent();
        kubeEvent.setName(event.getMetadata().getName());
        kubeEvent.setAction(event.getAction());
        kubeEvent.setApiVersion(event.getApiVersion());
        kubeEvent.setFirstTimestamp(event.getFirstTimestamp());
        kubeEvent.setLastTimestamp(event.getLastTimestamp());
        kubeEvent.setReason(event.getReason());
        kubeEvent.setMessage(event.getMessage());
        kubeEvent.setCount(event.getCount());
        kubeEvent.setObjectType(event.getInvolvedObject().getKind());
        kubeEvent.setObjectName(event.getInvolvedObject().getName());
        return kubeEvent;
    }

    public static RecoveryJob tansToRecoveryJob(KubeRecoveryJob kubeRecoveryJob) {
        if (kubeRecoveryJob.isParamsAnyBlank()) {
            LOGGER.error((Object)"Create recovery job error, cause parameter is invalid, parameter: %s", new Object[]{kubeRecoveryJob.toString()});
            throw new LegoCheckedException(1073947393L);
        }
        ObjectMeta meta = new ObjectMeta();
        meta.setName(kubeRecoveryJob.getName());
        RecoveryJob recoveryJob = new RecoveryJob();
        recoveryJob.setMetadata(meta);
        recoveryJob.setSpec(KubeConvertUtil.getRecoveryJobSpec(kubeRecoveryJob));
        return recoveryJob;
    }

    private static RecoveryJobSpec getRecoveryJobSpec(KubeRecoveryJob kubeRecoveryJob) {
        RecoveryJobSpec spec = new RecoveryJobSpec();
        spec.setRecoveryPlanName(kubeRecoveryJob.getRecoveryPlanName());
        Optional<RecoveryJobSpec.Type> recoveryJobType = RecoveryJobSpec.Type.getRecoveryJobType(kubeRecoveryJob.getType());
        if (!recoveryJobType.isPresent()) {
            LOGGER.error((Object)"Create recovery job error, cause recovery job type is invalid, job type: %s", new Object[]{kubeRecoveryJob.getType()});
            throw new LegoCheckedException(1073947393L);
        }
        Optional<RecoveryJobSpec.Operation> recoveryJobOperation = KubeConvertUtil.getRecoveryJobOperation(kubeRecoveryJob.getOperation());
        if (!recoveryJobOperation.isPresent()) {
            LOGGER.error((Object)"Create recovery job error, cause recovery job operation is invalid, job operation: %s", new Object[]{kubeRecoveryJob.getOperation()});
            throw new LegoCheckedException(1073947393L);
        }
        spec.setType(recoveryJobType.get());
        spec.setOperation(recoveryJobOperation.get());
        return spec;
    }

    public static KubeRecoveryJob tansToBcmRecoveryJob(RecoveryJob recoveryJob) {
        KubeRecoveryJob kubeRecoveryJob = new KubeRecoveryJob();
        kubeRecoveryJob.setId(recoveryJob.getMetadata().getUid());
        kubeRecoveryJob.setName(recoveryJob.getMetadata().getName());
        kubeRecoveryJob.setRecoveryPlanName(((RecoveryJobSpec)recoveryJob.getSpec()).getRecoveryPlanName());
        kubeRecoveryJob.setOperation(((RecoveryJobSpec)recoveryJob.getSpec()).getOperation().getValue());
        kubeRecoveryJob.setType(((RecoveryJobSpec)recoveryJob.getSpec()).getType().getValue());
        RecoveryJobStatus status = (RecoveryJobStatus)recoveryJob.getStatus();
        if (status != null) {
            kubeRecoveryJob.setStatus(status.getState());
            kubeRecoveryJob.setStage(status.getStage());
            kubeRecoveryJob.setLastUpdateTimestamp(status.getLastUpdateTimestamp());
        }
        return kubeRecoveryJob;
    }

    private static Optional<RecoveryJobSpec.Operation> getRecoveryJobOperation(String operationStr) {
        for (RecoveryJobSpec.Operation operation : RecoveryJobSpec.Operation.values()) {
            if (!operation.getValue().equals(operationStr)) continue;
            return Optional.of(operation);
        }
        return Optional.empty();
    }

    public static KubeResource transToKubeResource(Resources resources) {
        KubeResource resource = new KubeResource();
        resource.setVersion(resources.getApiVersion());
        resource.setKind(resources.getKind());
        resource.setName(resources.getName());
        resource.setNamespace(resources.getNamespace());
        return resource;
    }
}

