/*
 * Decompiled with CFR 0.152.
 */
package io.huawei.xuanwu.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"backupPolicyNames", "enable", "metadataBackupLocation", "postHookName", "preHookName", "reclaimPolicy", "resourceSetName", "volumeBackupLocation"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class BackupInstanceSpec
implements KubernetesResource {
    @JsonProperty(value="backupPolicyNames")
    @JsonPropertyDescription(value="BackupPolicyNames is a list of names of backupPolicy CRs. The backupPolicy includes the time strategy for performing backups.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> backupPolicyNames;
    @JsonProperty(value="enable")
    @JsonPropertyDescription(value="Enable field indicates the desired status of the instance, enable or disable. If the Enable field is not set, it will be set the initial value \"true\" by default. If set the value of the Enable is not \"true\" or \"false\", an error will be reported when creating backupInstance CR by k8s-api. If the Enable value is \"false\", the disabled backupInstance will not automatically execute the backupJob according to the backupPolicy, nor allow the backupInstance to be manually executed.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enable = true;
    @JsonProperty(value="metadataBackupLocation")
    @JsonPropertyDescription(value="MetadataBackupLocation is the metadata driver name")
    @JsonSetter(nulls=Nulls.SKIP)
    private String metadataBackupLocation;
    @JsonProperty(value="postHookName")
    @JsonPropertyDescription(value="PostHookName is the name of post rule crd, which should be executed during backup")
    @JsonSetter(nulls=Nulls.SKIP)
    private String postHookName;
    @JsonProperty(value="preHookName")
    @JsonPropertyDescription(value="PreHookName is the name of pre rule crd, which should be executed during backup")
    @JsonSetter(nulls=Nulls.SKIP)
    private String preHookName;
    @JsonProperty(value="reclaimPolicy")
    @JsonPropertyDescription(value="ReclaimPolicy is the delete policy of backupInstance CR. If the ReclaimPolicy field is not set, it will be set the initial value \"Retain\" by default. When the ReclaimPolicy value is \"Retain\", delete backupInstance CR itself and the associated backupSchedule CR. When the ReclaimPolicy value is \"Delete\", additionally, delete all related backup jobs.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ReclaimPolicy reclaimPolicy;
    @JsonProperty(value="resourceSetName")
    @JsonPropertyDescription(value="ResourceSetName is the name of resourceSet CR, resourceSet contains applications that need to be backed up")
    @JsonSetter(nulls=Nulls.SKIP)
    private String resourceSetName;
    @JsonProperty(value="volumeBackupLocation")
    @JsonPropertyDescription(value="VolumeBackupLocation is the persistent volume driver name")
    @JsonSetter(nulls=Nulls.SKIP)
    private String volumeBackupLocation;
    @JsonProperty(value="backupSpeed")
    @JsonPropertyDescription(value="BackupSpeed defines the rate of backup volume.")
    @JsonSetter(nulls=Nulls.SKIP)
    private BackupSpeed backupSpeed;
    @JsonProperty(value="enableConsistentSnapshot")
    @JsonPropertyDescription(value="EnableConsistentSnapshot indicates the desired status of the ConsistentSnapshot, enable or disable. If the EnableConsistentSnapshot field is not set, it will be set the initial value \"false\" by default.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enableConsistentSnapshot = false;

    public Boolean getEnableConsistentSnapshot() {
        return this.enableConsistentSnapshot;
    }

    public void setEnableConsistentSnapshot(Boolean enableConsistentSnapshot) {
        this.enableConsistentSnapshot = enableConsistentSnapshot;
    }

    public List<String> getBackupPolicyNames() {
        return this.backupPolicyNames;
    }

    public void setBackupPolicyNames(List<String> backupPolicyNames) {
        this.backupPolicyNames = backupPolicyNames;
    }

    public BackupSpeed getBackupSpeed() {
        return this.backupSpeed;
    }

    public void setBackupSpeed(BackupSpeed backupSpeed) {
        this.backupSpeed = backupSpeed;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getMetadataBackupLocation() {
        return this.metadataBackupLocation;
    }

    public void setMetadataBackupLocation(String metadataBackupLocation) {
        this.metadataBackupLocation = metadataBackupLocation;
    }

    public String getPostHookName() {
        return this.postHookName;
    }

    public void setPostHookName(String postHookName) {
        this.postHookName = postHookName;
    }

    public String getPreHookName() {
        return this.preHookName;
    }

    public void setPreHookName(String preHookName) {
        this.preHookName = preHookName;
    }

    public ReclaimPolicy getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    public void setReclaimPolicy(ReclaimPolicy reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
    }

    public String getResourceSetName() {
        return this.resourceSetName;
    }

    public void setResourceSetName(String resourceSetName) {
        this.resourceSetName = resourceSetName;
    }

    public String getVolumeBackupLocation() {
        return this.volumeBackupLocation;
    }

    public void setVolumeBackupLocation(String volumeBackupLocation) {
        this.volumeBackupLocation = volumeBackupLocation;
    }

    public static enum BackupSpeed {
        HIGHEST("Highest"),
        HIGH("High"),
        MEDIUM("Medium"),
        LOW("Low");

        String value;

        private BackupSpeed(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public static BackupSpeed getBackupSpeed(String speedStr) {
            if (VerifyUtil.isEmpty((String)speedStr)) {
                return MEDIUM;
            }
            for (BackupSpeed speed : BackupSpeed.values()) {
                if (!speedStr.equals(speed.value)) continue;
                return speed;
            }
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static enum ReclaimPolicy {
        DELETE("Delete"),
        RETAIN("Retain");

        String value;

        private ReclaimPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

