/*
 * Decompiled with CFR 0.152.
 */
package io.huawei.xuanwu.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "policy", "timedWait"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class CustomScheduleResource<P, T>
implements HasMetadata {
    private static final long serialVersionUID = 7701960097539005309L;
    private static final Logger LOG = LoggerFactory.getLogger(CustomScheduleResource.class);
    @JsonProperty(value="policy")
    protected P policy;
    @JsonProperty(value="timedWait")
    protected T timedWait;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private final String kind;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private final String apiVersion;
    private ObjectMeta metadata = new ObjectMeta();

    public CustomScheduleResource() {
        String version = super.getApiVersion();
        Class<?> clazz = this.getClass();
        if (Utils.isNullOrEmpty((String)version)) {
            throw new IllegalArgumentException(clazz.getName() + " CustomResource must provide an API version using @" + Group.class.getName() + " and @" + Version.class.getName() + " annotations");
        }
        this.apiVersion = version;
        this.kind = super.getKind();
    }

    public String toString() {
        return "CustomScheduleResource{kind='" + this.getKind() + '\'' + ", apiVersion='" + this.getApiVersion() + '\'' + ", metadata=" + this.metadata + ", policy=" + this.policy + ", timedWait=" + this.timedWait + '}';
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String version) {
        LOG.debug("Calling CustomScheduleResource#setApiVersion doesn't do anything because the API version is computed and shouldn't be changed");
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        LOG.debug("Calling CustomScheduleResource#setKind doesn't do anything because the Kind is computed and shouldn't be changed");
    }

    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public void setPolicy(P policy) {
        this.policy = policy;
    }

    public P getPolicy() {
        return this.policy;
    }

    public void setTimedWait(T timedWait) {
        this.timedWait = timedWait;
    }

    public T getTimedWait() {
        return this.timedWait;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomScheduleResource)) {
            return false;
        }
        CustomScheduleResource that = (CustomScheduleResource)o;
        if (!this.metadata.equals((Object)that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.policy, that.policy)) {
            return false;
        }
        if (!Objects.equals(this.timedWait, that.timedWait)) {
            return false;
        }
        if (!this.kind.equals(that.kind)) {
            return false;
        }
        return this.apiVersion.equals(that.apiVersion);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.metadata.hashCode();
        result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
        result = 31 * result + (this.timedWait != null ? this.timedWait.hashCode() : 0);
        result = 31 * result + this.kind.hashCode();
        result = 31 * result + this.apiVersion.hashCode();
        return result;
    }
}

