/*
 * Decompiled with CFR 0.152.
 */
package io.huawei.xuanwu.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.huawei.xuanwu.v1.volumereplicationpairspec.PrimaryPV;
import io.huawei.xuanwu.v1.volumereplicationpairspec.SecondaryPV;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"clusterType", "parameters", "primaryPV", "provider", "replicationModel", "secondaryPV"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class VolumeReplicationPairSpec
implements KubernetesResource {
    @JsonProperty(value="clusterType")
    @JsonPropertyDescription(value="ClusterType is optional, defines the clusterType of replication,default is InCluster")
    @JsonSetter(nulls=Nulls.SKIP)
    private ClusterType clusterType = (ClusterType)((Object)Serialization.unmarshal((String)"\"InCluster\"", ClusterType.class));
    @JsonProperty(value="parameters")
    @JsonPropertyDescription(value="User defined parameter for extension Non-public attributes, put them here. For now, include: primaryBackendName/secondaryBackendName/primaryBackendSN/secondaryBackendSN/syncRate")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> parameters;
    @JsonProperty(value="primaryPV")
    @JsonPropertyDescription(value="PrimaryPV is required in VolumeReplicationPair")
    @JsonSetter(nulls=Nulls.SKIP)
    private PrimaryPV primaryPV;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Provider is required in VolumeReplicationPair, used to filter the provider to create pair")
    @JsonSetter(nulls=Nulls.SKIP)
    private String provider;
    @JsonProperty(value="replicationModel")
    @JsonPropertyDescription(value="ReplicationModel is optional in VolumeReplicationPair, default ReplicationModelType is Async")
    @JsonSetter(nulls=Nulls.SKIP)
    private ReplicationModel replicationModel = (ReplicationModel)((Object)Serialization.unmarshal((String)"\"Async\"", ReplicationModel.class));
    @JsonProperty(value="secondaryPV")
    @JsonPropertyDescription(value="SecondaryPV is optional in VolumeReplicationPair")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecondaryPV secondaryPV;

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(ClusterType clusterType) {
        this.clusterType = clusterType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public PrimaryPV getPrimaryPV() {
        return this.primaryPV;
    }

    public void setPrimaryPV(PrimaryPV primaryPV) {
        this.primaryPV = primaryPV;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ReplicationModel getReplicationModel() {
        return this.replicationModel;
    }

    public void setReplicationModel(ReplicationModel replicationModel) {
        this.replicationModel = replicationModel;
    }

    public SecondaryPV getSecondaryPV() {
        return this.secondaryPV;
    }

    public void setSecondaryPV(SecondaryPV secondaryPV) {
        this.secondaryPV = secondaryPV;
    }

    public static enum ReplicationModel {
        SYNC("Sync"),
        ASYNC("Async");

        String value;

        private ReplicationModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum ClusterType {
        INCLUSTER("InCluster"),
        ACROSSCLUSTER("AcrossCluster");

        String value;

        private ClusterType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

