/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.cluster;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.agent.action.ClusterAction;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.cluster.OraclePowerHAAdapter;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OracleHpServiceGuradAdapter
extends OraclePowerHAAdapter {
    private static final Log LOGGER = LogFactory.getInstance(OracleHpServiceGuradAdapter.class);

    @Override
    public void startDatabase(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"start db,po is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)("begin start db:" + po.getName() + "," + po.getProviderSN()), 90160758786988L);
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        DrHostGroup hostGroup = (DrHostGroup)resourceService.getDrResourceBySn(po.getProviderSN());
        Integer type = NumberUtil.parseInteger(po.getProps().get("PROVIDER_TYPE"));
        boolean isCluster = DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == type.intValue();
        try {
            DrHostUtil.startCluster((DrHostGroup)hostGroup, (ProtectObject)po);
            String currentDeviceSn = this.startDatabaseAsSingleHost(po, neMgr, hostGroup, isCluster);
            NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)currentDeviceSn);
            ClusterAction action = new ClusterAction(extend, (String)extend.getExtendParams().get("mac_address"));
            String resoureGroupName = (String)po.getProps().get("RESOURCEGROUP_NAME");
            Map<String, String> params = this.getResourceGroupParam(po);
            action.startResourceGroup(params);
            LOGGER.info((Object)("start db(" + po.getName() + "," + po.getProviderSN() + ") success, resource group: " + resoureGroupName), 90160758786988L);
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)("Start cluster error:" + po.getName() + "," + po.getProviderSN()), (Throwable)le, 90160758786989L);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Start cluster error:" + po.getName() + "," + po.getProviderSN()), (long)1073948170L, null, (Log)LOGGER);
        }
    }

    private String startDatabaseAsSingleHost(ProtectObject po, INeMgrProtocolExtendService neMgr, DrHostGroup hostGroup, boolean isCluster) {
        LegoCheckedException ex = null;
        String currentDeviceSn = null;
        for (DrResource childDrResource : hostGroup.getChildResources()) {
            ProtectObject temp = OracleAppUtil.clone(po);
            temp.setProviderSN(childDrResource.getDeviceSn());
            String proProviderType = (String)po.getProps().get("PRO_PROVIDER_TYPE");
            if (isCluster) {
                OracleAppUtil.updateProtectObjectInstanceAndServiceName(temp);
            }
            temp.getProps().put("IS_CLUSTER", isCluster ? "1" : "0");
            if (!temp.getProps().containsKey("APP_VERSION")) {
                temp.getProps().put("APP_VERSION", temp.getProps().get("VERSION"));
            }
            try {
                int recoverType = DBRecoveryTools.getRecoverType((String)proProviderType, (String)String.valueOf(DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue()));
                temp = OracleAppUtil.getOperateParam(temp);
                NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)childDrResource.getDeviceSn());
                this.activeVGAndMountFileSystem(childDrResource, temp, extend, recoverType);
                OracleAppUtil.startOracleDatabase(temp, extend);
                ex = null;
                currentDeviceSn = childDrResource.getDeviceSn();
                LOGGER.info((Object)("start db(" + po.getName() + "," + po.getProviderSN() + ") success in " + childDrResource.getIpAddress()), 90160758786988L);
                break;
            }
            catch (LegoCheckedException le) {
                LOGGER.error((Object)("Start db(" + po.getName() + "," + po.getProviderSN() + ") error in " + childDrResource.getIpAddress()), (Throwable)le, 90160758786989L);
                ex = le;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Start db(" + po.getName() + "," + po.getProviderSN() + ") error in " + childDrResource.getIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                ex = new LegoCheckedException(1073948170L);
            }
        }
        if (null != ex) {
            throw ex;
        }
        return currentDeviceSn;
    }

    private void activeVGAndMountFileSystem(DrResource childDrResource, ProtectObject temp, NeMgrProtocolExtend extend, int recoverType) {
        Map storageInfoMap;
        List<HostDeviceStorageInfo> hostDeviceStorageInfos = this.buildActiveVgHostDeviceStorageInfos(temp);
        String vgActiveMode = (String)temp.getProps().get("CLUSTER_VG_ACTIVE_MODE");
        DeviceAction deviceAction = new DeviceAction(extend, childDrResource.getDeviceSn());
        try {
            deviceAction.activateVG(hostDeviceStorageInfos, vgActiveMode, Integer.valueOf(recoverType));
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)("activate VG:" + temp.getName() + "," + temp.getProviderSN() + "," + extend.getNetworkIpAddress()), (Throwable)legoEx, 90160758787071L);
            storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByVgName(hostDeviceStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo((LegoCheckedException)legoEx, (String)"vgName", (Map)storageInfoMap);
            this.parseAndThrowErrorInfo(hostDeviceStorageInfos);
        }
        hostDeviceStorageInfos = this.buildMountFileSystemHostDeviceStorageInfos(hostDeviceStorageInfos);
        try {
            deviceAction.mountFileSystems(hostDeviceStorageInfos);
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)("mount fs:" + temp.getName() + "," + temp.getProviderSN() + "," + extend.getNetworkIpAddress()), (Throwable)legoEx, 90160758787071L);
            storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByDeviceName(hostDeviceStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo((LegoCheckedException)legoEx, (String)"deviceName", (Map)storageInfoMap);
            this.parseAndThrowErrorInfo(hostDeviceStorageInfos);
        }
    }

    private void parseAndThrowErrorInfo(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        for (HostDeviceStorageInfo hostStorageInfo : hostDeviceStorageInfos) {
            if (hostStorageInfo.getErrorCode() == 0L) continue;
            throw new LegoCheckedException(hostStorageInfo.getErrorCode(), hostStorageInfo.getErrorParams());
        }
    }

    @Override
    public void stopDatabase(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"stop db,po is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)("stop db(" + po.getName() + ") on " + po.getProviderSN()), 90160758786988L);
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        DrHostGroup hostGroup = (DrHostGroup)resourceService.getDrResourceBySn(po.getProviderSN());
        super.stopDatabase(po);
        this.stopDatabaseAsSingleHost(po, neMgr, hostGroup);
    }

    public void stopDatabaseAsSingleHost(ProtectObject po, INeMgrProtocolExtendService neMgr, DrHostGroup hostGroup) {
        LegoCheckedException legoEx = null;
        Integer providerType = NumberUtil.parseInteger(po.getProps().get("PROVIDER_TYPE"));
        boolean isCluster = DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == providerType.intValue();
        for (DrResource childDrResource : hostGroup.getChildResources()) {
            try {
                NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)childDrResource.getDeviceSn());
                ProtectObject temp = OracleAppUtil.clone(po);
                temp.setProviderSN(childDrResource.getDeviceSn());
                if (isCluster) {
                    OracleAppUtil.updateProtectObjectInstanceAndServiceName(temp);
                }
                temp.getProps().put("IS_CLUSTER", isCluster ? "1" : "0");
                if (!temp.getProps().containsKey("APP_VERSION")) {
                    temp.getProps().put("APP_VERSION", temp.getProps().get("VERSION"));
                }
                OracleAppUtil.stopOracleDatabase(temp, extend);
                LOGGER.info((Object)("stop db(" + temp.getName() + ") success in " + extend.getNetworkIpAddress()), 90160758786988L);
                this.deActiveVGAndUmountFileSystem(po, childDrResource, extend);
            }
            catch (LegoCheckedException le) {
                LOGGER.error((Object)("stop hp service gurad database(" + po.getName() + ") error in " + childDrResource.getIpAddress()), (Throwable)le, 90160758786989L);
                legoEx = le;
            }
            catch (Exception e) {
                LOGGER.error((Object)("stop hp service gurad database(" + po.getName() + ") error in " + childDrResource.getIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                legoEx = new LegoCheckedException(1073948169L);
            }
        }
        if (null != legoEx) {
            throw legoEx;
        }
        LOGGER.info((Object)("stop resource group success, po: " + po.getName() + "," + po.getProviderSN()), 90160758786988L);
    }

    private void deActiveVGAndUmountFileSystem(ProtectObject po, DrResource childDrResource, NeMgrProtocolExtend extend) {
        Map storageInfoMap;
        DeviceAction deviceAction = new DeviceAction(extend, childDrResource.getDeviceSn());
        List<HostDeviceStorageInfo> hostDeviceStorageInfos = this.buildActiveVgHostDeviceStorageInfos(po);
        List<HostDeviceStorageInfo> fsHostDeviceStorageInfos = this.buildMountFileSystemHostDeviceStorageInfos(hostDeviceStorageInfos);
        try {
            deviceAction.unmountFileSystems(fsHostDeviceStorageInfos);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)("umount fs:" + po.getName() + "," + po.getProviderSN() + "," + extend.getNetworkIpAddress()), (Throwable)ex, 90160758787071L);
            storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByDeviceName(fsHostDeviceStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo((LegoCheckedException)ex, (String)"deviceName", (Map)storageInfoMap);
            this.parseAndThrowErrorInfo(fsHostDeviceStorageInfos);
        }
        try {
            deviceAction.deActivateVG(hostDeviceStorageInfos);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)("deActivate VG:" + po.getName() + "," + po.getProviderSN() + "," + extend.getNetworkIpAddress()), (Throwable)ex, 90160758787071L);
            storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByVgName(hostDeviceStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo((LegoCheckedException)ex, (String)"vgName", (Map)storageInfoMap);
            this.parseAndThrowErrorInfo(hostDeviceStorageInfos);
        }
    }

    private List<HostDeviceStorageInfo> buildActiveVgHostDeviceStorageInfos(ProtectObject po) {
        ArrayList<HostDeviceStorageInfo> hostDeviceStorageInfoList = new ArrayList<HostDeviceStorageInfo>();
        for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
            int storageSubType = poStorageInfo.getStorageSubType();
            if (storageSubType != 4 && storageSubType != 2) continue;
            HostDeviceStorageInfo hostDeviceStorageInfo = new HostDeviceStorageInfo();
            hostDeviceStorageInfo.setStorageSubType(poStorageInfo.getStorageSubType());
            hostDeviceStorageInfo.setStorageType(poStorageInfo.getStorageType());
            hostDeviceStorageInfo.setVgName(poStorageInfo.getVolumeGroupName());
            hostDeviceStorageInfo.setDeviceName(poStorageInfo.getDeviceName());
            hostDeviceStorageInfo.setMountPoint(poStorageInfo.getMountPoint());
            hostDeviceStorageInfoList.add(hostDeviceStorageInfo);
        }
        return hostDeviceStorageInfoList;
    }

    private List<HostDeviceStorageInfo> buildMountFileSystemHostDeviceStorageInfos(List<HostDeviceStorageInfo> hostStorageInfos) {
        ArrayList<HostDeviceStorageInfo> hostDeviceStorageInfoList = new ArrayList<HostDeviceStorageInfo>();
        for (HostDeviceStorageInfo hostStorageInfo : hostStorageInfos) {
            int storageType = hostStorageInfo.getStorageType();
            if (storageType != 0) continue;
            hostDeviceStorageInfoList.add(hostStorageInfo);
        }
        return hostDeviceStorageInfoList;
    }
}

