/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.action;

import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.BaseAsyncReplicateAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OracleAsyncReplicateAction
extends BaseAsyncReplicateAction {
    private static final Log LOGGER = LogFactory.getInstance(OracleAsyncReplicateAction.class);

    public List<ReplicationRelationBo> getReplicationRelationBos(ActionContext context, Set<ProtectObjectReplica> poReplicas) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        HashSet<String> archieveLogWwn = new HashSet<String>();
        Set poList = pg.getPolist();
        for (ProtectObject protectObject : poList) {
            Set poStorageInfoSet = protectObject.getUsedStorageResourceSet();
            Iterator iterator = poStorageInfoSet.iterator();
            while (iterator.hasNext()) {
                ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)iterator.next();
                if (Integer.parseInt("1") != poStorageInfo.getArchiveLog()) continue;
                archieveLogWwn.add(poStorageInfo.getLunWWN());
            }
        }
        HashSet<ReplicationRelationBo> result = new HashSet<ReplicationRelationBo>();
        HashMap<String, ReplicationRelationBo> repliationMapping = new HashMap<String, ReplicationRelationBo>();
        for (ProtectObjectReplica replica : poReplicas) {
            Set replicaStorageInfos = replica.getStorageInfos();
            Set<RelicaStorageInfo> storageInfos = this.filterStorageInfo(archieveLogWwn, replicaStorageInfos);
            for (RelicaStorageInfo storageInfo : storageInfos) {
                this.getReplicationRelationBo(result, repliationMapping, storageInfo);
            }
        }
        ArrayList<ReplicationRelationBo> resultList = new ArrayList<ReplicationRelationBo>();
        resultList.addAll(result);
        return resultList;
    }

    abstract Set<RelicaStorageInfo> filterStorageInfo(Set<String> var1, Set<RelicaStorageInfo> var2);

    private void getReplicationRelationBo(Set<ReplicationRelationBo> result, Map<String, ReplicationRelationBo> repliationMapping, RelicaStorageInfo storageInfo) {
        if (storageInfo instanceof RemoteStorageReplica) {
            ReplicationRelationBo replication;
            RemoteStorageReplica remoteReplica = (RemoteStorageReplica)storageInfo;
            String replicationId = remoteReplica.getConsistentGroupId();
            if (!VerifyUtil.isEmpty((String)replicationId) && !"--".equals(replicationId) && null == repliationMapping.get(replicationId)) {
                LOGGER.debug((Object)("filter storageInfo,ConsistentGroupId:" + replicationId), 90160758786988L);
                replication = new ReplicationRelationBo();
                replication.setReplicationId(replicationId);
                replication.setConsistentGroup(true);
                repliationMapping.put(replicationId, replication);
            }
            if (null == (replication = repliationMapping.get(replicationId))) {
                replication = new ReplicationRelationBo();
                replication.setReplicationId(remoteReplica.getReplicationPairId());
                LOGGER.debug((Object)("filter storageInfo,replicationId:" + remoteReplica.getReplicationPairId()), 90160758786988L);
            }
            replication.setSrcDeviceSn(remoteReplica.getSrcStorageProviderSN());
            replication.setTgtDeviceSn(remoteReplica.getStorageProviderSN());
            Map tgtLun = replication.getTgtLuns();
            tgtLun.put(remoteReplica.getSrcStorageId(), remoteReplica.getStorageId());
            replication.setTgtLuns(tgtLun);
            replication.setSyncMode(storageInfo.getPoReplica().getPgReplica().getType());
            result.add(replication);
        }
    }
}

