/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.MappingLunProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingLunSubProcessor;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.handler.IStorageMappingHandler;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AdgMappingLunProcessor
extends MappingLunProcessor {
    private static final long serialVersionUID = -5552943857894472905L;

    private static String getDeviceSn(RecoveryPlan recoveryPlan) {
        String deviceSn = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
            if (!setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId()) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
            deviceSn = setting.getValue();
            break;
        }
        return deviceSn;
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        String currentHostOrGroupId = DrHostUtil.getCurrentDisasterHost((RecoveryPlan)context.getRecoveryPlan(), (int)this.getProcType());
        if (currentHostOrGroupId == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Set mappingLunSubProcessors = this.getChildProc();
        if (VerifyUtil.isEmpty((Collection)mappingLunSubProcessors)) {
            this.updateSubProcessors(context);
        }
        this.initResourceVOs();
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        concurrentExecutor.process(context);
        boolean isSuccess = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            isSuccess = false;
        }
        return isSuccess;
    }

    private boolean updateSubProcessors(RecoveryProcessorContext context) {
        Iterator pgIter = context.getRecoveryPlan().getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = (ProtectGroup)pgIter.next();
        ArrayList poIdList = new ArrayList();
        pg.getPolist().forEach(e -> poIdList.add(e.getUuid()));
        String poIds = RecoveryProcessUtil.getPoIds(poIdList);
        HashSet<MappingLunSubProcessor> mappingLunSubProcessors = new HashSet<MappingLunSubProcessor>();
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String srcRedoLunId = pg.getProps().getOrDefault("REMOTE_PAIR_SRCLUNIDS", "").split(",")[0];
            String lunIds = pg.getProps().getOrDefault("REDO_BACK_UP_LUN_IDS", "");
            for (String lunId : lunIds.split(",")) {
                MappingLunSubProcessor processor = new MappingLunSubProcessor();
                processor.setLunId(lunId);
                processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
                processor.setDeviceId(recoveryTask.getTgtDevcieId());
                String deviceSn = AdgMappingLunProcessor.getDeviceSn(recoveryPlan);
                String lunGroupId = this.getLunGroupId(processor.getDeviceId(), srcRedoLunId);
                processor.setLunGroupId(lunGroupId);
                processor.setHostOrGroupId(deviceSn);
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setRelationType(Integer.valueOf(recoveryTask.getProtectType()));
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setPoIds(poIds);
                processor.setReplicationId(recoveryTask.getProtectId());
                mappingLunSubProcessors.add(processor);
            }
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(mappingLunSubProcessors);
        } else {
            this.setChildProc(mappingLunSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private String getLunGroupId(String deviceSn, String lunId) {
        IStorageMappingHandler storageMappingHandler = (IStorageMappingHandler)ServiceLocator.getInstance().getService(IStorageMappingHandler.class);
        MappingView mappingView = storageMappingHandler.getMappingViewByLunId(deviceSn, lunId);
        IStorageLunHandler lunHandler = (IStorageLunHandler)ServiceLocator.getInstance().getService(IStorageLunHandler.class);
        List lunGroups = lunHandler.queryLunGroups(deviceSn, XveMOType.MAPPINGVIEW, mappingView.getMappingViewId());
        return ((XveLunGroup)lunGroups.get(0)).getLunGroupId();
    }
}

