/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.OracleAdgConfigSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class OracleAdgConfigProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(OracleAdgConfigProcessor.class);
    private static final long serialVersionUID = 2801500054424344420L;

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        boolean isSuccess;
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(isSuccess = this.createSubProcessors(context))) {
            LOGGER.error((Object)"Create OracleAdgConfigProcessor sub processor failed");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (recoveryTemplate == null) {
            LOGGER.info((Object)"OracleAdgConfigProcessor recoveryTemplate is empty.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private boolean createSubProcessors(RecoveryProcessorContext context) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue()) {
            return true;
        }
        Set<RecoveryProcessor> configUdevSubProcessors = this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() ? this.getConfigUdevProcessorsForDrilling(context) : this.getConfigUdevProcessors(context);
        if (CollectionUtils.isEmpty(configUdevSubProcessors)) {
            LOGGER.error((Object)"Create udev sub processors failed.");
            return false;
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(configUdevSubProcessors);
        } else {
            this.setChildProc(configUdevSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private Set<RecoveryProcessor> getConfigUdevProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> configUdevSubProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : context.getRecoveryProtectObjects()) {
            String hostSnS = po.getProtectGroup().getProps().getOrDefault("STAND_BY_HOSTSNS", "");
            String redoLunWwn = po.getProtectGroup().getProps().getOrDefault("REDO_LUN_WWN", "");
            String backUpLunId = po.getProtectGroup().getProps().getOrDefault("REDO_BACK_UP_LUN_IDS", "");
            if (VerifyUtil.isEmpty((String)hostSnS)) {
                LOGGER.error((Object)"OracleAdgConfigProcessor host sn is empty.");
                return configUdevSubProcessors;
            }
            Set replicaSet = ProtectGroupExtendUtil.getAllRemoteStorageReplica((ProtectGroup)po.getProtectGroup());
            String[] redos = redoLunWwn.split(",");
            String[] backups = backUpLunId.split(",");
            Map<String, Lun> backupLunMap = this.getBackupLunList(((RemoteStorageReplica)replicaSet.stream().findFirst().get()).getStorageProviderSN(), backUpLunId);
            ArrayList<String> lunMappingList = new ArrayList<String>();
            for (int i = 0; i < redos.length; ++i) {
                lunMappingList.add(redos[i] + "=" + backupLunMap.get(backups[i]).getWwn());
            }
            String dbName = po.getProtectGroup().getProperty("DB_NAMES");
            for (String hostSn : hostSnS.split(",")) {
                OracleAdgConfigSubProcessor processor = new OracleAdgConfigSubProcessor();
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setDbName(dbName);
                processor.setPoId(po.getUuid());
                processor.setLunMapping(String.join((CharSequence)",", lunMappingList));
                processor.setDrHostSn(hostSn);
                configUdevSubProcessors.add((RecoveryProcessor)processor);
            }
        }
        return configUdevSubProcessors;
    }

    private Map<String, Lun> getBackupLunList(String sn, String backupLunIds) {
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List lunList = storageService.getLunsByDeviceSnAndLunIds(sn, Arrays.asList(backupLunIds.split(",")));
        HashMap<String, Lun> backupLunMap = new HashMap<String, Lun>();
        lunList.forEach(e -> backupLunMap.put(e.getLunId(), (Lun)e));
        return backupLunMap;
    }

    private Set<RecoveryProcessor> getConfigUdevProcessorsForDrilling(RecoveryProcessorContext context) {
        List allPos = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        HashSet<RecoveryProcessor> configUdevSubProcessors = new HashSet<RecoveryProcessor>();
        List<String> ips = OracleAppUtil.getIpsByRecoveryContext(context);
        if (VerifyUtil.isEmpty(ips)) {
            LOGGER.error((Object)"Not find ips by recoveryPlan.");
            return configUdevSubProcessors;
        }
        Map snapshotMap = (Map)context.getObject("TYPE_OF_CREATE_SNAPSHOT_BACKUP_COPY_PRO", Map.class);
        for (ProtectObject po : allPos) {
            this.setConfigSubProcessorByTargetHost(po, snapshotMap, ips, configUdevSubProcessors);
        }
        return configUdevSubProcessors;
    }

    private void setProcessorMappingWwn(Map<String, String> snapshotMap, OracleAdgConfigSubProcessor processor) {
        Set<Map.Entry<String, String>> entrySet = snapshotMap.entrySet();
        ArrayList<String> redoWwn = new ArrayList<String>();
        for (Map.Entry<String, String> entry : entrySet) {
            String value = entry.getValue();
            String[] strArray = value.split(";");
            String newSnapshotWWN = strArray[2];
            String asmDg = strArray[4];
            if (asmDg.equals("DATA")) {
                processor.setDataWwn(newSnapshotWWN);
            }
            if (!asmDg.equals("REDO")) continue;
            redoWwn.add(newSnapshotWWN);
        }
        processor.setRedoWwn(String.join((CharSequence)",", redoWwn));
    }

    private void setConfigSubProcessorByTargetHost(ProtectObject po, Map<String, String> snapshotMap, List<String> ips, Set<RecoveryProcessor> configUdevSubProcessors) {
        ProtectObject tempPo = OracleAppUtil.clone(po);
        for (String ip : ips) {
            tempPo.setProviderSN(ip);
            OracleAdgConfigSubProcessor processor = new OracleAdgConfigSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDbName(tempPo.getName());
            processor.setPoId(po.getUuid());
            processor.setDrHostSn(ip);
            this.setProcessorMappingWwn(snapshotMap, processor);
            configUdevSubProcessors.add((RecoveryProcessor)processor);
        }
    }
}

