/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Set;

public class OracleAdgConfigSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(OracleAdgConfigSubProcessor.class);
    private String poId;
    private String dbName;
    private String instanceName;
    private String instances;
    private String drHostSn;
    private String lunMapping;
    private String dataWwn;
    private String redoWwn;

    protected boolean execute(RecoveryProcessorContext context) {
        boolean isSuccess;
        LOGGER.info((Object)"Begin execute OracleAdgConfigSubProcessor db sub processor, dbName=%s.", new Object[]{this.getDbName()});
        this.updateProcessNameParams(new String[]{this.getDbName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.database.udev.already.config", new String[]{this.getDbName()});
            LOGGER.info((Object)"database instance udev has been  config, dbName=%s.", new Object[]{this.getDbName()});
            return true;
        }
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)context.getRecoveryProtectObjects(), (String)this.getPoId());
        if (VerifyUtil.isEmpty((Object)po)) {
            LOGGER.error((Object)"Not find po by poId: %s", new Object[]{this.getPoId()});
            this.updateProcessDetail("lego.err.1073947394", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        ProtectObject temp = OracleAppUtil.clone(po);
        temp.setProperty("drHostSn", (Object)this.getDrHostSn());
        temp.setProperty("DATABASES", (Object)this.getDbName());
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            temp.setProperty("lunMapping", (Object)this.getLunMapping());
            isSuccess = this.config(temp);
        } else {
            temp.setProperty("dataWwn", (Object)this.getDataWwn());
            temp.setProperty("redoWwn", (Object)this.getRedoWwn());
            isSuccess = this.drilling(temp);
        }
        if (isSuccess) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            LOGGER.error((Object)"can't config this database instance udev, the dbName=%s.", new Object[]{this.getDbName()});
            this.updateProcessDetail("ism.drm.recovery.database.udev.config.failed", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        LOGGER.info((Object)"End execute config db udev sub processor, dbName=%s.", new Object[]{this.getDbName()});
        return true;
    }

    protected boolean config(ProtectObject po) {
        IApplicationManager manager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        try {
            manager.config(po);
            LOGGER.info((Object)"Config database udev success, dbName=%s.", new Object[]{this.getDbName()});
            return true;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Config database udev failed:%s,%s.", new Object[]{po.getUuid(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
    }

    protected boolean drilling(ProtectObject po) {
        IApplicationManager manager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        try {
            manager.adgDrilling(po);
            LOGGER.info((Object)"Config database udev success, dbName=%s.", new Object[]{this.getDbName()});
            return true;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Config database udev failed:%s,%s.", new Object[]{po.getUuid(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
    }

    public String getPoId() {
        return this.poId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getInstances() {
        return this.instances;
    }

    public String getDrHostSn() {
        return this.drHostSn;
    }

    public String getLunMapping() {
        return this.lunMapping;
    }

    public String getDataWwn() {
        return this.dataWwn;
    }

    public String getRedoWwn() {
        return this.redoWwn;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setInstances(String instances) {
        this.instances = instances;
    }

    public void setDrHostSn(String drHostSn) {
        this.drHostSn = drHostSn;
    }

    public void setLunMapping(String lunMapping) {
        this.lunMapping = lunMapping;
    }

    public void setDataWwn(String dataWwn) {
        this.dataWwn = dataWwn;
    }

    public void setRedoWwn(String redoWwn) {
        this.redoWwn = redoWwn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OracleAdgConfigSubProcessor)) {
            return false;
        }
        OracleAdgConfigSubProcessor other = (OracleAdgConfigSubProcessor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$poId = this.getPoId();
        String other$poId = other.getPoId();
        if (this$poId == null ? other$poId != null : !this$poId.equals(other$poId)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$instanceName = this.getInstanceName();
        String other$instanceName = other.getInstanceName();
        if (this$instanceName == null ? other$instanceName != null : !this$instanceName.equals(other$instanceName)) {
            return false;
        }
        String this$instances = this.getInstances();
        String other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) {
            return false;
        }
        String this$drHostSn = this.getDrHostSn();
        String other$drHostSn = other.getDrHostSn();
        if (this$drHostSn == null ? other$drHostSn != null : !this$drHostSn.equals(other$drHostSn)) {
            return false;
        }
        String this$lunMapping = this.getLunMapping();
        String other$lunMapping = other.getLunMapping();
        if (this$lunMapping == null ? other$lunMapping != null : !this$lunMapping.equals(other$lunMapping)) {
            return false;
        }
        String this$dataWwn = this.getDataWwn();
        String other$dataWwn = other.getDataWwn();
        if (this$dataWwn == null ? other$dataWwn != null : !this$dataWwn.equals(other$dataWwn)) {
            return false;
        }
        String this$redoWwn = this.getRedoWwn();
        String other$redoWwn = other.getRedoWwn();
        return !(this$redoWwn == null ? other$redoWwn != null : !this$redoWwn.equals(other$redoWwn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OracleAdgConfigSubProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $poId = this.getPoId();
        result = result * 59 + ($poId == null ? 43 : $poId.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $instanceName = this.getInstanceName();
        result = result * 59 + ($instanceName == null ? 43 : $instanceName.hashCode());
        String $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : $instances.hashCode());
        String $drHostSn = this.getDrHostSn();
        result = result * 59 + ($drHostSn == null ? 43 : $drHostSn.hashCode());
        String $lunMapping = this.getLunMapping();
        result = result * 59 + ($lunMapping == null ? 43 : $lunMapping.hashCode());
        String $dataWwn = this.getDataWwn();
        result = result * 59 + ($dataWwn == null ? 43 : $dataWwn.hashCode());
        String $redoWwn = this.getRedoWwn();
        result = result * 59 + ($redoWwn == null ? 43 : $redoWwn.hashCode());
        return result;
    }

    public String toString() {
        return "OracleAdgConfigSubProcessor(poId=" + this.getPoId() + ", dbName=" + this.getDbName() + ", instanceName=" + this.getInstanceName() + ", instances=" + this.getInstances() + ", drHostSn=" + this.getDrHostSn() + ", lunMapping=" + this.getLunMapping() + ", dataWwn=" + this.getDataWwn() + ", redoWwn=" + this.getRedoWwn() + ")";
    }
}

