/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.StartupDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.StopASMSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StopASMProcessor
extends BaseRecoveryProcessor {
    protected static final Log LOGGER = LogFactory.getInstance(StopASMProcessor.class);
    private static final long serialVersionUID = -6977843808177339211L;
    private final Set<String> subProcKeySet = new HashSet<String>();
    private Map<String, Boolean> lastProcResult;

    public StopASMProcessor() {
    }

    public StopASMProcessor(RecoveryProcessor parentProcess) {
        this();
        if (null == parentProcess) {
            return;
        }
        this.setProcName(this.getName());
        this.setProcType(parentProcess.getProcType());
        this.setPlanId(parentProcess.getPlanId());
        this.setParentProc(parentProcess);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (null == context) {
            return false;
        }
        RecoveryProcessResult processResult = context.getProcessResult();
        this.lastProcResult = processResult.getStopAppProcResults();
        Set subProcessors = this.getChildProc();
        if (VerifyUtil.isEmpty((Collection)subProcessors)) {
            boolean createResult = this.createSubProcessors(context);
            if (!createResult) {
                LOGGER.error((Object)"create StopASMSubProcessor error.", 90160758786989L);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
        } else {
            this.updateChildSubProcessors(context);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.info((Object)"StopASMSubProcessors is empty.", 90160758786988L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> stopASMSubProcessors = new HashSet<RecoveryProcessor>();
        List startProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, StartupDBSubProcessor.class);
        if (null == startProcessors || startProcessors.isEmpty()) {
            startProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, StartupDBSubProcessor.class);
        }
        Set allPOs = context.getRecoveryProtectObjects();
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        for (ProtectObject po : allPOs) {
            boolean isStartApp = OracleAppUtil.getIsStartApp(recoverySettings, po);
            if (!isStartApp) {
                LOGGER.info((Object)(po.getUuid() + ":" + po.getName() + ":" + po.getProviderSN() + ":" + po.getPoType() + " need not startup app"), 90160758786988L);
                continue;
            }
            String isAsm = (String)po.getProps().get("IS_ASM");
            if (!"1".equals(isAsm)) {
                LOGGER.info((Object)(po.getUuid() + ":" + po.getName() + ":" + po.getProviderSN() + " is not asm."), 90160758786988L);
                continue;
            }
            boolean poIsStart = this.isProtectObjectInStartDbProcessor(startProcessors, po);
            if (!poIsStart) {
                LOGGER.info((Object)(po.getUuid() + ":" + po.getName() + ":" + po.getProviderSN() + ":" + po.getPoType() + " is not in startup app"), 90160758786988L);
                continue;
            }
            this.createSubProcessorByProtectObject(po, stopASMSubProcessors, context.getRecoveryPlan());
        }
        this.setChildProc(stopASMSubProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private boolean isProtectObjectInStartDbProcessor(List<RecoveryProcessor> startProcessors, ProtectObject po) {
        boolean poIsStart = false;
        for (RecoveryProcessor obj : startProcessors) {
            StartupDBSubProcessor startDbProc = (StartupDBSubProcessor)obj;
            if (!po.getUuid().equals(startDbProc.getPoId())) continue;
            poIsStart = true;
            break;
        }
        return poIsStart;
    }

    private boolean updateChildSubProcessors(RecoveryProcessorContext context) {
        Set allPOs = context.getRecoveryProtectObjects();
        for (ProtectObject po : allPOs) {
            for (RecoveryProcessor proc : this.getChildProc()) {
                StopASMSubProcessor subProcessor = (StopASMSubProcessor)proc;
                subProcessor.setIsDbStoped(this.getDbIsStoped(po.getUuid()));
            }
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private boolean getDbIsStoped(String poId) {
        return null != this.lastProcResult.get(RecoveryProcessResult.getStopAppProcResultKey((String)poId)) && this.lastProcResult.get(RecoveryProcessResult.getStopAppProcResultKey((String)poId)) != false;
    }

    protected void createSubProcessorByProtectObject(ProtectObject po, Set<RecoveryProcessor> stopASMSubProcessors, RecoveryPlan recoveryPlan) {
        String resourceSn = this.getResourceSnForStopAsm(po, recoveryPlan);
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(resourceSn);
        if (resource instanceof DrHostGroup) {
            for (DrResource host : resource.getChildResources()) {
                this.updateByDrHost(po, stopASMSubProcessors, host);
            }
        } else if (resource instanceof DrHost) {
            this.updateByDrHost(po, stopASMSubProcessors, resource);
        }
    }

    private void updateByDrHost(ProtectObject po, Set<RecoveryProcessor> stopASMSubProcessors, DrResource resource) {
        Map poProps = po.getProps();
        String asmInstanceName = (String)poProps.get("ASM_INSTANCENAME");
        String userName = (String)poProps.get("ASM_USERNAME");
        String pwd = (String)poProps.get("ASM_PASSWD");
        String version = (String)poProps.get("VERSION");
        boolean isCluster = "1".equals(poProps.get("IS_CLUSTER"));
        StopASMSubProcessor proc = this.getSubProcessor();
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        proc.setAsmInstanceName(asmInstanceName);
        proc.setAsmPwd(pwd);
        proc.setAsmUserName(userName);
        proc.setDbVersion(version);
        proc.setHostSN(resource.getDeviceSn());
        proc.setIsDbStoped(this.getDbIsStoped(po.getUuid()));
        proc.setIsCluster(isCluster);
        if (!this.subProcKeySet.contains(proc.generateResultKey())) {
            this.subProcKeySet.add(proc.generateResultKey());
            stopASMSubProcessors.add((RecoveryProcessor)proc);
        }
    }

    protected String getResourceSnForStopAsm(ProtectObject po, RecoveryPlan recoveryPlan) {
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        String resourceSn = DBRecoveryTools.getDisasterHostSn((RecoveryPlan)recoveryPlan, (String)protectGroup.getUuid(), (int)this.getProcType());
        return resourceSn;
    }

    protected StopASMSubProcessor getSubProcessor() {
        return new StopASMSubProcessor();
    }
}

