/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class SwitchoverOracleSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(SwitchoverOracleSubProcessor.class);
    private static final long serialVersionUID = -4091753825929611361L;
    private String dbName;
    private String poId;

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getDbName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.database.already.switchover", new String[]{this.getDbName()});
            return true;
        }
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)context.getRecoveryProtectObjects(), (String)this.poId);
        if (VerifyUtil.isEmpty((Object)po)) {
            LOGGER.error((Object)"Not find po by poId: %s", new Object[]{this.poId});
            this.updateProcessDetail("lego.err.1073947394", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.updatePoStandby(po);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        boolean isSuccess = this.switchoverDB(po);
        if (isSuccess) {
            Set protectGroups = recoveryPlan.getProtectGroups();
            for (ProtectGroup pg : protectGroups) {
                pg.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)pg);
            }
        }
        return isSuccess;
    }

    private void updatePoStandby(ProtectObject po) {
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        List appStandbyResources = applicationManager.getAppStandbyResource(po);
        if (CollectionUtils.isEmpty((Collection)appStandbyResources)) {
            LOGGER.error((Object)"Not find the adg standby resource, by poName: %s return.", new Object[]{po.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        ApplicationResource resource = (ApplicationResource)appStandbyResources.get(0);
        po.getProps().put("STANDBY_DB_NAME", resource.getExtendParams().get("STANDBY_DB_NAME"));
    }

    protected boolean switchoverDB(ProtectObject po) {
        po.getProps().put("APP_PROC_TYPE", String.valueOf(this.getProcType()));
        try {
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).switchover(po);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec switchover failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.updateProcessDetail("lego.err.1073948519", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exec switchover exception: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.updateProcessDetail("lego.err.1073948519", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOGGER.info((Object)"Exec switchover success for dbName: %s", new Object[]{this.getDbName()});
        return true;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

