/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.TestConnOracleRACAppSubProcessor;
import com.huawei.ism.drm.oracle.recovery.process.TestConnPDBSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleCDBUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestConnPDBProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 7302929261462434670L;
    private static final Log LOGGER = LogFactory.getInstance(TestConnPDBProcessor.class);
    private static final String TEST_PDB_POID_KEY = "testPDBpoUuid";
    private static final String TEST_PDB_INSTANCE_NAME = "instanceName";
    private static final String TEST_PDB_INSTANCES = "instances";
    private static final String TEST_PDB_DBNAME_KEY = "testPDBdbName";

    public TestConnPDBProcessor() {
    }

    public TestConnPDBProcessor(String poId, String dbName, String instanceName, String instances) {
        this.addString(TEST_PDB_POID_KEY, poId);
        this.addString(TEST_PDB_DBNAME_KEY, dbName);
        this.addString(TEST_PDB_INSTANCE_NAME, instanceName);
        this.addString(TEST_PDB_INSTANCES, instances);
    }

    public boolean execute(RecoveryProcessorContext context) {
        boolean createResult;
        String dbName = this.getString(TEST_PDB_DBNAME_KEY);
        this.updateProcessNameParams(new String[]{dbName});
        if (!this.checkCDBStartResult()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(createResult = this.createSubProcessors(context))) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        Map<Integer, List<IProcessor>> pdbSub = this.getSubProcessByPriority();
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithConcurrentSubExecutor(pdbSub, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)false);
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return true;
    }

    private boolean createSubProcessors(RecoveryProcessorContext context) {
        String poId = this.getString(TEST_PDB_POID_KEY);
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)context.getRecoveryProtectObjects(), (String)poId);
        HashSet<TestConnPDBSubProcessor> testConnPDBSubProcessors = new HashSet<TestConnPDBSubProcessor>();
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        List<String> lists = OracleCDBUtil.getStartPdbs(recoverySettings, po);
        if (VerifyUtil.isEmpty(lists)) {
            LOGGER.info((Object)"start PDB list is null.");
            return false;
        }
        for (String pdbName : lists) {
            TestConnPDBSubProcessor processor = new TestConnPDBSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setInstanceName(this.getString(TEST_PDB_INSTANCE_NAME));
            processor.setInstances(this.getString(TEST_PDB_INSTANCES));
            processor.setPoId(poId);
            processor.setDbName(pdbName);
            testConnPDBSubProcessors.add(processor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(testConnPDBSubProcessors);
        } else {
            this.setChildProc(testConnPDBSubProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private boolean checkCDBStartResult() {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), TestConnOracleRACAppSubProcessor.class);
        for (RecoveryProcessor tempProc : processors) {
            TestConnOracleRACAppSubProcessor resSubProc = (TestConnOracleRACAppSubProcessor)tempProc;
            String cdbName = resSubProc.getDbName();
            String dbName = this.getString(TEST_PDB_DBNAME_KEY);
            int statu = resSubProc.getProcStatus();
            if (!cdbName.equals(dbName) || statu != DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() && statu != DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    private Map<Integer, List<IProcessor>> getSubProcessByPriority() {
        HashMap<Integer, List<IProcessor>> subPDBMap = new HashMap<Integer, List<IProcessor>>();
        int count = 0;
        int priority = 0;
        for (RecoveryProcessor p : this.getChildProc()) {
            List tempList;
            if (0 == count % 5) {
                ArrayList list = new ArrayList();
                subPDBMap.put(++priority, list);
            }
            if (null == (tempList = (List)subPDBMap.get(priority))) {
                throw new LegoCheckedException(1073947393L);
            }
            tempList.add(p);
            ++count;
        }
        return subPDBMap;
    }
}

