/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.provider.DBRecoveryProcessProvider;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.recovery.process.MountHostDeviceProcessor;
import com.huawei.ism.drm.host.recovery.process.UmountHostDeviceProcessor;
import com.huawei.ism.drm.oracle.recovery.process.StopASMProcessor;
import com.huawei.ism.drm.oracle.recovery.process.TestConnOracleAppProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class OracleRecoveryProcessProvider
extends DBRecoveryProcessProvider {
    private static Log logger = LogFactory.getInstance(OracleRecoveryProcessProvider.class);

    public List<String> getAppType() {
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(DrmEnumDefine.AppType.ORACLE.name());
        return appTypes;
    }

    public RecoveryProcessor getTestConnDBProcessor() {
        TestConnOracleAppProcessor processor = new TestConnOracleAppProcessor();
        return processor;
    }

    public RecoveryProcessor getMountFsProcessor() {
        MountHostDeviceProcessor processor = new MountHostDeviceProcessor();
        return processor;
    }

    public RecoveryProcessor getUnMountFsProcessor() {
        UmountHostDeviceProcessor processor = new UmountHostDeviceProcessor();
        return processor;
    }

    public RecoveryProcessor getRebuildAppProcessor() {
        throw new LegoCheckedException("not support.");
    }

    public void resetRecoveryProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, boolean isNeedSaveToDb) {
        if (null == recoveryPlan) {
            logger.error((Object)"recoveryPlan is null.", 90160758786989L);
            return;
        }
        super.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, isNeedSaveToDb);
        if (null == rpDefinition) {
            logger.error((Object)"rpDefinition is null.", 90160758786989L);
            return;
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        boolean isSave = false;
        for (RecoveryProcessor processor : rpDefinition.getRecoveryProcessors()) {
            if (!(processor instanceof StopASMProcessor)) continue;
            boolean enable = processor.getIsEnabled();
            if (!this.hasDatabaseBasedOnAsm(recoveryPlan)) {
                logger.info((Object)("set StopASMProcessor is false,planName:" + recoveryPlan.getName() + ",planId:" + recoveryPlan.getPlanId()), 90160758786988L);
                processor.setIsEnabled(Boolean.valueOf(false));
            } else {
                processor.setIsEnabled(Boolean.valueOf(true));
            }
            if (enable == processor.getIsEnabled()) continue;
            isSave = true;
        }
        if (isSave && isNeedSaveToDb) {
            logger.info((Object)("update recovery process definition,planName:" + recoveryPlan.getName() + ",planId:" + rpDefinition.getPlanId()), 90160758786988L);
            recoveryProcessService.updateRecoveryProcessDefinition(rpDefinition);
        }
    }

    private boolean hasDatabaseBasedOnAsm(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan.getProtectGroups()) {
            logger.error((Object)"recoveryPlan.getProtectGroups() is null.", 90160758786989L);
            return false;
        }
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            if (null == protectGroup.getPolist()) {
                logger.error((Object)"protectGroup.getPolist() is null.", 90160758786989L);
                continue;
            }
            for (ProtectObject protectObject : protectGroup.getPolist()) {
                String isAsm = (String)protectObject.getProps().get("IS_ASM");
                if (VerifyUtil.isEmpty((String)isAsm)) {
                    logger.error((Object)("isAsm is null or empty,poId=" + protectObject.getUuid() + ",protectGroup name is " + protectGroup.getName()), 90160758786989L);
                    continue;
                }
                logger.debug((Object)("check asm,poId=" + protectObject.getUuid() + ",protectGroup name is " + protectGroup.getName() + "," + "1".equals(isAsm) + "," + "1".equals(isAsm.trim())), 90160758786988L);
                if ("1".equals(isAsm.trim())) {
                    return true;
                }
                logger.debug((Object)("po is not asm,poId=" + protectObject.getUuid() + ",isAsm=" + isAsm), 90160758786988L);
            }
        }
        logger.debug((Object)("po is not asm,planName:" + recoveryPlan.getName()), 90160758786988L);
        return false;
    }
}

