/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.cluster.UpdateDisasterPoAndDbInstanceClusterInfo;
import com.huawei.ism.drm.db.recovery.provider.DBRefactorConfigurationProvider;
import com.huawei.ism.drm.db.util.DatabaseApplicationUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class OracleRefactorConfigurationProvider
extends DBRefactorConfigurationProvider {
    private static Log logger = LogFactory.getInstance(OracleRefactorConfigurationProvider.class);

    private static void resetProtectObject(ProtectObject protectObject, String hostOrGroupId) {
        List databases;
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostOrGroupId);
        String hostSn = hostOrGroupId;
        if (resource instanceof DrHostGroup) {
            hostSn = ((DrResource)resource.getChildResources().stream().findFirst().get()).getDeviceSn();
        }
        if (!CollectionUtils.isEmpty((Collection)(databases = DatabaseApplicationUtil.queryAllDatabaseInstance((String)hostSn, (int)1, new HashMap())))) {
            protectObject.setName(((Database)databases.get(0)).getName());
            protectObject.setProviderSN(hostSn);
            OracleAppUtil.updatePoPropsWithStandbyAfterSwitchover(protectObject);
        }
    }

    public List<String> getAppType() {
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(DrmEnumDefine.AppType.ORACLE.name());
        return appTypes;
    }

    public void afterRefactorConfiguration(Set<ProtectGroup> protectGroups) {
        super.afterRefactorConfiguration(protectGroups);
        HashSet<ProtectGroup> adgPgList = new HashSet<ProtectGroup>();
        for (ProtectGroup pg : protectGroups) {
            if (pg.getTemplate().getType() != 47) continue;
            adgPgList.add(pg);
        }
        if (!VerifyUtil.isEmpty(adgPgList)) {
            String[] pgIds = RecoveryProcessUtil.getProtectGroupIds(adgPgList);
            RecoveryProcessUtil.changeProtectGroupStatus((String[])pgIds, (DrmEnumDefine.ProtectGroupStatus)DrmEnumDefine.ProtectGroupStatus.NORMAL);
        }
    }

    public void reverseProtectObjectAttributes(ProtectObject protectObject, Map<String, Object> params) {
        super.reverseProtectObjectAttributes(protectObject, params);
        String providerSN = protectObject.getProviderSN();
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(providerSN);
        if (drResource instanceof DrHostGroup) {
            this.initGroupProtectObjectAttributes(protectObject);
        }
    }

    public void updateProtectObject(ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        if (null == oldProtectObject || null == newProtectObject) {
            return;
        }
        super.updateProtectObject(oldProtectObject, newProtectObject);
        Map older = oldProtectObject.getProps();
        Map newer = newProtectObject.getProps();
        this.updatePropValue(older, newer, "SERVICENAME");
        this.updatePropValue(older, newer, "INSTANCENAME");
    }

    private void updatePropValue(Map<String, String> older, Map<String, String> newer, String key) {
        if (newer.containsKey(key)) {
            older.put(key, newer.get(key));
        }
    }

    private void initGroupProtectObjectAttributes(ProtectObject protectObject) {
        String name = protectObject.getName();
        String providerSN = protectObject.getProviderSN();
        List<DatabaseInstance> instances = OracleAppUtil.getOracleInstancesByGroupAndName(providerSN, name);
        JSONArray serviceNames = new JSONArray();
        JSONArray instanceNames = new JSONArray();
        HashSet<String> instanceNameSet = new HashSet<String>();
        for (DatabaseInstance instance : instances) {
            OracleInstance oracleInstance = (OracleInstance)instance;
            if (instanceNameSet.contains(oracleInstance.getInstanceName())) continue;
            String ip = oracleInstance.getHostSN();
            JSONObject json = new JSONObject();
            json.put((Object)"SERVICENAME", (Object)oracleInstance.getServiceName());
            json.put((Object)"ip", (Object)ip);
            serviceNames.add((Object)json);
            json = new JSONObject();
            json.put((Object)"INSTANCENAME", (Object)oracleInstance.getInstanceName());
            json.put((Object)"ip", (Object)ip);
            instanceNames.add((Object)json);
            instanceNameSet.add(oracleInstance.getInstanceName());
        }
        Map props = protectObject.getProps();
        props.put("SERVICENAME", this.jsonToString(serviceNames));
        props.put("INSTANCENAME", this.jsonToString(instanceNames));
    }

    private String jsonToString(JSONArray array) {
        String result = array.toString();
        return result;
    }

    public void updateProtectGroup(ProtectGroup oldProtectGroup, ProtectGroup newProtectGroup) {
        super.updateProtectGroup(oldProtectGroup, newProtectGroup);
        for (ProtectObject po : oldProtectGroup.getPolist()) {
            if (po.getPoType() != oldProtectGroup.getPoType()) continue;
            String msg = "update cluster info, po:" + po.getName() + "," + po.getProviderSN();
            logger.info((Object)msg, 90160758784001L);
            ExecutionService.submitTask((Runnable)new UpdateDisasterPoAndDbInstanceClusterInfo(po));
        }
    }

    protected void reverseProtectGroupAttributes(ProtectGroup protectGroup, Map<String, Object> params) {
        super.reverseProtectGroupAttributes(protectGroup, params);
        if (protectGroup.getTemplate().getType() == 47) {
            IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(protectGroup.getPoType());
            List appStandbyResource = applicationManager.getAppStandbyResource((ProtectObject)protectGroup.getPolist().stream().findFirst().get());
            ArrayList dbNames = new ArrayList();
            ArrayList hostSns = new ArrayList();
            ArrayList redoWWNs = new ArrayList();
            dbNames.add(((ApplicationResource)appStandbyResource.get(0)).getExtendParams().get("STANDBY_DB_NAME"));
            appStandbyResource.forEach(e -> hostSns.add(e.getHostSn()));
            Set appStorageInfos = ((ApplicationResource)appStandbyResource.get(0)).getAppStorageInfos();
            appStorageInfos.forEach(appStorageInfo -> {
                if ("REDO".equals(appStorageInfo.getAsmDg())) {
                    redoWWNs.add(appStorageInfo.getWwn());
                }
            });
            DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class);
            Set replicaSet = ProtectGroupExtendUtil.getAllRemoteStorageReplica((ProtectGroup)protectGroup);
            String devSn = ((RemoteStorageReplica)replicaSet.stream().findFirst().get()).getStorageProviderSN();
            List<String> lunIdList = Arrays.asList(String.join((CharSequence)",", protectGroup.getProperty("REDO_BACK_UP_LUN_IDS")));
            List redoPairs = drmStorageService.queryReplicationPairsByMasterLunId(devSn, lunIdList, true, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
            List replicationPairs = drmStorageService.queryReplicationPairsByMasterLunWWN(new ArrayList(redoWWNs), true);
            ArrayList redoBackUpLunIds = new ArrayList();
            redoPairs.forEach(pair -> redoBackUpLunIds.add(pair.getTgtLunId()));
            ArrayList<String> remotePairSrcIdList = new ArrayList<String>();
            ArrayList<String> remotePairTgtIdList = new ArrayList<String>();
            for (ReplicationPair replicationPair : replicationPairs) {
                remotePairSrcIdList.add(replicationPair.getSrcLunId());
                remotePairTgtIdList.add(replicationPair.getTgtLunId());
            }
            protectGroup.setProperty("STAND_BY_HOSTSNS", (Object)String.join((CharSequence)",", hostSns));
            protectGroup.setProperty("DB_NAMES", (Object)String.join((CharSequence)",", dbNames));
            protectGroup.setProperty("REDO_LUN_WWN", (Object)String.join((CharSequence)",", redoWWNs));
            protectGroup.setProperty("REDO_BACK_UP_LUN_IDS", (Object)String.join((CharSequence)",", redoBackUpLunIds));
            protectGroup.setProperty("REMOTE_PAIR_SRCLUNIDS", (Object)String.join((CharSequence)",", remotePairSrcIdList));
            protectGroup.setProperty("REMOTE_PAIR_TRGLUNIDS", (Object)String.join((CharSequence)",", remotePairTgtIdList));
        }
    }

    public void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
        if (protectObject.getPoType() == 14) {
            super.refactorProtectObjectStorageInfos(protectObject, params);
            return;
        }
        try {
            String archieve = (String)protectObject.getProps().get("ARCHIVE_LOG");
            if (VerifyUtil.isEmpty((String)archieve)) {
                logger.info((Object)"Archieve is null,po:%s,%s.", new Object[]{protectObject.getName(), protectObject.getProviderSN()});
                protectObject.getProps().put("ARCHIVE_LOG", "0");
            }
            IProtectObjectBaseProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(1);
            Map disHost = (Map)params.get("PG_DISASTER_HOST");
            String hostOrGroupId = (String)disHost.get(protectObject.getProtectGroup().getUuid());
            int type = protectObject.getProtectGroup().getTemplate().getType();
            if (type == 47) {
                protectObject.setProviderSN(hostOrGroupId);
                OracleRefactorConfigurationProvider.resetProtectObject(protectObject, hostOrGroupId);
            }
            ProtectObject clonePo = (ProtectObject)protectObject.clone();
            clonePo.setProviderSN(hostOrGroupId);
            if (!params.containsKey("oldProductSiteIds")) {
                Set oldProductSiteIds = this.getProductSiteByPo(clonePo);
                params.put("oldProductSiteIds", oldProductSiteIds);
            }
            this.constructUsedStorage(protectObject, params, provider, clonePo);
        }
        catch (LegoCheckedException e) {
            logger.error((Throwable)e, (Object)"query po storage info fail,po:%s,%s.", new Object[]{protectObject.getName(), protectObject.getProviderSN()});
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "query po storage info fail,po:" + protectObject.getName() + "," + protectObject.getProviderSN();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)logger);
        }
    }

    private void constructUsedStorage(ProtectObject protectObject, Map<String, Object> params, IProtectObjectBaseProvider provider, ProtectObject clonePo) {
        ArrayList oldStorageInfoList = new ArrayList(clonePo.getUsedStorageResourceSet());
        clonePo.clearUsedStorageResource();
        List storageInfoList = provider.getProtectObjectStorageInfo(clonePo);
        if (storageInfoList == null) {
            logger.error((Object)("storage info is null,po:" + protectObject.getName() + "," + protectObject.getProviderSN()), 90160758786896L);
            super.refactorProtectObjectStorageInfos(protectObject, params);
        } else {
            protectObject.setUsedStorageResourceSet(new HashSet(storageInfoList));
            this.caculateOToNewWwnMap(oldStorageInfoList, protectObject, params);
        }
    }

    public void refactorPolicyTemplate(ProtectGroup pg) {
        super.refactorPolicyTemplate(pg);
        int templateType = pg.getTemplate().getType();
        if (templateType == 6 || templateType == 4 || templateType == 35 || templateType == 36) {
            return;
        }
        Map prop = pg.getTemplate().getProps();
        if (prop.containsKey("ORACLE_FREEZE_FLAG") && !this.getIsReversed().booleanValue()) {
            prop.put("ORACLE_FREEZE_FLAG", "1");
        }
        if (prop.containsKey("ORACLE_CAP_THREASHOLD") && !this.getIsReversed().booleanValue()) {
            prop.put("ORACLE_CAP_THREASHOLD", "0");
        }
    }

    public void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        super.refactorRecoveryPlan(recoveryPlan, params);
        if (this.getIsReversed().booleanValue()) {
            return;
        }
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting recoverySetting : recoverySettings) {
            if (!"PDB".equals(recoverySetting.getName())) continue;
            this.batchRefactorPdb(recoverySetting);
        }
    }

    private void batchRefactorPdb(RecoverySetting recoverySetting) {
        String val = recoverySetting.getValue();
        if (VerifyUtil.isEmpty((String)val)) {
            return;
        }
        JSONArray pdbList = new JSONArray();
        for (Object obj : JSONArray.fromObject((Object)val)) {
            JSONObject pdb = (JSONObject)obj;
            String name = pdb.getString("pdbName");
            if (DrmAppEnumDefine.PDB_NAME_TYPE.ROOT.getName().equals(name) || DrmAppEnumDefine.PDB_NAME_TYPE.SEED.getName().equals(name)) continue;
            pdb.put((Object)"isStart", (Object)"true");
            pdbList.add((Object)pdb);
        }
        recoverySetting.setValue(pdbList.toString());
    }
}

