/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.util;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleDatabase;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.util.DatabaseApplicationUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostGroupService;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.hostagent.action.OracleAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public final class OracleAppUtil {
    private static final int MAX_HOST = 8;
    private static final int ERR_INDEX = -1;
    private static final String IS_PDB = "1";
    private static final String IS_CDB = "1";
    private static final List<String> DISK_TYPE_LIST = Arrays.asList("REDO", "DATA");
    private static final Log LOGGER = LogFactory.getInstance(OracleAppUtil.class);

    private OracleAppUtil() {
    }

    public static ProtectObject findPoById(Set<ProtectObject> pos, String poId) {
        if (pos == null) {
            LOGGER.error((Object)"pos is null.");
            return null;
        }
        for (ProtectObject po : pos) {
            if (!po.getUuid().equals(poId)) continue;
            return po;
        }
        return null;
    }

    public static DrHostGroup getRecoveryHostGroup(RecoveryPlan recoveryPlan) {
        DrHostGroup recHostGroup;
        if (recoveryPlan == null) {
            LOGGER.error((Object)"RecoveryPlan is null.");
            return null;
        }
        DrHostGroup hostGroup = null;
        String hostGroupSn = (String)recoveryPlan.getGlobalSettings().get("PO_DISASTER_HOST");
        List hostGroups = OracleAppUtil.getHostGroupService().getHostGroupListByDeviceSN(hostGroupSn);
        if (!VerifyUtil.isEmpty((Collection)hostGroups) && !VerifyUtil.isEmpty((Object)(recHostGroup = (DrHostGroup)hostGroups.get(0)))) {
            hostGroup = recHostGroup;
        }
        return hostGroup;
    }

    public static void filterHasSuccHosts(Set<DrResource> hostsOfHostGroup, String succHosts, int procType) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() != procType) {
            LOGGER.error((Object)"ProcType is not drilling.");
            return;
        }
        if (null == succHosts) {
            LOGGER.error((Object)"The succHosts is null.");
            return;
        }
        if (null == hostsOfHostGroup) {
            LOGGER.error((Object)"The hostsOfHostGroup is null.");
            return;
        }
        ArrayList<DrResource> hasSuccHosts = new ArrayList<DrResource>(8);
        for (DrResource host : hostsOfHostGroup) {
            if (-1 == succHosts.indexOf(host.getIpAddress())) continue;
            hasSuccHosts.add(host);
        }
        hostsOfHostGroup.removeAll(hasSuccHosts);
    }

    public static DrmEnumDefine.RecoveryPlanExecuteResultE getProcResultBySubProc(Set<RecoveryProcessor> rProcesses) {
        if (rProcesses == null) {
            LOGGER.error((Object)"The rProcesses is null.");
            return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED;
        }
        boolean hasFailed = false;
        boolean hasPartSuccessed = false;
        boolean hasSuccess = false;
        for (RecoveryProcessor process : rProcesses) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == process.getProcStatus()) {
                hasFailed = true;
                continue;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == process.getProcStatus()) {
                hasPartSuccessed = true;
                continue;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != process.getProcStatus()) continue;
            hasSuccess = true;
        }
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = hasPartSuccessed ? DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS : (hasFailed && hasSuccess ? DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS : (hasSuccess ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS : DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED));
        return procStatus;
    }

    public static void setResult(StringBuffer succHostsSb, String resSN, String resultOfLastTime) {
        if (null == succHostsSb) {
            LOGGER.error((Object)"The succHostsSb is null.");
            return;
        }
        if (null == resultOfLastTime) {
            if (0 != succHostsSb.length()) {
                succHostsSb.append(',');
            }
            succHostsSb.append(resSN);
        } else if (-1 == resultOfLastTime.indexOf(resSN)) {
            if (0 != succHostsSb.length()) {
                succHostsSb.append(',');
            }
            succHostsSb.append(resSN);
        }
    }

    public static String getResult(String resIPAddress, String resultOfLastTime) {
        if (null == resultOfLastTime) {
            resultOfLastTime = resIPAddress;
        } else if (-1 == resultOfLastTime.indexOf(resIPAddress)) {
            resultOfLastTime = resultOfLastTime + ",";
            resultOfLastTime = resultOfLastTime + resIPAddress;
        }
        LOGGER.debug((Object)"get result.");
        return resultOfLastTime;
    }

    public static DatabaseInstance getOracleInstanceByHostAndName(String host, String name) {
        if (name == null) {
            LOGGER.error((Object)"Query instance fail,name is null.");
            return null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("dbType", 1);
        props.put("hostSN", host);
        List instances = CommonDAOLocator.getMoDao().findMoBy(DatabaseInstance.class, "name", true, props);
        if (VerifyUtil.isEmpty((Collection)instances)) {
            return null;
        }
        for (DatabaseInstance instance : instances) {
            HashMap<String, Long> args = new HashMap<String, Long>();
            args.put("parentMo.moId", instance.getMoId());
            List databases = CommonDAOLocator.getMoDao().findMoBy(Database.class, "name", true, args);
            if (VerifyUtil.isEmpty((Collection)databases)) continue;
            for (Database database : databases) {
                if (!name.equalsIgnoreCase(database.getName())) continue;
                return instance;
            }
        }
        return null;
    }

    public static List<DatabaseInstance> getOracleInstancesByGroupAndName(String group, String name) {
        ArrayList<DatabaseInstance> instances = new ArrayList<DatabaseInstance>();
        List<String> hosts = OracleAppUtil.getHostGroupListByDeviceSN(group);
        if (VerifyUtil.isEmpty(hosts)) {
            return instances;
        }
        for (String host : hosts) {
            DatabaseInstance instance = OracleAppUtil.getOracleInstanceByHostAndName(host, name);
            if (instance == null) continue;
            instances.add(instance);
        }
        LOGGER.debug((Object)"Get oracle instances by groupAndName.");
        return instances;
    }

    public static List<String> getHostGroupListByDeviceSN(String hostGrpSn) {
        ArrayList<String> hostSNList = new ArrayList<String>();
        IHostGroupService hostGroupService = (IHostGroupService)ServiceContext.getInstance().lookup("DRM_Host/" + IHostGroupService.class.getName());
        List drGroups = hostGroupService.getHostGroupListByDeviceSN(hostGrpSn);
        for (DrHostGroup group : drGroups) {
            for (DrResource host : group.getChildResources()) {
                hostSNList.add(host.getDeviceSn());
            }
        }
        hostSNList.sort(Comparator.reverseOrder());
        LOGGER.debug((Object)"Get HostGroup list by DeviceSN.");
        return hostSNList;
    }

    private static IHostGroupService getHostGroupService() {
        return (IHostGroupService)ServiceContext.getInstance().lookup("DRM_Host/" + IHostGroupService.class.getName());
    }

    public static void startOracleDatabase(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        if ("1".equals(protectObject.getProps().get("IS_PDB"))) {
            OracleAppUtil.startPDB(protectObject, extend);
        } else {
            String cluster = (String)protectObject.getProps().get("IS_CLUSTER");
            if ("1".equals(protectObject.getProps().get("IS_ASM")) && !"1".equals(cluster)) {
                LOGGER.debug((Object)"Start asm: %s", new Object[]{protectObject.getProviderSN()});
                OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
                action.startAsmInstance(protectObject.getProps());
            }
            LOGGER.debug((Object)"Start dbName: %s, providerSn: %s", new Object[]{protectObject.getName(), protectObject.getProviderSN()});
            Map params = protectObject.getProps();
            OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
            action.startDatabase(params);
        }
    }

    public static void stopOracleDatabase(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Stop oracle database.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.stopDatabase(params);
    }

    public static void stopAsmInstance(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Stop asm instance.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.stopAsmInstance(params);
    }

    public static void testConnection(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        if ("1".equals(protectObject.getProps().get("IS_PDB"))) {
            OracleAppUtil.testPDB(protectObject, extend);
        } else {
            LOGGER.debug((Object)"Test oracle connection.");
            OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
            Map params = protectObject.getProps();
            action.testConnection(params);
        }
    }

    public static void freezeOracle(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Freeze oracle.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.freeze(params);
    }

    public static void thrawOracle(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Thraw oracle.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.thraw(params);
    }

    public static void forcedArchive(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Forced archive.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.forcedArchive(params);
    }

    public static void updateProtectObjectInstanceAndServiceName(ProtectObject po) {
        Map poProps = po.getProps();
        poProps.put("INSTANCENAME", "");
        poProps.put("SERVICENAME", "");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topMoUuid", po.getProviderSN());
        props.put("name", po.getName());
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List databases = moDao.findMoBy(OracleDatabase.class, "name", true, props);
        if (VerifyUtil.isEmpty((Collection)databases)) {
            LOGGER.error((Object)"Databases is empty, po name: %s, hostSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(po.getProviderSN());
            throw new LegoCheckedException(1073948189L, new String[]{resource.getName(), resource.getName()});
        }
        ManagedObject mo = ((OracleDatabase)databases.get(0)).getParentMo();
        if (!(mo instanceof OracleInstance)) {
            LOGGER.error((Object)"Not find the right mo.");
            throw new LegoCheckedException(1073947394L);
        }
        OracleInstance oracleInstance = (OracleInstance)mo;
        poProps.put("INSTANCENAME", oracleInstance.getInstanceName());
        poProps.put("SERVICENAME", oracleInstance.getServiceName());
        if (VerifyUtil.isEmpty((String)((String)poProps.get("INSTANCENAME")))) {
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(po.getProviderSN());
            LOGGER.error((Object)"The po's props when key is INSTANCENAME, the value is null, poName: %s, poProviderSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073948189L, new String[]{resource.getName(), resource.getName()});
        }
    }

    public static void updatePoPropsWithStandbyAfterSwitchover(ProtectObject po) {
        String hostSn = po.getProviderSN();
        List databases = DatabaseApplicationUtil.queryAllDatabaseInstance((String)hostSn, (int)1, new HashMap());
        if (CollectionUtils.isEmpty((Collection)databases)) {
            LOGGER.error((Object)"Not find the databases.");
            return;
        }
        for (Database database : databases) {
            ManagedObject mo = database.getParentMo();
            if (!(mo instanceof OracleInstance)) {
                LOGGER.error((Object)"Not the right type for change.");
                continue;
            }
            OracleInstance oracleInstance = (OracleInstance)database.getParentMo();
            po.setName(database.getName());
            Map poProps = po.getProps();
            poProps.put("DATABASES", database.getName());
            poProps.put("IS_ASM", oracleInstance.getUseAsm() != false ? "1" : "0");
            poProps.put("SERVICENAME", oracleInstance.getServiceName());
            poProps.put("INSTANCENAME", oracleInstance.getInstanceName());
            poProps.put("VERSION", oracleInstance.getDbVersion());
            poProps.put("ORACLE_HOME", oracleInstance.getOracleHome());
        }
    }

    public static ProtectObject clone(ProtectObject po) {
        ProtectObject obj = new ProtectObject();
        obj.setUuid(po.getUuid());
        obj.setMoUuid(po.getMoUuid());
        obj.setName(po.getName());
        obj.getProps().putAll(po.getProps());
        obj.getUsedStorageResourceSet().addAll(po.getUsedStorageResourceSet());
        obj.setProviderSN(po.getProviderSN());
        obj.setPoType(po.getPoType());
        LOGGER.debug((Object)"Clone oracle po.");
        return obj;
    }

    public static void updateProtectObjectInstance(ProtectObject newPo, ProtectObject oldPo) {
        String instanceNames = (String)oldPo.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)instanceNames)) {
            LOGGER.error((Object)"Not find any instanceNames.");
            return;
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceNames);
        for (Object obj : instanceArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            String instanceName = JsonUtil.getString((JSONObject)jsonObject, (String)"INSTANCENAME", (String[])new String[]{""});
            String hostSn = JsonUtil.getString((JSONObject)jsonObject, (String)"ip", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) continue;
            newPo.getProps().put("INSTANCENAME", instanceName);
            newPo.getProps().put("hostSn", hostSn);
            break;
        }
    }

    public static List<ProtectObject> buildProtectObjects(ProtectObject po) {
        ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            OracleAppUtil.appendProjectObject(po, protectObjects);
        } else {
            protectObjects.add(po);
        }
        if (protectObjects.isEmpty()) {
            LOGGER.error((Object)"Build po(name: %s, providerSn: %s) result is empty.", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073947393L, "the po list is empty.");
        }
        return protectObjects;
    }

    private static void appendProjectObject(ProtectObject po, List<ProtectObject> freezePos) {
        String sn = po.getProviderSN();
        String activeHostSn = (String)po.getProps().get("ACTIVE_NODE_HOST_SN");
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(sn);
        if (drResource instanceof DrHostGroup && !VerifyUtil.isEmpty((String)activeHostSn)) {
            LOGGER.debug((Object)"The active HostSn: %s, host size: %s, poName: %s", new Object[]{activeHostSn, drResource.getChildResources().size(), po.getName()});
            for (DrResource childDrResource : drResource.getChildResources()) {
                if (!activeHostSn.equals(childDrResource.getDeviceSn())) continue;
                LOGGER.debug((Object)"The poName: %s, activeHostSn: %s, ip is: %s", new Object[]{po.getName(), activeHostSn, childDrResource.getIpAddress()});
                drResource = childDrResource;
                break;
            }
        }
        OracleAppUtil.generateFreezePos(po, freezePos, drResource);
    }

    private static void generateFreezePos(ProtectObject po, List<ProtectObject> freezePos, DrResource drResource) {
        if (drResource instanceof DrHost) {
            ProtectObject clonePo = OracleAppUtil.clone(po);
            clonePo.setProviderSN(drResource.getDeviceSn());
            OracleAppUtil.updateProtectObjectInstanceAndServiceName(clonePo);
            freezePos.add(clonePo);
            return;
        }
        try {
            freezePos.addAll(OracleAppUtil.decodePOInstanceAndServiceName(po, (DrHostGroup)drResource));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Get freeze po failed for host group,po:" + po.getName() + "," + po.getProviderSN()), (long)1073947393L, null, (Log)LOGGER);
        }
    }

    private static List<ProtectObject> decodePOInstanceAndServiceName(ProtectObject po, DrHostGroup hostGroup) {
        ArrayList<ProtectObject> result = new ArrayList<ProtectObject>();
        for (DrResource childResource : hostGroup.getChildResources()) {
            ProtectObject clonePo = OracleAppUtil.clone(po);
            clonePo.setProviderSN(childResource.getDeviceSn());
            OracleAppUtil.updateProtectObjectInstanceAndServiceName(clonePo);
            result.add(clonePo);
        }
        result.sort((Comparator<ProtectObject>)new CommonComparator("providerSN", true));
        return result;
    }

    public static void checkOperationParameters(ProtectObject po) {
        OracleAppUtil.checkAuthorityParameters(po);
        if (null == po.getUsedStorageResourceSet() || po.getUsedStorageResourceSet().isEmpty()) {
            LOGGER.error((Object)"The po's UsedStorageResourceSet is null, poName = %s", new Object[]{po.getName()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkAuthorityParameters(ProtectObject po) {
        OracleAppUtil.checkBaseParameters(po);
        Map props = po.getProps();
        if (null == props.get("INSTANCENAME") || null == props.get("SERVICENAME")) {
            LOGGER.error((Object)"The po's instanceName or service name not exists, poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073947393L);
        }
        if (!"1".equals(props.get("IS_ASM"))) {
            props.put("ASM_INSTANCENAME", "");
        }
        String authType = (String)props.get("AUTH_TYPE");
        String isCloseAsm = (String)props.get("IS_CLOSE_ASM");
        OracleAppUtil.checkAndUpdateProps(po, authType, isCloseAsm);
    }

    private static void checkAndUpdateProps(ProtectObject po, String authType, String isCloseAsm) {
        Map props = po.getProps();
        if (authType != null && "1".equals(authType)) {
            props.put("USERNAME", "");
            props.put("PASSWD", "");
            props.put("ASMGroupName", "");
            props.put("PROP_KEY_ASM_IS_CHANGED", "");
            props.put("ASM_USERNAME", "");
            props.put("ASM_PASSWD", "");
        } else {
            if (!("1".equals(isCloseAsm) || null != props.get("USERNAME") && null != props.get("PASSWD"))) {
                LOGGER.error((Object)"The po's username or password not exists, poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
                throw new LegoCheckedException(1073947393L);
            }
            if ("1".equals(isCloseAsm) && (null == props.get("ASM_PASSWD") || null == props.get("ASM_USERNAME"))) {
                LOGGER.error((Object)"The po's asm username or password not exists,poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private static void checkBaseParameters(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"Po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (1 != po.getPoType()) {
            LOGGER.error((Object)"Po's type is wrong,po: %s, %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)po.getProviderSN())) {
            LOGGER.error((Object)"Po's ProviderSN is null,po: %s", new Object[]{po.getName()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static ProtectObject getOperateParam(ProtectObject po) {
        Map props;
        ProtectGroup protectGroup;
        ProtectObject result = new ProtectObject();
        result.setPoType(1);
        result.setProviderSN(po.getProviderSN());
        result.getProps().putAll(po.getProps());
        HashSet<String> asmGroupName = new HashSet<String>();
        for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
            String groupName = info.getAsmDiskGroupName();
            if (!VerifyUtil.isEmpty((String)groupName)) {
                asmGroupName.add(groupName);
            }
            ProtectObjectStorageInfo paramInfo = new ProtectObjectStorageInfo();
            paramInfo.setDeviceName(info.getDeviceName());
            paramInfo.setMountPoint(info.getMountPoint());
            paramInfo.setStorageSubType(info.getStorageSubType());
            paramInfo.setStorageType(info.getStorageType());
            paramInfo.setVolumeGroupName(info.getVolumeGroupName());
            result.addHostStorageResourceInfo(paramInfo);
        }
        Integer isAsm = NumberUtil.convertToInteger(po.getProps().get("IS_ASM"));
        if (1 == isAsm && !VerifyUtil.isEmpty(asmGroupName)) {
            result.getProps().put("ASMGroupName", OracleAppUtil.generateASMGroupName(asmGroupName));
        }
        PolicyTemplate template = (protectGroup = po.getProtectGroup()) != null ? protectGroup.getTemplate() : null;
        Map map = props = template != null ? template.getProps() : null;
        if (props != null) {
            result.getProps().put("ORACLE_CAP_THREASHOLD", props.get("ORACLE_CAP_THREASHOLD"));
        } else {
            LOGGER.info((Object)"The template props of po(%s, %s, %s) is null", new Object[]{po.getName(), po.getProviderSN(), po.getUuid()});
        }
        return result;
    }

    private static String generateASMGroupName(Set<String> asmGroupName) {
        StringBuilder buffer = new StringBuilder();
        for (String tmp : asmGroupName) {
            buffer.append(tmp);
            buffer.append('+');
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    public static boolean isProtectArchieveLog(Set<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            LOGGER.error((Object)"ProtectObjectList is null.");
            return false;
        }
        for (ProtectObject protectObject : protectObjectList) {
            String archieve = (String)protectObject.getProps().get("ARCHIVE_LOG");
            if (!"1".equals(archieve)) continue;
            LOGGER.debug((Object)"Protect archive log,po: %s", new Object[]{protectObject.getName()});
            return true;
        }
        LOGGER.debug((Object)"Not protect archive log.");
        return false;
    }

    public static boolean getIsStartApp(Set<RecoverySetting> recoverySettings, ProtectObject po) {
        boolean isStartApp = true;
        for (RecoverySetting rs : recoverySettings) {
            if (!rs.getName().equals("isStart") || !rs.getOwnerId().equals(po.getUuid())) continue;
            isStartApp = Boolean.parseBoolean(rs.getValue());
            break;
        }
        LOGGER.debug((Object)"Get IsStart App.");
        return isStartApp;
    }

    public static void queryPlugDatabase(ProtectObject po) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)po.getProviderSN());
        OracleAction action = new OracleAction(ne, po.getProviderSN());
        String result = action.queryDatabaseAuth(po.getProps());
        if (VerifyUtil.isEmpty((String)result)) {
            LOGGER.error((Object)"query database isCDB fail, instanceName is %s and providerSN is %s", new Object[]{po.getProps().get("INSTANCENAME"), po.getProviderSN()});
            throw new LegoCheckedException(-1L);
        }
        JSONObject json = JSONObject.fromObject((Object)result);
        String isCdb = json.getString("type");
        po.getProps().put("IS_CDB", isCdb);
        if (!"1".equals(isCdb)) {
            LOGGER.debug((Object)"this database is not pdb, instance name is %s", new Object[]{po.getProps().get("INSTANCENAME")});
            return;
        }
        String pdbs = action.queryPlugDatabase(po.getProps());
        if (VerifyUtil.isEmpty((String)pdbs)) {
            LOGGER.error((Object)"Query pdbs failed, instanceName is %s and providerSN is %s", new Object[]{po.getProps().get("INSTANCENAME"), po.getProviderSN()});
            throw new LegoCheckedException(-1L);
        }
        po.getProps().put("PDB", pdbs);
    }

    private static void startPDB(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.startPDB(params);
    }

    private static void testPDB(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.testPDB(params);
    }

    public static Set<String> getNeedCheckHosts() {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List allLocalSites = siteService.getAllLocalSites();
        allLocalSites = Optional.ofNullable(allLocalSites).orElseGet(Collections::emptyList);
        HashSet<String> hostSns = new HashSet<String>();
        for (Site localSite : allLocalSites) {
            List allHostResource = siteService.getAllResourceBySite(localSite.getSiteId(), "ism.drm.deviceType.drhost.mainType");
            allHostResource = Optional.ofNullable(allHostResource).orElseGet(Collections::emptyList);
            allHostResource.stream().map(DrResource::getDeviceSn).forEach(hostSns::add);
        }
        return hostSns;
    }

    public static void restorePreparePDB(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.replaceUdevRule(params);
    }

    public static void adgDrilling(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.replaceUdevRuleDrilling(params);
    }

    public static void adgStartupDB(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.adgStartupDb(params);
    }

    public static Set<ProtectObjectStorageInfo> queryMatchedStorages(ProtectObject po) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)po.getProviderSN());
        OracleAction action = new OracleAction(ne, po.getProviderSN());
        List databases = DatabaseApplicationUtil.queryAllDatabaseInstance((String)po.getProviderSN(), (int)1, new HashMap());
        HashSet<ProtectObjectStorageInfo> matchedStorages = new HashSet<ProtectObjectStorageInfo>();
        for (Database database : databases) {
            Set<ProtectObjectStorageInfo> storageInfos;
            ManagedObject managedObject = database.getParentMo();
            if (!(managedObject instanceof OracleInstance)) continue;
            OracleInstance dbInstance = (OracleInstance)managedObject;
            HashMap<String, String> reqMap = new HashMap<String, String>();
            reqMap.put("INSTANCENAME", dbInstance.getInstanceName());
            reqMap.put("DATABASES", database.getName());
            reqMap.put("ORACLE_HOME", dbInstance.getOracleHome());
            reqMap.put("ARCHIVE_LOG", "0");
            try {
                storageInfos = action.queryLuns(reqMap);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Get luns failed by error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                return matchedStorages;
            }
            for (ProtectObjectStorageInfo info : storageInfos) {
                if (!DISK_TYPE_LIST.contains(info.getAsmDiskGroupName())) continue;
                matchedStorages.add(info);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)databases)) {
            po.getProps().put("DATABASES", ((Database)databases.get(0)).getName());
        }
        return matchedStorages;
    }

    public static List<String> getIpsByRecoveryContext(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        Optional<String> opt = recoverySettings.stream().filter(setting -> setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId())).filter(setting -> "PG_DISASTER_HOST".equals(setting.getName())).map(RecoverySetting::getValue).findFirst();
        if (!opt.isPresent()) {
            LOGGER.error((Object)"Not find hostID from recovery plan setting with PG_DISASTER_HOST");
            throw new LegoCheckedException(1073947394L);
        }
        String hostSn = opt.get();
        ArrayList<String> ips = new ArrayList<String>();
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostSn);
        if (resource instanceof DrHostGroup) {
            resource.getChildResources().forEach(res -> ips.add(res.getDeviceSn()));
        } else {
            ips.add(hostSn);
        }
        return ips;
    }
}

