/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.base;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IStorageRecoveryPlanService;
import com.huawei.ism.drm.rest.fusionsphere.base.BaseAbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service.ResourceMappingUtil;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbsVRRestService
extends BaseAbsVRRestService {
    protected static final int NUM_PAGELIST = 10;
    private static final Log logger = LogFactory.getInstance(AbsVRRestService.class);
    private static final String RESMAPPING_TARGET_NAME = "resourceMapping_objectName";
    private static final String VRGMAPPING_TARGET_NAME = "VRGMapping_objectName";
    private static final String DRM_FS_STORAGE_REP_BUNDLE = "DRM_FusionShpere_SRA";

    protected void checkResourceMappingAuthority(ResourceMapping resMap) {
        Site productSite;
        logger.debug((Object)"checkResourceMappingAuthority start");
        if (null == resMap) {
            return;
        }
        this.checkUserAuthority(resMap.getProductSiteId());
        this.checkUserAuthority(resMap.getRecoverySiteId());
        Site recoverySite = this.getSiteBySiteId(resMap.getRecoverySiteId());
        if (0 == recoverySite.getSiteType()) {
            this.checkUserResourceAuthority(resMap.getRecoveryResourceProviderId());
            if (resMap.getResourceType() == ResTypeEnum.VRG.getResType()) {
                this.checkUserResourceAuthority(resMap.getRecoveryResourceId());
            } else {
                this.checkResourceProvider(resMap.getRecoveryResourceId(), resMap.getRecoveryResourceProviderId());
            }
        }
        if (0 == (productSite = this.getSiteBySiteId(resMap.getProductSiteId())).getSiteType()) {
            this.checkUserResourceAuthority(resMap.getProductResourceProviderId());
            if (resMap.getResourceType() == ResTypeEnum.VRG.getResType()) {
                this.checkUserResourceAuthority(resMap.getProductResourceId());
            } else {
                this.checkResourceProvider(resMap.getProductResourceId(), resMap.getProductResourceProviderId());
            }
        }
    }

    protected Site getSiteBySiteId(String siteId) {
        ISiteBaseService siteService = (ISiteBaseService)super.getBundleService(ISiteBaseService.class.getName(), ISiteBaseService.class);
        Site site = siteService.getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"site is null", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return site;
    }

    protected void checkResourceProvider(String uuid, String providerSn) {
        ManagedObject mo = this.getMo(ManagedObject.class, "uuid", uuid);
        if (null != mo && null != mo.getTopMoUuid() && !mo.getTopMoUuid().equals(providerSn)) {
            logger.error((Object)("providerSn=" + providerSn + "is not the top object of uuid=" + uuid), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected <T extends NetworkEntity> List<T> filterResourceList(List<T> objList) {
        if (VerifyUtil.isEmpty(objList)) {
            return null;
        }
        ArrayList<String> objSns = new ArrayList<String>();
        for (NetworkEntity vrg : objList) {
            objSns.add(vrg.getSn());
        }
        List retSns = this.getScopeService().filterResource(objSns, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Collection)retSns)) {
            logger.warn((Object)("current user has no Resource right, sns=" + objSns), 90160758787071L);
            return null;
        }
        ArrayList<NetworkEntity> retObj = new ArrayList<NetworkEntity>();
        for (NetworkEntity vrg : objList) {
            if (!retSns.contains(vrg.getSn())) continue;
            retObj.add(vrg);
        }
        return retObj;
    }

    protected void generateAddResLog(String[] detailParams, int resType, LegoCheckedException ex) {
        logger.debug((Object)"generateAddResLog start");
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        String resourceType = String.valueOf(resType);
        if (null != detailParams) {
            if (3 == resType || 4 == resType) {
                logParams[0] = ResourceMappingUtil.getResType(resourceType);
                logParams[1] = detailParams[0];
                logParams[2] = detailParams[1];
                logParams[3] = detailParams[2];
                logParams[4] = detailParams[3];
                logParams[5] = detailParams[4];
                logParams[6] = detailParams[5];
                logParams[7] = detailParams[6];
                logParams[8] = detailParams[7];
            } else {
                logParams[0] = ResourceMappingUtil.getResType(resourceType);
                logParams[1] = detailParams[0];
                logParams[2] = detailParams[1];
                logParams[3] = detailParams[2];
                logParams[4] = detailParams[3];
                logParams[5] = detailParams[4];
                logParams[6] = detailParams[5];
            }
        }
        String optName = "resource_createResourceMapping_operateName";
        String targetKey = RESMAPPING_TARGET_NAME;
        if (resourceType.equals("5")) {
            optName = "resource_createVRGMapping_operateName";
            targetKey = VRGMAPPING_TARGET_NAME;
            logParams = detailParams;
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException(optName, 1, targetKey, (Exception)ex);
        } else {
            this.writeSucOperationLog(optName, 1, targetKey, ResourceMappingUtil.getAddMapDetailResType(resourceType), logParams);
        }
    }

    protected void generateDelOptResLog(ResourceMapping resMap, LegoCheckedException ex, String optType) {
        logger.debug((Object)"generateDelOptResLog start");
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        String resourceType = dbLine;
        if (null != resMap) {
            Site proSite = this.getSiteBySiteId(resMap.getProductSiteId());
            Site recoverySite = this.getSiteBySiteId(resMap.getRecoverySiteId());
            int resType = resMap.getResourceType();
            logParams[0] = ResourceMappingUtil.getResType(String.valueOf(resType));
            logParams[1] = resMap.getProductResourceName();
            logParams[2] = resMap.getRecoveryResourceName();
            logParams[3] = proSite.getName();
            logParams[4] = resMap.getProductResourceProviderName();
            if (3 == resType || 4 == resType) {
                logParams[5] = resMap.getProductVpcName();
                logParams[6] = recoverySite.getName();
                logParams[7] = resMap.getRecoveryResourceProviderName();
                logParams[8] = resMap.getRecoveryVpcName();
            } else {
                logParams[5] = recoverySite.getName();
                logParams[6] = resMap.getRecoveryResourceProviderName();
            }
            resourceType = String.valueOf(resMap.getResourceType());
        }
        String optName = optType;
        String targetKey = RESMAPPING_TARGET_NAME;
        if (resourceType.equals("5")) {
            optName = "resource_deleteVRGMapping_operateName";
            targetKey = VRGMAPPING_TARGET_NAME;
            logParams = this.getVrgDelParam(resMap);
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException(optName, 2, targetKey, (Exception)ex);
        } else {
            this.writeSucOperationLog(optName, 2, targetKey, ResourceMappingUtil.getDelMapDetailResType(resourceType), logParams);
        }
    }

    private String[] getVrgDelParam(ResourceMapping resMap) {
        logger.debug((Object)"getVrgDelParam start");
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (null != resMap) {
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = resMap.getProductSiteName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = resMap.getRecoverySiteName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        return logParams;
    }

    protected void generateModOptResLog(ResourceMapping srcMap, ResourceMapping dstMap, LegoCheckedException ex, String optType) {
        logger.debug((Object)"generateModOptResLog start");
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        String resourceType = dbLine;
        if (null != srcMap) {
            Site proSite = this.getSiteBySiteId(srcMap.getProductSiteId());
            Site srcRecSite = this.getSiteBySiteId(srcMap.getRecoverySiteId());
            int resType = srcMap.getResourceType();
            logParams[0] = ResourceMappingUtil.getResType(String.valueOf(resType));
            logParams[1] = srcMap.getProductResourceName();
            logParams[2] = srcMap.getRecoveryResourceName();
            if (null != dstMap) {
                logParams[3] = dstMap.getRecoveryResourceName();
            }
            logParams[4] = proSite.getName();
            logParams[5] = srcMap.getProductResourceProviderName();
            if (3 == resType || 4 == resType) {
                logParams[6] = srcMap.getProductVpcName();
                logParams[7] = srcRecSite.getName();
                logParams[8] = srcMap.getRecoveryResourceProviderName();
                logParams[9] = srcMap.getRecoveryVpcName();
                if (null != dstMap) {
                    Site dstRecSite = this.getSiteBySiteId(dstMap.getRecoverySiteId());
                    logParams[10] = dstRecSite.getName();
                    logParams[11] = dstMap.getRecoveryResourceProviderName();
                    logParams[12] = dstMap.getRecoveryVpcName();
                }
            } else {
                logParams[6] = srcRecSite.getName();
                logParams[7] = srcMap.getRecoveryResourceProviderName();
                if (null != dstMap) {
                    Site dstRecSite = this.getSiteBySiteId(dstMap.getRecoverySiteId());
                    logParams[8] = dstRecSite.getName();
                    logParams[9] = dstMap.getRecoveryResourceProviderName();
                }
            }
            resourceType = String.valueOf(srcMap.getResourceType());
        }
        this.writeOperationLog(ex, optType, logParams, resourceType);
    }

    private void writeOperationLog(LegoCheckedException ex, String optType, String[] logParams, String resourceType) {
        logger.trace((Object)"enter writeOperationLog");
        if (null != ex) {
            this.writeFailedOperationLogNoException(optType, 2, RESMAPPING_TARGET_NAME, (Exception)ex);
        } else {
            this.writeSucOperationLog(optType, 2, RESMAPPING_TARGET_NAME, ResourceMappingUtil.getModMapDetailResType(resourceType), logParams);
        }
    }

    protected IStorageRecoveryPlanService getStorageRecPlanService() {
        logger.debug((Object)"getStorageRecPlanService start");
        IStorageRecoveryPlanService galaxRecoveryPlanServices = (IStorageRecoveryPlanService)this.getBundleService(DRM_FS_STORAGE_REP_BUNDLE, IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
        return galaxRecoveryPlanServices;
    }

    protected LegoCheckedException handlingException(Exception ex) {
        LegoCheckedException exception = !(ex instanceof LegoCheckedException) ? new LegoCheckedException(-1L, ExceptionUtil.getErrorMessage((Throwable)ex)) : (LegoCheckedException)ex;
        return exception;
    }

    protected void handlingExceptionNoLog(Exception ex, String msg, Log log) {
        LegoCheckedException exception = this.handlingException(ex);
        ExceptionUtil.rethrowException((Throwable)exception, (String)msg, (long)exception.getErrorCode(), (String[])exception.getParameters(), (Log)log);
    }

    protected void handlingExceptionLog(Exception ex, String operationName, String msg, String objectName, Log log) {
        LegoCheckedException exception = this.handlingException(ex);
        this.writeFailedOperationLogNoException(operationName, 2, objectName, (Exception)exception);
        ExceptionUtil.rethrowException((Throwable)exception, (String)msg, (long)exception.getErrorCode(), (String[])exception.getParameters(), (Log)log);
    }
}

