/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.PortGroup;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IGalaxRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.cloud.service.IFusionsphereRestService;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.CompareJsonObjectByName;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.FusionsphereQueryPlanUtil;
import com.huawei.ism.drm.rest.fusionsphere.util.BaseRestUtils;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbsFsQueryRestServiceImpl
extends AbsVRRestService
implements IFusionsphereRestService {
    private static Log logger = LogFactory.getInstance(AbsFsQueryRestServiceImpl.class);
    private static final String TEST_QUERY_TYPE = "test";
    private static final String KEY_TOP_UUID = "topMoUuid";
    private static final String RECOVERY_QUERYTYPE = "recovery";

    @Override
    public String queryCloudMapping(String planId, String queryType) {
        logger.debug((Object)("AbsFsQueryRestServiceImpl:getAvailableTestNetwork enter, planId=" + planId), 90160758786816L);
        JSONArray jArray = new JSONArray();
        RecoveryPlan rp = this.queryRecoveryPlan(planId, queryType);
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in rp is empty, planId=" + rp.getPlanId()));
            return jArray.toString();
        }
        Set<String> clusterUrn = this.getRecoveryPlanUsedCluster(rp);
        if (VerifyUtil.isEmpty(clusterUrn)) {
            logger.error((Object)("result of query cluter is empty, planId=" + planId), 90160758787071L);
            return jArray.toString();
        }
        NetworkEntity nEntity = (NetworkEntity)this.getMo(NetworkEntity.class, "sn", pg.getPoProviderSN());
        GalaxObject gObject = (GalaxObject)this.getMo(GalaxObject.class, "uuid", clusterUrn.iterator().next());
        if (null != nEntity && null != gObject) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"srcCloudId", (Object)pg.getPoProviderSN());
            jsonObject.put((Object)"srcCloudName", (Object)nEntity.getName());
            jsonObject.put((Object)"srcHostClusterId", (Object)clusterUrn.iterator().next());
            jsonObject.put((Object)"srcHostClusterName", (Object)gObject.getName());
            this.fillRemoteCloudInfo(rp, jsonObject);
            jArray.add((Object)jsonObject);
        }
        logger.debug((Object)"AbsFsQueryRestServiceImpl:getAvailableTestNetwork leave.", 90160758786816L);
        return jArray.toString();
    }

    @Override
    public String queryHostClusters(String cloudSn) {
        List nodes;
        logger.debug((Object)("AbsFsQueryRestServiceImpl:queryHostClusters enter, cloudSn=" + cloudSn), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{cloudSn});
        String newCloudSn = BaseRestUtils.base64Decode((String)cloudSn);
        this.checkUserResourceAuthority(newCloudSn);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        List<String> cloudSns = this.getFusionComputeSns(newCloudSn);
        List clusters = this.getScopeService().getResources(ComputeCluster.class, KEY_TOP_UUID, cloudSns);
        if (!VerifyUtil.isEmpty((Collection)clusters)) {
            clusters.stream().filter(cluster -> cluster != null && cluster.getClass() == ComputeCluster.class).map(cluster -> this.buildHostClusterJSONObject(cluster.getUuid(), cluster.getName())).forEach(jsonObjects::add);
        }
        if (!VerifyUtil.isEmpty((Collection)(nodes = this.getScopeService().getResources(ComputeNode.class, KEY_TOP_UUID, cloudSns)))) {
            nodes.stream().filter(node -> node != null && VerifyUtil.isEmpty((String)node.getComputeClusterUrn())).map(node -> this.buildHostClusterJSONObject(node.getUuid(), node.getName())).forEach(jsonObjects::add);
        }
        Collections.sort(jsonObjects, new CompareJsonObjectByName("remoteHostClusterName"));
        logger.debug((Object)"AbsFsQueryRestServiceImpl:queryHostClusters leave.", 90160758786816L);
        return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
    }

    private JSONObject buildHostClusterJSONObject(String id, String name) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"remoteHostClusterId", (Object)id);
        jsonObject.put((Object)"remoteHostClusterName", (Object)name);
        return jsonObject;
    }

    @Override
    public String queryPortGroupMappings(String planId, String queryType, String replicaId) {
        logger.debug((Object)("AbsFsQueryRestServiceImpl:queryPortGroupMappings enter, planId=" + planId), 90160758786816L);
        RecoveryPlan rp = this.queryRecoveryPlan(planId, queryType);
        Set<String> portGroupUrns = VerifyUtil.isEmpty((String)replicaId) ? this.getRecoveryPlanUsedPorgGroup(rp) : this.getPortGroupUrnsFromReplica(replicaId);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (String pgUrn : portGroupUrns) {
            GalaxObject gObject = (GalaxObject)this.getMo(GalaxObject.class, "uuid", pgUrn);
            if (null == gObject) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"srcPortGroupId", (Object)pgUrn);
            jsonObject.put((Object)"srcPortGroupName", (Object)gObject.getName());
            this.fillRemotePortGroupInfo(rp, jsonObject);
            jsonObjects.add(jsonObject);
        }
        Collections.sort(jsonObjects, new CompareJsonObjectByName("srcPortGroupName"));
        logger.debug((Object)"AbsFsQueryRestServiceImpl:queryPortGroupMappings leave.", 90160758786816L);
        return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
    }

    @Override
    public String queryPortGroups(String cloudSn) {
        logger.debug((Object)("AbsFsQueryRestServiceImpl:queryPortGroups enter, cloudSn=" + cloudSn), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{cloudSn});
        String newCloudSn = BaseRestUtils.base64Decode((String)cloudSn);
        this.checkUserResourceAuthority(newCloudSn);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        ArrayList<String> pgSns = new ArrayList<String>();
        pgSns.add(newCloudSn);
        List portGroups = this.getScopeService().getResources(PortGroup.class, KEY_TOP_UUID, pgSns);
        if (VerifyUtil.isEmpty((Collection)portGroups)) {
            logger.error((Object)("there is no portgroup under cloud, sn=" + newCloudSn), 90160758787071L);
            return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
        }
        for (PortGroup pGroup : portGroups) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"remotePortGroupId", (Object)pGroup.getUuid());
            jsonObject.put((Object)"remotePortGroupName", (Object)pGroup.getName());
            jsonObjects.add(jsonObject);
        }
        Collections.sort(jsonObjects, new CompareJsonObjectByName("remotePortGroupName"));
        logger.debug((Object)("AbsFsQueryRestServiceImpl:queryPortGroups leave, cloudSn=" + newCloudSn), 90160758786816L);
        return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
    }

    @Override
    public String queryNetworkMappings(String planId, String queryType) {
        logger.debug((Object)("AbsFsQueryRestServiceImpl:queryNetworkMappings enter, planId=" + planId), 90160758786816L);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        RecoveryPlan rp = this.queryRecoveryPlan(planId, queryType);
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in recovery plan is empty, planId=" + planId));
            throw new LegoCheckedException(1073947393L);
        }
        Set networkUrnSet = this.getStorageRecPlanService().getNetworkUrnsByPlan(planId);
        if (VerifyUtil.isEmpty((Collection)networkUrnSet)) {
            logger.error((Object)("there is no network info used plan, planId=" + planId), 90160758787071L);
            return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
        }
        List<VPC> vpcs = this.queryVpcByCloud(pg.getPoProviderSN());
        for (String networkUrn : networkUrnSet) {
            GalaxObject gObject = (GalaxObject)this.getMo(GalaxObject.class, "uuid", networkUrn);
            VPC vpc = this.findVpcByGalaxObject(vpcs, gObject);
            if (null == gObject || null == vpc) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"srcNetworkId", (Object)networkUrn);
            jsonObject.put((Object)"srcNetworkName", (Object)gObject.getName());
            jsonObject.put((Object)"srcVPCId", (Object)vpc.getUuid());
            jsonObject.put((Object)"srcVPCName", (Object)vpc.getName());
            this.fillRemoteNetWorkInfo(rp, jsonObject);
            jsonObjects.add(jsonObject);
        }
        Collections.sort(jsonObjects, new CompareJsonObjectByName("srcNetworkName"));
        logger.debug((Object)("AbsFsQueryRestServiceImpl:queryNetworkMappings leave, planId=" + planId), 90160758786816L);
        return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
    }

    @Override
    public String queryNetworks(String cloudSn) {
        logger.debug((Object)("AbsFsQueryRestServiceImpl:queryNetworks enter, cloudSn=" + cloudSn), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{cloudSn});
        this.checkUserResourceAuthority(cloudSn);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        ArrayList<String> fmSns = new ArrayList<String>();
        fmSns.add(cloudSn);
        List networks = this.getScopeService().getResources(FmNetwork.class, KEY_TOP_UUID, fmSns);
        if (VerifyUtil.isEmpty((Collection)networks)) {
            logger.error((Object)("there is no network under cloud, sn=" + cloudSn), 90160758787071L);
            return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
        }
        List<VPC> vpcs = this.queryVpcByCloud(cloudSn);
        for (FmNetwork network : networks) {
            VPC vpc = this.findVpcByGalaxObject(vpcs, (GalaxObject)network);
            if (null == vpc) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"remoteNetworkId", (Object)network.getUuid());
            jsonObject.put((Object)"remoteNetworkName", (Object)network.getName());
            jsonObject.put((Object)"remoteVPCId", (Object)vpc.getUuid());
            jsonObject.put((Object)"remoteVPCName", (Object)vpc.getName());
            jsonObjects.add(jsonObject);
        }
        Collections.sort(jsonObjects, new CompareJsonObjectByName("remoteNetworkName"));
        logger.debug((Object)("AbsFsQueryRestServiceImpl:queryNetworks leave, cloudSn=" + cloudSn), 90160758786816L);
        return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
    }

    @Override
    public String querySecurityGroupMappings(String planId, String queryType) {
        logger.debug((Object)("AbsFsQueryRestServiceImpl:querySecurityGroupMappings enter, planId=" + planId), 90160758786816L);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        RecoveryPlan rp = this.queryRecoveryPlan(planId, queryType);
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in recovery plan is empty, planId=" + planId));
            throw new LegoCheckedException(1073947393L);
        }
        Set secGroupUrnSet = this.getStorageRecPlanService().getSecGroupUrnsByPlan(planId);
        if (VerifyUtil.isEmpty((Collection)secGroupUrnSet)) {
            logger.error((Object)("there is no security group info used plan, planId=" + planId), 90160758787071L);
            return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
        }
        List<VPC> vpcs = this.queryVpcByCloud(pg.getPoProviderSN());
        for (String secGroupUrn : secGroupUrnSet) {
            GalaxObject gObject = (GalaxObject)this.getMo(GalaxObject.class, "uuid", secGroupUrn);
            VPC vpc = this.findVpcByGalaxObject(vpcs, gObject);
            if (null == gObject || null == vpc) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"srcSecurityGroupId", (Object)secGroupUrn);
            jsonObject.put((Object)"srcSecurityGroupName", (Object)gObject.getName());
            jsonObject.put((Object)"srcVPCId", (Object)vpc.getUuid());
            jsonObject.put((Object)"srcVPCName", (Object)vpc.getName());
            this.fillRemoteSecGroupInfo(rp, jsonObject);
            jsonObjects.add(jsonObject);
        }
        Collections.sort(jsonObjects, new CompareJsonObjectByName("srcSecurityGroupName"));
        logger.debug((Object)("AbsFsQueryRestServiceImpl:querySecurityGroupMappings leave, planId=" + planId), 90160758786816L);
        return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
    }

    @Override
    public String querySecurityGroups(String cloudSn) {
        logger.debug((Object)("AbsFsQueryRestServiceImpl:querySecurityGroups enter, cloudSn=" + cloudSn), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{cloudSn});
        this.checkUserResourceAuthority(cloudSn);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        ArrayList<String> fmSns = new ArrayList<String>();
        fmSns.add(cloudSn);
        List secGroups = this.getScopeService().getResources(SecurityGroup.class, KEY_TOP_UUID, fmSns);
        if (VerifyUtil.isEmpty((Collection)secGroups)) {
            logger.error((Object)("there is no network under cloud, sn=" + cloudSn), 90160758787071L);
            return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
        }
        List<VPC> vpcs = this.queryVpcByCloud(cloudSn);
        for (SecurityGroup secGroup : secGroups) {
            VPC vpc = this.findVpcByGalaxObject(vpcs, (GalaxObject)secGroup);
            if (null == vpc) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"remoteSecurityGroupId", (Object)secGroup.getUuid());
            jsonObject.put((Object)"remoteSecurityGroupName", (Object)secGroup.getName());
            jsonObject.put((Object)"remoteVPCId", (Object)vpc.getUuid());
            jsonObject.put((Object)"remoteVPCName", (Object)vpc.getName());
            jsonObjects.add(jsonObject);
        }
        Collections.sort(jsonObjects, new CompareJsonObjectByName("remoteSecurityGroupName"));
        logger.debug((Object)("AbsFsQueryRestServiceImpl:querySecurityGroups leave, cloudSn=" + cloudSn), 90160758786816L);
        return FusionsphereQueryPlanUtil.changeJsonObjects(jsonObjects).toString();
    }

    private IRecoveryPlanBaseService getRecoveryPlanService() {
        return (IRecoveryPlanBaseService)this.getBundleService(IRecoveryPlanBaseService.class.getName(), IRecoveryPlanBaseService.class);
    }

    private RecoveryPlan queryRecoveryPlan(String planId, String queryType) {
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{planId, queryType});
        if (!TEST_QUERY_TYPE.equals(queryType)) {
            logger.error((Object)"paramter queryType is empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        RecoveryPlan rp = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (null == rp) {
            logger.error((Object)("the recovery plan is not exist, planId=" + planId), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return rp;
    }

    private void fillRemoteCloudInfo(RecoveryPlan rp, JSONObject jsonObject) {
        String testClouds = FusionsphereQueryPlanUtil.getRecoverySettingValue("testHostCluster", rp);
        if (VerifyUtil.isEmpty((String)testClouds)) {
            return;
        }
        try {
            String oldClusterId;
            GalaxObject galaxObject;
            JSONArray jsonArray = JSONArray.fromObject((Object)testClouds);
            if (null == jsonArray || jsonArray.isEmpty()) {
                return;
            }
            JSONObject oldSetting = jsonArray.getJSONObject(0);
            String oldSiteId = oldSetting.getString("remoteSiteId");
            Site site = this.getSiteBySiteId(oldSiteId);
            jsonObject.put((Object)"remoteSiteId", (Object)oldSiteId);
            jsonObject.put((Object)"remoteSiteName", (Object)site.getName());
            String oldCloud = oldSetting.getString("remoteCloudId");
            ArrayList<String> sns = new ArrayList<String>();
            sns.add(oldCloud);
            List drClouds = this.getScopeService().getResources(DrResource.class, "deviceSn", sns);
            if (!VerifyUtil.isEmpty((Collection)drClouds)) {
                jsonObject.put((Object)"remoteCloudId", (Object)oldCloud);
                jsonObject.put((Object)"remoteCloudName", (Object)((DrResource)drClouds.get(0)).getName());
            }
            if (null != (galaxObject = (GalaxObject)this.getMo(GalaxObject.class, "uuid", oldClusterId = oldSetting.getString("remoteHostClusterId")))) {
                jsonObject.put((Object)"remoteHostClusterId", (Object)oldClusterId);
                jsonObject.put((Object)"remoteHostClusterName", (Object)galaxObject.getName());
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("parse cloud setting catch lego exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private void fillRemotePortGroupInfo(RecoveryPlan rp, JSONObject jsonObject) {
        String testPortGroups = FusionsphereQueryPlanUtil.getRecoverySettingValue("testPortGroup", rp);
        if (VerifyUtil.isEmpty((String)testPortGroups)) {
            return;
        }
        try {
            JSONObject oldSetting = FusionsphereQueryPlanUtil.getJsonObjectFromArray(testPortGroups, "srcPortGroupId", jsonObject.getString("srcPortGroupId"));
            if (null == oldSetting) {
                return;
            }
            String oldPortGroupId = oldSetting.getString("remotePortGroupId");
            GalaxObject galaxObject = (GalaxObject)this.getMo(GalaxObject.class, "uuid", oldPortGroupId);
            if (null != galaxObject) {
                jsonObject.put((Object)"remotePortGroupId", (Object)oldPortGroupId);
                jsonObject.put((Object)"remotePortGroupName", (Object)galaxObject.getName());
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("parse portgroup setting catch lego exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private void fillRemoteNetWorkInfo(RecoveryPlan rp, JSONObject jsonObject) {
        String testNetWorks = FusionsphereQueryPlanUtil.getRecoverySettingValue("testNetwork", rp);
        if (VerifyUtil.isEmpty((String)testNetWorks)) {
            return;
        }
        try {
            JSONObject oldSetting = FusionsphereQueryPlanUtil.getJsonObjectFromArray(testNetWorks, "srcNetworkId", jsonObject.getString("srcNetworkId"));
            if (null == oldSetting) {
                return;
            }
            String oldNetworkId = oldSetting.getString("remoteNetworkId");
            String oldVpcId = oldSetting.getString("remoteVPCId");
            GalaxObject galaxObject = (GalaxObject)this.getMo(GalaxObject.class, "uuid", oldNetworkId);
            GalaxObject vpc = (GalaxObject)this.getMo(GalaxObject.class, "uuid", oldVpcId);
            if (null != galaxObject && null != vpc) {
                jsonObject.put((Object)"remoteNetworkId", (Object)oldNetworkId);
                jsonObject.put((Object)"remoteNetworkName", (Object)galaxObject.getName());
                jsonObject.put((Object)"remoteVPCId", (Object)oldVpcId);
                jsonObject.put((Object)"remoteVPCName", (Object)vpc.getName());
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("parse portgroup setting catch lego exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private void fillRemoteSecGroupInfo(RecoveryPlan rp, JSONObject jsonObject) {
        String testSecGroups = FusionsphereQueryPlanUtil.getRecoverySettingValue("testSecurityGroup", rp);
        if (VerifyUtil.isEmpty((String)testSecGroups)) {
            return;
        }
        try {
            JSONObject oldSetting = FusionsphereQueryPlanUtil.getJsonObjectFromArray(testSecGroups, "srcSecurityGroupId", jsonObject.getString("srcSecurityGroupId"));
            if (null == oldSetting) {
                return;
            }
            String oldSecGroupId = oldSetting.getString("remoteSecurityGroupId");
            String oldVpcId = oldSetting.getString("remoteVPCId");
            GalaxObject galaxObject = (GalaxObject)this.getMo(GalaxObject.class, "uuid", oldSecGroupId);
            GalaxObject vpc = (GalaxObject)this.getMo(GalaxObject.class, "uuid", oldVpcId);
            if (null != galaxObject && null != vpc) {
                jsonObject.put((Object)"remoteSecurityGroupId", (Object)oldSecGroupId);
                jsonObject.put((Object)"remoteSecurityGroupName", (Object)galaxObject.getName());
                jsonObject.put((Object)"remoteVPCId", (Object)oldVpcId);
                jsonObject.put((Object)"remoteVPCName", (Object)vpc.getName());
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("parse portgroup setting catch lego exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private List<GalaxVM> getVMsByProtectGroup(ProtectGroup pg) {
        Set pos = pg.getPolist();
        if (VerifyUtil.isEmpty((Collection)pos)) {
            logger.error((Object)("there is no protect objects, pgId=" + pg.getUuid()), 90160758787071L);
            return null;
        }
        HashSet<String> vmUudidSet = new HashSet<String>();
        for (ProtectObject po : pos) {
            vmUudidSet.add(po.getMoUuid());
        }
        List gVms = this.getScopeService().getResources(GalaxVM.class, "uuid", new ArrayList(vmUudidSet));
        return gVms;
    }

    private Set<String> getRecoveryPlanUsedPorgGroup(RecoveryPlan rp) {
        HashSet<String> portGroupUrns = new HashSet<String>();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in rp is empty, planId=" + rp.getPlanId()));
            return portGroupUrns;
        }
        List<GalaxVM> gVms = this.getVMsByProtectGroup(pg);
        if (VerifyUtil.isEmpty(gVms)) {
            logger.error((Object)("result of query vm is empty, planId=" + rp.getPlanId()), 90160758787071L);
            return portGroupUrns;
        }
        for (GalaxVM gVm : gVms) {
            portGroupUrns.addAll(FusionsphereQueryPlanUtil.getPortGroupsByVm(gVm));
        }
        return portGroupUrns;
    }

    private Set<String> getPortGroupUrnsFromReplica(String replicaId) {
        IGalaxRecoveryPlanService galaxRecoveryPlanService = (IGalaxRecoveryPlanService)this.getBundleService("DRM_FusionShpere_Base", IGalaxRecoveryPlanService.class.getName(), IGalaxRecoveryPlanService.class);
        List vmConfigList = galaxRecoveryPlanService.queryVmConfigsByReplicaId(replicaId);
        HashSet<String> portGroupUrns = new HashSet<String>();
        for (String vmConfig : vmConfigList) {
            GalaxVM gVm = new GalaxVM();
            gVm.setVmConfig(vmConfig);
            portGroupUrns.addAll(FusionsphereQueryPlanUtil.getPortGroupsByVm(gVm));
        }
        return portGroupUrns;
    }

    private Set<String> getRecoveryPlanUsedCluster(RecoveryPlan rp) {
        HashSet<String> clusterUrns = new HashSet<String>();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in rp is empty, planId=" + rp.getPlanId()));
            return clusterUrns;
        }
        List<GalaxVM> gVms = this.getVMsByProtectGroup(pg);
        if (VerifyUtil.isEmpty(gVms)) {
            logger.error((Object)("result of query vm is empty, planId=" + rp.getPlanId()), 90160758787071L);
            return clusterUrns;
        }
        for (GalaxVM gVm : gVms) {
            clusterUrns.add(gVm.isBindingHost() != false ? gVm.getHostUrn() : gVm.getClusterUrn());
        }
        return clusterUrns;
    }

    private List<VPC> queryVpcByCloud(String cloudSn) {
        logger.debug((Object)("queryVpcByCloud start:cloudSn=" + cloudSn));
        ArrayList<String> cloudSns = new ArrayList<String>();
        cloudSns.add(cloudSn);
        return this.getScopeService().getResources(VPC.class, KEY_TOP_UUID, cloudSns);
    }

    private VPC findVpcByGalaxObject(List<VPC> vpcs, GalaxObject gObject) {
        if (null == gObject) {
            return null;
        }
        if (VerifyUtil.isEmpty(vpcs)) {
            logger.error((Object)"there is no VPC info.", 90160758787071L);
            return null;
        }
        for (VPC vpc : vpcs) {
            if (!vpc.getMoId().equals(gObject.getParentId())) continue;
            return vpc;
        }
        logger.error((Object)("can not find the vpc, name=" + gObject.getName()), 90160758787071L);
        return null;
    }

    private IFmService getFmService() {
        logger.debug((Object)"getFmService start");
        return (IFmService)this.getBundleService("DRM_FusionShpere_Base", IFmService.class.getName());
    }

    private List<String> getFusionComputeSns(String cloudSn) {
        logger.debug((Object)("getFusionComputeSns start:cloudSn=" + cloudSn));
        NetworkEntity entity = (NetworkEntity)this.getMo(NetworkEntity.class, "uuid", cloudSn);
        if (null == entity) {
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList<String> cloudSns = new ArrayList<String>();
        if (entity instanceof VRM) {
            cloudSns.add(cloudSn);
            return cloudSns;
        }
        if (entity instanceof FusionManager) {
            List vrms = this.getFmService().getRegistedFcOfSpecfiedFm(cloudSn);
            if (VerifyUtil.isEmpty((Collection)vrms)) {
                return cloudSns;
            }
            for (VRM vrm : vrms) {
                this.checkUserResourceAuthority(vrm.getSn());
                cloudSns.add(vrm.getSn());
            }
            return cloudSns;
        }
        throw new LegoCheckedException(1073947393L);
    }

    @Override
    public String queryRecoverySites(String planId, String queryType) {
        if (CommUtil.isNullStr((String)planId) || CommUtil.isNullStr((String)queryType)) {
            logger.error((Object)"Fail to get params when calling Rest Service", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!TEST_QUERY_TYPE.equals(queryType) && !RECOVERY_QUERYTYPE.equals(queryType)) {
            logger.error((Object)"queryType is error.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
        RecoveryPlan rp = this.queryRecoveryPlan(planId, queryType);
        ProtectGroup pg = rp.getProtectGroup();
        String disasterSiteId = this.getRecoverySiteIdBySetting(rp);
        return this.toJsonStr(disasterSiteId, pg);
    }

    private String getRecoverySiteIdBySetting(RecoveryPlan rp) {
        Map setting = rp.getGlobalSettings();
        if (VerifyUtil.isEmpty((Map)setting)) {
            return null;
        }
        return (String)setting.get("SELECT_DISASTER_SITE_KEY");
    }

    private String toJsonStr(String disasterSiteId, ProtectGroup pg) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"productSiteId", (Object)pg.getProductSiteId());
        jsonObject.put((Object)"productSiteName", (Object)pg.getProductSiteName());
        if (null != disasterSiteId) {
            jsonObject.put((Object)"recoverySiteName", (Object)this.getSiteNameBySiteId(disasterSiteId));
            jsonObject.put((Object)"recoverySiteId", (Object)disasterSiteId);
        }
        jsonArray.add((Object)jsonObject);
        return jsonArray.toString();
    }

    private String getSiteNameBySiteId(String siteId) {
        String siteName = "--";
        ISiteBaseService siteSerivce = (ISiteBaseService)this.getBundleService(ISiteBaseService.class);
        Site site = siteSerivce.getSiteById(siteId);
        if (!VerifyUtil.isEmpty((Object)site)) {
            siteName = site.getName();
        }
        return siteName;
    }
}

