/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.IpV6BaseVO;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.NicInfoVO;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.SetNicInfoParam;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.SetNicInfoParamFromExcel;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsFileHandleUtil {
    public static final String IP_SPLIT = ",";
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final int SEVEN = 7;
    private static final int EIGHT = 8;
    private static final int NINE = 9;
    private static final int TEN = 10;
    private static final int ELEVEN = 11;
    private static final int TWELVE = 12;
    private static final int THIRTEEN = 13;
    private static final int FOURTEEN = 14;
    private static final int TWENTY = 20;
    private static final String N_STR = "N";
    private static final String Y_STR = "Y";
    private static final int MAX_SIZE_EXCEL = 0xA00000;
    private static final String XLSX_SUFFIX = ".xlsx";
    private static Log logger = LogFactory.getInstance(XlsFileHandleUtil.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SetNicInfoParamFromExcel> checkFileContentFormatAndFetchNicCheckInfo(String path, int pageIndex) throws InvalidFormatException, IOException {
        ArrayList<SetNicInfoParamFromExcel> setNicInfoParamList = new ArrayList<SetNicInfoParamFromExcel>();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path);
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)inputStream);
            XSSFSheet sheet = xssfWorkbook.getSheetAt(pageIndex);
            if (null == sheet) {
                logger.error((Object)(pageIndex + " sheet is null"));
                throw new LegoCheckedException("excel file format error! please check carefully \uff01");
            }
            if (sheet.getLastRowNum() < 3) {
                logger.error((Object)"row in 1 sheet less than 3");
                throw new LegoCheckedException("excel file format error! please check carefully \uff01");
            }
            XSSFRow rowThree = sheet.getRow(3);
            if (null == rowThree) {
                logger.error((Object)"there has null row of 3rd row!");
                throw new LegoCheckedException("excel file format error! please check carefully \uff01");
            }
            if (rowThree.getLastCellNum() < 14) {
                logger.error((Object)"cell in 3 row  less than 11");
                throw new LegoCheckedException("excel file format error! please check carefully \uff01");
            }
            for (int i = 3; i <= sheet.getLastRowNum(); ++i) {
                XlsFileHandleUtil.generateSetNicInfoParamList(setNicInfoParamList, sheet, i);
            }
        }
        catch (LegoCheckedException e) {
            try {
                logger.error((Object)"analysis file error");
                throw e;
                catch (EncryptedDocumentException e2) {
                    logger.error((Object)"analysis file error");
                    throw e2;
                }
                catch (IOException e3) {
                    logger.error((Object)"analysis file error");
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                XlsFileHandleUtil.closeInputStream(inputStream);
                throw throwable;
            }
        }
        XlsFileHandleUtil.closeInputStream(inputStream);
        return setNicInfoParamList;
    }

    private static void generateSetNicInfoParamList(List<SetNicInfoParamFromExcel> setNicInfoParamList, XSSFSheet sheet, int i) {
        boolean status2;
        XSSFRow row = sheet.getRow(i);
        if (row.getLastCellNum() < 14) {
            logger.error((Object)"cell in 3 row  less than 12");
            throw new LegoCheckedException("excel format error! cell in 3 row  less than 12!");
        }
        SetNicInfoParamFromExcel param = new SetNicInfoParamFromExcel();
        String poName = XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(0));
        String poGroupName = XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(1));
        String poId = XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(2));
        String planId = XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(3));
        String nicSeqNum = XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(4));
        String nicSeqName = XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(5));
        boolean status1 = StringUtils.isNotBlank((CharSequence)poId) && StringUtils.isNotBlank((CharSequence)planId) && StringUtils.isNotBlank((CharSequence)nicSeqNum);
        boolean bl = status2 = StringUtils.isNotBlank((CharSequence)poName) && StringUtils.isNotBlank((CharSequence)poGroupName) && StringUtils.isNotBlank((CharSequence)nicSeqName);
        if (!status1 || !status2) {
            logger.error((Object)"the three hide info is not complete, please check carefully!");
            throw new LegoCheckedException("the three hide info is not complete, please check carefully!");
        }
        param.setPoId(poId);
        param.setPlanId(planId);
        param.setNicSeqNum(nicSeqNum);
        param.setProtectobjectName(poName);
        param.setProtectGroupName(poGroupName);
        param.setNetWorkCardName(nicSeqName);
        param.setIpType(XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(7)));
        setNicInfoParamList.add(param);
    }

    private static void generateV6SetNicInfoParamList(List<SetNicInfoParam> setNicInfoParamList, XSSFSheet sheet, int i) {
        XSSFRow row = sheet.getRow(i);
        if (row.getLastCellNum() < 20) {
            logger.error((Object)"cell in 3 row  less than 20");
            throw new LegoCheckedException("excle format error!");
        }
        SetNicInfoParam param = new SetNicInfoParam();
        param.setPoId(XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(2)));
        param.setPlanId(XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(3)));
        param.setNicSeqNum(XlsFileHandleUtil.fetchValueFromCell((Cell)row.getCell(4)));
        setNicInfoParamList.add(param);
    }

    /*
     * Exception decompiling
     */
    public static List<SetNicInfoParamFromExcel> fetchNicInfoListFromExcel(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<SetNicInfoParamFromExcel> fetchV6NicInfoListFromExcel(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void generateSetNicInfoList(List<SetNicInfoParamFromExcel> setNicInfoParamFromExcelList, XSSFSheet sheet, int i) {
        boolean checkV4Status2;
        XSSFRow xssfRow = sheet.getRow(i);
        XlsFileHandleUtil.checkRowCell(xssfRow);
        String ipType = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(7));
        if (!"IPV4".equals(ipType)) {
            return;
        }
        SetNicInfoParamFromExcel nicInfoParam = new SetNicInfoParamFromExcel();
        NicInfoVO nicInfoVo = new NicInfoVO();
        String protectobjectName = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(0));
        String protectGroupName = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(1));
        String poId = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(2));
        String planId = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(3));
        String nicSeqNum = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(4));
        String netWorkCardName = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(5));
        boolean checkV4Status1 = StringUtils.isNotBlank((CharSequence)protectobjectName) && StringUtils.isNotBlank((CharSequence)protectGroupName) && StringUtils.isNotBlank((CharSequence)poId) && StringUtils.isNotBlank((CharSequence)planId);
        boolean bl = checkV4Status2 = StringUtils.isNotBlank((CharSequence)nicSeqNum) && StringUtils.isNotBlank((CharSequence)netWorkCardName);
        if (checkV4Status1 && checkV4Status2) {
            nicInfoParam.setProtectobjectName(protectobjectName);
            nicInfoParam.setProtectGroupName(protectGroupName);
            nicInfoParam.setPoId(poId);
            nicInfoParam.setPlanId(planId);
            nicInfoParam.setNicSeqNum(nicSeqNum);
            nicInfoParam.setNetWorkCardName(netWorkCardName);
            String ipConfigStr = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(6));
            if (!N_STR.equals(ipConfigStr) && !Y_STR.equals(ipConfigStr)) {
                throw new LegoCheckedException(1073947393L, "ip setting str invalid!");
            }
        } else {
            logger.error((Object)("in the 1st sheet, row " + i + "is not complete! the basic info is lost!"));
            throw new LegoCheckedException("in the 1st sheet, row " + i + "is not complete! the basic info is lost!");
        }
        nicInfoParam.setIsConfigIP(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(6)));
        nicInfoVo.setIp(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(8)));
        nicInfoVo.setNetmask(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(9)));
        nicInfoVo.setGateway(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(11)));
        nicInfoVo.setSetdns(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(12)));
        nicInfoVo.setAdddns(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(13)));
        nicInfoParam.setNicInfoVO(nicInfoVo);
        setNicInfoParamFromExcelList.add(nicInfoParam);
    }

    private static void generateV6SetNicInfoList(List<SetNicInfoParamFromExcel> setNicInfoParamFromExcelList, XSSFSheet sheet, int i) {
        ArrayList<IpV6BaseVO> ipV6BaseVOList;
        boolean checkV6Status2;
        XSSFRow xssfRow = sheet.getRow(i);
        XlsFileHandleUtil.checkRowCell(xssfRow);
        String ipType = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(7));
        if (!"IPV6".equals(ipType)) {
            return;
        }
        SetNicInfoParamFromExcel nicInfoParam = new SetNicInfoParamFromExcel();
        NicInfoVO nicInfoVo = new NicInfoVO();
        String protectobjectName = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(0));
        String protectGroupName = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(1));
        String poId = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(2));
        String planId = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(3));
        String nicSeqNum = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(4));
        String netWorkCardName = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(5));
        boolean checkV6Status1 = StringUtils.isNotBlank((CharSequence)protectobjectName) && StringUtils.isNotBlank((CharSequence)protectGroupName) && StringUtils.isNotBlank((CharSequence)poId) && StringUtils.isNotBlank((CharSequence)planId);
        boolean bl = checkV6Status2 = StringUtils.isNotBlank((CharSequence)netWorkCardName) && StringUtils.isNotBlank((CharSequence)nicSeqNum);
        if (checkV6Status1 && checkV6Status2) {
            nicInfoParam.setProtectobjectName(protectobjectName);
            nicInfoParam.setProtectGroupName(protectGroupName);
            nicInfoParam.setPoId(poId);
            nicInfoParam.setPlanId(planId);
            nicInfoParam.setNicSeqNum(nicSeqNum);
            nicInfoParam.setNetWorkCardName(netWorkCardName);
            String ipConfigStr = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(6));
            if (!N_STR.equals(ipConfigStr) && !Y_STR.equals(ipConfigStr)) {
                throw new LegoCheckedException(1073947393L, "ip setting str invalid!");
            }
            nicInfoParam.setIsConfigIPV6(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(6)));
            ipV6BaseVOList = new ArrayList<IpV6BaseVO>();
            String ipV6Str = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(8));
            String preFixStr = XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(10));
            String[] ipV6Array = ipV6Str.split(IP_SPLIT);
            String[] preFixArray = preFixStr.split(IP_SPLIT);
            if (ipV6Array.length > 0) {
                for (int index = 0; index < ipV6Array.length; ++index) {
                    String ipv6Addr = ipV6Array[index];
                    if (VerifyUtil.isEmpty((String)ipv6Addr)) continue;
                    IpV6BaseVO ipv6Info = new IpV6BaseVO();
                    ipv6Info.setIpv6Addr(ipv6Addr);
                    ipv6Info.setIpv6Prefix(preFixArray[index]);
                    ipV6BaseVOList.add(ipv6Info);
                }
            }
        } else {
            logger.error((Object)("in the 2st sheet, row " + i + "is not complete! the basic info is lost!"));
            throw new LegoCheckedException("in the 1st sheet, row " + i + "is not complete! the basic info is lost!");
        }
        nicInfoVo.setIpAddress6(VerifyUtil.isEmpty(ipV6BaseVOList) ? null : ipV6BaseVOList);
        nicInfoVo.setGatewayIpAddr6(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(11)));
        nicInfoVo.setSetdns6(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(12)));
        nicInfoVo.setAdddns6(XlsFileHandleUtil.fetchValueFromXssfCell(xssfRow.getCell(13)));
        nicInfoParam.setNicInfoVO(nicInfoVo);
        setNicInfoParamFromExcelList.add(nicInfoParam);
    }

    private static void checkRowCell(XSSFRow xssfRow) {
        if (xssfRow.getLastCellNum() < 14) {
            logger.error((Object)"cell in 3rd row less than 14!");
            throw new LegoCheckedException("excel format error! cell in 3rd row less than 14!");
        }
        if (xssfRow.getLastCellNum() > 14) {
            logger.error((Object)"cell in 3rd row after 14 will not do work, only 1 to 14 will do work!");
        }
    }

    private static void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e, 90160758784000L);
            }
        }
    }

    private static void closeFileOutPutStream(FileOutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e, 90160758784000L);
            }
        }
    }

    private static String fetchValueFromCell(Cell cell) {
        if (cell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            DecimalFormat dfs = new DecimalFormat("0");
            return String.valueOf(dfs.format(cell.getNumericCellValue()));
        }
        if (cell.getCellType() == CellType.STRING) {
            return String.valueOf(cell.getStringCellValue());
        }
        if (cell.getCellType() == CellType.BLANK) {
            return "";
        }
        return "error";
    }

    private static String fetchValueFromXssfCell(XSSFCell xssfRow) {
        if (xssfRow.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(xssfRow.getBooleanCellValue());
        }
        if (xssfRow.getCellType() == CellType.NUMERIC) {
            DecimalFormat dfs = new DecimalFormat("0");
            return String.valueOf(dfs.format(xssfRow.getNumericCellValue()));
        }
        if (xssfRow.getCellType() == CellType.STRING) {
            return String.valueOf(xssfRow.getStringCellValue());
        }
        if (xssfRow.getCellType() == CellType.BLANK) {
            return "";
        }
        return "error";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void uploadFileToServerLocal(Attachment file, String fileName, int length) throws IOException {
        InputStream is = null;
        FileOutputStream output = null;
        try {
            if (VerifyUtil.isEmpty((Object)file)) {
                logger.error((Object)"import file is null.");
                throw new LegoCheckedException(65540L);
            }
            XlsFileHandleUtil.checkFileSuffix(file);
            DataHandler dh = file.getDataHandler();
            if (length >= 0xA00000) {
                logger.error((Object)"import file length too big.");
                throw new LegoCheckedException(65540L);
            }
            is = dh.getInputStream();
            if (is == null) {
                logger.error((Object)"cant not get inputStream.");
                throw new LegoCheckedException(65540L);
            }
            byte[] bytes = new byte[0xA00000];
            int read = is.read(bytes);
            if (-1 == read) {
                logger.error((Object)"can't get read.");
                throw new LegoCheckedException(65540L);
            }
            byte[] licenseBytes = new byte[read];
            System.arraycopy(bytes, 0, licenseBytes, 0, read);
            File tempFile = new File(fileName);
            if (!tempFile.exists()) {
                XlsFileHandleUtil.checkFileExit(tempFile);
            }
            output = new FileOutputStream(tempFile);
            output.write(licenseBytes);
            output.flush();
        }
        catch (LegoCheckedException e) {
            try {
                logger.error((Object)"write file e.");
                throw e;
                catch (IOException e2) {
                    logger.error((Object)"write file error.");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                XlsFileHandleUtil.closeInputStream(is);
                XlsFileHandleUtil.closeFileOutPutStream(output);
                throw throwable;
            }
        }
        XlsFileHandleUtil.closeInputStream(is);
        XlsFileHandleUtil.closeFileOutPutStream(output);
    }

    private static void checkFileSuffix(Attachment file) {
        String fileOriginalName = file.getDataHandler().getName();
        if (!fileOriginalName.endsWith(XLSX_SUFFIX)) {
            logger.error((Object)"Import file failed, cause file is not xlsx type.");
            throw new LegoCheckedException(65540L);
        }
    }

    private static void checkFileExit(File tempFile) throws IOException {
        boolean createResult = tempFile.createNewFile();
        if (!createResult) {
            logger.error((Object)"tempFile if null.");
            throw new LegoCheckedException(65540L);
        }
    }
}

