/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drp;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IGalaxVMInfoService;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.drp.CSVUtils;
import com.huawei.ism.drm.rest.fusionsphere.drp.GalaxVMRecoveryProxy;
import com.huawei.ism.drm.rest.fusionsphere.drp.RecoveryInformationManager;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.RecoveryMappingInformation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

public class ExportResMappingBs
extends AbsVRRestService {
    private static Log logger = LogFactory.getInstance(ExportResMappingBs.class);
    private static final String RECOVERY_PLAN_SERVICE_NAME = IRecoveryPlanBaseService.class.getName();
    private static ExportResMappingBs instance = new ExportResMappingBs();

    private ExportResMappingBs() {
        logger.trace((Object)"enter ExportResMappingBs");
    }

    public static ExportResMappingBs getInstance() {
        return instance;
    }

    public void exportResMapping(String planId, List<String> headInfos, HttpServletResponse response) {
        logger.info((Object)"[Begin] to export recovery resources mapping information.", 90160758786816L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CSVUtils.createCSVFile(headInfos, this.getVMRecoveryMappingInfos(planId), (ByteArrayOutputStream)baos);
        ByteArrayInputStream exportExcelStream = new ByteArrayInputStream(baos.toByteArray());
        this.downloadFile(response, exportExcelStream);
        logger.info((Object)"[Finished] to export recovery resources mapping information.", 90160758786816L);
    }

    private List<Object> getVMRecoveryMappingInfos(String planId) {
        ArrayList<Object> vmMappingInfos = new ArrayList<Object>();
        RecoveryPlan plan = this.getRecoveryPlan(planId);
        if (plan == null) {
            logger.error((Object)"there is no recovery plan", 90160758787071L);
            throw new LegoCheckedException(1073948722L);
        }
        RecoveryInformationManager recInfoMgr = new RecoveryInformationManager(plan, this.getGalaxVMInfoService(plan));
        List<ResourceMapping> resourceMappings = this.getAllResourceMappings();
        resourceMappings.addAll(this.getReverseResourceMappings(resourceMappings));
        Set pgSet = plan.getProtectGroups();
        for (ProtectGroup pg : pgSet) {
            logger.debug((Object)("Succeed to get ProtectGroup in RecoveryPlan id is [" + plan.getPlanId() + "], PG is [" + pg.getUuid() + "]"), 90160758786816L);
            Set pos = pg.getPolist();
            logger.debug((Object)("ProtectObject count is [" + pos.size() + "] in ProtectGroup [" + pg.getUuid() + "]"), 90160758786816L);
            for (ProtectObject po : pos) {
                this.addVMMappingInfo(vmMappingInfos, po, recInfoMgr, resourceMappings);
            }
        }
        logger.info((Object)"[Finished] to construct VMMappingInfo.", 90160758786816L);
        return vmMappingInfos;
    }

    private RecoveryPlan getRecoveryPlan(String planId) {
        if (null == planId || planId.isEmpty()) {
            logger.error((Object)"param: planId is null or empty");
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
        logger.debug((Object)("Succeed to access IRecoveryPlanBaseService in getVMRecoveryMappingInfos. RecoveryPlan id is [" + planId + "]"), 90160758786816L);
        return rpServices.getRecoveryPlan(planId);
    }

    private IRecoveryPlanBaseService getRecoveryPlanService() {
        logger.debug((Object)"getRecoveryPlanService start");
        return (IRecoveryPlanBaseService)ServiceLocator.getBundleService((String)"DRM_Base", (String)IRecoveryPlanBaseService.class.getName(), IRecoveryPlanBaseService.class);
    }

    private IResourceMappingService getResourceMappingService() {
        logger.debug((Object)"getResourceMappingService start");
        return (IResourceMappingService)ServiceLocator.getBundleService((String)"DRM_FusionShpere_Base", (String)IResourceMappingService.class.getName(), IResourceMappingService.class);
    }

    public IGalaxVMInfoService getGalaxVMInfoService(RecoveryPlan plan) {
        logger.debug((Object)"getGalaxVMInfoService start");
        GalaxVMRecoveryProxy proxy = new GalaxVMRecoveryProxy(plan);
        String serviceBundleName = proxy.getRepBundleName();
        if (!VerifyUtil.isEmpty((String)serviceBundleName)) {
            IGalaxVMInfoService vmInfoService = (IGalaxVMInfoService)ServiceLocator.getBundleService((String)serviceBundleName, (String)IGalaxVMInfoService.class.getName(), IGalaxVMInfoService.class);
            return vmInfoService;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResourceMapping> getAllResourceMappings() {
        logger.debug((Object)"getAllResourceMappings start");
        ArrayList qcs = new ArrayList();
        List rmList = new ArrayList();
        String orderByField = "productSiteName";
        Page page = null;
        try {
            page = this.getResourceMappingService().pageQueryConditionResourceMapping(0, Integer.MAX_VALUE, orderByField, true, qcs);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to pageQueryResourceMapping. Caught Exception ", (long)-1L, null, (Log)logger);
        }
        finally {
            if (null != page) {
                rmList = page.getResult();
            }
        }
        return rmList;
    }

    private List<ResourceMapping> getReverseResourceMappings(List<ResourceMapping> rmList) {
        logger.debug((Object)"getReverseResourceMappings start");
        ArrayList<ResourceMapping> reverseResourceMappings = new ArrayList<ResourceMapping>();
        for (ResourceMapping rm : rmList) {
            reverseResourceMappings.add(this.swapRm(rm));
        }
        return reverseResourceMappings;
    }

    private ResourceMapping swapRm(ResourceMapping rm) {
        logger.debug((Object)"swapRm start");
        ResourceMapping resourceMapping = new ResourceMapping();
        resourceMapping.setProductResourceId(rm.getRecoveryResourceId());
        resourceMapping.setRecoveryResourceId(rm.getProductResourceId());
        resourceMapping.setProductResourceName(rm.getRecoveryResourceName());
        resourceMapping.setRecoveryResourceName(rm.getProductResourceName());
        resourceMapping.setProductResourceProviderId(rm.getRecoveryResourceProviderId());
        resourceMapping.setRecoveryResourceProviderId(rm.getProductResourceProviderId());
        resourceMapping.setProductResourceProviderName(rm.getRecoveryResourceProviderName());
        resourceMapping.setRecoveryResourceProviderName(rm.getProductResourceProviderName());
        resourceMapping.setProductSiteId(rm.getRecoverySiteId());
        resourceMapping.setRecoverySiteId(rm.getProductSiteId());
        resourceMapping.setProductSiteName(rm.getRecoverySiteName());
        resourceMapping.setRecoverySiteName(rm.getProductSiteName());
        resourceMapping.setProductVpcId(rm.getRecoveryVpcId());
        resourceMapping.setRecoveryVpcId(rm.getProductVpcId());
        resourceMapping.setProductVpcName(rm.getRecoveryVpcName());
        resourceMapping.setRecoveryVpcName(rm.getProductVpcName());
        return resourceMapping;
    }

    private boolean isPlatformFC(String platformSn) {
        logger.debug((Object)"isPlatformFC start");
        if (null == platformSn || platformSn.isEmpty()) {
            return false;
        }
        return platformSn.startsWith("Dr_Vrm");
    }

    private void addVMMappingInfo(List<Object> vmMappingInfos, ProtectObject po, RecoveryInformationManager recInfoMgr, List<ResourceMapping> resourceMappings) {
        int resourceType;
        String recoveryProviderSN;
        String recoveryResourceId;
        String productResourceId;
        logger.info((Object)("Po id is " + po.getUuid() + " po name is " + po.getName() + " po providerSN is " + po.getProviderSN()), 90160758786816L);
        String poId = po.getUuid();
        if (this.isPlatformFC(po.getProviderSN())) {
            String recoveryLocation = recInfoMgr.getVmRecoveryLocation(poId);
            productResourceId = recInfoMgr.getVmProductUrn(poId);
            recoveryResourceId = recInfoMgr.getVmRecoveryUrn(poId);
            recoveryProviderSN = this.getRecoveryFCId(po.getProviderSN(), recInfoMgr.getVmProductLocation(poId), resourceMappings);
            resourceType = 1;
            if (VerifyUtil.isEmpty((String)recoveryLocation) || VerifyUtil.isEmpty((String)recoveryResourceId)) {
                logger.error((Object)("Po id is " + po.getUuid() + " po name is " + po.getName() + "recoveryLocation is " + recoveryLocation + "recoveryResourceId is " + recoveryResourceId), 90160758787071L);
                return;
            }
            if (!this.isAlreadyHas(vmMappingInfos, po.getProviderSN(), recoveryProviderSN, recoveryLocation)) {
                this.addPGClusterMapping(vmMappingInfos, po.getProviderSN(), recoveryProviderSN, recoveryLocation, resourceMappings);
            }
        } else {
            String recoveryLocation = recInfoMgr.getVmRecoveryVPC(poId);
            productResourceId = recInfoMgr.getVmProductGlobalIdMap(poId);
            recoveryResourceId = recInfoMgr.getVmRecoveryGlobalIdMap(poId);
            recoveryProviderSN = this.getRecoveryFMId(po.getProviderSN(), recoveryLocation, resourceMappings);
            resourceType = 4;
            if (VerifyUtil.isEmpty((String)recoveryLocation) || VerifyUtil.isEmpty((String)recoveryResourceId)) {
                logger.error((Object)("Po id is " + po.getUuid() + " po name is " + po.getName() + "recoveryLocation is " + recoveryLocation + "recoveryResourceId is " + recoveryResourceId), 90160758787071L);
                return;
            }
        }
        RecoveryMappingInformation vmMappingInfo = this.configRecoveryVMMapping(po, productResourceId, recoveryResourceId, recoveryProviderSN, resourceType);
        vmMappingInfos.add(vmMappingInfo);
    }

    private String getRecoveryFCId(String productCloudPlatform, String productCluster, List<ResourceMapping> resourceMappings) {
        logger.info((Object)("To getRecoveryFCId productCloudPlatform is " + productCloudPlatform + " productCluster is " + productCluster), 90160758786816L);
        for (ResourceMapping rm : resourceMappings) {
            if (!rm.getProductResourceProviderId().equals(productCloudPlatform) || !rm.getProductResourceId().equals(productCluster)) continue;
            return rm.getRecoveryResourceProviderId();
        }
        return "";
    }

    private boolean isAlreadyHas(List<Object> mappingInfos, String productProviderSN, String recoveryProviderSN, String recoveryResourceUrn) {
        for (Object element : mappingInfos) {
            if (!(element instanceof RecoveryMappingInformation)) {
                logger.error((Object)("model type error " + element), 90160758787071L);
                continue;
            }
            RecoveryMappingInformation mappingInformation = (RecoveryMappingInformation)element;
            if (!mappingInformation.getProductCloudPlatform().equals(productProviderSN) || !mappingInformation.getRecoveryCloudPlatform().equals(recoveryProviderSN) || !mappingInformation.getRecoveryResourceId().equals(recoveryResourceUrn)) continue;
            return true;
        }
        return false;
    }

    private void addPGClusterMapping(List<Object> mappingInfos, String productProviderSN, String recoveryProviderSN, String recoveryResourceUrn, List<ResourceMapping> resourceMappings) {
        logger.debug((Object)"addPGClusterMapping start");
        for (ResourceMapping rm : resourceMappings) {
            if (!rm.getProductResourceProviderId().equals(productProviderSN) || !rm.getRecoveryResourceId().equals(recoveryResourceUrn) || !rm.getRecoveryResourceProviderId().equals(recoveryProviderSN)) continue;
            int resType = this.getResourceType(rm);
            RecoveryMappingInformation mappingInformation = new RecoveryMappingInformation();
            mappingInformation.setProductionInfo(productProviderSN, rm.getProductResourceName(), rm.getProductResourceId());
            mappingInformation.setRecoveryInfo(recoveryProviderSN, rm.getRecoveryResourceName(), rm.getRecoveryResourceId());
            mappingInformation.setResourceType(Integer.valueOf(resType));
            mappingInfos.add(mappingInformation);
        }
    }

    private int getResourceType(ResourceMapping rm) {
        logger.debug((Object)"getResourceType start");
        int resType = rm.getResourceType() == ResTypeEnum.CLUSTER_RESOURCE.getResType() ? 2 : 3;
        return resType;
    }

    private String getRecoveryFMId(String providerSN, String recoveryVPCId, List<ResourceMapping> resourceMappings) {
        logger.info((Object)("To getRecoveryFMId providerSN is " + providerSN + " recoveryVPCId is " + recoveryVPCId), 90160758786816L);
        for (ResourceMapping rm : resourceMappings) {
            if (!rm.getProductResourceProviderId().equals(providerSN) || !rm.getRecoveryVpcId().equals(recoveryVPCId)) continue;
            return rm.getRecoveryResourceProviderId();
        }
        return "";
    }

    private RecoveryMappingInformation configRecoveryVMMapping(ProtectObject po, String productResourceId, String recoveryResourceId, String recoveryProviderSN, int resourceType) {
        logger.debug((Object)"configRecoveryVMMapping start");
        RecoveryMappingInformation vmMappingInfo = new RecoveryMappingInformation();
        vmMappingInfo.setProductionInfo(po.getProviderSN(), po.getName(), productResourceId);
        vmMappingInfo.setRecoveryInfo(recoveryProviderSN, po.getName(), recoveryResourceId);
        vmMappingInfo.setResourceType(Integer.valueOf(resourceType));
        return vmMappingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(HttpServletResponse response, ByteArrayInputStream exportExcelStream) {
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.addHeader("Content-Disposition", "attachment;filename=" + this.getExportExcelName());
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(exportExcelStream);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[bis.available()];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)("downloadFile" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            }
            catch (Throwable throwable) {
                ExportResMappingBs.close(bis, bos, exportExcelStream);
                throw throwable;
            }
            ExportResMappingBs.close(bis, bos, exportExcelStream);
        }
        ExportResMappingBs.close(bis, bos, exportExcelStream);
    }

    private String getExportExcelName() {
        logger.debug((Object)"getExportExcelName start");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return "ExportRecoveryInformation_" + df.format(new Date()) + ".csv";
    }

    private static void close(BufferedInputStream bis, BufferedOutputStream bos, ByteArrayInputStream exportExcelStream) {
        if (null != exportExcelStream) {
            try {
                exportExcelStream.close();
            }
            catch (IOException e) {
                logger.error((Object)("downloadFile." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            }
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                logger.error((Object)("downloadFile." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            }
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                logger.error((Object)("downloadFile." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            }
        }
    }
}

