/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drp;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.sdk.service.IGalaxVMInfoService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.rest.fusionsphere.drp.GalaxVMRecoveryProxy;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecoveryInformationManager {
    private RecoveryPlan currentRecoveryPlan;
    private Map<String, String> vmProductUrnMap = new HashMap<String, String>();
    private Map<String, String> vmProductIdMap = new HashMap<String, String>();
    private Map<String, String> vmProductLocationMap = new HashMap<String, String>();
    private Map<String, String> vmRecoveryUrnMap = new HashMap<String, String>();
    private Map<String, String> vmRecoveryIdMap = new HashMap<String, String>();
    private Map<String, String> vmRecoveryLocationMap = new HashMap<String, String>();
    private Map<String, String> vmProductVPCMap = new HashMap<String, String>();
    private Map<String, String> vmRecoveryVPCMap = new HashMap<String, String>();
    private Map<String, String> vmProductGlobalIdMap = new HashMap<String, String>();
    private Map<String, String> vmRecoveryGlobalIdMap = new HashMap<String, String>();

    public RecoveryInformationManager(RecoveryPlan plan, IGalaxVMInfoService vmInfoService) {
        GalaxVMRecoveryProxy vmRecoveryProxy = new GalaxVMRecoveryProxy(plan);
        if (null != vmInfoService) {
            List<ProtectObject> poList = vmRecoveryProxy.getPos();
            this.vmProductUrnMap = vmInfoService.getVmProductionUrnMap(poList);
            this.vmProductIdMap = vmInfoService.getVmProductionIdMap(poList);
            this.vmProductLocationMap = vmInfoService.getVmProductionLocationMap(poList);
            this.vmRecoveryUrnMap = vmInfoService.getVmRecoveryUrnMap(poList);
            this.vmRecoveryIdMap = vmInfoService.getVmRecoveryIdMap(poList);
            String productSiteId = null;
            String recoverySiteId = null;
            if (!VerifyUtil.isEmpty((Map)plan.getGlobalSettings())) {
                productSiteId = null == plan.getGlobalSettings().get("PRODUCT_SITE_ID") ? null : (String)plan.getGlobalSettings().get("PRODUCT_SITE_ID");
                recoverySiteId = null == plan.getGlobalSettings().get("SELECT_DISASTER_SITE_KEY") ? null : (String)plan.getGlobalSettings().get("SELECT_DISASTER_SITE_KEY");
            }
            this.vmRecoveryLocationMap = vmInfoService.getVmRecoveryLocationMap(poList, productSiteId, recoverySiteId);
            this.vmProductVPCMap = vmInfoService.getVmProductVPCMap(poList);
            this.vmRecoveryVPCMap = vmInfoService.getVmRecoveryVPCMap(poList);
            this.vmProductGlobalIdMap = vmInfoService.getVmProductGlobalIdMap(poList);
            this.vmRecoveryGlobalIdMap = vmInfoService.getVmRecoveryGlobalIdMap(poList);
        }
    }

    public RecoveryPlan getCurrentRecoveryPlan() {
        return this.currentRecoveryPlan;
    }

    public void setCurrentRecoveryPlan(RecoveryPlan currentRecoveryPlan) {
        this.currentRecoveryPlan = currentRecoveryPlan;
    }

    public Map<String, String> getVmProductUrnMap() {
        return this.vmProductUrnMap;
    }

    public void setVmProductUrnMap(Map<String, String> vmProductUrnMap) {
        this.vmProductUrnMap = vmProductUrnMap;
    }

    public Map<String, String> getVmProductIdMap() {
        return this.vmProductIdMap;
    }

    public void setVmProductIdMap(Map<String, String> vmProductIdMap) {
        this.vmProductIdMap = vmProductIdMap;
    }

    public Map<String, String> getVmProductLocationMap() {
        return this.vmProductLocationMap;
    }

    public void setVmProductLocationMap(Map<String, String> vmProductLocationMap) {
        this.vmProductLocationMap = vmProductLocationMap;
    }

    public Map<String, String> getVmRecoveryUrnMap() {
        return this.vmRecoveryUrnMap;
    }

    public void setVmRecoveryUrnMap(Map<String, String> vmRecoveryUrnMap) {
        this.vmRecoveryUrnMap = vmRecoveryUrnMap;
    }

    public Map<String, String> getVmRecoveryIdMap() {
        return this.vmRecoveryIdMap;
    }

    public void setVmRecoveryIdMap(Map<String, String> vmRecoveryIdMap) {
        this.vmRecoveryIdMap = vmRecoveryIdMap;
    }

    public Map<String, String> getVmRecoveryLocationMap() {
        return this.vmRecoveryLocationMap;
    }

    public void setVmRecoveryLocationMap(Map<String, String> vmRecoveryLocationMap) {
        this.vmRecoveryLocationMap = vmRecoveryLocationMap;
    }

    public Map<String, String> getVmProductVPCMap() {
        return this.vmProductVPCMap;
    }

    public void setVmProductVPCMap(Map<String, String> vmProductVPCMap) {
        this.vmProductVPCMap = vmProductVPCMap;
    }

    public Map<String, String> getVmRecoveryVPCMap() {
        return this.vmRecoveryVPCMap;
    }

    public void setVmRecoveryVPCMap(Map<String, String> vmRecoveryVPCMap) {
        this.vmRecoveryVPCMap = vmRecoveryVPCMap;
    }

    public Map<String, String> getVmProductGlobalIdMap() {
        return this.vmProductGlobalIdMap;
    }

    public void setVmProductGlobalIdMap(Map<String, String> vmProductGlobalIdMap) {
        this.vmProductGlobalIdMap = vmProductGlobalIdMap;
    }

    public Map<String, String> getVmRecoveryGlobalIdMap() {
        return this.vmRecoveryGlobalIdMap;
    }

    public void setVmRecoveryGlobalIdMap(Map<String, String> vmRecoveryGlobalIdMap) {
        this.vmRecoveryGlobalIdMap = vmRecoveryGlobalIdMap;
    }

    public String getVmProductUrn(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmProductUrnMap().get(poId);
    }

    public String getVmProductId(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmProductIdMap().get(poId);
    }

    public String getVmProductLocation(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmProductLocationMap().get(poId);
    }

    public String getVmRecoveryUrn(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmRecoveryUrnMap().get(poId);
    }

    public String getVmRecoveryId(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmRecoveryIdMap().get(poId);
    }

    public String getVmRecoveryLocation(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmRecoveryLocationMap().get(poId);
    }

    public String getVmProductVPC(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmProductVPCMap().get(poId);
    }

    public String getVmRecoveryVPC(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmRecoveryVPCMap().get(poId);
    }

    public String getVmProductGlobalIdMap(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmProductGlobalIdMap().get(poId);
    }

    public String getVmRecoveryGlobalIdMap(String poId) {
        if (null == poId || poId.isEmpty()) {
            return "";
        }
        return this.getVmRecoveryGlobalIdMap().get(poId);
    }
}

