/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drp;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.sdk.model.NicInfoEntity;
import com.huawei.ism.drm.galax.sdk.model.TestNetwork;
import com.huawei.ism.drm.galax.sdk.service.IHostRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.service.IStorageRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmNicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.IpAddress6;
import com.huawei.ism.drm.galax.sdk.vrm.model.NicSpecification;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.drp.GalaxVMRecoveryProxy;
import com.huawei.ism.drm.rest.fusionsphere.drp.ReCoveryPlanUtil;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.IdNameValueVo;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.IpV6BaseVO;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.NicInfoVO;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.SetNicInfoParam;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.SetNicInfoParamFromExcel;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.ism.drm.web.service.logging.LoggingService;
import com.huawei.ism.drm.web.service.session.SessionService;
import com.huawei.ism.drm.web.service.tunnel.BundleService;
import com.huawei.ism.drm.web.util.StringUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class RecoveryPlanBs
extends AbsVRRestService
implements ApplicationContextAware {
    private static Log logger = LogFactory.getInstance(RecoveryPlanBs.class);
    private static final int NET_MASK_LEN = 8;
    private static final int IP_LENGTH = 4;
    private static final int NUM_223 = 223;
    private static final int NUM_3 = 3;
    private static final String NEED_CONFIG_IP = "Y";
    private static RecoveryPlanBs instance = new RecoveryPlanBs();
    private ApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        RecoveryPlanBs.getInstance().setBundleService((BundleService)this.applicationContext.getBean(BundleService.class));
        RecoveryPlanBs.getInstance().setSessionService((SessionService)this.applicationContext.getBean(SessionService.class));
        RecoveryPlanBs.getInstance().setLoggingService((LoggingService)this.applicationContext.getBean(LoggingService.class));
    }

    public static RecoveryPlanBs getInstance() {
        return instance;
    }

    public JSONObject getAllTestnetworks(String planId, String recoverySiteId, Long userId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"parameter planId is empty", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
        RecoveryPlan rp = rpServices.getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)rp)) {
            logger.error((Object)("this recovery plan is not exist, planId=" + planId), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"planId", (Object)planId);
        jsonObject.put((Object)"planName", (Object)rp.getName());
        jsonObject.put((Object)"recSiteName", (Object)this.getRecoverySiteByRecoveryPlan(rp));
        String rpType = this.getReplicationType(rp);
        jsonObject.put((Object)"replicationType", (Object)rpType);
        jsonObject.put((Object)"testNetworkList", (Object)ReCoveryPlanUtil.parseTestNetwork(this.queryTestNetwork(planId, recoverySiteId, rpType, userId)));
        return jsonObject;
    }

    public JSONArray getAvailableTestNetwork(String planId, String recoverySiteId, String recNetworkUrn, Long userId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)recNetworkUrn)) {
            logger.error((Object)"queryAvailableTestNetwork error, planId or recNetworkSn is empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
        RecoveryPlan rp = rpServices.getRecoveryPlan(planId);
        String replicationType = this.getReplicationType(rp);
        if (VerifyUtil.isEmpty((String)replicationType)) {
            logger.error((Object)("can not find the replication type, planId=" + planId), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        List<TestNetwork> testNetworks = this.setTestNetworkListByQueryAvailTestNetwork(recNetworkUrn, planId, recoverySiteId, replicationType, userId);
        return ReCoveryPlanUtil.parseTestNetwork(testNetworks);
    }

    public JSONArray queryNetworkCards(String planId, String poId) {
        List nicInfo;
        IStorageRecoveryPlanService galaxRecoveryPlanServices;
        ArrayList<IdNameValueVo> list = new ArrayList<IdNameValueVo>();
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId)) {
            logger.error((Object)"Failed to query network card info, planId or poId is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
        RecoveryPlan rp = rpServices.getRecoveryPlan(planId);
        String replicationType = this.getReplicationType(rp);
        if (replicationType.equals("StorageArray")) {
            galaxRecoveryPlanServices = (IStorageRecoveryPlanService)this.getBundleService("DRM_FusionShpere_SRA", IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
            nicInfo = galaxRecoveryPlanServices.getNicList(planId, poId);
        } else {
            galaxRecoveryPlanServices = (IHostRecoveryPlanService)this.getBundleService("DRM_FusionShpere_HRA", IHostRecoveryPlanService.class.getName(), IHostRecoveryPlanService.class);
            nicInfo = galaxRecoveryPlanServices.getNicList(planId, poId);
        }
        for (int i = 0; i < nicInfo.size(); ++i) {
            int seqNum = ((NicInfoEntity)nicInfo.get(i)).getSequenceNum();
            IdNameValueVo obj = new IdNameValueVo();
            obj.setId((long)seqNum);
            obj.setName(((NicInfoEntity)nicInfo.get(i)).getName());
            list.add(obj);
        }
        return ReCoveryPlanUtil.parseNicBases(list);
    }

    public JSONObject queryNetworkCardInfo(String nicSeqNum, String poId, String planId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId) || VerifyUtil.isEmpty((String)nicSeqNum)) {
            logger.error((Object)"Failed to query network card info, planId or poId or nicSeqNum is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
        RecoveryPlan rp = rpServices.getRecoveryPlan(planId);
        String replicationType = this.getReplicationType(rp);
        NicSpecification queryNicInfo = null;
        try {
            IStorageRecoveryPlanService galaxRecoveryPlanServices;
            int queryCardSeqNumber = Integer.parseInt(nicSeqNum);
            if (replicationType.equals("StorageArray")) {
                galaxRecoveryPlanServices = (IStorageRecoveryPlanService)this.getBundleService("DRM_FusionShpere_SRA", IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
                queryNicInfo = galaxRecoveryPlanServices.getRecoveryPlanNicInfoById(planId, poId, Integer.valueOf(queryCardSeqNumber));
            } else {
                galaxRecoveryPlanServices = (IHostRecoveryPlanService)this.getBundleService("DRM_FusionShpere_HRA", IHostRecoveryPlanService.class.getName(), IHostRecoveryPlanService.class);
                queryNicInfo = galaxRecoveryPlanServices.getRecoveryPlanNicInfoById(planId, poId, Integer.valueOf(queryCardSeqNumber));
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Cannot translate queryCardSeqNum to a Integer. ", (long)1073947393L, null, (Log)logger);
        }
        if (queryNicInfo instanceof FmNicSpecification) {
            logger.info((Object)"queryNicInfo is instance of FmNicSpecification. ", 90160758786816L);
            FmNicSpecification queryFmNicInfo = (FmNicSpecification)queryNicInfo;
            logger.info((Object)("The flex ip is: " + queryFmNicInfo.getFlexIpMap()), 90160758786816L);
            return ReCoveryPlanUtil.parseNicDetail((NicSpecification)queryFmNicInfo);
        }
        return ReCoveryPlanUtil.parseNicDetail(queryNicInfo);
    }

    public List<SetNicInfoParamFromExcel> checkNicInfoVOAndSave(List<SetNicInfoParamFromExcel> setNicInfoParamCheckList) {
        ArrayList<SetNicInfoParam> setNicInfoParamList = new ArrayList<SetNicInfoParam>();
        ArrayList<SetNicInfoParamFromExcel> errorNicInfoParamFromExcel = new ArrayList<SetNicInfoParamFromExcel>();
        ArrayList<SetNicInfoParamFromExcel> disableIPSetList = new ArrayList<SetNicInfoParamFromExcel>();
        for (SetNicInfoParamFromExcel setNicInfoParamFromExcel : setNicInfoParamCheckList) {
            NicInfoVO nicInfoVO = setNicInfoParamFromExcel.getNicInfoVO();
            this.ipv4NicInfoCheck(setNicInfoParamFromExcel, nicInfoVO);
            this.ipv6NicInfoCheck(setNicInfoParamFromExcel, nicInfoVO);
            if (setNicInfoParamList != null && setNicInfoParamList.size() >= 1) {
                this.checkDefaultGateway(setNicInfoParamList, setNicInfoParamFromExcel, nicInfoVO);
            }
            setNicInfoParamList.add((SetNicInfoParam)setNicInfoParamFromExcel);
        }
        this.disableIPSet(disableIPSetList);
        this.saveSetNicInfoParamList(setNicInfoParamList);
        return errorNicInfoParamFromExcel;
    }

    private void checkDefaultGateway(List<SetNicInfoParam> setNicInfoParamList, SetNicInfoParamFromExcel setNicInfoParamFromExcel, NicInfoVO nicInfoVO) {
        for (int i = 0; i < setNicInfoParamList.size(); ++i) {
            if (!setNicInfoParamFromExcel.getPoId().equals(setNicInfoParamList.get(i).getPoId())) continue;
            NicInfoVO nicTemp = setNicInfoParamList.get(i).getNicInfoVO();
            if (!VerifyUtil.isEmpty((String)nicInfoVO.getGateway()) || !VerifyUtil.isEmpty((String)nicTemp.getGateway())) {
                this.ipv4GatewayCheck(nicInfoVO, nicTemp);
            }
            if (VerifyUtil.isEmpty((String)nicInfoVO.getGatewayIpAddr6()) && VerifyUtil.isEmpty((String)nicTemp.getGatewayIpAddr6())) continue;
            this.ipv6GatewayCheck(nicInfoVO, nicTemp);
        }
    }

    private void ipv4GatewayCheck(NicInfoVO nicInfoVO, NicInfoVO nicTemp) {
        if (!(VerifyUtil.isEmpty((String)nicInfoVO.getGateway()) || VerifyUtil.isEmpty((String)nicTemp.getGateway()) || nicInfoVO.getGateway().equals(nicTemp.getGateway()))) {
            throw new LegoCheckedException(1073947393L, "the same protect group just only use one ipv4 gateWay!");
        }
        if (VerifyUtil.isEmpty((String)nicInfoVO.getGateway())) {
            nicInfoVO.setGateway(nicTemp.getGateway());
        } else {
            nicTemp.setGateway(nicInfoVO.getGateway());
        }
    }

    private void ipv6GatewayCheck(NicInfoVO nicInfoVO, NicInfoVO nicTemp) {
        if (!(VerifyUtil.isEmpty((String)nicInfoVO.getGatewayIpAddr6()) || VerifyUtil.isEmpty((String)nicTemp.getGatewayIpAddr6()) || nicInfoVO.getGatewayIpAddr6().equals(nicTemp.getGatewayIpAddr6()))) {
            throw new LegoCheckedException(1073947393L, "the same protect group just only use one ipv6 gateWay!");
        }
        if (VerifyUtil.isEmpty((String)nicInfoVO.getGatewayIpAddr6())) {
            nicInfoVO.setGatewayIpAddr6(nicTemp.getGatewayIpAddr6());
        } else {
            nicTemp.setGatewayIpAddr6(nicInfoVO.getGatewayIpAddr6());
        }
    }

    private void ipv4NicInfoCheck(SetNicInfoParamFromExcel setNicInfoParamFromExcel, NicInfoVO nicInfoVO) {
        String ipv4IsConfigIP = setNicInfoParamFromExcel.getIsConfigIP();
        if (!NEED_CONFIG_IP.equals(ipv4IsConfigIP)) {
            this.setV4BlankNicInfoVO(nicInfoVO);
            return;
        }
        String ipv4ipAddress = nicInfoVO.getIp();
        String ipv4subnetMask = nicInfoVO.getNetmask();
        String ipv4defaultGateway = nicInfoVO.getGateway();
        String ipv4prefDNSServerIPAddress = nicInfoVO.getSetdns();
        String ipv4altDNSServerIPAddress = nicInfoVO.getAdddns();
        if (VerifyUtil.isEmpty((String)ipv4ipAddress) || !StringUtil.isIpValid((String)ipv4ipAddress)) {
            logger.error((Object)"IPV4 address is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV4 address is not valid!");
        }
        if (VerifyUtil.isEmpty((String)ipv4subnetMask) || !RecoveryPlanBs.validateNetMask(ipv4subnetMask)) {
            logger.error((Object)"IPV4 address subnetMask is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV4 address subnetMask is not valid!");
        }
        if (!this.isBlankIPGwAndDnsInfo(ipv4defaultGateway) && !this.isValidIPv4GwAndDnsInfo(ipv4defaultGateway)) {
            logger.error((Object)"IPV4 defaultGateway is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV4 defaultGateway is not valid!");
        }
        if (!this.isBlankIPGwAndDnsInfo(ipv4prefDNSServerIPAddress) && !this.isValidIPv4GwAndDnsInfo(ipv4prefDNSServerIPAddress)) {
            logger.error((Object)"IPV4 prefDNS Server IP Address is not valid!");
            throw new LegoCheckedException(1073947393L, "IIPV4 prefDNS Server IP Address is not valid!");
        }
        if (!this.isBlankIPGwAndDnsInfo(ipv4altDNSServerIPAddress) && !this.isValidIPv4GwAndDnsInfo(ipv4altDNSServerIPAddress)) {
            logger.error((Object)"IPV4 altDNS Server IP Address is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV4 altDNS Server IP Address is not valid!");
        }
    }

    private void ipv6NicInfoCheck(SetNicInfoParamFromExcel setNicInfoParamFromExcel, NicInfoVO nicInfoVO) {
        String ipv6IsConfigIP = setNicInfoParamFromExcel.getIsConfigIPV6();
        if (!NEED_CONFIG_IP.equals(ipv6IsConfigIP)) {
            this.setV6BlankNicInfoVO(nicInfoVO);
            return;
        }
        List ipv6AddressList = nicInfoVO.getIpAddress6();
        if (null == ipv6AddressList) {
            logger.error((Object)"ipv6AddressList is null, please check! ");
            throw new LegoCheckedException(1073947393L, "ipv6AddressList is null, please check! ");
        }
        String ipv6Address = ((IpV6BaseVO)ipv6AddressList.get(0)).getIpv6Addr();
        String ipv6SubNetPrefix = ((IpV6BaseVO)ipv6AddressList.get(0)).getIpv6Prefix();
        String gatewayIpAddr6 = nicInfoVO.getGatewayIpAddr6();
        String setdns6 = nicInfoVO.getSetdns6();
        String adddns6 = nicInfoVO.getAdddns6();
        if (!StringUtil.isValidSubnetprefix((String)ipv6SubNetPrefix)) {
            logger.error((Object)"IPV6 SubNetPrefix is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV6 SubNetPrefix is not valid!");
        }
        if (!AddressUtil.ipType((String)ipv6Address).equals("IPV6")) {
            logger.error((Object)"the ipv6 you set isn't not okay, we need ipv6 address, not ipv4! please check again!");
            throw new LegoCheckedException(1073947393L, "the ipv6 you set isn't not okay, we need ipv6 address, not ipv4! please check again!");
        }
        if (VerifyUtil.isEmpty((String)ipv6Address) || !this.isValidIPv6GwAndDnsInfo(ipv6Address)) {
            logger.error((Object)"IPV6 address is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV6 address is not valid!");
        }
        if (!this.isBlankIPGwAndDnsInfo(gatewayIpAddr6) && !this.isValidIPv6GwAndDnsInfo(gatewayIpAddr6)) {
            logger.error((Object)"IPV6 gateway ip address is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV6 gateway ip address is not valid!");
        }
        if (!this.isBlankIPGwAndDnsInfo(setdns6) && !this.isValidIPv6GwAndDnsInfo(setdns6)) {
            logger.error((Object)"IPV6 set dns is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV6 set dns is not valid!");
        }
        if (!this.isBlankIPGwAndDnsInfo(adddns6) && !this.isValidIPv6GwAndDnsInfo(adddns6)) {
            logger.error((Object)"IPV6 add dns is not valid!");
            throw new LegoCheckedException(1073947393L, "IPV6 add dns is not valid!");
        }
    }

    private void setV4BlankNicInfoVO(NicInfoVO nicInfoVO) {
        nicInfoVO.setIp(null);
        nicInfoVO.setNetmask(null);
        nicInfoVO.setGateway(null);
        nicInfoVO.setSetdns(null);
        nicInfoVO.setAdddns(null);
    }

    private void setV6BlankNicInfoVO(NicInfoVO nicInfoVO) {
        nicInfoVO.setIpAddress6(null);
        nicInfoVO.setGatewayIpAddr6(null);
        nicInfoVO.setSetdns6(null);
        nicInfoVO.setAdddns6(null);
    }

    public void checkRecoveryPlanWhenIpsSet1(RecoveryPlan rp) {
        if (VerifyUtil.isEmpty((Object)rp)) {
            logger.error((Object)"rp is null.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in recovery plan is empty, planId=" + rp.getPlanId()));
            throw new LegoCheckedException(1073947393L);
        }
        String providerSN = pg.getPoProviderSN();
        DrmEnumDefine.RecoveryPlanStatusE status = DrmEnumDefine.RecoveryPlanStatusE.getType((int)rp.getPlanStatus());
        if (null == status) {
            logger.error((Object)("plan's status(" + rp.getPlanStatus() + ") is invalid."), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)status, (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING);
        if (VerifyUtil.isEmpty((String)providerSN)) {
            logger.error((Object)"The providerSN is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isDrVrm = providerSN.startsWith("Dr_Vrm_");
        if (!isDrVrm) {
            logger.error((Object)"not FC VM!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void saveSetNicInfoParamList(List<SetNicInfoParam> setNicInfoParamList) {
        if (VerifyUtil.isEmpty(setNicInfoParamList)) {
            logger.debug((Object)"no setNicInfoParamList to save!");
            return;
        }
        for (SetNicInfoParam setNicInfoParam : setNicInfoParamList) {
            try {
                this.saveNetworkCardInfo(setNicInfoParam);
            }
            catch (RuntimeException e) {
                logger.error((Object)("save this network error: vmid:" + setNicInfoParam.getPoId()));
            }
        }
    }

    private void disableIPSet(List<SetNicInfoParamFromExcel> disableIPSetList) {
        if (VerifyUtil.isEmpty(disableIPSetList)) {
            logger.debug((Object)"no setNicInfoParamList to save!");
            return;
        }
        for (SetNicInfoParam setNicInfoParam : disableIPSetList) {
            try {
                setNicInfoParam.getNicInfoVO().setIp(null);
                setNicInfoParam.getNicInfoVO().setNetmask(null);
                setNicInfoParam.getNicInfoVO().setGateway(null);
                setNicInfoParam.getNicInfoVO().setSetdns(null);
                setNicInfoParam.getNicInfoVO().setAdddns(null);
                setNicInfoParam.getNicInfoVO().setIpAddress6(null);
                setNicInfoParam.getNicInfoVO().setSetdns6(null);
                setNicInfoParam.getNicInfoVO().setAdddns6(null);
                this.saveNetworkCardInfo(setNicInfoParam);
            }
            catch (RuntimeException e) {
                logger.error((Object)("disable this network IP error: vmid:" + setNicInfoParam.getPoId()));
            }
        }
    }

    private boolean isBlankIPGwAndDnsInfo(String ipdefaultGateway) {
        return VerifyUtil.isEmpty((String)ipdefaultGateway);
    }

    private boolean isValidIPv4GwAndDnsInfo(String ipv4defaultGateway) {
        if (StringUtil.isIpValid((String)ipv4defaultGateway)) {
            String[] ips = ipv4defaultGateway.split("\\.");
            if (ips.length != 4) {
                return false;
            }
            int fristElementOfIP = Integer.parseInt(ips[0]);
            int lastElementOfIP = Integer.parseInt(ips[3]);
            if (fristElementOfIP > 223 || fristElementOfIP < 1) {
                return false;
            }
            return lastElementOfIP != 0;
        }
        return false;
    }

    private boolean isValidIPv6GwAndDnsInfo(String ipInfo) {
        if (!"IPV6".equals(AddressUtil.ipType((String)ipInfo))) {
            logger.error((Object)"the ipv6 getway or DNS you set isn't not okay, please check again!");
            return false;
        }
        return Ipv6AddressUtil.isValidIPv6((String)ipInfo);
    }

    public void checkNetworkCardInfoInExcel(SetNicInfoParam nicParam) {
        if (VerifyUtil.isEmpty((Object)nicParam) || VerifyUtil.isEmpty((String)nicParam.getPlanId())) {
            logger.error((Object)"Save network card info error, planId is invalid. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
        RecoveryPlan rp = rpServices.getRecoveryPlan(nicParam.getPlanId());
        this.checkRecoveryPlanWhenIpsSet(rp);
        String replicationType = this.getReplicationType(rp);
        if (VerifyUtil.isEmpty((String)replicationType)) {
            logger.error((Object)"The providerSN is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!StringUtil.isStrNumberValid((String)nicParam.getNicSeqNum())) {
            logger.error((Object)"checkRequestedInfo error, params are empty or invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        int sequenceNum = -1;
        if (!StringUtil.isStrNumberValid((String)nicParam.getNicSeqNum())) {
            logger.error((Object)"checkRequestedInfo error, params are empty or invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            sequenceNum = Integer.parseInt(nicParam.getNicSeqNum());
        }
        catch (RuntimeException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Cannot translate queryCardSeqNum to a Integer. ", (long)1073947393L, null, (Log)logger);
        }
        this.checkSequenceNum(sequenceNum, replicationType, nicParam);
    }

    public void checkRecoveryPlanWhenIpsSet(RecoveryPlan rp) {
        if (VerifyUtil.isEmpty((Object)rp)) {
            logger.error((Object)"save networkcard info error, rp is null.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in recovery plan is empty, planId=" + rp.getPlanId()));
            throw new LegoCheckedException(1073947393L);
        }
        String providerSN = pg.getPoProviderSN();
        DrmEnumDefine.RecoveryPlanStatusE status = DrmEnumDefine.RecoveryPlanStatusE.getType((int)rp.getPlanStatus());
        if (null == status) {
            logger.error((Object)("Save network card info error, plan's status(" + rp.getPlanStatus() + ") is invalid."), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)status, (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING);
        if (VerifyUtil.isEmpty((String)providerSN)) {
            logger.error((Object)"The providerSN is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isDrVrm = providerSN.startsWith("Dr_Vrm_");
        if (!isDrVrm) {
            logger.error((Object)"not FC VM!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void saveNetworkCardInfo(SetNicInfoParam nicParam) {
        if (VerifyUtil.isEmpty((Object)nicParam) || VerifyUtil.isEmpty((String)nicParam.getPlanId())) {
            logger.error((Object)"Save network card info error, planId is invalid. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
        RecoveryPlan rp = rpServices.getRecoveryPlan(nicParam.getPlanId());
        if (VerifyUtil.isEmpty((Object)rp)) {
            logger.error((Object)"save networkcard info error, rp is null.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        String replicationType = this.getReplicationType(rp);
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg in recovery plan is empty, planId=" + rp.getPlanId()));
            throw new LegoCheckedException(1073947393L);
        }
        String providerSN = pg.getPoProviderSN();
        DrmEnumDefine.RecoveryPlanStatusE status = DrmEnumDefine.RecoveryPlanStatusE.getType((int)rp.getPlanStatus());
        if (null == status) {
            logger.error((Object)("Save network card info error, plan's status(" + rp.getPlanStatus() + ") is invalid."), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)status, (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING);
        if (VerifyUtil.isEmpty((String)providerSN) || VerifyUtil.isEmpty((String)replicationType)) {
            logger.error((Object)"The providerSN is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isDrVrm = providerSN.startsWith("Dr_Vrm_");
        this.checkRequestedInfo(isDrVrm, nicParam, replicationType);
        FmNicSpecification saveRpNicInfo = this.getRequestedRpNicInfo(isDrVrm, nicParam);
        if (isDrVrm) {
            this.saveVRMNetworkCardInfo(saveRpNicInfo, replicationType, nicParam);
        } else {
            this.saveFMNetworkCardInfo(saveRpNicInfo, replicationType, nicParam);
        }
    }

    public JSONObject checkElasticIpValid(String elasticIp, String poId, String planId, String recoverySiteId) {
        IStorageRecoveryPlanService galaxRecoveryPlanServices;
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)elasticIp) || VerifyUtil.isEmpty((String)poId) || VerifyUtil.isEmpty((String)recoverySiteId)) {
            logger.error((Object)"checkFlexIpAvailability error, params are empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
        RecoveryPlan rp = rpServices.getRecoveryPlan(planId);
        int result = 0;
        String replicationType = this.getReplicationType(rp);
        if (replicationType.equals("StorageArray")) {
            galaxRecoveryPlanServices = (IStorageRecoveryPlanService)this.getBundleService("DRM_FusionShpere_SRA", IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
            result = galaxRecoveryPlanServices.queryEIpInfoFromFm(planId, poId, recoverySiteId, elasticIp);
        } else {
            galaxRecoveryPlanServices = (IHostRecoveryPlanService)this.getBundleService("DRM_FusionShpere_HRA", IHostRecoveryPlanService.class.getName(), IHostRecoveryPlanService.class);
            result = galaxRecoveryPlanServices.queryEIpInfoFromFm(planId, poId, recoverySiteId, elasticIp);
        }
        JSONObject object = new JSONObject();
        object.put((Object)"result", (Object)result);
        return object;
    }

    private IRecoveryPlanBaseService getRecoveryPlanService() {
        logger.debug((Object)"getRecoveryPlanService start");
        return (IRecoveryPlanBaseService)this.getBundleService(IRecoveryPlanBaseService.class.getName(), IRecoveryPlanBaseService.class);
    }

    private ISiteBaseService getSiteService() {
        logger.debug((Object)"getSiteService start");
        ISiteBaseService siteService = (ISiteBaseService)this.getBundleService("DRM_Base", ISiteBaseService.class.getName(), ISiteBaseService.class);
        return siteService;
    }

    private void checkRequestedInfo(boolean isDrVrm, SetNicInfoParam nicParam, String replicationType) {
        int sequenceNum = -1;
        if (!StringUtil.isStrNumberValid((String)nicParam.getNicSeqNum())) {
            logger.error((Object)"checkRequestedInfo error, params are empty or invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            sequenceNum = Integer.parseInt(nicParam.getNicSeqNum());
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Cannot translate queryCardSeqNum to a Integer. ", (long)1073947393L, null, (Log)logger);
        }
        NicInfoVO nicInfoVO = nicParam.getNicInfoVO();
        this.checkSequenceNum(sequenceNum, replicationType, nicParam);
        if (!VerifyUtil.isEmpty((String)nicInfoVO.getIp())) {
            this.checkIPv4AddressInfo(isDrVrm, nicInfoVO);
        }
        if (nicInfoVO.getIpAddress6() != null && ((IpV6BaseVO)nicInfoVO.getIpAddress6().get(0)).getIpv6Addr() != null && !((IpV6BaseVO)nicInfoVO.getIpAddress6().get(0)).getIpv6Addr().equals("")) {
            this.checkIPv6AddressInfo(isDrVrm, nicInfoVO);
        }
        if (!isDrVrm) {
            this.checkFlexIpAdvancedParams(nicInfoVO);
        }
    }

    private FmNicSpecification getRequestedRpNicInfo(boolean isDrVrm, SetNicInfoParam nicParam) {
        logger.debug((Object)"getRequestedRpNicInfo start");
        FmNicSpecification tmpRpNicInfo = new FmNicSpecification();
        int sequenceNum = -1;
        boolean useIPv4Bool = false;
        boolean useIPv6Bool = false;
        String nicId = nicParam.getNicSeqNum();
        try {
            sequenceNum = Integer.parseInt(nicId);
            useIPv4Bool = !VerifyUtil.isEmpty((String)nicParam.getNicInfoVO().getIp());
            useIPv6Bool = !VerifyUtil.isEmpty((Collection)nicParam.getNicInfoVO().getIpAddress6());
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Cannot translate queryCardSeqNum to a Integer. ", (long)1073947393L, null, (Log)logger);
        }
        tmpRpNicInfo.setSequenceNum(Integer.valueOf(sequenceNum));
        this.setIPv4InfoToNicInfoObject(tmpRpNicInfo, nicParam.getNicInfoVO());
        this.setIPv6InfoToNicInfoObject(tmpRpNicInfo, isDrVrm, nicParam.getNicInfoVO());
        if (useIPv6Bool && useIPv4Bool) {
            tmpRpNicInfo.setIpVersion("8");
        }
        if (!isDrVrm) {
            this.setFlexIpAndNatInfoToNicInfoObject(tmpRpNicInfo, nicParam.getNicInfoVO());
        }
        return tmpRpNicInfo;
    }

    private void setIPv4InfoToNicInfoObject(FmNicSpecification tmpRpNicInfo, NicInfoVO nicInfoVO) {
        String ipv4defaultGatewayTmp;
        logger.debug((Object)"setIPv4InfoToNicInfoObject start");
        String ipv4ipAddress = nicInfoVO.getIp();
        String ipv4subnetMask = nicInfoVO.getNetmask();
        String ipv4defaultGateway = nicInfoVO.getGateway();
        String ipv4prefDNSServerIPAddress = nicInfoVO.getSetdns();
        String ipv4altDNSServerIPAddress = nicInfoVO.getAdddns();
        String ipv4PrefDnsTmp = VerifyUtil.isEmpty((String)ipv4prefDNSServerIPAddress) ? null : ipv4prefDNSServerIPAddress;
        String ipv4AltDnsTmp = VerifyUtil.isEmpty((String)ipv4altDNSServerIPAddress) ? null : ipv4altDNSServerIPAddress;
        String ipv4IpAddressTmp = VerifyUtil.isEmpty((String)ipv4ipAddress) ? null : ipv4ipAddress;
        String ipv4subnetMaskTmp = VerifyUtil.isEmpty((String)ipv4subnetMask) ? null : ipv4subnetMask;
        String string = ipv4defaultGatewayTmp = VerifyUtil.isEmpty((String)ipv4defaultGateway) ? null : ipv4defaultGateway;
        if (!VerifyUtil.isEmpty((String)ipv4ipAddress)) {
            tmpRpNicInfo.setIpVersion("4");
            tmpRpNicInfo.setIp(ipv4IpAddressTmp);
            tmpRpNicInfo.setNetmask(ipv4subnetMaskTmp);
            tmpRpNicInfo.setGateway(ipv4defaultGatewayTmp);
            tmpRpNicInfo.setSetdns(ipv4PrefDnsTmp);
            tmpRpNicInfo.setAdddns(ipv4AltDnsTmp);
        }
    }

    private void setIPv6InfoToNicInfoObject(FmNicSpecification tmpRpNicInfo, boolean isDrVrm, NicInfoVO nicInfoVO) {
        logger.debug((Object)"setIPv6InfoToNicInfoObject start");
        List ipV6BaseVOs = nicInfoVO.getIpAddress6();
        String ipv6defaultGateway = nicInfoVO.getGatewayIpAddr6();
        String ipv6prefDNSIPAddress = nicInfoVO.getSetdns6();
        String ipv6altDNSIPAddress = nicInfoVO.getAdddns6();
        if (VerifyUtil.isEmpty((Collection)ipV6BaseVOs)) {
            return;
        }
        tmpRpNicInfo.setIpVersion("6");
        ArrayList<IpAddress6> ipAddress6List = new ArrayList<IpAddress6>();
        int len = ipV6BaseVOs.size() > 5 ? 5 : ipV6BaseVOs.size();
        for (int i = 0; i < len; ++i) {
            IpAddress6 tmpIPv6Address = new IpAddress6();
            tmpIPv6Address.setIpv6Addr(((IpV6BaseVO)ipV6BaseVOs.get(i)).getIpv6Addr());
            tmpIPv6Address.setIpv6Prefix(isDrVrm ? ((IpV6BaseVO)ipV6BaseVOs.get(i)).getIpv6Prefix() : null);
            ipAddress6List.add(tmpIPv6Address);
        }
        String ipv6defaultGatewayTmp = VerifyUtil.isEmpty((String)ipv6defaultGateway) ? null : ipv6defaultGateway;
        tmpRpNicInfo.setIpAddress6(ipAddress6List);
        tmpRpNicInfo.setGatewayIpAddr6(ipv6defaultGatewayTmp);
        String ipv6PrefDnsTmp = VerifyUtil.isEmpty((String)ipv6prefDNSIPAddress) ? null : ipv6prefDNSIPAddress;
        String ipv6AltDnsTmp = VerifyUtil.isEmpty((String)ipv6altDNSIPAddress) ? null : ipv6altDNSIPAddress;
        tmpRpNicInfo.setAdddns6(ipv6AltDnsTmp);
        tmpRpNicInfo.setSetdns6(ipv6PrefDnsTmp);
    }

    private void setFlexIpAndNatInfoToNicInfoObject(FmNicSpecification tmpRpNicInfo, NicInfoVO nicInfoVO) {
        logger.debug((Object)"setFlexIpAndNatInfoToNicInfoObject start");
        Map flexIpMap = nicInfoVO.getFlexIpMap();
        String advancePrivatePort = nicInfoVO.getPrivatePort();
        String advancePublicPort = nicInfoVO.getPublicPort();
        String advancePortocal = nicInfoVO.getProtocal();
        if (!VerifyUtil.isEmpty((Map)flexIpMap)) {
            tmpRpNicInfo.setFlexIpMap(flexIpMap);
        }
        if (!VerifyUtil.isEmpty((String)advancePrivatePort)) {
            tmpRpNicInfo.setPrivatePort(advancePrivatePort);
            tmpRpNicInfo.setPublicPort(advancePublicPort);
            tmpRpNicInfo.setProtocal(advancePortocal);
        }
    }

    private void checkSequenceNum(int nicId, String replicationType, SetNicInfoParam nicParam) {
        IStorageRecoveryPlanService galaxRecoveryPlanServices;
        if (nicId < 0 || nicId > 15) {
            logger.error((Object)"nicId is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        String planId = nicParam.getPlanId();
        String poId = nicParam.getPoId();
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId)) {
            logger.error((Object)"planId or poId is null or empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        List nicInfoList = null;
        if ("StorageArray".equals(replicationType)) {
            galaxRecoveryPlanServices = (IStorageRecoveryPlanService)this.getBundleService("DRM_FusionShpere_SRA", IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
            nicInfoList = galaxRecoveryPlanServices.getNicList(planId, poId);
        } else {
            galaxRecoveryPlanServices = (IHostRecoveryPlanService)this.getBundleService("DRM_FusionShpere_HRA", IHostRecoveryPlanService.class.getName(), IHostRecoveryPlanService.class);
            nicInfoList = galaxRecoveryPlanServices.getNicList(planId, poId);
        }
        if (VerifyUtil.isEmpty((Collection)nicInfoList)) {
            logger.error((Object)"query nicInfoList failed.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        for (NicInfoEntity e : nicInfoList) {
            if (nicId != e.getSequenceNum()) continue;
            return;
        }
        logger.error((Object)"nicId is not in PO.", 90160758787071L);
        throw new LegoCheckedException(1073947394L);
    }

    private void checkIPv4AddressInfo(boolean isDrVrm, NicInfoVO nicInfoVO) {
        logger.debug((Object)"checkIPv4AddressInfo start");
        String ipv4ipAddress = nicInfoVO.getIp();
        String ipv4subnetMask = nicInfoVO.getNetmask();
        String ipv4defaultGateway = nicInfoVO.getGateway();
        String ipv4prefDNSServerIPAddress = nicInfoVO.getSetdns();
        String ipv4altDNSServerIPAddress = nicInfoVO.getAdddns();
        this.checkIPv4StaticInfo(ipv4ipAddress, ipv4subnetMask, isDrVrm);
        this.checkIPv4GwAndDnsInfo(ipv4defaultGateway, ipv4prefDNSServerIPAddress, ipv4altDNSServerIPAddress);
    }

    private void checkIPv4StaticInfo(String ipv4ipAddress, String ipv4subnetMask, boolean isDrVrm) {
        if (VerifyUtil.isEmpty((String)ipv4ipAddress) || isDrVrm && VerifyUtil.isEmpty((String)ipv4subnetMask)) {
            logger.error((Object)"IPv4 address or subnet mask is empty while type is static ip.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!StringUtil.isIpValid((String)ipv4ipAddress) || isDrVrm && !RecoveryPlanBs.validateNetMask(ipv4subnetMask)) {
            logger.error((Object)"IPv4 address or subnet mask is not valid", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkIPv4GwAndDnsInfo(String ipv4defaultGateway, String ipv4prefDNSServerIPAddress, String ipv4altDNSServerIPAddress) {
        boolean isIPv4AltDNSValid;
        boolean isIPv4DefaultGatewayValid = VerifyUtil.isEmpty((String)ipv4defaultGateway) || StringUtil.isIpValid((String)ipv4defaultGateway);
        boolean isIPv4PrefDNSValid = VerifyUtil.isEmpty((String)ipv4prefDNSServerIPAddress) || StringUtil.isIpValid((String)ipv4prefDNSServerIPAddress);
        boolean bl = isIPv4AltDNSValid = VerifyUtil.isEmpty((String)ipv4altDNSServerIPAddress) || StringUtil.isIpValid((String)ipv4altDNSServerIPAddress);
        if (!(isIPv4DefaultGatewayValid && isIPv4PrefDNSValid && isIPv4AltDNSValid)) {
            logger.error((Object)"IPv4 gateway or dns info error.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkIPv6AddressInfo(boolean isDrVrm, NicInfoVO nicInfoVO) {
        logger.debug((Object)"checkIPv6AddressInfo start");
        List ipV6BaseVOs = nicInfoVO.getIpAddress6();
        String ipv6defaultGateway = nicInfoVO.getGatewayIpAddr6();
        String ipv6prefDNSIPAddress = nicInfoVO.getSetdns6();
        String ipv6altDNSIPAddress = nicInfoVO.getAdddns6();
        this.checkIPv6StaticInfo(ipV6BaseVOs, isDrVrm);
        this.checkIPv6GwAndDnsInfo(ipv6defaultGateway, ipv6prefDNSIPAddress, ipv6altDNSIPAddress);
    }

    private void checkIPv6GwAndDnsInfo(String ipv6defaultGateway, String ipv6prefDNSIPAddress, String ipv6altDNSIPAddress) {
        boolean isIPv6AltDnsValid;
        boolean isIPv6GwValid = VerifyUtil.isEmpty((String)ipv6defaultGateway) || StringUtil.isIPv6Valid((String)ipv6defaultGateway);
        boolean isIPv6PrefDnsValid = VerifyUtil.isEmpty((String)ipv6prefDNSIPAddress) || StringUtil.isIPv6Valid((String)ipv6prefDNSIPAddress);
        boolean bl = isIPv6AltDnsValid = VerifyUtil.isEmpty((String)ipv6altDNSIPAddress) || StringUtil.isIPv6Valid((String)ipv6altDNSIPAddress);
        if (!(isIPv6GwValid && isIPv6PrefDnsValid && isIPv6AltDnsValid)) {
            logger.error((Object)"ipv6 gateway or dns info is error", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkFlexIpAdvancedParams(NicInfoVO nicInfoVO) {
        boolean isuseFlexIpBool = false;
        boolean isuseNATBool = false;
        Map flexIpMap = nicInfoVO.getFlexIpMap();
        String advancePrivatePort = nicInfoVO.getPrivatePort();
        String advancePublicPort = nicInfoVO.getPublicPort();
        String advancePortocal = nicInfoVO.getProtocal();
        try {
            isuseFlexIpBool = !VerifyUtil.isEmpty((Map)flexIpMap);
            isuseNATBool = !VerifyUtil.isEmpty((String)advancePrivatePort);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Cannot translate FlexIpAdvancedParams when checked. ", (long)1073947393L, null, (Log)logger);
        }
        if (isuseFlexIpBool && isuseNATBool) {
            logger.error((Object)"EIP and DNat can not be set at the same time.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (isuseFlexIpBool && !this.isFlexIpValid(flexIpMap)) {
            logger.error((Object)"flex IP params error. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!(!isuseNATBool || StringUtil.isPortRangeValid((String)advancePrivatePort) && StringUtil.isPortRangeValid((String)advancePublicPort) && this.isProtocalNameValid(advancePortocal))) {
            logger.error((Object)"NAT params error. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean isFlexIpValid(Map<String, String> flexIpMap) {
        for (String flexIp : flexIpMap.values()) {
            if (StringUtil.isIpValid((String)flexIp)) continue;
            return false;
        }
        return true;
    }

    private void saveVRMNetworkCardInfo(FmNicSpecification saveRpNicInfo, String replicationType, SetNicInfoParam nicParam) {
        String planId = nicParam.getPlanId();
        String poId = nicParam.getPoId();
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId)) {
            logger.error((Object)"saveVRMNetworkCardInfo error, planId or poId are empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (replicationType.equals("StorageArray")) {
            IStorageRecoveryPlanService galaxRecoveryPlanServices = (IStorageRecoveryPlanService)this.getBundleService("DRM_FusionShpere_SRA", IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
            galaxRecoveryPlanServices.modifyRecoveryPlanNicInfo(planId, poId, (NicSpecification)saveRpNicInfo);
        } else {
            IHostRecoveryPlanService galaxRecoveryPlanServices = (IHostRecoveryPlanService)this.getBundleService("DRM_FusionShpere_HRA", IHostRecoveryPlanService.class.getName(), IHostRecoveryPlanService.class);
            galaxRecoveryPlanServices.modifyRecoveryPlanNicInfo(planId, poId, (NicSpecification)saveRpNicInfo);
        }
    }

    private void saveFMNetworkCardInfo(FmNicSpecification saveRpNicInfo, String replicationType, SetNicInfoParam nicParam) {
        logger.debug((Object)"saveFMNetworkCardInfo start");
        if (replicationType.equals("StorageArray")) {
            this.saveFMNetworkInfoByStorageService(saveRpNicInfo, nicParam);
        } else {
            this.saveFMNetworkInfoByHostService(saveRpNicInfo, nicParam);
        }
    }

    private void saveFMNetworkInfoByStorageService(FmNicSpecification saveRpNicInfo, SetNicInfoParam nicParam) {
        String planId = nicParam.getPlanId();
        String poId = nicParam.getPoId();
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId)) {
            logger.error((Object)"saveFMNetworkInfoByStorageService error, params are empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IStorageRecoveryPlanService storageRecoveryPlanService = (IStorageRecoveryPlanService)this.getBundleService("DRM_FusionShpere_SRA", IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
        Map flexIpMap = nicParam.getNicInfoVO().getFlexIpMap();
        if (!VerifyUtil.isEmpty((Map)flexIpMap)) {
            for (Map.Entry entry : flexIpMap.entrySet()) {
                String recoverySiteId = (String)entry.getKey();
                String flexIp = (String)entry.getValue();
                logger.info((Object)("The recoverySiteId=" + recoverySiteId + ";flexIPAddr is:" + flexIp), 90160758786816L);
                int result = storageRecoveryPlanService.queryEIpInfoFromFm(planId, poId, recoverySiteId, flexIp);
                logger.info((Object)("query flex IP result is:" + result), 90160758786816L);
                if (result == 0) continue;
                logger.error((Object)("elastic ip is invalid: " + result), 90160758787071L);
                throw new LegoCheckedException(1073948865L);
            }
        } else {
            logger.info((Object)"The flexIPAddr is empty, so directly save nicInfo", 90160758786816L);
        }
        storageRecoveryPlanService.modifyRecoveryPlanNicInfo(planId, poId, (NicSpecification)saveRpNicInfo);
    }

    private void saveFMNetworkInfoByHostService(FmNicSpecification saveRpNicInfo, SetNicInfoParam nicParam) {
        String planId = nicParam.getPlanId();
        String poId = nicParam.getPoId();
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId)) {
            logger.error((Object)"saveFMNetworkInfoByHostService error, params are empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        Map flexIpMap = nicParam.getNicInfoVO().getFlexIpMap();
        IHostRecoveryPlanService hostRecoveryPlanService = (IHostRecoveryPlanService)this.getBundleService("DRM_FusionShpere_HRA", IHostRecoveryPlanService.class.getName(), IHostRecoveryPlanService.class);
        if (!VerifyUtil.isEmpty((Map)flexIpMap)) {
            for (Map.Entry entry : flexIpMap.entrySet()) {
                String recoverySiteId = (String)entry.getKey();
                String flexIp = (String)entry.getValue();
                logger.info((Object)("The recoverySiteId=" + recoverySiteId + ";flexIPAddr is:" + flexIp), 90160758786816L);
                int result = hostRecoveryPlanService.queryEIpInfoFromFm(planId, poId, recoverySiteId, flexIp);
                logger.info((Object)("query flex IP result is:" + result), 90160758786816L);
                if (result == 0) continue;
                logger.error((Object)("elastic ip is invalid: " + result), 90160758787071L);
                throw new LegoCheckedException(1073948865L);
            }
        } else {
            logger.info((Object)"The flexIPAddr is empty, so directly save nicInfo", 90160758786816L);
        }
        hostRecoveryPlanService.modifyRecoveryPlanNicInfo(planId, poId, (NicSpecification)saveRpNicInfo);
    }

    private boolean isProtocalNameValid(String advancePortocal) {
        return !VerifyUtil.isEmpty((String)advancePortocal) && (advancePortocal.equals("TCP") || advancePortocal.equals("UDP"));
    }

    private void checkIPv6StaticInfo(List<IpV6BaseVO> ipV6BaseVOs, boolean isDrVrm) {
        if (VerifyUtil.isEmpty(ipV6BaseVOs)) {
            logger.error((Object)"ipv6ipAddress or ipv6Prefix are error", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        int len = ipV6BaseVOs.size() > 5 ? 5 : ipV6BaseVOs.size();
        for (int i = 0; i < len; ++i) {
            if (StringUtil.isIPv6Valid((String)ipV6BaseVOs.get(i).getIpv6Addr()) && (!isDrVrm || StringUtil.isIPv6PrefixValid((String)ipV6BaseVOs.get(i).getIpv6Prefix()))) continue;
            logger.error((Object)("ipv6 address or prefix error, when checking ipv6 info. ipv6 address is:" + ipV6BaseVOs.get(i)), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private String getRecoverySiteByRecoveryPlan(RecoveryPlan rp) {
        logger.debug((Object)"getRecoverySiteByRecoveryPlan start");
        GalaxVMRecoveryProxy vmRecoveryProxy = new GalaxVMRecoveryProxy(rp);
        Site recoverySite = this.getSiteService().getSiteById(vmRecoveryProxy.getRecoverySiteId());
        if (VerifyUtil.isEmpty((Object)recoverySite)) {
            throw new LegoCheckedException(1073947394L);
        }
        return recoverySite.getName();
    }

    private String getReplicationType(RecoveryPlan rp) {
        GalaxVMRecoveryProxy vmRecoveryProxy = new GalaxVMRecoveryProxy(rp);
        return vmRecoveryProxy.getProtectReplicationType();
    }

    private List<TestNetwork> queryTestNetwork(String planId, String recoverySiteId, String replicationType, Long userId) {
        if (VerifyUtil.isEmpty((String)replicationType)) {
            logger.error((Object)"The replicationType is empty", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        return this.setTestNetworkList(planId, recoverySiteId, replicationType, userId);
    }

    private List<TestNetwork> setTestNetworkList(String planId, String recoverySiteId, String replicationType, Long userId) {
        logger.debug((Object)"setTestNetworkList start");
        List testNetworkList = null;
        if (replicationType.equals("StorageArray")) {
            IStorageRecoveryPlanService galaxRecoveryPlanServices = (IStorageRecoveryPlanService)this.getBundleService("DRM_FusionShpere_SRA", IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
            testNetworkList = galaxRecoveryPlanServices.queryTestNetwork(planId, recoverySiteId, userId.longValue());
        } else {
            IHostRecoveryPlanService galaxRecoveryPlanServices = (IHostRecoveryPlanService)this.getBundleService("DRM_FusionShpere_HRA", IHostRecoveryPlanService.class.getName(), IHostRecoveryPlanService.class);
            testNetworkList = galaxRecoveryPlanServices.queryTestNetwork(planId, recoverySiteId, userId.longValue());
        }
        return testNetworkList;
    }

    private List<TestNetwork> setTestNetworkListByQueryAvailTestNetwork(String drUrn, String planId, String recoverySiteId, String replicationType, Long userId) {
        logger.debug((Object)"setTestNetworkListByQueryAvailTestNetwork start");
        List testNetworkList = null;
        if (replicationType.equals("StorageArray")) {
            IStorageRecoveryPlanService galaxRecoveryPlanServices = (IStorageRecoveryPlanService)this.getBundleService("DRM_FusionShpere_SRA", IStorageRecoveryPlanService.class.getName(), IStorageRecoveryPlanService.class);
            testNetworkList = galaxRecoveryPlanServices.queryAvaiablePortGroup(drUrn, planId, recoverySiteId, true, userId.longValue());
        } else {
            IHostRecoveryPlanService galaxRecoveryPlanServices = (IHostRecoveryPlanService)this.getBundleService("DRM_FusionShpere_HRA", IHostRecoveryPlanService.class.getName(), IHostRecoveryPlanService.class);
            testNetworkList = galaxRecoveryPlanServices.queryAvaiablePortGroup(drUrn, planId, recoverySiteId, false, userId.longValue());
        }
        return testNetworkList;
    }

    private static boolean validateNetMask(String mask) {
        logger.debug((Object)"validateNetMask start");
        if (RecoveryPlanBs.regNetMask(mask)) {
            String[] masks = mask.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (String one : masks) {
                String binaryStr = Integer.toBinaryString(NumberUtil.getIntValue((Integer)NumberUtil.convertToInteger((Object)one)));
                int times = 8 - binaryStr.length();
                for (int idx = 0; idx < times; ++idx) {
                    sb.append("0");
                }
                sb.append(binaryStr);
            }
            int index0 = sb.indexOf("0");
            int validate = sb.indexOf("1", index0);
            return validate <= 0;
        }
        return false;
    }

    private static boolean regNetMask(String str) {
        logger.debug((Object)"regNetMask start");
        if (null == str || str.trim().length() <= 0) {
            return false;
        }
        String reg = "^(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[0-9]{1,2})(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[0-9]{1,2})){3}$";
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        return Pattern.compile(reg).matcher(str).matches();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

