/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drsmapping.service;

import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IDrsMappingService;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.drsmapping.service.IDrsMappingSynRestService;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DrsMappingSynRestServiceImpl
extends AbsVRRestService
implements IDrsMappingSynRestService {
    private static final Log LOGGER = LogFactory.getInstance(DrsMappingSynRestServiceImpl.class);
    private static final String DRM_GALAX_MANAGER = "DRM_FusionShpere_Base";
    private static final String LOG_OBJECT_NAME = "resourceMapping_objectName";

    @Override
    public void synAddDrsMapping(RestJsonRequest request) {
        this.checkUserOperationAuthority("resource_createResourceMapping_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            List resMap = (List)request.toObject();
            this.checkDrsAuthority(resMap);
            this.getDrsMappingService().synAddDrsMapping(resMap);
            LOGGER.info((Object)"Succeed to synchronize add drsMappings.");
            for (DrsMapping drsMapping : resMap) {
                ResourceMapping resourceMapping = drsMapping.getResourceMapping();
                this.writeSucOperationLog("resource_create_drsMapping_operateName", 1, LOG_OBJECT_NAME, "resource_createDrsMapping_operateDetail", new String[]{drsMapping.getProductGroupName(), drsMapping.getRecoveryGroupName(), resourceMapping.getProductResourceName(), resourceMapping.getProductSiteName(), resourceMapping.getProductResourceProviderName(), resourceMapping.getRecoveryResourceName(), resourceMapping.getRecoverySiteName(), resourceMapping.getRecoveryResourceProviderName()});
            }
        }
        catch (Exception ex) {
            String msg = String.format(Locale.ROOT, "Method synAddDrsMapping error,msg is %s.", ExceptionUtil.getErrorMessage((Throwable)ex));
            this.handlingExceptionLog(ex, "resource_create_drsMapping_operateName", msg, LOG_OBJECT_NAME, LOGGER);
        }
    }

    @Override
    public void synUpdateDrsMapping(RestJsonRequest request) {
        this.checkUserOperationAuthority("resource_modifyResourceMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            Object object = request.toObject();
            if (!(object instanceof DrsMapping)) {
                LOGGER.error((Object)"Data object is not DrsMapping type.");
                throw new LegoCheckedException(1073947393L);
            }
            DrsMapping drsMapping = (DrsMapping)request.toObject();
            if (VerifyUtil.isEmpty((Object)drsMapping) || VerifyUtil.isEmpty((Object)drsMapping.getResourceMapping())) {
                LOGGER.error((Object)"Data drsMapping is invalidation,drsMappingId is %s.", new Object[]{drsMapping.getMappingId()});
                throw new LegoCheckedException(2117645L);
            }
            this.checkResourceMappingAuthority(drsMapping.getResourceMapping());
            DrsMapping oldDrsMapping = this.getDrsMappingService().getResourceMappingById(drsMapping.getMappingId());
            String productGroupName = drsMapping.getProductGroupName();
            String oldRecoveryGroupName = oldDrsMapping.getRecoveryGroupName();
            String newRecoveryGroupName = drsMapping.getRecoveryGroupName();
            this.getDrsMappingService().synUpdateDrsMapping(drsMapping);
            LOGGER.info((Object)"Succeed to synchronize update drsMapping.");
            ResourceMapping resourceMapping = drsMapping.getResourceMapping();
            this.writeSucOperationLog("resource_modify_drsMapping_operateName", 1, LOG_OBJECT_NAME, "resource_modifyDrsMapping_operateDetail", new String[]{productGroupName, oldRecoveryGroupName, newRecoveryGroupName, resourceMapping.getProductResourceName(), resourceMapping.getProductSiteName(), resourceMapping.getProductResourceProviderName(), resourceMapping.getRecoveryResourceName(), resourceMapping.getRecoverySiteName(), resourceMapping.getRecoveryResourceProviderName()});
        }
        catch (Exception ex) {
            String msg = String.format(Locale.ROOT, "Method synUpdateDrsMapping error,msg is %s.", ExceptionUtil.getErrorMessage((Throwable)ex));
            this.handlingExceptionLog(ex, "resource_modify_drsMapping_operateName", msg, LOG_OBJECT_NAME, LOGGER);
        }
    }

    @Override
    public void synDeleteDrsMapping(String drsMappingId) {
        this.checkUserOperationAuthority("resource_deleteResourceMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{drsMappingId});
            IDrsMappingService drsService = this.getDrsMappingService();
            DrsMapping delDrsMapping = drsService.getResourceMappingById(drsMappingId);
            if (VerifyUtil.isEmpty((Object)delDrsMapping)) {
                LOGGER.error((Object)"Method deleteDrsMapping drsMapping is null.");
                throw new LegoCheckedException(1073947394L);
            }
            ResourceMapping oldResMap = delDrsMapping.getResourceMapping();
            this.checkResourceMappingAuthority(oldResMap);
            drsService.synDeleteDrsMapping(drsMappingId, oldResMap);
            LOGGER.info((Object)"Succeed to synchronize delete drsMapping.");
            this.writeSucOperationLog("resource_delete_drsMapping_operateName", 1, LOG_OBJECT_NAME, "resource_deleteDrsMapping_operateDetail", new String[]{delDrsMapping.getProductGroupName(), delDrsMapping.getRecoveryGroupName(), oldResMap.getProductResourceName(), oldResMap.getProductSiteName(), oldResMap.getProductResourceProviderName(), oldResMap.getRecoveryResourceName(), oldResMap.getRecoverySiteName(), oldResMap.getRecoveryResourceProviderName()});
        }
        catch (Exception ex) {
            String msg = String.format(Locale.ROOT, "Method synDeleteDrsMapping error,msg is %s.", ExceptionUtil.getErrorMessage((Throwable)ex));
            this.handlingExceptionLog(ex, "resource_delete_drsMapping_operateName", msg, LOG_OBJECT_NAME, LOGGER);
        }
    }

    @Override
    public String synGetVmsOfGroup(List<DrsMapping> drsMappings, String siteId) {
        this.checkUserOperationAuthority("resource_createResourceMapping_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{drsMappings});
            this.checkDrsAuthority(drsMappings);
            Map map = this.getDrsMappingService().synGetVmsOfGroup(drsMappings, siteId);
            LOGGER.info((Object)"Succeed get synGetVmsOfGroup info.");
            return JSONObject.fromObject((Object)map).toString();
        }
        catch (Exception ex) {
            String msg = String.format(Locale.ROOT, "Method synGetVmsOfGroup error,msg is %s.", ExceptionUtil.getErrorMessage((Throwable)ex));
            this.handlingExceptionNoLog(ex, msg, LOGGER);
            return new JSONObject().toString();
        }
    }

    private void checkDrsAuthority(List<DrsMapping> resMap) {
        if (VerifyUtil.isEmpty(resMap)) {
            LOGGER.error((Object)"Data resMap is null");
            throw new LegoCheckedException(2117645L);
        }
        for (DrsMapping drsMapping : resMap) {
            if (VerifyUtil.isEmpty((Object)drsMapping.getResourceMapping())) {
                LOGGER.error((Object)"Data drsMapping is invalidation");
                throw new LegoCheckedException(2117645L);
            }
            this.checkResourceMappingAuthority(drsMapping.getResourceMapping());
        }
    }

    private IDrsMappingService getDrsMappingService() {
        return (IDrsMappingService)this.getBundleService(DRM_GALAX_MANAGER, IDrsMappingService.class.getName());
    }
}

