/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.host.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmDrBootOptionEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmDrOperationEnum;
import com.huawei.ism.drm.galax.sdk.pg.host.service.IBHRPgController;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.host.service.ExePORequest;
import com.huawei.ism.drm.rest.fusionsphere.host.service.IHostPolicyTemplateRestService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.beanutils.BeanUtils;

public class HostPTRestServiceImpl
extends AbsVRRestService
implements IHostPolicyTemplateRestService {
    protected static final String TYPE_PARAM_KEY = "{type}";
    private static Log logger = LogFactory.getInstance(HostPTRestServiceImpl.class);
    private static final int FIFTY_NINE = 59;
    private static final int TWENTY_THREE = 23;
    private static final int TEN_THOUSAND = 10000;
    private final List<Integer> manulAutoSplit = Arrays.asList(1, 0);
    private final List<Integer> periodTypeList = Arrays.asList(0, 1, 2, 3, 4);

    @Override
    public BatchOperationResult exeProtectAction(ExePORequest request) {
        this.checkUserOperationAuthority("protectedGroup_modify_operateName", 2, "ism.drm.12.protectgroup.auth.management");
        logger.info((Object)"into exeProtectAction.", 90160758786816L);
        if (VerifyUtil.isEmpty((Object)request)) {
            logger.error((Object)"paramter is null.", 90160758787071L);
            this.generateOptLog(new LegoCheckedException(1073947393L), request.getOpertionType(), null, null);
            throw new LegoCheckedException(1073947393L);
        }
        int opTypeInt = request.getOpertionType();
        int bootTypeInt = request.getBootType();
        String pgId = request.getPgId();
        String[] uuids = request.getMoUuid();
        ProtectGroup pg = null;
        try {
            pg = this.getProtectGroupById(pgId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Try to modify vm protection status, pg is not exit ", (Throwable)e, 90160758787071L);
            this.generateOptLog(e, opTypeInt, null, null);
            throw e;
        }
        try {
            this.checkUserAuthority(pgId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Try to modify vm protection status, not enough right ", (Throwable)e, 90160758787071L);
            this.generateOptLog(e, opTypeInt, pg.getName(), null);
            throw e;
        }
        try {
            this.checkIsAllpoInPg(pgId, uuids);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Try to modify vm protection status, caught Excepiton ", (Throwable)e, 90160758787071L);
            this.generateOptLog(e, opTypeInt, pg.getName(), null);
            throw e;
        }
        VmDrOperationEnum opEnum = VmDrOperationEnum.getVMDrOperation((int)opTypeInt);
        if (null == opEnum) {
            this.generateOptLog(new LegoCheckedException(1073947393L), opTypeInt, pg.getName(), null);
            throw new LegoCheckedException(1073947393L);
        }
        VmDrBootOptionEnum bootEnum = null;
        if (opTypeInt == VmDrOperationEnum.START_DR.getValue() && (bootEnum = VmDrBootOptionEnum.getVMDrBootOption((int)bootTypeInt)) == null) {
            this.generateOptLog(new LegoCheckedException(1073947393L), opTypeInt, pg.getName(), null);
            throw new LegoCheckedException(1073947393L);
        }
        BatchOperationResult result = this.protectObjectOperate(opTypeInt, uuids, bootTypeInt, opEnum, bootEnum, pg);
        logger.info((Object)"end exeProtectAction.", 90160758786816L);
        return result;
    }

    private ProtectGroup getProtectGroupById(String pgId) {
        logger.debug((Object)"getProtectGroupById start");
        IProtectGroupBaseService pgService = (IProtectGroupBaseService)this.getBundleService("DRM_Base", IProtectGroupBaseService.class.getName(), IProtectGroupBaseService.class);
        return pgService.getProtectGroupByID(pgId);
    }

    private void checkIsAllpoInPg(String pgId, String[] uuids) {
        logger.debug((Object)"checkIsAllpoInPg start");
        ProtectGroup pg = this.getProtectGroupById(pgId);
        if (VerifyUtil.isEmpty((Object)pg)) {
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList<String> allPouuidInPgList = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            allPouuidInPgList.add(po.getMoUuid());
        }
        for (int i = 0; i < uuids.length; ++i) {
            if (allPouuidInPgList.contains(uuids[i])) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    private BatchOperationResult protectObjectOperate(int opTypeInt, String[] uuids, Integer bootTypeInt, VmDrOperationEnum opEnum, VmDrBootOptionEnum bootEnum, ProtectGroup pg) {
        IBHRPgController pgController = this.getBHRPGService();
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        HashMap<String, Long> failResultMap = new HashMap<String, Long>();
        for (int i = 0; i < uuids.length; ++i) {
            BatchOperation batchOperation = new BatchOperation();
            String pgName = pg.getName();
            String poName = this.getPoName(pg, uuids[i]);
            if (opTypeInt == VmDrOperationEnum.START_DR.getValue()) {
                batchOperation.setDetailParam(new String[]{pgName, poName, this.getBootOptionName(bootTypeInt)});
                batchOperation.setOptDetail("protectionGroup.task.startdr.log.desc.label");
            } else {
                batchOperation.setDetailParam(new String[]{pgName, poName});
                batchOperation.setOptDetail("protectionGroup.task.pauseorresume.log.desc.label");
            }
            batchOperation.setTargetName(poName);
            resultList.add(batchOperation);
            try {
                pgController.modifyVmStatus(uuids[i], opEnum, bootEnum);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Try to modify vm protection status, caught LegoCheckedException ", (Throwable)e, 90160758787071L);
                batchOperation.setErrorCode(e.getErrorCode());
                failResultMap.put(uuids[i], e.getErrorCode());
            }
            catch (Exception e) {
                logger.error((Object)("Try to modify vm protection status, caught Excepiton " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                batchOperation.setErrorCode(-1L);
                failResultMap.put(uuids[i], -1L);
            }
            this.generateOptLog(null, opTypeInt, pgName, poName);
        }
        int operCount = uuids.length;
        result.setTotalCount(operCount);
        result.setFailCount(failResultMap.size());
        result.setSucceedCount(operCount - failResultMap.size());
        result.setResult(resultList);
        return result;
    }

    private IBHRPgController getBHRPGService() {
        logger.debug((Object)"getBHRPGService start");
        return (IBHRPgController)super.getBundleService("DRM_FusionShpere_HRA", IBHRPgController.class.getName(), IBHRPgController.class);
    }

    private String getPoName(ProtectGroup pg, String uuid) {
        logger.debug((Object)"getPoName start");
        Set poSet = pg.getPolist();
        for (ProtectObject po : poSet) {
            if (!po.getMoUuid().equals(uuid)) continue;
            return po.getName();
        }
        return "--";
    }

    private String getBootOptionName(int index) {
        return this.getBootOptionKey(index);
    }

    private String getBootOptionKey(int index) {
        logger.debug((Object)"getBootOptionKey start");
        String[] bootOptionKeyList = new String[]{"", "protectionGroup.task.startdr.option.drbegin.label", "", "", "protectionGroup.task.startdr.option.consistencycheck.label", "protectionGroup.task.startdr.option.diffsyn.label"};
        if (index >= 0 && index < bootOptionKeyList.length) {
            return bootOptionKeyList[index];
        }
        return "";
    }

    private void generateOptLog(LegoCheckedException ex, int opType, String pgName, String vmName) {
        logger.debug((Object)"generateOptLog start");
        String dbLine = "--";
        String tempPgName = pgName == null ? dbLine : pgName;
        String tempVmName = vmName == null ? dbLine : vmName;
        String[] logParams = new String[]{tempPgName, tempVmName};
        String optString = "protectedGroup_startProtectedObject_operateName";
        String detailStr = "ism.drm.pg.log.desc";
        if (opType == VmDrOperationEnum.START_DR.getValue()) {
            optString = "protectedGroup_startProtectedObject_operateName";
        } else if (opType == VmDrOperationEnum.PAUSE_DR.getValue()) {
            optString = "protectedGroup_pauseProtectedObject_operateName";
        } else if (opType == VmDrOperationEnum.RESUME_DR.getValue()) {
            optString = "protectedGroup_resumeProtectedObject_operateName";
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException(optString, 2, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog(optString, 2, vmName, detailStr, logParams);
        }
    }

    @Override
    public Response modifyHostTemplate(String protectgroupId, PolicyTemplate policyTemplate) {
        this.checkUserOperationAuthority("protectedGroup_modifyPolicy_operateName", 2, "ism.drm.protectgroup.auth.modify");
        String pgName = null;
        try {
            this.validateProtectGroupId(protectgroupId);
            ProtectGroup pg = this.getProtectGroupById(protectgroupId);
            if (!VerifyUtil.isEmpty((Object)pg)) {
                pgName = pg.getName();
                this.checkUserAuthority(protectgroupId);
            }
            this.validateProtectGroup(pg);
            this.validatePolicyTemplate(policyTemplate, pg);
            PolicyTemplate pt = this.checkModifyProtectGroupParam(policyTemplate, pg);
            int poType = pg.getPoType();
            String protectType = (String)pg.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
            if (12 == poType && ProtectTypeEnum.HOST_REPLICATION.getType().equals(protectType)) {
                IBHRPgController bhrPgController = (IBHRPgController)super.getBundleService("DRM_FusionShpere_HRA", IBHRPgController.class.getName(), IBHRPgController.class);
                pt.setProps(policyTemplate.getProps());
                bhrPgController.updatePolicyTemplate(protectgroupId, pt, this.getCurrentUser().getUserName());
            } else {
                ((IProtectGroupBaseService)this.getBundleService(IProtectGroupBaseService.class)).updateProtectGroupTemplate(protectgroupId, pt);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"modify host template catch lego failed.", (Throwable)e, 90160758787071L);
            this.generateModifyPTLog(pgName, e);
        }
        catch (Exception e) {
            logger.error((Object)("modify host template failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.generateModifyPTLog(pgName, new LegoCheckedException(-1L));
        }
        this.generateModifyPTLog(pgName, null);
        return Response.ok().build();
    }

    private void validateProtectGroupId(String pgId) {
        logger.debug((Object)"validateProtectGroupId start");
        if (VerifyUtil.isEmpty((String)pgId)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void validateProtectGroup(ProtectGroup protectgroup) {
        logger.debug((Object)"validateProtectGroup start");
        if (VerifyUtil.isEmpty((Object)protectgroup)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void validatePolicyTemplate(PolicyTemplate policyTemplate, ProtectGroup pg) {
        logger.debug((Object)"validatePolicyTemplate start");
        this.checkHostPtProps(policyTemplate, pg);
        this.checkSnapHostNumberStr(policyTemplate);
        ((IProtectGroupBaseService)this.getBundleService(IProtectGroupBaseService.class)).checkPolicyProps(pg.getPoType(), policyTemplate);
    }

    private void checkHostPtProps(PolicyTemplate policyTemplate, ProtectGroup pg) {
        String copyRateStr;
        String encryptionStr;
        if (policyTemplate.getType() != 11) {
            return;
        }
        Map props = policyTemplate.getProps();
        if (VerifyUtil.isEmpty((Map)props)) {
            throw new LegoCheckedException(1073947393L);
        }
        String compressionStr = (String)props.get("COMPRESSION");
        if (this.isPropsEmpty(compressionStr, encryptionStr = (String)props.get("ENTRYPTION"), copyRateStr = (String)props.get("COPYRATE"))) {
            throw new LegoCheckedException(1073947393L);
        }
        String cloudSn = pg.getPoProviderSN();
        NetworkEntity nEntity = (NetworkEntity)this.getMo(NetworkEntity.class, "sn", cloudSn);
        if (null == nEntity) {
            logger.error((Object)("cloud object is not exist, cloudSn=" + cloudSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        boolean copyRate = false;
        try {
            Integer recoverPointNum;
            Boolean.valueOf(compressionStr);
            Boolean.valueOf(encryptionStr);
            copyRate = Boolean.valueOf(copyRateStr);
            if (!"v5.0".equals(nEntity.getVersion()) && "FusionCompute".equalsIgnoreCase((String)pg.getProps().get("PROVIDER_TYPE")) && (VerifyUtil.isEmpty((Object)(recoverPointNum = Integer.valueOf((String)props.get("FS_Snap_Restore_Num")))) || recoverPointNum < 2 || recoverPointNum > 32)) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (NumberFormatException e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        this.checkCopyRate(props, copyRate);
    }

    private void checkCopyRate(Map<String, String> props, boolean copyRate) {
        logger.debug((Object)"checkCopyRate start");
        int copyRateValue = 0;
        if (copyRate) {
            try {
                String copyRateValueStr = props.get("COPYRATEVALUE");
                copyRateValue = Integer.parseInt(copyRateValueStr);
            }
            catch (NumberFormatException e) {
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
            if (copyRateValue < 1 || copyRateValue > 10000) {
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private boolean isPropsEmpty(String compressionStr, String encryptionStr, String copyRateStr) {
        return VerifyUtil.isEmpty((String)compressionStr) || VerifyUtil.isEmpty((String)encryptionStr) || VerifyUtil.isEmpty((String)copyRateStr);
    }

    private PolicyTemplate checkModifyProtectGroupParam(PolicyTemplate policyTemplate, ProtectGroup pg) {
        logger.debug((Object)"checkModifyProtectGroupParam start");
        if (VerifyUtil.isEmpty((Object)pg)) {
            throw new LegoCheckedException(1073947394L);
        }
        this.checkUserAuthority(pg.getUuid());
        PolicyTemplate pt = pg.getTemplate();
        if (VerifyUtil.isEmpty((Object)pt) || VerifyUtil.isEmpty((Collection)pt.getSchedules())) {
            throw new LegoCheckedException(1073947394L);
        }
        Set schedules = policyTemplate.getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            throw new LegoCheckedException(1073947393L);
        }
        for (Schedule newSch : schedules) {
            this.checkSchedule(pt, newSch);
        }
        return pt;
    }

    private void checkSchedule(PolicyTemplate pt, Schedule newSch) {
        logger.debug((Object)"checkSchedule start");
        Set schedules = pt.getSchedules();
        this.checkManulOrAuto(schedules, newSch);
    }

    private void checkManulOrAuto(Set<Schedule> scs, Schedule newSch) {
        logger.debug((Object)"checkManulOrAuto start");
        String scheduleId = newSch.getScheduleId();
        int newScheduleMode = newSch.getScheduleMode();
        this.checkScheduleId(scheduleId, newScheduleMode);
        Iterator<Schedule> scheduleIterator = scs.iterator();
        HashSet<Schedule> addSet = new HashSet<Schedule>();
        boolean isValidScheduleId = false;
        PolicyTemplate manualTemplate = null;
        while (scheduleIterator.hasNext()) {
            Schedule sc = scheduleIterator.next();
            if (!scheduleId.equals(sc.getScheduleId())) continue;
            if (sc.getProtectLocation() != newSch.getProtectLocation()) {
                throw new LegoCheckedException(1073947393L);
            }
            if (1 == newScheduleMode && 0 == sc.getScheduleMode()) {
                manualTemplate = sc.getPolicyTemplate();
                scheduleIterator.remove();
            } else if (0 == newScheduleMode && 1 == sc.getScheduleMode()) {
                this.checkScheduleDetail(newSch, sc);
                newSch.setScheduleId(UUIDGenerator.getUUID());
                addSet.add(newSch);
            } else {
                this.checkScheduleContent(newSch, sc);
            }
            isValidScheduleId = true;
            break;
        }
        if (scs.isEmpty()) {
            Schedule schedule = new Schedule();
            schedule.setScheduleId(UUIDGenerator.getUUID());
            schedule.setScheduleMode(1);
            schedule.setPolicyTemplate(manualTemplate);
            scs.add(schedule);
        }
        scs.addAll(addSet);
        if (!isValidScheduleId) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkScheduleContent(Schedule newSch, Schedule sc) {
        logger.debug((Object)"checkScheduleContent start");
        try {
            this.checkScheduleDetail(newSch, sc);
            BeanUtils.copyProperties((Object)sc, (Object)newSch);
        }
        catch (LegoCheckedException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)e.getMessage(), (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"Update schedule infos failed!", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    private void checkScheduleId(String scheduleId, int newScheduleMode) {
        logger.debug((Object)"checkScheduleId start");
        if (VerifyUtil.isEmpty((String)scheduleId) || !this.manulAutoSplit.contains(newScheduleMode)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkScheduleDetail(Schedule newSch, Schedule oldSch) {
        int scheduleModel = newSch.getScheduleMode();
        String beginTime = newSch.getStartTime();
        String endTime = newSch.getEndTime();
        Set scheduleRanges = newSch.getScheduleRanges();
        Set oldScheduleRanges = oldSch.getScheduleRanges();
        int periodType = newSch.getPeriodType();
        int periodInterval = newSch.getPeriodInterval();
        if (1 == scheduleModel) {
            newSch.setStartTime("");
            newSch.setEndTime("");
            return;
        }
        if (VerifyUtil.isEmpty((String)beginTime) || !this.periodTypeList.contains(periodType)) {
            throw new LegoCheckedException(1073947393L);
        }
        Date beginDate = CommUtils.parseDate((String)beginTime);
        if (null == beginDate) {
            throw new LegoCheckedException(1073947393L);
        }
        if (beginDate.before(new Date())) {
            throw new LegoCheckedException(1073948456L);
        }
        newSch.setStartTime(beginDate.getTime() + "");
        Date endDate = CommUtils.parseDate((String)endTime);
        if (null != endDate) {
            if (beginDate.after(endDate)) {
                throw new LegoCheckedException(1073948455L);
            }
            newSch.setEndTime(endDate.getTime() + "");
        }
        if (!VerifyUtil.isEmpty((Collection)scheduleRanges)) {
            for (ScheduleRangeTime rang : scheduleRanges) {
                long startDateLong = rang.getStartTime().getTime();
                long endDateLong = rang.getEndTime().getTime();
                if (endDateLong > startDateLong) continue;
                throw new LegoCheckedException(1073948455L);
            }
        }
        this.checkPeriodType(newSch, periodType, periodInterval);
        this.setScheduleRanges(newSch, scheduleRanges, oldScheduleRanges, periodType);
    }

    protected long string2Long(String beginTime) {
        logger.debug((Object)"string2Long start");
        try {
            return Long.parseLong(beginTime);
        }
        catch (NumberFormatException e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    private void checkSnapHostNumberStr(PolicyTemplate policyTemplate) {
        logger.debug((Object)"checkSnapHostNumberStr start");
        if (policyTemplate.getType() == 2) {
            Map props = policyTemplate.getProps();
            if (VerifyUtil.isEmpty((Map)props)) {
                throw new LegoCheckedException(1073947393L);
            }
            String snapHostNumberStr = (String)props.get("PP_SNAPSHOT_COUNT");
            if (VerifyUtil.isEmpty((String)snapHostNumberStr)) {
                throw new LegoCheckedException(1073947393L);
            }
            int value = 0;
            try {
                value = Integer.parseInt(snapHostNumberStr);
            }
            catch (NumberFormatException e) {
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
            if (value < 1 || value > 512) {
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    protected void setScheduleRanges(Schedule newSch, Set<ScheduleRangeTime> scheduleRanges, Set<ScheduleRangeTime> oldScheduleRanges, int periodType) {
        logger.debug((Object)"checkVisSnap start");
        if (!(periodType != 0 && periodType != 1 || VerifyUtil.isEmpty(scheduleRanges))) {
            ScheduleRangeTime scheduleRangeTime = scheduleRanges.iterator().next();
            if (!VerifyUtil.isEmpty(oldScheduleRanges)) {
                ScheduleRangeTime oldRangeTime = oldScheduleRanges.iterator().next();
                if (null != oldRangeTime) {
                    scheduleRangeTime.setScheduleRangeId(oldRangeTime.getScheduleRangeId());
                }
            } else {
                scheduleRangeTime.setScheduleRangeId(UUIDGenerator.getUUID());
            }
            scheduleRangeTime.setSchedule(newSch);
            HashSet<ScheduleRangeTime> srts = new HashSet<ScheduleRangeTime>();
            srts.add(scheduleRangeTime);
            newSch.setScheduleRanges(srts);
        } else {
            newSch.getScheduleRanges().clear();
        }
    }

    private void checkPeriodType(Schedule newSch, int periodType, int periodInterval) {
        logger.debug((Object)"checkPeriodType start");
        switch (periodType) {
            case 0: {
                this.checkParam(periodInterval, 5, 59);
                break;
            }
            case 1: {
                this.checkParam(periodInterval, 1, 23);
                break;
            }
            case 2: {
                this.checkParam(periodInterval, 1, 31);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (1 != newSch.getLastDayOfMonth()) break;
                newSch.setDaysOfMonth("L");
                break;
            }
            default: {
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private void checkParam(int value, int min, int maxVal) {
        logger.debug((Object)"checkParam start");
        if (value < min || value > maxVal) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void generateModifyPTLog(String tempPgName, LegoCheckedException e) {
        logger.debug((Object)"generateModifyPTLog start");
        String pgName = VerifyUtil.isEmpty((String)tempPgName) ? "--" : tempPgName;
        String[] logParams = new String[]{pgName};
        String optString = "protectedGroup_modifyPolicy_operateName";
        String detailStr = "ism.drm.pg.log.desc";
        if (null != e) {
            this.writeFailedOperationLog(optString, 2, tempPgName, (Exception)((Object)e));
        } else {
            this.writeSucOperationLog(optString, 2, tempPgName, detailStr, logParams);
        }
    }
}

