/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.host.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.pg.host.model.VmPropsBaseParam;
import com.huawei.ism.drm.galax.sdk.pg.host.service.IVmInfoMaintainService;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.host.service.IMaintainVmPropsRestService;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaintainVmPropsRestServiceImpl
extends AbsVRRestService
implements IMaintainVmPropsRestService {
    private static final String HOST_REPLICATION_BUNDLE_NAME = "DRM_FusionShpere_HRA";
    private static final String FS_SNAP_RESTORE_NUM = "FS_Snap_Restore_Num";
    private static final Log LOG = LogFactory.getInstance(MaintainVmPropsRestServiceImpl.class);

    @Override
    public void syncMaintainProps(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("site_resource_syncUpdateVRGVMInfo_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        String vmName = "";
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            Map params = (Map)request.toObject();
            IVmInfoMaintainService handler = this.getService();
            GalaxVM vm = this.getGalaxVMParam(params, "GalaxVM");
            vmName = vm.getName();
            GalaxVM phVm = this.getGalaxVMParam(params, "GalaxPhVM");
            String fmVmInfo = this.getVMInfoEParam(params, "fmVmInfo");
            String vrgSn = this.getVrgSn(params);
            String fmPhVmInfo = this.getVMInfoEParam(params, "fmPhVmInfo");
            VmPropsBaseParam baseParam = new VmPropsBaseParam();
            baseParam.setGalaxVm(vm);
            baseParam.setVmInfo(fmVmInfo);
            baseParam.setPhGalaxVm(phVm);
            baseParam.setPhVmInfo(fmPhVmInfo);
            handler.syncProcess(vrgSn, baseParam, true);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"syncMaintainProps error:", (Throwable)e, 90160758787071L);
            this.generateMainTainPropLog(vmName, e);
            throw e;
        }
        this.generateMainTainPropLog(vmName, null);
    }

    @Override
    public String getFcPhVmInfo(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
        Map params = (Map)request.toObject();
        String fcSn = this.getCloudSn(params);
        List<String> uuidList = this.getUuidList(params);
        IVmInfoMaintainService handler = this.getService();
        this.checkUserResourceAuthority(fcSn);
        String ret = handler.queryLocalPhVmExistStatus(fcSn, uuidList);
        return this.constructResponseData(ret);
    }

    private String getCloudSn(Map<String, Object> params) {
        Object obj = params.get("cloudSn");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        LOG.error((Object)"param CLOUD_SN is null or not instanceof String ", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private String getFmPhVmIdForPh(Map<String, Object> params) {
        Object objVmIds = params.get("phVmIds");
        if (objVmIds == null) {
            return "";
        }
        if (objVmIds instanceof String) {
            return (String)objVmIds;
        }
        LOG.error((Object)"param PH_VM_ID is not instanceof String ", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private String getVrgSn(Map<String, Object> params) {
        Object obj = params.get("vrgSn");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        LOG.error((Object)"param VRG_SN is null or not instanceof String ", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private String constructResponseData(String resultObj) {
        if (null == resultObj) {
            LOG.error((Object)"ConstructResponseData failed.", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        String messageObj = ReverseObjectSerializableUtils.serializableObj((Object)resultObj);
        JSONObject response = new JSONObject();
        response.put((Object)"type", (Object)resultObj.getClass().getName());
        response.put((Object)"message", (Object)messageObj);
        return response.toString();
    }

    private List<String> getUuidList(Map<String, Object> params) {
        Object obj = params.get("vmUuid");
        if (obj != null && obj instanceof List) {
            return (List)obj;
        }
        LOG.error((Object)"param VM_UUID is null or not instanceof List", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private Set<String> getUuidListForPh(Map<String, Object> params) {
        Object objUuids = params.get("vmUuids");
        if (objUuids != null && objUuids instanceof Set) {
            return (Set)objUuids;
        }
        LOG.error((Object)"param VM_UUID is null or not instanceof List", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private IVmInfoMaintainService getService() {
        return (IVmInfoMaintainService)this.getBundleService(HOST_REPLICATION_BUNDLE_NAME, IVmInfoMaintainService.class.getName());
    }

    private GalaxVM getGalaxVMParam(Map<String, Object> params, String key) {
        Object obj = params.get(key);
        if (obj != null && obj instanceof GalaxVM) {
            return (GalaxVM)obj;
        }
        LOG.error((Object)"param GALAX_VM is null or not instanceof GalaxVM ", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private String getVMInfoEParam(Map<String, Object> params, String key) {
        Object obj = params.get(key);
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        LOG.error((Object)"param VMInfoE is null or not instanceof String ", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private void generateMainTainPropLog(String vmName, LegoCheckedException legoException) {
        if (VerifyUtil.isEmpty((String)vmName)) {
            vmName = "--";
        }
        if (null != legoException) {
            this.writeFailedOperationLogNoException("site_resource_syncUpdateVRGVMInfo_operateName", 3, vmName, (Exception)((Object)legoException));
        } else {
            this.writeSucOperationLog("site_resource_syncUpdateVRGVMInfo_operateName", 3, vmName, null, null);
        }
    }

    @Override
    public void setOccupiedvmProperty(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("site_resource_syncSetDRVMRestoreNum_operateName", 3, "ism.drm.site.resource.auth.management.operateID");
        String vmUuid = "";
        String vmName = "";
        String snapRestoretNum = "";
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            Map params = (Map)request.toObject();
            IVmInfoMaintainService handler = this.getService();
            String cloudSn = this.getCloudSn(params);
            this.checkUserResourceAuthority(cloudSn);
            vmUuid = params.get("vmUuid").toString();
            snapRestoretNum = params.get(FS_SNAP_RESTORE_NUM).toString();
            if (VerifyUtil.isEmpty((String)snapRestoretNum)) {
                throw new LegoCheckedException(1073947393L);
            }
            Integer recoverPointNum = Integer.valueOf(snapRestoretNum);
            if (recoverPointNum < 2 || recoverPointNum > 32) {
                throw new LegoCheckedException(1073947393L);
            }
            vmName = handler.queryPhVmName(cloudSn, vmUuid);
            handler.setOccupiedvmProperty(cloudSn, vmUuid, recoverPointNum);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("syncMaintainProps error where vmUuid=" + vmUuid), (Throwable)e, 90160758787071L);
            this.generateSetOccupiedvmPropertyLog(vmName, null, e);
            throw e;
        }
        this.generateSetOccupiedvmPropertyLog(vmName, snapRestoretNum, null);
    }

    @Override
    public String getOccupiedvmSnapshot(String cloudSn, String vmUuid) throws ClassNotFoundException {
        this.checkUserOperationAuthority("site_resource_syncSetDRVMRestoreNum_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        this.checkUserResourceAuthority(cloudSn);
        IVmInfoMaintainService handler = this.getService();
        List vmSnapshotList = new ArrayList();
        try {
            vmSnapshotList = handler.getOccupiedvmProperty(cloudSn, vmUuid);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Exception:", (long)-1L, null, (Log)LOG);
        }
        return JSONArray.fromObject(vmSnapshotList).toString();
    }

    private void generateSetOccupiedvmPropertyLog(String vmName, String recoverPointNum, LegoCheckedException legoException) {
        if (VerifyUtil.isEmpty((String)vmName)) {
            vmName = "--";
        }
        if (null != legoException) {
            this.writeFailedOperationLogNoException("site_resource_syncSetDRVMRestoreNum_operateName", 3, vmName, (Exception)((Object)legoException));
        } else {
            this.writeSucOperationLog("site_resource_syncSetDRVMRestoreNum_operateName", 3, vmName, "site_resource_syncSetDRVMRestoreNum_operateDetail", new String[]{recoverPointNum});
        }
    }

    @Override
    public String getPhVmInfos(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            Map params = (Map)request.toObject();
            IVmInfoMaintainService handler = this.getService();
            String vrgSn = this.getVrgSn(params);
            String fmPhVmId = this.getFmPhVmIdForPh(params);
            Set<String> fcPhVmId = this.getUuidListForPh(params);
            String resultObj = handler.queryFmVm(vrgSn, fcPhVmId, Arrays.asList(fmPhVmId.split(";")));
            JSONObject response = new JSONObject();
            String messageObj = ReverseObjectSerializableUtils.serializableObj((Object)resultObj);
            try {
                response.put((Object)"type", (Object)resultObj.getClass().getName());
                response.put((Object)"message", (Object)messageObj);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"JSON operation failed.", (Throwable)e, 90160758787071L);
            }
            return response.toString();
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"getFmPhVmInfo error:", (Throwable)e, 90160758787071L);
            throw e;
        }
    }
}

