/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.galax.sdk.model.DrVRG;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResourceMappingScope
extends AbstractRestService {
    private static final String DRM_GALAX_MANAGER = "DRM_FusionShpere_Base";
    private static final String VRG_BUNDLE_NAME = "DRM_FusionShpere_VRG";
    private static final Log LOGGER = LogFactory.getInstance(ResourceMappingScope.class);

    private ISiteBaseService getSiteService() {
        return (ISiteBaseService)ServiceLocator.getBundleService((String)"DRM_Base", (String)ISiteBaseService.class.getName());
    }

    private ICloudService getCloudService() {
        return (ICloudService)ServiceLocator.getBundleService((String)DRM_GALAX_MANAGER, (String)ICloudService.class.getName(), ICloudService.class);
    }

    private IVRGController getVRGController() {
        return (IVRGController)ServiceLocator.getBundleService((String)VRG_BUNDLE_NAME, (String)IVRGController.class.getName(), IVRGController.class);
    }

    public List<ResourceMapping> filterResourceMapping(List<ResourceMapping> resourceMappings, Long userId) {
        ISiteBaseService siteService = this.getSiteService();
        List allSites = siteService.getAllSites(userId);
        ArrayList<ResourceMapping> resourceMappingsRemove = new ArrayList<ResourceMapping>();
        for (ResourceMapping resourceMapping : resourceMappings) {
            Site productSite = this.getSiteService().getSiteById(resourceMapping.getProductSiteId());
            Site recoverySite = this.getSiteService().getSiteById(resourceMapping.getRecoverySiteId());
            if (productSite == null || recoverySite == null) {
                resourceMappingsRemove.add(resourceMapping);
                continue;
            }
            if (!this.isSiteAuthorized(allSites, resourceMapping.getProductSiteId()) || !this.isSiteAuthorized(allSites, resourceMapping.getRecoverySiteId())) {
                resourceMappingsRemove.add(resourceMapping);
                continue;
            }
            if (!this.isCloudAuthorized(this.getCloudBySiteId(resourceMapping.getProductSiteId(), userId), resourceMapping.getProductResourceProviderId()) || !this.isCloudAuthorized(this.getCloudBySiteId(resourceMapping.getRecoverySiteId(), userId), resourceMapping.getRecoveryResourceProviderId())) {
                resourceMappingsRemove.add(resourceMapping);
                continue;
            }
            if (resourceMapping.getResourceType() != ResTypeEnum.VRG.getResType() || !this.filteByVRG(resourceMapping, userId)) continue;
            resourceMappingsRemove.add(resourceMapping);
        }
        resourceMappings.removeAll(resourceMappingsRemove);
        return resourceMappingsRemove;
    }

    public boolean checkResourceMapping(ResourceMapping resourceMapping, Long userId) {
        ISiteBaseService siteService = this.getSiteService();
        List allSites = siteService.getAllSites(userId);
        Site productSite = this.getSiteService().getSiteById(resourceMapping.getProductSiteId());
        Site recoverySite = this.getSiteService().getSiteById(resourceMapping.getRecoverySiteId());
        if (productSite == null || recoverySite == null) {
            LOGGER.info((Object)"Data productSite or recoverySite is null.");
            return false;
        }
        if (!this.isSiteAuthorized(allSites, resourceMapping.getProductSiteId()) || !this.isSiteAuthorized(allSites, resourceMapping.getRecoverySiteId())) {
            LOGGER.info((Object)"Data site authorized is false,productSiteId is %s,recoverySiteId is %s.", new Object[]{resourceMapping.getProductSiteId(), resourceMapping.getRecoverySiteId()});
            return false;
        }
        if (!this.isCloudAuthorized(this.getCloudBySiteId(resourceMapping.getProductSiteId(), userId), resourceMapping.getProductResourceProviderId()) || !this.isCloudAuthorized(this.getCloudBySiteId(resourceMapping.getRecoverySiteId(), userId), resourceMapping.getRecoveryResourceProviderId())) {
            LOGGER.info((Object)"Data cloud authorized is false,productSiteId is %s,recoverySiteId is %s,userId is %s.", new Object[]{resourceMapping.getProductSiteId(), resourceMapping.getRecoverySiteId(), userId});
            return false;
        }
        return resourceMapping.getResourceType() != ResTypeEnum.VRG.getResType() || !this.filteByVRG(resourceMapping, userId);
    }

    private boolean filteByVRG(ResourceMapping resourceMapping, Long userId) {
        return !this.isVRGAuthorized(this.getVrgBySiteId(resourceMapping.getProductSiteId(), userId), resourceMapping.getProductResourceId()) || !this.isVRGAuthorized(this.getVrgBySiteId(resourceMapping.getRecoverySiteId(), userId), resourceMapping.getRecoveryResourceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CloudInfo> getCloudBySiteId(String siteId, Long userId) {
        Page page = null;
        List resultList = Collections.EMPTY_LIST;
        try {
            ICloudService cloudService = this.getCloudService();
            page = cloudService.pageQueryLocalCloudBySiteId(siteId, userId, "name", 1000, 0, true);
        }
        finally {
            if (null != page) {
                resultList = page.getResult();
            }
        }
        return resultList;
    }

    private List<DrVRG> getVrgBySiteId(String siteId, Long userId) {
        IVRGController vrgController = this.getVRGController();
        List vrgList = vrgController.getVrgListBySiteId(siteId, userId);
        return vrgList;
    }

    private boolean isVRGAuthorized(List<DrVRG> vrgList, String vrgSn) {
        for (DrVRG vrgVo : vrgList) {
            if (!vrgVo.getDeviceSn().equals(vrgSn)) continue;
            return true;
        }
        return false;
    }

    private boolean isCloudAuthorized(List<CloudInfo> cloudList, String cloudSn) {
        for (CloudInfo cloudInfo : cloudList) {
            if (!cloudInfo.getDeviceSn().equals(cloudSn)) continue;
            return true;
        }
        return false;
    }

    private boolean isSiteAuthorized(List<Site> siteList, String siteId) {
        for (Site site : siteList) {
            if (!site.getSiteId().equals(siteId)) continue;
            return true;
        }
        return false;
    }
}

