/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.VrgMapStatusEnum;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public final class ResourceMappingUtil {
    private static final Log LOGGER = LogFactory.getInstance(ResourceMappingUtil.class);
    private static final String COMMER = ":";
    private static final String ADD_RESMAP_OPT_FC_KEY = "resource_createResourceMapping_operateDetail";
    private static final String ADD_RESMAP_OPT_FM_KEY = "resource_createFMResourceMapping_operateDetail";
    private static final String ADD_RESMAP_OPT_VRG_KEY = "resource_createVRGMapping_operateDetail";
    private static final String MOD_RESMAP_OPT_FC_KEY = "resource_modifyResourceMapping_operateDetail";
    private static final String MOD_RESMAP_OPT_FM_KEY = "resource_modifyFMResourceMapping_operateDetail";
    private static final String DEL_RESMAP_OPT_FC_KEY = "resource_deleteResourceMapping_operateDetail";
    private static final String DEL_RESMAP_OPT_FM_KEY = "resource_deleteFMResourceMapping_operateDetail";
    private static final String DEL_RESMAP_OPT_VRG_KEY = "resource_deleteVRGMapping_operateDetail";

    private ResourceMappingUtil() {
    }

    public static void checkResMappingStatus(int status) {
        if (status == VrgMapStatusEnum.NORMAL.getStatus() || status == VrgMapStatusEnum.MAPPING.getStatus()) {
            LOGGER.error((Object)"Failed to repair ResourceMapping, vrg map status is %s.", new Object[]{String.valueOf(status)});
            throw new LegoCheckedException(102401L, "Failed to repair ResourceMapping error, vrg is normal or mapping.");
        }
    }

    public static int getVrgMappingStatus(ResourceMapping mapping, IVRGController vrgService) {
        VRG vrgInfo;
        if (mapping == null || vrgService == null) {
            LOGGER.error((Object)"Parameter invalid, mapping information or service is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            vrgInfo = vrgService.getVRGBySn(mapping.getProductResourceId());
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() == 1073947394L) {
                vrgInfo = vrgService.getVRGBySn(mapping.getRecoveryResourceId());
            }
            LOGGER.error((Object)"Get VRG information catch LegoCheckedException, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        if (VerifyUtil.isEmpty((Object)vrgInfo)) {
            LOGGER.error((Object)"get VRG information failed, mapping= %s.", new Object[]{mapping.toString()});
            throw new LegoCheckedException(1073947394L);
        }
        return vrgInfo.getMapStatus();
    }

    public static String getResType(String resMappingTypeInit) {
        LOGGER.debug((Object)"Enter getResType.");
        String retResType = "--";
        if (resMappingTypeInit.equals("0")) {
            retResType = "ism.drm.galax.rm.resource.cluster";
        } else if (resMappingTypeInit.equals("1")) {
            retResType = "ism.drm.galax.rm.resource.computenode";
        } else if (resMappingTypeInit.equals("2")) {
            retResType = "ism.drm.galax.rm.resource.portgroup";
        } else if (resMappingTypeInit.equals("3")) {
            retResType = "ism.drm.galax.rm.resource.network";
        } else if (resMappingTypeInit.equals("4")) {
            retResType = "ism.drm.galax.rm.resource.securityGroup";
        } else if (resMappingTypeInit.equals("5")) {
            retResType = "ism.drm.galax.rm.resource.vrg";
        } else if (resMappingTypeInit.equals("6")) {
            retResType = "ism.drm.galax.rm.resource.datastore";
        } else if (resMappingTypeInit.equals("7")) {
            retResType = "ism.drm.galax.rm.resource.vdc";
        }
        return retResType;
    }

    public static String getAddMapDetailResType(String resMappingTypeInit) {
        LOGGER.debug((Object)"Enter getAddMapDetailResType.");
        String detailKey = "--";
        if (resMappingTypeInit.equals("0")) {
            detailKey = ADD_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("1")) {
            detailKey = ADD_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("2")) {
            detailKey = ADD_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("3")) {
            detailKey = ADD_RESMAP_OPT_FM_KEY;
        } else if (resMappingTypeInit.equals("4")) {
            detailKey = ADD_RESMAP_OPT_FM_KEY;
        } else if (resMappingTypeInit.equals("5")) {
            detailKey = ADD_RESMAP_OPT_VRG_KEY;
        } else if (resMappingTypeInit.equals("6")) {
            detailKey = ADD_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("7")) {
            detailKey = ADD_RESMAP_OPT_FM_KEY;
        }
        return detailKey;
    }

    public static String getModMapDetailResType(String resMappingTypeInit) {
        LOGGER.debug((Object)"Enter getModMapDetailResType.");
        String detailKey = "--";
        if (resMappingTypeInit.equals("0")) {
            detailKey = MOD_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("1")) {
            detailKey = MOD_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("2")) {
            detailKey = MOD_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("3")) {
            detailKey = MOD_RESMAP_OPT_FM_KEY;
        } else if (resMappingTypeInit.equals("4")) {
            detailKey = MOD_RESMAP_OPT_FM_KEY;
        } else if (resMappingTypeInit.equals("6")) {
            detailKey = MOD_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("7")) {
            detailKey = MOD_RESMAP_OPT_FM_KEY;
        } else if (resMappingTypeInit.equals("5")) {
            detailKey = MOD_RESMAP_OPT_FC_KEY;
        }
        return detailKey;
    }

    public static String getDelMapDetailResType(String resMappingTypeInit) {
        LOGGER.debug((Object)"Enter getDelMapDetailResType.");
        String detailKey = "--";
        if (resMappingTypeInit.equals("0")) {
            detailKey = DEL_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("1")) {
            detailKey = DEL_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("2")) {
            detailKey = DEL_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("3")) {
            detailKey = DEL_RESMAP_OPT_FM_KEY;
        } else if (resMappingTypeInit.equals("4")) {
            detailKey = DEL_RESMAP_OPT_FM_KEY;
        } else if (resMappingTypeInit.equals("5")) {
            detailKey = DEL_RESMAP_OPT_VRG_KEY;
        } else if (resMappingTypeInit.equals("6")) {
            detailKey = DEL_RESMAP_OPT_FC_KEY;
        } else if (resMappingTypeInit.equals("7")) {
            detailKey = DEL_RESMAP_OPT_FM_KEY;
        }
        return detailKey;
    }

    public static String getResTypeById(int resType) {
        LOGGER.debug((Object)"Enter getResTypeById.");
        String resourceType = "--";
        switch (resType) {
            case 0: {
                resourceType = "clusters";
                break;
            }
            case 1: {
                resourceType = "host";
                break;
            }
            case 2: {
                resourceType = "portgroups";
                break;
            }
            case 3: {
                resourceType = "FmNetwork";
                break;
            }
            case 4: {
                resourceType = "SecurityGroup";
                break;
            }
            case 5: {
                resourceType = "VRG";
                break;
            }
            case 6: {
                resourceType = "datastores";
                break;
            }
        }
        return resourceType;
    }

    public static String getResTypeByUuid(String resUuid) {
        LOGGER.debug((Object)"Enter getResTypeByUuid.");
        String[] uuids = resUuid.split(COMMER);
        return uuids[uuids.length - 2];
    }
}

