/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service;

import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;

class VRGResPairTask
extends Thread {
    private static final Log LOGGER = LogFactory.getInstance(VRGResPairTask.class);
    private IVRGController vrgService;
    private List<ResourceMapping> vrGResMappings = null;

    public VRGResPairTask() {
    }

    public VRGResPairTask(List<ResourceMapping> vrGResMappings, IVRGController vrgService) {
        this.vrGResMappings = vrGResMappings;
        this.vrgService = vrgService;
    }

    @Override
    public void run() {
        this.createVrgMapPair(this.vrGResMappings);
    }

    private void createVrgMapPair(List<ResourceMapping> resourceMappingList) {
        for (int idx = 0; idx < resourceMappingList.size(); ++idx) {
            ResourceMapping resMap = resourceMappingList.get(idx);
            try {
                this.vrgService.recreateVRGMap(resMap.getRecoverySiteId(), resMap.getProductResourceId(), resMap.getRecoveryResourceId());
                continue;
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("Failed to pair VRG ResourceMapping. ResourceMapping id is [" + resMap.getMappingId() + "]. "), (Throwable)e, 90160758787071L);
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to pair VRG ResourceMapping. ResourceMapping id is [" + resMap.getMappingId() + "]. "), (long)-1L, null, (Log)LOGGER);
            }
        }
    }
}

