/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.util;

import com.huawei.ism.drm.rest.fusionsphere.base.annotation.Length;
import com.huawei.ism.drm.rest.fusionsphere.base.annotation.NotEmpty;
import com.huawei.ism.drm.rest.fusionsphere.base.annotation.NotNull;
import com.huawei.ism.drm.rest.fusionsphere.base.annotation.Range;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;

public class AnnotationParamValidUtils {
    private static final Log LOGGER = LogFactory.getInstance(AnnotationParamValidUtils.class);

    private AnnotationParamValidUtils() {
    }

    public static void checkObject(Object obj) {
        if (obj == null) {
            LOGGER.error((Object)"Data obj is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields.length < 1) {
            return;
        }
        for (Field field : fields) {
            Annotation[] annotations = field.getAnnotations();
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException ex) {
                LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            }
            Class<?> fieldClass = field.getType();
            AnnotationParamValidUtils.checkAnnotation(annotations, value, fieldClass);
        }
    }

    private static void checkAnnotation(Annotation[] annotations, Object value, Class<?> fieldClass) {
        if (annotations == null) {
            return;
        }
        for (Annotation annotation : annotations) {
            if (NotNull.class.equals(annotation.annotationType()) && value == null) {
                LOGGER.error((Object)((NotNull)annotation).message());
                throw new LegoCheckedException(1073947393L);
            }
            if (Length.class.equals(annotation.annotationType()) && value instanceof CharSequence && !VerifyUtil.isEmpty((String)String.valueOf(value))) {
                AnnotationParamValidUtils.checkLength(annotation, value);
            }
            if (Range.class.equals(annotation.annotationType()) && Integer.class.equals(fieldClass) && value != null) {
                AnnotationParamValidUtils.checkRange(annotation, value);
            }
            if (NotEmpty.class.equals(annotation.annotationType())) {
                AnnotationParamValidUtils.checkNotEmpty(annotation, value);
            }
            AnnotationParamValidUtils.checkCollection(value);
        }
    }

    private static void checkNotEmpty(Annotation annotation, Object value) {
        if (value == null) {
            LOGGER.error((Object)((NotEmpty)annotation).message());
            throw new LegoCheckedException(1073947393L);
        }
        if (value instanceof CharSequence && VerifyUtil.isEmpty((Object)value)) {
            LOGGER.error((Object)((NotEmpty)annotation).message());
            throw new LegoCheckedException(1073947393L);
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            LOGGER.error((Object)((NotEmpty)annotation).message());
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkRange(Annotation annotation, Object value) {
        Range range = (Range)annotation;
        int valueStr = (Integer)value;
        if (valueStr < range.min() || range.max() < valueStr) {
            LOGGER.error((Object)range.message());
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkLength(Annotation annotation, Object value) {
        Length length = (Length)annotation;
        String valueStr = (String)value;
        if (valueStr.length() < length.min() || length.max() < valueStr.length()) {
            LOGGER.error((Object)length.message());
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkCollection(Object value) {
        if (!(value instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)value;
        for (Object aa : collection) {
            if (aa.getClass().getClassLoader() == null) continue;
            AnnotationParamValidUtils.checkObject(aa);
        }
    }
}

