/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.vrg.service;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VrgMapStatusEnum;
import com.huawei.ism.drm.galax.sdk.model.DrVRG;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.model.VRGResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VrgIpInfo;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.galax.sdk.vrg.model.VrgVO;
import com.huawei.ism.drm.galax.sdk.vrg.service.IAssignedVmController;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.ism.drm.galax.web.bean.GalaxVMEntity;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.cloud.model.VRGMappingInfo;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.GalaXCommConstants;
import com.huawei.ism.drm.rest.fusionsphere.util.BaseRestUtils;
import com.huawei.ism.drm.rest.fusionsphere.vrg.service.IVrgRestService;
import com.huawei.ism.drm.rest.fusionsphere.vrg.util.VrgRestUtil;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.ism.drm.web.util.FieldComparator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbsVrgQueryRestService
extends AbsVRRestService
implements IVrgRestService {
    private static Log logger = LogFactory.getInstance(AbsVrgQueryRestService.class);

    @Override
    public String getVrgBasicInfo(String vrgUuid) {
        logger.debug((Object)("VrgRestServiceImpl:getVrgBasicInfo enter, vrgUuid=" + vrgUuid), 90160758786816L);
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)vrgUuid)) {
            logger.error((Object)"parameter vrgUuid is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserResourceAuthority(vrgUuid);
        ArrayList<String> sns = new ArrayList<String>();
        sns.add(vrgUuid);
        List drVRGs = this.getScopeService().getResources(DrVRG.class, "deviceSn", sns);
        if (VerifyUtil.isEmpty((Collection)drVRGs)) {
            logger.error((Object)("vrg is not registed, vrgUuid=" + vrgUuid), 90160758787071L);
            return new JSONObject().toString();
        }
        VRG vrg = this.getVRGService().getVRGBySn(vrgUuid);
        logger.debug((Object)"VrgRestServiceImpl:getVrgBasicInfo leave.", 90160758786816L);
        return VrgRestUtil.parseVrg(vrg, ((DrVRG)drVRGs.get(0)).getPort()).toString();
    }

    @Override
    public RestJsonRequest getDrVrgListOfRemoteSite(String siteId) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId});
        this.checkUserAuthority(siteId);
        IVRGController vrgService = this.getVRGService();
        RestJsonRequest request = new RestJsonRequest();
        request.setClasssName(List.class.getName());
        if (null != vrgService) {
            List vrgs = vrgService.getVrgListBySiteId(siteId, this.getCurrentUserId());
            ArrayList<String> listObj = new ArrayList<String>();
            for (DrVRG vrg : vrgs) {
                JSONObject jObj = JSONObject.fromObject((Object)vrg);
                listObj.add(jObj.toString());
            }
            request.setValue(ReverseObjectSerializableUtils.serializableObj(listObj));
        } else {
            request.setValue(ReverseObjectSerializableUtils.serializableObj(new ArrayList(0)));
        }
        return request;
    }

    @Override
    public String getVMsProtected(String vrgSn, String mappingId, String orderBy, String orderType) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        logger.info((Object)("To get VMs under VRG , resourceMappingId is " + mappingId), 90160758786816L);
        BaseRestUtils.checkParamCommon((Object[])new Object[]{vrgSn, mappingId, orderBy, orderType});
        this.checkUserResourceAuthority(vrgSn);
        ArrayList<GalaxVMEntity> vmList = new ArrayList<GalaxVMEntity>();
        JSONObject result = new JSONObject();
        ResourceMapping resourceMapping = this.getVRGResourceMappingById(mappingId);
        if (resourceMapping == null) {
            logger.error((Object)"The result of VRG resoucre mapping is not exit, get vms under vrg failed.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        try {
            this.checkResourceMappingAuthority(resourceMapping);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"no enough right, get vms under vrg failed.", 90160758787071L);
            throw e;
        }
        logger.debug((Object)("To get VMs protected VRG , vrgSn is " + vrgSn), 90160758786816L);
        vmList.addAll(this.getVMProtectedByVRG(vrgSn));
        int totalCount = vmList.size();
        boolean orderByAscend = orderType.equals("asc");
        Collections.sort(vmList, new CommonComparator(orderBy, orderByAscend, false));
        PageParameter pagePara = this.getPageParameter();
        VrgRestUtil.pageQuery(null, vmList, orderBy, orderType, pagePara.getStartPage(), pagePara.getPageSize());
        logger.debug((Object)("To get VMs protected VRG , vm list size is " + vmList.size()), 90160758786816L);
        result.put((Object)"totalCount", (Object)totalCount);
        result.put((Object)"records", (Object)JSONArray.fromObject(vmList));
        logger.info((Object)"end get VMs under VRG", 90160758786816L);
        return result.toString();
    }

    @Override
    public String getVMsUnprotected(String vrgSn, String mappingId, String orderBy, String orderType) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        logger.info((Object)("To get VMs which can add to vrg , resourceMappingId is " + mappingId), 90160758786816L);
        BaseRestUtils.checkParamCommon((Object[])new Object[]{vrgSn, mappingId, orderBy, orderType});
        this.checkUserResourceAuthority(vrgSn);
        ResourceMapping resourceMapping = this.getVRGResourceMappingById(mappingId);
        if (resourceMapping == null) {
            logger.error((Object)"resourceMapping is not exit, get vms which can add to vrg failed.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        try {
            this.checkResourceMappingAuthority(resourceMapping);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"not enough right, get vms which can add to vrg failed.", 90160758787071L);
            throw e;
        }
        String vrmSn = this.getVRMSn(mappingId, vrgSn);
        if (VerifyUtil.isEmpty((String)vrmSn)) {
            logger.error((Object)"vrmSn is null, get vms which can add to vrg failed.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<GalaxVMEntity> vmList = new ArrayList();
        int totalCount = 0;
        try {
            logger.info((Object)("To get VMs unprotected, vrmSn is " + vrmSn), 90160758786816L);
            IAssignedVmController assignedVmService = this.getAssignedVmService();
            vmList = assignedVmService.queryValidVmsFromVrm(vrmSn, this.getCurrentUserId());
            Map queryParam = this.getExtParamInQueryParam();
            String filterName = (String)queryParam.get("filterName");
            String filterValue = (String)queryParam.get("filterValue");
            this.filterVms(vmList, filterName, filterValue);
            totalCount = vmList.size();
            boolean isSortFieldByAscend = orderType.equals("asc");
            String sortName = VerifyUtil.isEmpty((String)orderBy) ? "name" : orderBy;
            Collections.sort(vmList, new FieldComparator(sortName, isSortFieldByAscend));
            PageParameter pagePara = this.getPageParameter();
            VrgRestUtil.pageQuery(null, vmList, orderBy, orderType, pagePara.getStartPage(), pagePara.getPageSize());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"To get VMs unprotected by VRG, Caught LegoCheckedException", (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"To add VMs unprotected by  VRG, Caught Exception", (long)-1L, null, (Log)logger);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"totalCount", (Object)totalCount);
        result.put((Object)"records", (Object)JSONArray.fromObject(vmList));
        logger.info((Object)"end get VMs which can add to vrg", 90160758786816L);
        return result.toString();
    }

    @Override
    public String queryVrgVmsNumber(String vrgSn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{vrgSn});
        this.checkUserResourceAuthority(vrgSn);
        return String.valueOf(this.getAssignedVmService().getVmsNumber(vrgSn));
    }

    @Override
    public String getRemoteVRGIpInfo(String sn) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{sn});
        this.checkUserResourceAuthority(sn);
        JSONObject object = new JSONObject();
        VrgIpInfo vrgIpInfo = this.getVRGService().getVRGIpInfoByVRGSn(sn);
        try {
            object.put((Object)"businessIp", (Object)vrgIpInfo.getAddress());
            object.put((Object)"businessPort", (Object)vrgIpInfo.getPort());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return object.toString();
    }

    @Override
    public String getRemoteVRG(String sn) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{sn});
        this.checkUserResourceAuthority(sn);
        IVRGController vrgService = this.getVRGService();
        JSONObject object = new JSONObject();
        VRG vrg = vrgService.getVRGBySn(sn);
        try {
            object.put((Object)"status", (Object)vrg.getVrgStauts());
            object.put((Object)"availableCapacity", (Object)vrg.getAvailableCapacity());
            object.put((Object)"totalCapacity", (Object)vrg.getTotalCapacity());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return object.toString();
    }

    @Override
    public String getVrgList() {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        return this.getVRGService().getAllVrgList(this.getCurrentUserId());
    }

    @Override
    public String getAvailableVRGMapping(String mappingId, String orderBy, String orderType, int startPage, int pageSize) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        logger.info((Object)("into getAvailableVRGMapping , resourceMappingId is " + mappingId), 90160758786816L);
        if (VerifyUtil.isEmpty((String)mappingId) || VerifyUtil.isEmpty((String)orderBy) || VerifyUtil.isEmpty((String)orderType)) {
            logger.error((Object)"param invalid, getAvailableVRGMapping failed.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ResourceMapping rm = this.getVRGResourceMappingById(mappingId);
        if (rm == null) {
            logger.error((Object)"ResourceMapping not exit, getAvailableVRGMapping failed.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        try {
            this.checkResourceMappingAuthority(rm);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"not enouth right, getAvailableVRGMapping failed.", 90160758787071L);
            throw e;
        }
        List<VrgVO> productVrgVOs = this.getVRGInfoList(rm.getProductSiteId());
        List<VrgVO> recoveryVrgVOs = this.getVRGInfoList(rm.getRecoverySiteId());
        List<ResourceMapping> rmList = this.getAvailableVRGMappingInfo(rm);
        ArrayList<VRGMappingInfo> vrgMappingInfos = new ArrayList<VRGMappingInfo>();
        for (ResourceMapping resourceMapping : rmList) {
            VRGResourceMapping vrgRM = (VRGResourceMapping)resourceMapping;
            int vrgMapStatus = vrgRM.getStatus();
            if (vrgMapStatus != VrgMapStatusEnum.NORMAL.getStatus()) continue;
            VRGMappingInfo info = new VRGMappingInfo();
            info.setMappingId(vrgRM.getMappingId());
            info.setProductVRGName(vrgRM.getProductResourceName());
            info.setRecoveryVRGName(vrgRM.getRecoveryResourceName());
            info.setProductVRGIP(this.getVRGIP(vrgRM.getProductResourceId(), productVrgVOs));
            info.setRecoveryVRGIP(this.getVRGIP(vrgRM.getRecoveryResourceId(), recoveryVrgVOs));
            vrgMappingInfos.add(info);
        }
        int totalCount = vrgMappingInfos.size();
        String orderByField = VerifyUtil.isEmpty((String)orderBy) ? "productVRGName" : orderBy;
        boolean orderByAscend = orderType.equals("asc");
        Collections.sort(vrgMappingInfos, new CommonComparator(orderByField, orderByAscend, false));
        VrgRestUtil.pageQuery(null, vrgMappingInfos, orderByField, orderType, startPage, pageSize);
        JSONObject result = new JSONObject();
        result.put((Object)"totalCount", (Object)totalCount);
        result.put((Object)"records", (Object)JSONArray.fromObject(vrgMappingInfos));
        logger.info((Object)("end getAvailableVRGMapping , resourceMappingId is " + mappingId), 90160758786816L);
        return result.toString();
    }

    @Override
    public String getFusionComputeByVrg(String vrgSn) {
        logger.debug((Object)("VrgRestServiceImpl:getFusionComputeByVrg enter, vrgSn=" + vrgSn), 90160758786816L);
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)vrgSn)) {
            logger.error((Object)("parameter invalid, vrgSn=" + vrgSn), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserResourceAuthority(vrgSn);
        ICloudService cloudService = (ICloudService)this.getBundleService("DRM_FusionShpere_Base", ICloudService.class.getName(), ICloudService.class);
        DrVrm drVrm = cloudService.getVrmByVrgSn(vrgSn);
        if (null == drVrm) {
            logger.error((Object)("there is no VRM associated by vrg, vrgSn=" + vrgSn), 90160758787071L);
            return new JSONObject().toString();
        }
        JSONObject retObject = new JSONObject();
        retObject.put((Object)"deviceSn", (Object)drVrm.getDeviceSn());
        retObject.put((Object)"cloudName", (Object)drVrm.getName());
        retObject.put((Object)"ipAddress", (Object)drVrm.getIpAddress());
        retObject.put((Object)"port", (Object)drVrm.getPort());
        retObject.put((Object)"cloudStatus", (Object)drVrm.getStatus());
        retObject.put((Object)"cloudType", (Object)"FusionCompute");
        logger.debug((Object)"VrgRestServiceImpl:getFusionComputeByVrg leave.", 90160758786816L);
        return retObject.toString();
    }

    protected IResourceMappingService getResourceMappingService() {
        IResourceMappingService rmService = (IResourceMappingService)super.getBundleService("DRM_FusionShpere_Base", IResourceMappingService.class.getName(), IResourceMappingService.class);
        if (VerifyUtil.isEmpty((Object)rmService)) {
            logger.error((Object)"get rmService failed, rmService is null", 90160758787071L);
            throw new LegoCheckedException(1073947395L);
        }
        return rmService;
    }

    protected IVRGController getVRGService() {
        IVRGController vrgControllerService = (IVRGController)super.getBundleService("DRM_FusionShpere_VRG", IVRGController.class.getName(), IVRGController.class);
        if (VerifyUtil.isEmpty((Object)vrgControllerService)) {
            logger.error((Object)"get vrgControllerService failed, vrgControllerService is null", 90160758787071L);
            throw new LegoCheckedException(1073947395L);
        }
        return vrgControllerService;
    }

    protected IAssignedVmController getAssignedVmService() {
        IAssignedVmController avmControllerService = (IAssignedVmController)super.getBundleService("DRM_FusionShpere_VRG", IAssignedVmController.class.getName(), IAssignedVmController.class);
        if (VerifyUtil.isEmpty((Object)avmControllerService)) {
            logger.error((Object)"get vrgControllerService failed, vrgControllerService is null", 90160758787071L);
            throw new LegoCheckedException(1073947395L);
        }
        return avmControllerService;
    }

    protected ResourceMapping getVRGResourceMappingById(String id) {
        if (VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(1073947393L);
        }
        IResourceMappingService rmService = (IResourceMappingService)this.getBundleService("DRM_FusionShpere_Base", GalaXCommConstants.RM_SERVICE_KEY, IResourceMappingService.class);
        ResourceMapping resourceMapping = rmService.getResourceMappingById(id);
        if (resourceMapping == null || resourceMapping.getResourceType() != ResTypeEnum.VRG.getResType()) {
            return null;
        }
        return resourceMapping;
    }

    private List<GalaxVMEntity> getVMProtectedByVRG(String vrgSn) {
        try {
            IAssignedVmController assignedVmService = this.getAssignedVmService();
            return assignedVmService.queryVmsFromVrg(vrgSn, this.getCurrentUserId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"To get VMs protected by VRG, Caught LegoCheckedException", (Throwable)e, 90160758787071L);
        }
        catch (Exception e) {
            logger.error((Object)("To get VMs protected by VRG, Caught Exception" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return Collections.EMPTY_LIST;
    }

    private void filterVms(List<GalaxVMEntity> vmList, String filterName, String filterValue) {
        if (VerifyUtil.isEmpty(vmList) || VerifyUtil.isEmpty((String)filterName) || VerifyUtil.isEmpty((String)filterValue)) {
            return;
        }
        Iterator<GalaxVMEntity> iterator = vmList.iterator();
        while (iterator.hasNext()) {
            GalaxVMEntity vm = iterator.next();
            if (filterName.equals("name") && !vm.getName().toUpperCase(Locale.getDefault()).contains(filterValue.toUpperCase(Locale.getDefault()))) {
                iterator.remove();
            }
            if (filterName.equals("osType") && !vm.getOsType().toUpperCase(Locale.getDefault()).contains(filterValue.toUpperCase(Locale.getDefault()))) {
                iterator.remove();
            }
            if (!filterName.equals("vmId") || vm.getVmId().toUpperCase(Locale.getDefault()).contains(filterValue.toUpperCase(Locale.getDefault()))) continue;
            iterator.remove();
        }
    }

    private String getVRMSn(String resourceMappingId, String vrgSn) {
        ResourceMapping resourceMapping = this.getVRGResourceMappingById(resourceMappingId);
        if (resourceMapping == null) {
            logger.error((Object)("resourceMapping is not exit, resourcemapping id is " + resourceMappingId), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        logger.info((Object)("To get VRM SN, ResourceMapping id is " + resourceMappingId), 90160758786816L);
        if (vrgSn.equals(resourceMapping.getProductResourceId())) {
            return resourceMapping.getProductResourceProviderId();
        }
        return resourceMapping.getRecoveryResourceProviderId();
    }

    private List<VrgVO> getVRGInfoList(String siteId) {
        List<Object> vrgList = new ArrayList<VrgVO>();
        IVRGController vrgController = this.getVRGService();
        Page page = vrgController.pageQueryVrgsBySiteId(siteId, this.getCurrentUserId(), "name", Integer.MAX_VALUE, 0, true);
        if (null != page) {
            vrgList = page.getResult();
        }
        return vrgList;
    }

    private List<ResourceMapping> getAvailableVRGMappingInfo(ResourceMapping resourceMapping) {
        ArrayList<QueryCondition> qcs = new ArrayList<QueryCondition>();
        qcs.add(new QueryCondition("productSiteId", (Object)resourceMapping.getProductSiteId()));
        qcs.add(new QueryCondition("productResourceProviderId", (Object)resourceMapping.getProductResourceProviderId()));
        qcs.add(new QueryCondition("recoverySiteId", (Object)resourceMapping.getRecoverySiteId()));
        qcs.add(new QueryCondition("recoveryResourceProviderId", (Object)resourceMapping.getRecoveryResourceProviderId()));
        qcs.add(new QueryCondition("resourceType", (Object)ResTypeEnum.VRG.getResType()));
        List<ResourceMapping> rmList = this.getResourceMappingsByCondition(qcs);
        if (!VerifyUtil.isEmpty(rmList)) {
            for (ResourceMapping rm : rmList) {
                if (!rm.getMappingId().equals(resourceMapping.getMappingId())) continue;
                rmList.remove(rm);
                break;
            }
        }
        return rmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResourceMapping> getResourceMappingsByCondition(List<QueryCondition> conditions) {
        List rmList = new ArrayList();
        String orderByField = "productSiteName";
        Page page = null;
        try {
            page = this.getResourceMappingService().pageQueryConditionResourceMapping(0, Integer.MAX_VALUE, orderByField, true, conditions);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to pageQueryResourceMapping. Caught Exception ", (long)-1L, null, (Log)logger);
        }
        finally {
            if (null != page) {
                rmList = page.getResult();
            }
        }
        return rmList;
    }

    private String getVRGIP(String vrgSN, List<VrgVO> vrgList) {
        String vrgIp = "";
        if (!VerifyUtil.isEmpty((String)vrgSN)) {
            for (VrgVO vrg : vrgList) {
                if (!vrg.getDeviceSn().equals(vrgSN)) continue;
                vrgIp = vrg.getIpAddress();
                break;
            }
        }
        return vrgIp;
    }
}

