/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.vrg.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.sdk.service.IResScopeService;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.galax.sdk.vrg.model.AssignedVm;
import com.huawei.ism.drm.galax.sdk.vrg.service.IAssignedVmController;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.ResourceMappingUtil;
import com.huawei.ism.drm.rest.fusionsphere.util.BaseRestUtils;
import com.huawei.ism.drm.rest.fusionsphere.vrg.service.AbsVrgQueryRestService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class VrgRestServiceImpl
extends AbsVrgQueryRestService {
    private static final Log logger = LogFactory.getInstance(VrgRestServiceImpl.class);
    private static final String VRGMAPPING_TARGET_NAME = "VRGMapping_objectName";
    private static final int MAX_POPROPS_LEN = 8192;
    private static final String RESOURCE_REFRESH_OPERATENAME = "resource_refresh_operateName";
    private static final String RESOURCE_REFRESH_OPERATEDETAIL = "resource_refresh_operateDetail";

    @Override
    public Response refreshVrg(String vrgUuid) {
        logger.debug((Object)("VrgRestServiceImpl:refreshVrg enter,vrgUuid=" + vrgUuid), 90160758786816L);
        this.checkUserOperationAuthority(RESOURCE_REFRESH_OPERATENAME, 3, "ism.drm.site.resource.auth.management.operateID");
        if (VerifyUtil.isEmpty((String)vrgUuid)) {
            logger.error((Object)("parameter invalid, vrgUuid=" + vrgUuid), 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947393L);
            this.generateRefreshVrgLog(null, ex);
            throw ex;
        }
        try {
            this.checkUserResourceAuthority(vrgUuid);
            IVRGController vrgService = this.getVRGService();
            vrgService.refreshVrg(vrgUuid, this.getCurrentUserName());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("refresh VRG failed, vrgUuid=" + vrgUuid), (Throwable)e, 90160758787071L);
            this.generateRefreshVrgLog(vrgUuid, e);
            throw e;
        }
        this.generateRefreshVrgLog(vrgUuid, null);
        logger.debug((Object)"VrgRestServiceImpl:refreshVrg leave.", 90160758786816L);
        return Response.ok().build();
    }

    @Override
    public void synUpdateAssignedVms(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("site_resource_syncUpdateVRGVM_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"params error", (Throwable)e, 90160758787071L);
            this.generateSynupdateAvmsLog(null, null, e);
            throw e;
        }
        String jsonArray = (String)request.toObject();
        JSONArray vmJsonInfo = JSONArray.fromObject((Object)jsonArray);
        ArrayList<String> vmNames = new ArrayList<String>();
        String vrgSn = null;
        for (int index = 0; index < vmJsonInfo.size(); ++index) {
            JSONObject avmInfo = vmJsonInfo.getJSONObject(index);
            JSONObject extendProps = avmInfo.getJSONObject("extendProps");
            if (null == extendProps) continue;
            if (extendProps.containsKey((Object)"vmMgrInfo0")) {
                FixLengthProps poRecoveryProps = new FixLengthProps((Map)avmInfo.get("extendProps"), 8192);
                vmNames.add(JSONObject.fromObject((Object)poRecoveryProps.getValue("vmMgrInfo")).getString("name"));
            } else if (null != extendProps.getJSONObject("vmMgrInfo")) {
                vmNames.add(extendProps.getJSONObject("vmMgrInfo").getString("name"));
            }
            vrgSn = avmInfo.getString("vrgSn");
        }
        List<ResourceMapping> lisResMaps = this.getVrgResourceMapping(vrgSn);
        ResourceMapping resMap = null;
        try {
            if (!VerifyUtil.isEmpty(lisResMaps)) {
                resMap = lisResMaps.iterator().next();
                this.checkResourceMappingAuthority(resMap);
            }
            this.getAssignedVmService().synUpdateAssignedVms(jsonArray);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"get vrgsn error with LegoCheckedException", (Throwable)e, 90160758787071L);
            for (String name : vmNames) {
                this.generateSynupdateAvmsLog(resMap, name, e);
            }
            throw e;
        }
        catch (Exception e) {
            LegoCheckedException ex = new LegoCheckedException(-1L);
            for (String name : vmNames) {
                this.generateSynupdateAvmsLog(resMap, name, ex);
            }
            ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, null, (Log)logger);
        }
        for (String name : vmNames) {
            this.generateSynupdateAvmsLog(resMap, name, null);
        }
    }

    private List<ResourceMapping> getVrgResourceMapping(String vrgSn) {
        IResourceMappingService rmService = (IResourceMappingService)this.getBundleService("DRM_FusionShpere_Base", IResourceMappingService.class.getName(), IResourceMappingService.class);
        QueryCondition condition = new QueryCondition("productResourceId", (Object)vrgSn);
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(condition);
        String orderBy = "productResourceName";
        Page page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
        if (null == page || VerifyUtil.isEmpty((Collection)page.getResult())) {
            conditions.clear();
            QueryCondition newCondition = new QueryCondition("recoveryResourceId", (Object)vrgSn);
            conditions.add(newCondition);
            page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
        }
        List lisResMaps = null == page ? null : page.getResult();
        return lisResMaps;
    }

    @Override
    public void synDeleteAssignedVms(RestJsonRequest request) throws ClassNotFoundException {
        String vmName;
        this.checkUserOperationAuthority("site_resource_syncDeleteVRGVM_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"params error", (Throwable)e, 90160758787071L);
            this.generateSynRemoveVmsFromVRGLog(null, null, e);
            throw e;
        }
        List vmUuids = (List)request.toObject();
        IResScopeService resService = (IResScopeService)this.getBundleService("DRM_FusionShpere_Base", IResScopeService.class.getName(), IResScopeService.class);
        List listVm = null;
        listVm = resService.getResources(AssignedVm.class, "vmUuid", vmUuids);
        if (VerifyUtil.isEmpty((Collection)listVm)) {
            LegoCheckedException ex = new LegoCheckedException(1073947394L);
            this.generateSynRemoveVmsFromVRGLog(null, null, ex);
            throw ex;
        }
        IResourceMappingService rmService = (IResourceMappingService)this.getBundleService("DRM_FusionShpere_Base", IResourceMappingService.class.getName(), IResourceMappingService.class);
        String vrgSn = ((AssignedVm)listVm.iterator().next()).getVrgSn();
        QueryCondition condition = new QueryCondition("productResourceId", (Object)vrgSn);
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(condition);
        String orderBy = "productResourceName";
        Page page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
        if (null == page || VerifyUtil.isEmpty((Collection)page.getResult())) {
            conditions.clear();
            QueryCondition newCondition = new QueryCondition("recoveryResourceId", (Object)vrgSn);
            conditions.add(newCondition);
            page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
        }
        List lisResMaps = null == page ? null : page.getResult();
        String extendProps = null;
        ResourceMapping resMap = null;
        try {
            if (!VerifyUtil.isEmpty((Collection)lisResMaps)) {
                resMap = (ResourceMapping)lisResMaps.iterator().next();
                this.checkResourceMappingAuthority(resMap);
            }
            this.getAssignedVmService().synDeleteAssignedVms(vmUuids);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"get vrgsn error with LegoCheckedException", (Throwable)e, 90160758787071L);
            for (AssignedVm avm : listVm) {
                FixLengthProps poRecoveryProps = new FixLengthProps(avm.getExtendProps(), 8192);
                extendProps = poRecoveryProps.getValue("vmMgrInfo");
                String vmName2 = JSONObject.fromObject((Object)extendProps).getString("name");
                this.generateSynRemoveVmsFromVRGLog(resMap, vmName2, e);
            }
            throw e;
        }
        catch (Exception e) {
            for (AssignedVm avm : listVm) {
                FixLengthProps poRecoveryProps = new FixLengthProps(avm.getExtendProps(), 8192);
                extendProps = poRecoveryProps.getValue("vmMgrInfo");
                vmName = JSONObject.fromObject((Object)extendProps).getString("name");
                this.generateSynRemoveVmsFromVRGLog(resMap, vmName, null);
            }
            ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, null, (Log)logger);
        }
        for (AssignedVm avm : listVm) {
            FixLengthProps poRecoveryProps = new FixLengthProps(avm.getExtendProps(), 8192);
            extendProps = poRecoveryProps.getValue("vmMgrInfo");
            vmName = JSONObject.fromObject((Object)extendProps).getString("name");
            this.generateSynRemoveVmsFromVRGLog(resMap, vmName, null);
        }
    }

    @Override
    public Response repairVrgResMapping(String mappingId) {
        this.checkUserOperationAuthority("resource_reMapVRGMapping_operateName", 3, "ism.drm.site.resource.auth.management.operateID");
        logger.info((Object)("into repairVrgResMapping, mappingId is [" + mappingId + "]."), 90160758786816L);
        if (VerifyUtil.isEmpty((String)mappingId)) {
            logger.error((Object)"Failed to repair vrg, mappingId is empty.", 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947393L);
            this.generateRepairVRGlog(null, ex);
            throw ex;
        }
        IResourceMappingService rmService = this.getResourceMappingService();
        IVRGController vrgService = this.getVRGService();
        ResourceMapping rmTemp = rmService.getResourceMappingById(mappingId);
        if (VerifyUtil.isEmpty((Object)rmTemp)) {
            logger.error((Object)"Failed to repair vrg, ResourceMapping not exit.", 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947394L);
            this.generateRepairVRGlog(rmTemp, ex);
            throw ex;
        }
        try {
            this.checkResourceMappingAuthority(rmTemp);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Failed to repair vrg, not enough right.", 90160758787071L);
            this.generateRepairVRGlog(rmTemp, e);
            throw e;
        }
        try {
            ResourceMappingUtil.checkResMappingStatus(ResourceMappingUtil.getVrgMappingStatus(rmTemp, vrgService));
            vrgService.recreateVRGMap(rmTemp.getRecoverySiteId(), rmTemp.getProductResourceId(), rmTemp.getRecoveryResourceId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Failed to repair VRG ResourceMapping", (Throwable)e, 90160758787071L);
            this.generateRepairVRGlog(rmTemp, e);
            throw e;
        }
        catch (Exception e) {
            LegoCheckedException ex = new LegoCheckedException(-1L, (Throwable)e);
            this.generateRepairVRGlog(rmTemp, ex);
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to repair VRG ResourceMapping", (long)-1L, null, (Log)logger);
        }
        this.generateRepairVRGlog(rmTemp, null);
        logger.info((Object)("end repair VRG ResourceMapping, mappingId is [" + mappingId + "]."), 90160758786816L);
        return Response.ok().build();
    }

    @Override
    public BatchOperationResult addVMsToVRG(String mappingId, boolean isReconfig, String[] uuid) {
        LegoCheckedException ex;
        this.checkAddVmsToVrgAuthority(isReconfig);
        logger.info((Object)("into addVMsToVRG, mappingId is [" + mappingId + "]."), 90160758786816L);
        if (this.isParamEmpty(mappingId, uuid)) {
            logger.error((Object)"Failed to add vms to vrg, param is invalid.", 90160758787071L);
            LegoCheckedException ex2 = new LegoCheckedException(1073947393L);
            this.generateAddVmsToVRGLog(null, null, isReconfig, ex2);
            throw ex2;
        }
        String vrgSn = "";
        ResourceMapping resMap = null;
        try {
            resMap = this.getVRGResourceMappingById(mappingId);
            vrgSn = this.getProductVRGSn(mappingId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"get vrgsn error with LegoCheckedException", (Throwable)e, 90160758787071L);
            this.generateAddVmsToVRGLog(resMap, null, isReconfig, e);
            throw e;
        }
        catch (Exception e) {
            ex = new LegoCheckedException(-1L, (Throwable)e);
            this.generateAddVmsToVRGLog(resMap, null, isReconfig, ex);
            ExceptionUtil.rethrowException((Throwable)e, (String)"get vrgsn error with ", (long)-1L, null, (Log)logger);
        }
        List<String> uuidList = this.getUuidList(isReconfig, uuid, resMap);
        if (VerifyUtil.isEmpty((String)vrgSn) || VerifyUtil.isEmpty(uuidList)) {
            logger.error((Object)"vrgSn or uuidList is null", 90160758787071L);
            ex = new LegoCheckedException(1073947393L);
            this.generateAddVmsToVRGLog(resMap, null, isReconfig, ex);
            throw ex;
        }
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            IAssignedVmController assignedVmService = this.getAssignedVmService();
            boolean reConfig = isReconfig;
            batchOperationResult = assignedVmService.addVmsToVrg(vrgSn, uuidList, this.getCurrentUser().getUserName(), reConfig);
            this.handleObjectNotExsistResult(batchOperationResult);
            List opResultList = batchOperationResult.getResult();
            for (BatchOperation operationResult : opResultList) {
                LegoCheckedException ex3 = operationResult.getErrorCode() == 0L ? null : new LegoCheckedException(operationResult.getErrorCode());
                this.generateAddVmsToVRGLog(resMap, operationResult.getTargetName(), isReconfig, ex3);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"To add VMs To VRG, Caught LegoCheckedException", (Throwable)e, 90160758787071L);
            this.handleException(resMap, (Exception)((Object)e), uuid, isReconfig);
            throw e;
        }
        catch (Exception e) {
            this.handleException(resMap, e, uuid, isReconfig);
            ExceptionUtil.rethrowException((Throwable)e, (String)"To add VMs To VRG, Caught Exception", (long)-1L, null, (Log)logger);
        }
        logger.info((Object)("end addVMsToVRG, mappingId is [" + mappingId + "]."), 90160758786816L);
        return batchOperationResult;
    }

    private List<String> getUuidList(boolean isReconfig, String[] uuid, ResourceMapping resMap) {
        try {
            return this.getVMsUUID(uuid);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"get uuidList error", (Throwable)e, 90160758787071L);
            this.generateAddVmsToVRGLog(resMap, null, isReconfig, e);
            throw e;
        }
    }

    private void checkAddVmsToVrgAuthority(boolean isReconfig) {
        if (isReconfig) {
            this.checkUserOperationAuthority("resource_resetVMInVRGMapping_operateName", 3, "ism.drm.site.resource.auth.management.operateID");
        } else {
            this.checkUserOperationAuthority("resource_addVMtoVRGMapping_operateName", 3, "ism.drm.site.resource.auth.management.operateID");
        }
    }

    private boolean isParamEmpty(String mappingId, String[] uuid) {
        return VerifyUtil.isEmpty((String)mappingId) || VerifyUtil.isEmpty((Object[])uuid);
    }

    @Override
    public BatchOperationResult removeVMsFromVRG(String mappingId, boolean forcedDel, String[] uuid) {
        this.checkUserOperationAuthority("resource_removeVMFromVRGMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        logger.info((Object)("into removeVMsFromVRG, mappingId is [" + mappingId + "]."), 90160758786816L);
        if (this.isParamEmpty(mappingId, uuid)) {
            logger.error((Object)"Failed to remove vms from vrg, param is invalid.", 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947393L);
            this.generateRemoveVmsFromVRGLog(null, null, ex);
            throw ex;
        }
        String vrgSn = "";
        ResourceMapping sourceResMap = this.getVRGResourceMappingById(mappingId);
        try {
            vrgSn = this.getProductVRGSn(mappingId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"get vrgsn error", 90160758787071L);
            this.generateRemoveVmsFromVRGLog(sourceResMap, null, e);
            throw e;
        }
        List<String> uuidList = this.getVmsUuidList(uuid, sourceResMap);
        if (VerifyUtil.isEmpty((String)vrgSn) || VerifyUtil.isEmpty(uuidList)) {
            logger.error((Object)"vrgsn or uuidList is null", 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947393L);
            this.generateRemoveVmsFromVRGLog(sourceResMap, null, ex);
            throw ex;
        }
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            IAssignedVmController assignedVmService = this.getAssignedVmService();
            batchOperationResult = assignedVmService.removeVmsFromVrg(vrgSn, uuidList, this.getCurrentUser().getUserName(), forcedDel);
            this.handleObjectNotExsistResult(batchOperationResult);
            List opResultList = batchOperationResult.getResult();
            for (BatchOperation operationResult : opResultList) {
                LegoCheckedException ex = operationResult.getErrorCode() == 0L ? null : new LegoCheckedException(operationResult.getErrorCode());
                this.generateRemoveVmsFromVRGLog(sourceResMap, operationResult.getTargetName(), ex);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"To delete VMs protected by VRG, Caught LegoCheckedException", (Throwable)e, 90160758787071L);
            for (String name : this.getVMsName(uuid)) {
                this.generateRemoveVmsFromVRGLog(sourceResMap, name, e);
            }
            throw e;
        }
        catch (Exception e) {
            LegoCheckedException ex = new LegoCheckedException(-1L, (Throwable)e);
            for (String name : this.getVMsName(uuid)) {
                this.generateRemoveVmsFromVRGLog(sourceResMap, name, ex);
            }
            ExceptionUtil.rethrowException((Throwable)e, (String)"To delete VMs protected by VRG, Caught Exception", (long)-1L, null, (Log)logger);
        }
        logger.info((Object)("end removeVMsFromVRG, mappingId is [" + mappingId + "]."), 90160758786816L);
        return batchOperationResult;
    }

    private List<String> getVmsUuidList(String[] uuid, ResourceMapping sourceResMap) {
        try {
            return this.getVMsUUID(uuid);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"get uuidList error", 90160758787071L);
            this.generateRemoveVmsFromVRGLog(sourceResMap, null, e);
            throw e;
        }
    }

    @Override
    public BatchOperationResult moveVMs(String sourceMappingId, String targetMappingId, boolean isForcedMove, String[] uuid) {
        this.checkUserOperationAuthority("resource_moveVMBetweenVRGMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        logger.info((Object)("into moveVMs, sourceMappingId is [" + sourceMappingId + "].targetMappingId is [" + targetMappingId + "]."), 90160758786816L);
        if (this.isEmptyParam(uuid, sourceMappingId, targetMappingId)) {
            logger.error((Object)"srcVRGSN or uuids or mappingId is null", 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947393L);
            this.generateMoveVMsLog(null, null, null, ex);
            throw ex;
        }
        ResourceMapping sourceResMap = this.getVRGResourceMappingById(sourceMappingId);
        ResourceMapping dstResMap = this.getVRGResourceMappingById(targetMappingId);
        if (VerifyUtil.isEmpty((Object)sourceResMap)) {
            logger.error((Object)"Source resourceMaping does not exit.", 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947394L);
            this.generateMoveVMsLog(sourceResMap, dstResMap, null, ex);
            throw ex;
        }
        String srcVRGSN = null;
        String destVRGSN = null;
        try {
            this.checkResourceMappingAuthority(sourceResMap);
            srcVRGSN = this.getProductVRGSn(sourceMappingId);
            destVRGSN = this.getProductVRGSn(targetMappingId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"not enough right", 90160758787071L);
            this.generateMoveVMsLog(sourceResMap, dstResMap, null, e);
            throw e;
        }
        ArrayList uuidList = new ArrayList();
        Collections.addAll(uuidList, uuid);
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            IAssignedVmController assignedVmController = this.getAssignedVmService();
            batchOperationResult = assignedVmController.moveToNewVrg(srcVRGSN, uuidList, destVRGSN, this.getCurrentUser().getUserName(), isForcedMove);
            this.handleObjectNotExsistResult(batchOperationResult);
            List opResultList = batchOperationResult.getResult();
            for (BatchOperation operationResult : opResultList) {
                LegoCheckedException ex = operationResult.getErrorCode() == 0L ? null : new LegoCheckedException(operationResult.getErrorCode());
                this.generateMoveVMsLog(sourceResMap, dstResMap, operationResult.getTargetName(), ex);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"To delete VMs protected by VRG, Caught LegoCheckedException", (Throwable)e, 90160758787071L);
            for (String name : this.getVMsName(uuid)) {
                this.generateMoveVMsLog(sourceResMap, dstResMap, name, e);
            }
            throw e;
        }
        catch (Exception e) {
            LegoCheckedException ex = new LegoCheckedException(-1L, (Throwable)e);
            for (String name : this.getVMsName(uuid)) {
                this.generateMoveVMsLog(sourceResMap, dstResMap, name, ex);
            }
            ExceptionUtil.rethrowException((Throwable)e, (String)"To delete VMs protected by VRG, Caught Exception", (long)-1L, null, (Log)logger);
        }
        logger.info((Object)("end moveVMs, sourceMappingId is [" + sourceMappingId + "].targetMappingId is [" + targetMappingId + "]."), 90160758786816L);
        return batchOperationResult;
    }

    private String getProductVRGSn(String mappingId) {
        ResourceMapping resourceMapping = this.getVRGResourceMappingById(mappingId);
        if (resourceMapping == null) {
            logger.error((Object)"resourceMapping is null", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        this.checkResourceMappingAuthority(resourceMapping);
        String productSiteId = resourceMapping.getProductSiteId();
        ISiteBaseService siteService = (ISiteBaseService)super.getBundleService(ISiteBaseService.class.getName(), ISiteBaseService.class);
        Site productSite = siteService.getSiteById(productSiteId);
        if (0 == productSite.getSiteType()) {
            return resourceMapping.getProductResourceId();
        }
        return resourceMapping.getRecoveryResourceId();
    }

    private List<String> getVMsUUID(String[] vmsUUID) {
        if (this.hasEmptyElement(vmsUUID)) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> uuidList = new ArrayList<String>();
        Collections.addAll(uuidList, vmsUUID);
        return uuidList;
    }

    private boolean hasEmptyElement(String[] stringList) {
        if (VerifyUtil.isEmpty((Object[])stringList)) {
            return true;
        }
        for (String str : stringList) {
            if (!VerifyUtil.isEmpty((String)str)) continue;
            return true;
        }
        return false;
    }

    private void handleObjectNotExsistResult(BatchOperationResult batchOperationResult) {
        List resultList = batchOperationResult.getResult();
        for (BatchOperation batchOperation : resultList) {
            if (batchOperation.getErrorCode() != 1073947394L) continue;
            batchOperation.setTargetName("--");
        }
    }

    private void handleException(ResourceMapping resMap, Exception exception, String[] uuid, boolean isReconfig) {
        LegoCheckedException ex = exception instanceof LegoCheckedException ? (LegoCheckedException)((Object)exception) : new LegoCheckedException(-1L, (Throwable)exception);
        for (String name : this.getVMsName(uuid)) {
            this.generateAddVmsToVRGLog(resMap, name, isReconfig, ex);
        }
    }

    private List<String> getVMsName(String[] uuids) {
        ArrayList<String> namesList = new ArrayList<String>();
        if (VerifyUtil.isEmpty((Object[])uuids)) {
            namesList.add("--");
            return namesList;
        }
        IResScopeService resScopeService = (IResScopeService)this.getBundleService("DRM_FusionShpere_Base", IResScopeService.class.getName(), IResScopeService.class);
        if (VerifyUtil.isEmpty((Object)resScopeService)) {
            namesList.add("--");
            return namesList;
        }
        List galaxVms = resScopeService.getResources(GalaxVM.class, "uuid", Arrays.asList(uuids));
        if (!VerifyUtil.isEmpty((Collection)galaxVms)) {
            for (GalaxVM galaxVM : galaxVms) {
                namesList.add(galaxVM.getName());
            }
        } else {
            namesList.add("--");
        }
        return namesList;
    }

    private boolean isEmptyParam(String[] uuids, String mappingId, String rmId) {
        return this.hasEmptyElement(uuids) || VerifyUtil.isEmpty((String)mappingId) || VerifyUtil.isEmpty((String)rmId);
    }

    private void generateRepairVRGlog(ResourceMapping resMap, LegoCheckedException ex) {
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (!VerifyUtil.isEmpty((Object)resMap)) {
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = resMap.getProductSiteName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = resMap.getRecoverySiteName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("resource_reMapVRGMapping_operateName", 3, VRGMAPPING_TARGET_NAME, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("resource_reMapVRGMapping_operateName", 3, VRGMAPPING_TARGET_NAME, "resource_reMapVRGMapping_operateDetail", logParams);
        }
    }

    private void generateAddVmsToVRGLog(ResourceMapping resMap, String vmName, boolean isReconfig, LegoCheckedException ex) {
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (null != resMap) {
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = resMap.getProductSiteName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = resMap.getRecoverySiteName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        String optString = "resource_addVMtoVRGMapping_operateName";
        String detailStr = "resource_addVMtoVRGMapping_operateDetail";
        if (isReconfig) {
            optString = "resource_resetVMInVRGMapping_operateName";
            detailStr = "resource_resetVMInVRGMapping_operateDetail";
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException(optString, 3, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog(optString, 3, vmName, detailStr, logParams);
        }
    }

    private void generateSynupdateAvmsLog(ResourceMapping resMap, String vmName, LegoCheckedException ex) {
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (null != resMap) {
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = resMap.getProductSiteName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = resMap.getRecoverySiteName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("site_resource_syncUpdateVRGVM_operateName", 3, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("site_resource_syncUpdateVRGVM_operateName", 3, vmName, "site_resource_syncUpdateVRGVM_operateDetail", logParams);
        }
    }

    private void generateRemoveVmsFromVRGLog(ResourceMapping resMap, String vmName, LegoCheckedException ex) {
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (null != resMap) {
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = resMap.getProductSiteName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = resMap.getRecoverySiteName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("resource_removeVMFromVRGMapping_operateName", 2, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("resource_removeVMFromVRGMapping_operateName", 2, vmName, "resource_removeVMFromVRGMapping_operateDetail", logParams);
        }
    }

    private void generateSynRemoveVmsFromVRGLog(ResourceMapping resMap, String vmName, LegoCheckedException ex) {
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (null != resMap) {
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = resMap.getProductSiteName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = resMap.getRecoverySiteName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("site_resource_syncDeleteVRGVM_operateName", 2, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("site_resource_syncDeleteVRGVM_operateName", 2, vmName, "site_resource_syncDeleteVRGVM_operateDetail", logParams);
        }
    }

    private void generateMoveVMsLog(ResourceMapping srcResMap, ResourceMapping dstResMap, String vmName, LegoCheckedException ex) {
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (null != srcResMap) {
            logParams[0] = srcResMap.getProductResourceName();
            logParams[1] = srcResMap.getRecoveryResourceName();
            logParams[2] = srcResMap.getProductSiteName();
            logParams[3] = srcResMap.getProductResourceProviderName();
            logParams[4] = srcResMap.getRecoverySiteName();
            logParams[5] = srcResMap.getRecoveryResourceProviderName();
        }
        if (null != dstResMap) {
            logParams[6] = dstResMap.getProductResourceName();
            logParams[7] = dstResMap.getRecoveryResourceName();
            logParams[8] = dstResMap.getProductSiteName();
            logParams[9] = dstResMap.getProductResourceProviderName();
            logParams[10] = dstResMap.getRecoverySiteName();
            logParams[11] = dstResMap.getRecoveryResourceProviderName();
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("resource_moveVMBetweenVRGMapping_operateName", 2, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("resource_moveVMBetweenVRGMapping_operateName", 2, vmName, "resource_moveVMBetweenVRGMapping_operateDetail", logParams);
        }
    }

    private void generateRefreshVrgLog(String vrgSn, LegoCheckedException ex) {
        String vrgIp;
        NetworkEntity nEntity = this.getVrgBySn(vrgSn);
        String vrgName = null == nEntity ? "--" : nEntity.getName();
        String string = vrgIp = null == nEntity ? "--" : nEntity.getLinkIp();
        if (null != ex) {
            this.writeFailedOperationLogNoException(RESOURCE_REFRESH_OPERATENAME, 3, vrgName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog(RESOURCE_REFRESH_OPERATENAME, 3, vrgName, RESOURCE_REFRESH_OPERATEDETAIL, new String[]{vrgName, vrgIp});
        }
    }

    private NetworkEntity getVrgBySn(String vrgSn) {
        if (!VerifyUtil.isEmpty((String)vrgSn)) {
            try {
                return (NetworkEntity)this.getMo(NetworkEntity.class, "sn", vrgSn);
            }
            catch (Exception e) {
                logger.error((Object)("get Vrg info failed, vrgSn=" + vrgSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        return null;
    }
}

