/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.vrg.util;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.VrgMapStatusEnum;
import com.huawei.ism.drm.galax.sdk.model.DrVRG;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.vrg.model.VrgVO;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collections;
import java.util.List;

public final class VrgRestUtil {
    private static final Log LOGGER = LogFactory.getInstance(VrgRestUtil.class);

    private VrgRestUtil() {
    }

    public static JSONArray parseDrVrgs(List<DrVRG> drVRGs) {
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(drVRGs)) {
            return array;
        }
        for (DrVRG drVRG : drVRGs) {
            if (null == drVRG) continue;
            JSONObject object = new JSONObject();
            object.put((Object)"name", (Object)drVRG.getName());
            object.put((Object)"ipAddress", (Object)drVRG.getIpAddress());
            object.put((Object)"port", (Object)drVRG.getPort());
            object.put((Object)"status", (Object)drVRG.getStatus());
            object.put((Object)"deviceSn", (Object)drVRG.getDeviceSn());
            object.put((Object)"totalCapacity", (Object)drVRG.getTotalCapacity());
            object.put((Object)"availableCapacity", (Object)drVRG.getAvailableCapacity());
            array.add((Object)object);
        }
        return array;
    }

    public static JSONArray parseVrgVOs(List<VrgVO> vrgVOs) {
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(vrgVOs)) {
            return array;
        }
        for (VrgVO vrgVo : vrgVOs) {
            if (null == vrgVo) continue;
            JSONObject object = new JSONObject();
            object.put((Object)"cloudName", (Object)vrgVo.getName());
            object.put((Object)"ipAddress", (Object)vrgVo.getIpAddress());
            object.put((Object)"port", (Object)vrgVo.getPort());
            object.put((Object)"cloudStatus", (Object)vrgVo.getStatus());
            object.put((Object)"deviceSn", (Object)vrgVo.getDeviceSn());
            object.put((Object)"version", (Object)vrgVo.getVersion());
            object.put((Object)"cloudType", (Object)"VRG");
            array.add((Object)object);
        }
        return array;
    }

    public static boolean isDrVrgExsit(String vrgSn, List<DrVRG> drVRGs) {
        if (VerifyUtil.isEmpty(drVRGs) || VerifyUtil.isEmpty((String)vrgSn)) {
            LOGGER.error((Object)"there is no Vrg objects or vrgSn is null.", 90160758787071L);
            return false;
        }
        boolean isExsit = false;
        for (DrVRG drVRG : drVRGs) {
            if (!vrgSn.equals(drVRG.getDeviceSn())) continue;
            isExsit = true;
            break;
        }
        if (!isExsit) {
            LOGGER.error((Object)("Vrg is not under the site, vrgUuid=" + vrgSn), 90160758787071L);
            return false;
        }
        return true;
    }

    public static JSONObject parseVrg(VRG vrg, String port) {
        JSONObject object = new JSONObject();
        if (null == vrg) {
            return object;
        }
        object.put((Object)"name", (Object)vrg.getName());
        object.put((Object)"ipAddress", (Object)vrg.getIpAddress());
        object.put((Object)"port", (Object)port);
        object.put((Object)"status", (Object)vrg.getStatus());
        object.put((Object)"deviceSn", (Object)vrg.getSn());
        object.put((Object)"totalCapacity", (Object)vrg.getTotalCapacity());
        object.put((Object)"availableCapacity", (Object)vrg.getAvailableCapacity());
        object.put((Object)"isLinked", (Object)(vrg.getMapStatus() == VrgMapStatusEnum.NORMAL.getStatus() ? 1 : 0));
        return object;
    }

    public static <T> void pageQuery(String defaultSortField, List<T> viewList, String orderBy, String orderType, int startPage, int pageSize) {
        if (null == viewList) {
            return;
        }
        if (viewList.isEmpty()) {
            viewList.addAll(Collections.EMPTY_LIST);
            return;
        }
        boolean orderByAscend = false;
        String sortType = orderType;
        if (VerifyUtil.isEmpty((String)sortType) || sortType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        String sortField = orderBy;
        String sortName = !VerifyUtil.isEmpty((String)defaultSortField) ? defaultSortField : sortField;
        Collections.sort(viewList, new CommonComparator(sortName, orderByAscend, false));
        int pageNo = startPage;
        Page page = Page.createPage((int)pageNo, (int)pageSize, viewList);
        if (null != page) {
            viewList.clear();
            viewList.addAll(page.getResult());
        } else {
            viewList.addAll(Collections.EMPTY_LIST);
        }
    }
}

