/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.vrm.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IResScopeService;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.util.BaseRestUtils;
import com.huawei.ism.drm.rest.fusionsphere.vrm.service.IVrmRestService;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VrmRestServiceImpl
extends AbsVRRestService
implements IVrmRestService {
    private static Log logger = LogFactory.getInstance(VrmRestServiceImpl.class);

    @Override
    public String getVrmBySn(String vrmSn) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{vrmSn});
        this.checkUserResourceAuthority(vrmSn);
        VRM vrm = this.getVrmService().getVrm(vrmSn);
        JSONObject object = this.getVrmJsonObj(vrm);
        return object.toString();
    }

    private JSONObject getVrmJsonObj(VRM vrm) {
        JSONObject object = new JSONObject();
        object.put((Object)"name", (Object)vrm.getName());
        object.put((Object)"uuid", (Object)vrm.getUuid());
        if (null != vrm.getLicenseVersion()) {
            object.put((Object)"licenseVersion", (Object)vrm.getLicenseVersion());
        }
        return object;
    }

    private IVrmService getVrmService() {
        return (IVrmService)this.getBundleService("DRM_FusionShpere_Base", IVrmService.class.getName());
    }

    private IFmService getFmService() {
        return (IFmService)this.getBundleService("DRM_FusionShpere_Base", IFmService.class.getName());
    }

    @Override
    public String excuteCmdToVm(String vrmSn, String vmUri, String cmdType) {
        String result;
        NetworkEntity ne;
        this.checkUserOperationAuthority("site_resource_vmConfig_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        String cloudName = null;
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{vrmSn, vmUri, cmdType});
            this.checkUserResourceAuthority(vrmSn);
        }
        catch (LegoCheckedException e) {
            this.generateExcuteCmdToVmlog(null, e);
        }
        IResScopeService resService = (IResScopeService)this.getBundleService("DRM_FusionShpere_Base", IResScopeService.class.getName(), IResScopeService.class);
        ArrayList<String> vrmSns = new ArrayList<String>();
        vrmSns.add(vrmSn);
        List vrmList = resService.getResources(NetworkEntity.class, "sn", vrmSns);
        if (!VerifyUtil.isEmpty((Collection)vrmList) && null != (ne = (NetworkEntity)vrmList.iterator().next())) {
            cloudName = ne.getName();
        }
        try {
            result = this.getVrmService().excuteCmdToVm(vrmSn, vmUri, cmdType);
        }
        catch (LegoCheckedException e) {
            this.generateExcuteCmdToVmlog(cloudName, e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("execute cmd failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            LegoCheckedException ex = new LegoCheckedException(-1L);
            this.generateExcuteCmdToVmlog(cloudName, ex);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        this.generateExcuteCmdToVmlog(cloudName, null);
        return result;
    }

    private void generateExcuteCmdToVmlog(String cloudName, LegoCheckedException ex) {
        String newCloudName = "--";
        if (!VerifyUtil.isEmpty((String)cloudName)) {
            newCloudName = cloudName;
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("site_resource_vmConfig_operateName", 3, newCloudName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("site_resource_vmConfig_operateName", 3, newCloudName, null, null);
        }
    }

    @Override
    public String queryVmResult(String vrmSn, String taskUri) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{vrmSn, taskUri});
        this.checkUserResourceAuthority(vrmSn);
        return this.getVrmService().queryVmResult(vrmSn, taskUri);
    }

    @Override
    public String getDatastoreInfos(String vrmSn, String dsUrn) {
        try {
            vrmSn = URLDecoder.decode(vrmSn, "UTF-8");
            dsUrn = URLDecoder.decode(dsUrn, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)"getDatastoreInfos decode failed:", (Throwable)e);
            vrmSn = "";
            dsUrn = "";
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{vrmSn, dsUrn});
        this.checkUserResourceAuthority(vrmSn);
        return this.getVrmService().getDatastoreInfos(vrmSn, dsUrn);
    }

    @Override
    public RestJsonRequest queryRegistedCloudsBySiteId(String siteId) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId});
        this.checkUserAuthority(siteId);
        List cloudLists = this.getFmService().getRegistedCloudListBySiteId(siteId, this.getCurrentUserId(), null);
        RestJsonRequest restObject = new RestJsonRequest();
        restObject.setClasssName(List.class.getName());
        ArrayList<String> listObj = new ArrayList<String>();
        if (!VerifyUtil.isEmpty((Collection)cloudLists)) {
            for (CloudInfo cloud : cloudLists) {
                JSONObject jObj = JSONObject.fromObject((Object)cloud);
                listObj.add(jObj.toString());
            }
        }
        restObject.setValue(ReverseObjectSerializableUtils.serializableObj(listObj));
        return restObject;
    }

    @Override
    public String getRegistedCloudType(String siteId) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId});
        this.checkUserAuthority(siteId);
        return this.getFmService().getRegistedCloudType(siteId);
    }

    @Override
    public String getRegistedFcOfSpecfiedFm(String sn) {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{sn});
        this.checkUserResourceAuthority(sn);
        List vrmList = this.getFmService().getRegistedFcOfSpecfiedFm(sn);
        List<VRM> vrmRetList = this.filterResourceList(vrmList);
        return this.convertVRMArrayToJsonString(vrmRetList);
    }

    private String convertVRMArrayToJsonString(List<VRM> list) {
        JSONArray result = new JSONArray();
        if (null == list || list.isEmpty()) {
            return result.toString();
        }
        for (VRM vrm : list) {
            JSONObject object = this.getVrmJsonObj(vrm);
            result.add((Object)object);
        }
        return result.toString();
    }

    @Override
    public String getInvalidSharedDiskVms(String pdId) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.protectgroup.auth.scan");
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), pdId);
        JSONObject result = new JSONObject();
        result.put((Object)"vmNameList", (Object)this.getVrmService().getInvalidSharedDiskVms(pdId));
        return result.toString();
    }
}

