/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.cert.sdk.service.ICertificateService;
import com.huawei.ism.drm.cert.sdk.service.IComponentCertificateService;
import com.huawei.ism.drm.cert.sdk.service.ISystemCertificateService;
import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CertificateOperateTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(CertificateOperateTask.class);
    private static final Pattern TASK_LINK_PATTERN = Pattern.compile("x://([^?]+)\\??.*");
    private String action;
    private ISystemCertificateService systemCertificateService;
    private boolean independent;
    private List<Node> nodeList;
    private Boolean autoSwitchCluster;
    private final Object lock = new Object();

    public CertificateOperateTask(String action, ISystemCertificateService systemCertificateService, BackTask backTask, String taskId, boolean independent) {
        super(UUIDGenerator.getUUID(), backTask, true);
        backTask.setTaskLink("x://" + taskId + "?independent=" + independent);
        this.action = action;
        this.systemCertificateService = systemCertificateService;
        this.independent = independent;
    }

    public ISystemCertificateService getSystemCertificateService() {
        return this.systemCertificateService;
    }

    public ICertificateService getCertificateService() {
        return this.getSystemCertificateService().getCertificateServiceByCertName(this.getCertName());
    }

    public IComponentCertificateService getComponentCertificateService() {
        ICertificateService certificateService = this.getCertificateService();
        if (!(certificateService instanceof IComponentCertificateService)) {
            throw this.failure("sync file for cert ${cert}. cause: no component certificate service");
        }
        return (IComponentCertificateService)certificateService;
    }

    public String getCertName() {
        return this.getBackTask().getTargetName();
    }

    protected String getAction() {
        return this.action;
    }

    protected void succeed() {
        super.succeed();
        this.notifyCertificateUpdateSucceed(true);
    }

    protected void processFailure(Exception exception) {
        super.processFailure(exception);
        this.notifyCertificateUpdateFailure(exception, true);
    }

    protected void notifyCertificateUpdateSucceed(boolean quiet) {
        this.notifyCertificateUpdateStatus("00000000", null, quiet);
    }

    protected void notifyCertificateUpdateFailure(Exception exception, boolean quiet) {
        this.notifyCertificateUpdateStatus("11111111", this.simplify(this.message("${act} certificate for cert ${cert} failed. cause: " + exception.getMessage())), quiet);
    }

    public void notifyCertificateUpdateStatus(String resultCode, String errorMsg) {
        this.notifyCertificateUpdateStatus(resultCode, errorMsg, true);
    }

    public void notifyCertificateUpdateStatus(String resultCode, String errorMsg, boolean quiet) {
        if (!this.independent) {
            return;
        }
        String taskId = this.getBackTask().getTaskLink().replaceAll("^x://", "").replaceAll("\\?.*$", "");
        logger.debug((Object)"notify certificate update status: %s", new Object[]{taskId});
        this.systemCertificateService.notifyCertificateUpdateStatus(taskId, this.getCertName(), resultCode, this.simplify(errorMsg), quiet);
    }

    protected NodeAgentLocalService.Iface getNodeAgentLocalService() {
        return this.systemCertificateService.getNodeAgentLocalService();
    }

    protected String message(String detail) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("act", this.getAction());
        data.put("cert", this.getCertName());
        return StringUtil.format((String)detail, data);
    }

    protected LegoCheckedException failure(String cause) {
        String msg = this.simplify(this.message(cause));
        logger.error((Object)msg);
        return new LegoCheckedException(-1L, new String[]{msg}, msg);
    }

    protected LegoCheckedException failure(long errorCode, String cause, String ... args) {
        String message = this.simplify(this.message(cause));
        String[] params = (String[])Arrays.asList(Arrays.asList(args), Collections.singletonList(message)).stream().flatMap(Collection::stream).toArray(String[]::new);
        logger.error((Object)message);
        return new LegoCheckedException(errorCode, params, message);
    }

    private String simplify(String cause) {
        int indexB;
        if (cause == null) {
            return null;
        }
        int indexA = cause.indexOf("cause:");
        if (indexA == (indexB = cause.lastIndexOf("cause:"))) {
            return cause;
        }
        return cause.substring(0, indexA) + cause.substring(indexB);
    }

    protected void enableHaAutoSwitch() {
        if (this.isAutoSwitchCluster()) {
            CommandReaction.get(() -> this.getNodeAgentLocalService().executeAtLocalNode(new Command("ha_forbid_switch"), null), (long)1073949713L);
        }
    }

    protected void disableHaAutoSwitch() {
        if (this.isAutoSwitchCluster()) {
            CommandReaction.get(() -> this.getNodeAgentLocalService().executeAtLocalNode(new Command("ha_cancel_forbid_switch"), null), (long)1073949712L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutoSwitchCluster() {
        Object object = this.lock;
        synchronized (object) {
            if (this.autoSwitchCluster == null) {
                this.autoSwitchCluster = "double".equals(CommandReaction.get(() -> ((NodeAgentLocalService.Iface)this.getNodeAgentLocalService()).getDeployMode(), (long)1073949715L).getResult());
            }
            return this.autoSwitchCluster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Node> getNodeList() {
        Object object = this.lock;
        synchronized (object) {
            if (this.nodeList == null) {
                this.nodeList = (List)CommandReaction.get(() -> ((NodeAgentLocalService.Iface)this.getNodeAgentLocalService()).getNodeList(), (long)1073949715L).getResult();
            }
            return this.nodeList;
        }
    }

    public static boolean isMatchedTask(BackTask task, String taskId) {
        if (task == null || taskId == null) {
            return false;
        }
        String taskLink = task.getTaskLink();
        if (taskLink == null) {
            return false;
        }
        Matcher matcher = TASK_LINK_PATTERN.matcher(taskLink);
        if (!matcher.matches()) {
            return false;
        }
        return taskId.equals(matcher.group(1));
    }

    public static boolean isMatchedTask(BackTask task, Map<String, String> ... nameTypeMap) {
        if (nameTypeMap == null) {
            return false;
        }
        for (Map<String, String> nameType : nameTypeMap) {
            if (nameType == null || !Objects.equals(task.getType(), nameType.get(task.getTaskName()))) continue;
            return true;
        }
        return false;
    }
}

