/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.detect;

import com.google.common.reflect.TypeToken;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.poll.PollController;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.detect.IResourceDetectManager;
import com.huawei.ism.drm.detect.ResourceDetectedEvent;
import com.huawei.ism.drm.detect.ResourceEventDetector;
import com.huawei.ism.drm.detect.ResourceEventHandler;
import com.huawei.ism.drm.detect.ResourceEventIterator;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.base.thread.ThreadPoolConfig;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.stereotype.Component;

@Component
public class ResourceDetectManager
implements IResourceDetectManager,
IPoller {
    private static final Log LOGGER = LogFactory.getInstance(ResourceDetectManager.class);
    private static final String BATCH_SIZE_CONFIG_KEY = "resource.detect.batch.size";
    private static final int MAXIMUM_POOL_SIZE = 100;
    private static final int WORK_QUEUE_SIZE = 10000;
    private static final ThreadPoolConfig THREAD_POOL_CONFIG = ThreadPoolConfig.getThreadPoolConfig((String)"detect").corePoolSize(0).maximumPoolSize(100).workQueueSize(10000).initialize();
    private static final long DEFAULT_BATCH_SIZE = 25L;
    private static final long MINIMUM_BATCH_SIZE = 10L;
    private static final long MAXIMUM_BATCH_SIZE = 100L;
    private static final int DELAY_SECONDS = 3;
    private static final long DELAY_MILLIS = 3000L;
    private final List<ResourceEventDetector<?, ?>> detectors;
    private final List<ResourceEventHandler<?, ?>> handlers;
    private final ConcurrentHashMap<Map.Entry<ResourceEventDetector<?, ?>, String>, Long> detectTimestamps;

    public ResourceDetectManager(List<ResourceEventDetector<?, ?>> detectors, List<ResourceEventHandler<?, ?>> handlers, PollController pollController) {
        this.detectors = Objects.requireNonNull(detectors);
        this.handlers = Objects.requireNonNull(handlers);
        this.detectTimestamps = new ConcurrentHashMap();
        pollController.addPoller((IPoller)this, 3, 3);
    }

    public void detect() {
        HibernateUtil.execute(this::process);
    }

    public int getDetectTaskQueueSize() {
        ThreadPoolExecutor executor = THREAD_POOL_CONFIG.getThreadPoolExecutor();
        return executor.getQueue().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Session session) {
        int size = this.getDetectTaskQueueSize();
        if (size > 0) {
            LOGGER.warn((Object)"%s stacked tasks exist.", new Object[]{String.valueOf(size)});
        }
        long startTime = System.currentTimeMillis();
        String hql = "from DrResource order by detectTimes asc nulls first, deviceSn";
        try (ScrollableResults results = session.createQuery(hql).setReadOnly(true).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);){
            this.submitDetectTasks(session, results);
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (endTime - startTime > 3000L) {
                LOGGER.warn((Object)"resource detect timeout");
            }
        }
    }

    private void submitDetectTasks(Session session, ScrollableResults results) {
        long count = 0L;
        long batchSize = ResourceDetectManager.getBatchSize();
        String deviceSn = null;
        while (results.next()) {
            Object result = results.get(0);
            if (result instanceof DrResource) {
                DrResource resource = (DrResource)result;
                if (!this.submitDetectTask(deviceSn, resource)) break;
                deviceSn = resource.getDeviceSn();
            }
            if (++count % batchSize != 0L) continue;
            session.flush();
            session.clear();
        }
    }

    private boolean submitDetectTask(String deviceSn, DrResource resource) {
        if (Objects.equals(resource.getDeviceSn(), deviceSn)) {
            return true;
        }
        ThreadPoolExecutor executor = THREAD_POOL_CONFIG.getThreadPoolExecutor();
        try {
            executor.execute(() -> this.detect(resource));
        }
        catch (RejectedExecutionException e) {
            LOGGER.error((Object)"submit detect task failed", (Throwable)e);
            return false;
        }
        return true;
    }

    private static long getBatchSize() {
        LegoBaseConfig config = LegoBaseConfig.getInstance();
        long batchSize = config.getNumberWithMaxValue(BATCH_SIZE_CONFIG_KEY, 25L, 100L);
        return Math.max(batchSize, 10L);
    }

    public void detect(DrResource resource) {
        try {
            this.getMatchedResourceEventDetectors(resource).forEach(detector -> this.detect((ResourceEventDetector<? extends DrResource, ?>)detector, resource));
            this.updateResourceDetectTimes(resource.getDeviceSn());
        }
        catch (Throwable e) {
            LOGGER.error(e, (Object)"fail to detect event for %s", new Object[]{resource.getDbId()});
        }
    }

    private void detect(ResourceEventDetector<? extends DrResource, ?> detector, DrResource resource) {
        long clock;
        List<ResourceEventHandler<?, ?>> matchedResourceEventHandlers = this.getMatchedResourceEventHandlers(detector);
        if (matchedResourceEventHandlers.isEmpty()) {
            return;
        }
        Long updatedTime = this.queryResourceLastDetectTime(detector, resource.getDeviceSn());
        ResourceEventDetector<? extends DrResource, ?> resourceEventDetector = detector;
        if (!resourceEventDetector.isDetectable(resource)) {
            return;
        }
        long timestamp = 0L;
        if (updatedTime == null || updatedTime == 0L) {
            try {
                timestamp = resourceEventDetector.queryClock(resource);
            }
            catch (LegoCheckedException e2) {
                resourceEventDetector.handleException(resource, e2);
                throw e2;
            }
        } else {
            timestamp = updatedTime;
        }
        ResourceEventIterator iterator = resourceEventDetector.detect(resource, timestamp);
        if (iterator != null) {
            clock = this.handle(iterator, matchedResourceEventHandlers, e -> resourceEventDetector.handleException(resource, e));
        } else {
            LOGGER.warn((Object)"invalid implement: %s", new Object[]{resourceEventDetector.getClass().getName()});
            clock = 0L;
        }
        this.updateResourceLastDetectTime(detector, resource.getDeviceSn(), Math.max(clock, timestamp));
    }

    private List<ResourceEventHandler<?, ?>> getMatchedResourceEventHandlers(ResourceEventDetector<? extends DrResource, ?> detector) {
        return this.handlers.stream().filter(handler -> this.isMatchedResourceEventHandlerAndDetector((ResourceEventHandler<?, ?>)handler, detector)).collect(Collectors.toList());
    }

    private boolean isMatchedResourceEventHandlerAndDetector(ResourceEventHandler<?, ?> handler, ResourceEventDetector<? extends DrResource, ?> detector) {
        return TypeToken.of((Type)handler.getResourceType()).isSupertypeOf(detector.getResourceType()) && TypeToken.of((Type)handler.getEventDataType()).isSupertypeOf(detector.getEventDataType());
    }

    private long handle(ResourceEventIterator<?, ?> iterator, List<ResourceEventHandler<?, ?>> resourceEventHandlers, Consumer<LegoCheckedException> handleConsumer) {
        ResourceDetectedEvent event;
        if (iterator == null) {
            return 0L;
        }
        AtomicLong clock = new AtomicLong(0L);
        while (ResourceDetectManager.hasNextWithException(iterator, handleConsumer) && (event = iterator.next()) != null && event.getData() != null) {
            clock.updateAndGet(value -> Math.max(value, event.getTimestamp()));
            resourceEventHandlers.forEach(handler -> handler.handle(event));
        }
        return clock.get();
    }

    private static boolean hasNextWithException(ResourceEventIterator<?, ?> iterator, Consumer<LegoCheckedException> exConsumer) {
        try {
            return iterator.hasNext();
        }
        catch (LegoCheckedException e) {
            exConsumer.accept(e);
            return false;
        }
    }

    private Long queryResourceLastDetectTime(ResourceEventDetector<?, ?> detector, String deviceSn) {
        AbstractMap.SimpleEntry key = new AbstractMap.SimpleEntry(detector, deviceSn);
        return this.detectTimestamps.get(key);
    }

    private void updateResourceLastDetectTime(ResourceEventDetector<?, ?> detector, String deviceSn, long timestamp) {
        AbstractMap.SimpleEntry key = new AbstractMap.SimpleEntry(detector, deviceSn);
        this.detectTimestamps.put(key, timestamp);
    }

    private void updateResourceDetectTimes(String deviceSn) {
        HibernateUtil.execute(session -> {
            String hql = "update DrResource set detectTimes=coalesce(detectTimes, 0) + 1 where deviceSn=:sn";
            Query query = session.createQuery(hql);
            query.setParameter("sn", (Object)deviceSn);
            int count = query.executeUpdate();
            if (count == 0) {
                LOGGER.warn((Object)"fail to update detectTimes for resource %s", new Object[]{deviceSn});
            }
        });
    }

    public long queryClock(DrResource resource) {
        return this.getMatchedResourceEventDetectors(resource).map(detector -> this.queryClock((ResourceEventDetector<?, ?>)detector, resource)).max(Comparator.comparing(Function.identity())).orElse(0L);
    }

    private long queryClock(ResourceEventDetector<?, ?> detector, DrResource resource) {
        ResourceEventDetector<?, ?> resourceEventDetector = detector;
        return resourceEventDetector.queryClock(resource);
    }

    public void removeDetectCache(String deviceSn) {
        this.detectTimestamps.entrySet().removeIf(entry -> Objects.equals(((Map.Entry)entry.getKey()).getValue(), deviceSn));
    }

    public void unlockResourceDetect(String devSn) {
        if (VerifyUtil.isEmpty(this.detectors)) {
            return;
        }
        for (ResourceEventDetector<?, ?> detector : this.detectors) {
            detector.unlockResourceDetect(devSn);
        }
    }

    private Stream<ResourceEventDetector<?, ?>> getMatchedResourceEventDetectors(DrResource resource) {
        return this.detectors.stream().filter(detector -> this.isMatchResourceEventDetector((ResourceEventDetector<?, ?>)detector, resource));
    }

    private boolean isMatchResourceEventDetector(ResourceEventDetector<?, ?> detector, DrResource resource) {
        Class<?> type = resource.getClass();
        Type resourceType = detector.getResourceType();
        if (!(resourceType instanceof Class)) {
            return false;
        }
        Class resourceClass = (Class)resourceType;
        if (!resourceClass.isAssignableFrom(type)) {
            return false;
        }
        return this.checkDetector(detector, resource);
    }

    private boolean checkDetector(ResourceEventDetector<?, ?> detector, DrResource resource) {
        ResourceEventDetector<?, ?> resourceEventDetector = detector;
        return resourceEventDetector.check(resource);
    }

    public String getPollerID() {
        return "resource-detector";
    }

    public String getPollerType() {
        return "resource-detector";
    }

    public void run() {
        try {
            this.detect();
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)"detect failed", throwable);
        }
    }
}

