/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.detect.router;

import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.detect.EventRelatedResourceResolver;
import com.huawei.ism.drm.detect.ManagedResourceEvent;
import com.huawei.ism.drm.detect.ManagedResourceEventFactory;
import com.huawei.ism.drm.detect.ResourceDetectedEvent;
import com.huawei.ism.drm.detect.router.CommonEventRouter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.Session;

public abstract class ProtectionObjectEventRouter<R extends DrResource, D, M extends ManagedResourceEvent<R, ProtectObject>, F extends ManagedResourceEventFactory<R, ProtectObject, M>>
extends CommonEventRouter<R, D, ProtectObject, M> {
    private static final Log LOGGER = LogFactory.getInstance(ProtectionObjectEventRouter.class);
    private static final String STORAGE_METADATA = "storageMetadata";
    private static final String ESCAPE_SYMBOLS = "#[^_%]";
    private final Map<String, EventRelatedResourceResolver<R, D>> resolvers;
    private final F factory;

    public ProtectionObjectEventRouter(F factory, List<Map.Entry<String, EventRelatedResourceResolver<R, D>>> resolvers) {
        this.factory = (ManagedResourceEventFactory)Objects.requireNonNull(factory);
        this.resolvers = resolvers.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    protected List<M> route(ResourceDetectedEvent<R, D> event) {
        for (EventRelatedResourceResolver<R, D> resolver2 : this.resolvers.values()) {
            if (resolver2.check(event)) continue;
            return Collections.emptyList();
        }
        HashMap params = new HashMap();
        this.resolvers.forEach((key, resolver) -> params.put(key, resolver.resolve(event)));
        return HibernateUtil.call(this::queryProtectObjects, params).stream().map(protectObject -> this.factory.create(event.getResource(), protectObject, params)).collect(Collectors.toList());
    }

    private List<ProtectObject> queryProtectObjects(Session session, Map<String, Object> params) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(ProtectObject.class);
        Root root = query.from(ProtectObject.class);
        Predicate[] predicates = (Predicate[])params.entrySet().stream().map(entry -> this.buildStorageMetadataPredicate(builder, (Root<ProtectObject>)root, (Map.Entry<String, Object>)entry)).filter(Optional::isPresent).map(Optional::get).toArray(Predicate[]::new);
        if (predicates.length == 0) {
            LOGGER.warn((Object)"can not build storage metadata predicates by invalid params");
            return Collections.emptyList();
        }
        if (predicates.length == 1) {
            return session.createQuery(query.where((Expression)predicates[0])).list();
        }
        return session.createQuery(query.where((Expression)builder.and(predicates))).list();
    }

    private Optional<Predicate> buildStorageMetadataPredicate(CriteriaBuilder builder, Root<ProtectObject> root, Map.Entry<String, Object> entry) {
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof Collection) {
            return this.buildStorageMetadataPredicate(builder, root, key, (Collection)value);
        }
        return this.buildStorageMetadataPredicate(builder, root, key, value);
    }

    private Optional<Predicate> buildStorageMetadataPredicate(CriteriaBuilder builder, Root<ProtectObject> root, String key, Collection<?> values) {
        Predicate[] predicates = (Predicate[])values.stream().map(value -> this.buildStorageMetadataPredicate(builder, root, key, value)).filter(Optional::isPresent).map(Optional::get).toArray(Predicate[]::new);
        if (predicates.length == 0) {
            return Optional.empty();
        }
        if (predicates.length == 1) {
            return Optional.of(predicates[0]);
        }
        return Optional.of(builder.or(predicates));
    }

    private Optional<Predicate> buildStorageMetadataPredicate(CriteriaBuilder builder, Root<ProtectObject> root, String key, Object value) {
        Map<String, Object> condition = Collections.singletonMap(key, value);
        String json = JSONObject.fromObject(condition).toString();
        String pattern = json.substring(1, json.length() - 1);
        return Optional.of(builder.like((Expression)root.get(STORAGE_METADATA), "%" + this.escape(pattern) + "%", '#'));
    }

    private String escape(String pattern) {
        char token = ESCAPE_SYMBOLS.charAt(0);
        StringBuilder builder = new StringBuilder();
        for (char symbol : pattern.toCharArray()) {
            if (ESCAPE_SYMBOLS.indexOf(symbol) >= 0) {
                builder.append(token);
            }
            builder.append(symbol);
        }
        return builder.toString();
    }
}

