/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.task;

import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class FixedProtectionCheckerThreadPool {
    private static final Log logger = LogFactory.getInstance(FixedProtectionCheckerThreadPool.class);
    private static ExecutorService executorService;

    private FixedProtectionCheckerThreadPool() {
    }

    public static Future<Map<String, Object>> submit(Callable<Map<String, Object>> callable) {
        return executorService.submit(callable);
    }

    static {
        int poolSize = 20;
        try {
            String strPoolSize = ResourceUtil.getValue("protection.check.pool.size");
            poolSize = Integer.parseInt(strPoolSize);
        }
        catch (Exception e) {
            logger.error((Object)"Getting the config of thread pool size failed, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        executorService = Executors.newFixedThreadPool(poolSize);
    }
}

