/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.IConfigSyncRateService;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;

public class SyncRateObserverImpl
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(SyncRateObserverImpl.class);
    private IConfigSyncRateService configSyncRateService;

    public IConfigSyncRateService getConfigSyncRateService() {
        return this.configSyncRateService;
    }

    public void setConfigSyncRateService(IConfigSyncRateService configSyncRateService) {
        this.configSyncRateService = configSyncRateService;
    }

    public void before(MessageEvent event) {
    }

    public void after(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            LOGGER.debug((Object)"objectList is null after SyncRate.");
            return;
        }
        int messageType = event.getMessageType();
        if (messageType != 3) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup)) continue;
            ProtectGroup protectGroup = (ProtectGroup)object;
            this.excuteSyncRate(protectGroup);
        }
    }

    private void excuteSyncRate(ProtectGroup protectGroup) {
        try {
            PolicyTemplate policyTemplate = protectGroup.getTemplate();
            List<ProtectGroupSyncRatePolicy> pgsrps = ProtectGroupUtil.convertToSyncRatePolicy(policyTemplate);
            this.configSyncRateService.createSyncRateTask(protectGroup, pgsrps);
            this.configSyncRateService.runAtOnce(protectGroup, pgsrps, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"create sync rate task failed. error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

