/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.template.manager;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

public abstract class AbstractPolicyTemplateManager
extends BaseService
implements IPolicyTemplateManager {
    private static final Log logger = LogFactory.getInstance(AbstractPolicyTemplateManager.class);
    protected IBaseDao<Object, Serializable> baseDao;

    public IBaseDao<Object, Serializable> getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(IBaseDao<Object, Serializable> baseDao) {
        this.baseDao = baseDao;
    }

    public void addTemplate(PolicyTemplate policyTemplate) {
        if (policyTemplate == null) {
            logger.error((Object)"Invalid parameter");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.isSystemDefinePtExsist(policyTemplate) && policyTemplate.getIsSystemDefine().booleanValue()) {
            logger.error((Object)"AddSystemDefineTemplate failed policytemplate already Exist ptId: %s", new Object[]{policyTemplate.getPtId()});
            return;
        }
        try {
            this.baseDao.save((Object)policyTemplate);
        }
        catch (DataAccessException e) {
            logger.error((Object)"AddSystemDefineTemplate failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public List<PolicyTemplate> getAllTemplate(long userId) {
        List list;
        String hql = "from PolicyTemplate as pt  where pt.isSystemDefine=? order by pt.type";
        Session session = null;
        try {
            List templates;
            session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
            Query query = session.createQuery(hql);
            query.setParameter(0, (Object)true);
            list = templates = query.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"Get all PolicyTemplate failed");
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return list;
    }

    public Page pageQueryPolicyTemplate(int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props, long userId) {
        List criterionList = this.getBaseDao().translatePropsToCriterions(props);
        List list = this.getBaseDao().createCriteria(PolicyTemplate.class, orderBy, isAsc, criterionList.toArray(new Criterion[criterionList.size()]));
        return Page.createPage((int)pageNo, (int)pageSize, (List)list);
    }

    public boolean isSystemDefinePtExsist(PolicyTemplate policyTemplate) {
        List policyTemplates = null;
        String hql = "from PolicyTemplate as pt where pt.type=? and pt.isSystemDefine=?";
        try {
            policyTemplates = this.baseDao.getHibernateTemplate().find(hql, new Object[]{policyTemplate.getType(), true});
        }
        catch (DataAccessException e) {
            logger.error((Object)"Get isSystemDefinePt failed");
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return !VerifyUtil.isEmpty((Collection)policyTemplates);
    }

    public void deleteTemplate(String uuid) {
        PolicyTemplate pt = this.getPtByUuid(uuid);
        if (pt == null) {
            logger.error((Object)"Template does not exist");
            throw new LegoCheckedException(1073947394L);
        }
        if (pt.getIsSystemDefine().booleanValue()) {
            logger.error((Object)"Can't delete isSystemDefinePt, ptId= %s, ptNameL: %s.", new Object[]{pt.getPtId(), pt.getName()});
        }
        try {
            this.getBaseDao().getHibernateTemplate().delete((Object)pt);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Delete policytemplate failed ptId= %s", new Object[]{e, pt.getPtId()});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void filterSensitiveParam(PolicyTemplate dbPolicyTemplate) {
        if (dbPolicyTemplate == null) {
            logger.debug((Object)"DbPolicyTemplate is null,not fillProps.");
            return;
        }
        dbPolicyTemplate.getSchedules().forEach(ScriptParamsUtils::filterSensitiveParams);
    }

    public PolicyTemplate clonePolicyTemlate(int type) {
        logger.debug((Object)"ClonePolicyTemlate type:%s", new Object[]{String.valueOf(type)});
        for (PolicyTemplate pt : this.getAllTemplate(0L)) {
            if (pt.getType() != type) continue;
            try {
                return (PolicyTemplate)pt.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)"Cloning template failed. Type: %s", new Object[]{String.valueOf(type)});
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        logger.error((Object)"Cloning template failed. Type: %s", new Object[]{String.valueOf(type)});
        throw new LegoCheckedException(-1L);
    }
}

