/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BeginRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.AbstractRecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.MotionPausedUtils;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RecoveryProcessSerialExecutor
extends AbstractRecoveryProcessSerialExecutor {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessSerialExecutor.class);
    private int curProcessorIndex = -1;
    private boolean isContainsPause = false;
    private boolean isAfterPause = false;

    private RecoveryProcessSerialExecutor(String name, List<? extends IProcessor> processorList) {
        this.init(name, processorList);
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutor(List<? extends IProcessor> recoveryProcessors, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        if (recoveryProcessors == null || recoveryProcessors.isEmpty()) {
            return null;
        }
        return new RecoveryProcessSerialExecutor(RecoveryProcessSerialExecutor.getTemplateName(), recoveryProcessors);
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutor(Set<RecoveryProcessor> recoveryProcessors, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        if (recoveryProcessors == null || recoveryProcessors.isEmpty()) {
            return null;
        }
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(recoveryProcessors);
        return new RecoveryProcessSerialExecutor(RecoveryProcessSerialExecutor.getTemplateName(), sortedProcessors);
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutorSort(Set<RecoveryProcessor> recoveryProcessors) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(recoveryProcessors);
        RecoveryProcessSerialExecutor template = new RecoveryProcessSerialExecutor("RCT_" + UUIDGenerator.getUUID(), sortedProcessors);
        return template;
    }

    private boolean isBeginRecoveryProcessor(IProcessor recoveryProcessor) {
        if (recoveryProcessor == null) {
            return false;
        }
        return recoveryProcessor instanceof BeginRecoveryProcessor;
    }

    @Override
    protected void dealMotionPaused(RecoveryProcessorContext context, IProcessor processor, int index, int size) {
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        return this.callProcessors(context);
    }

    private boolean callProcessors(RecoveryProcessorContext context) {
        IProcessor processor = null;
        boolean isNormal = true;
        try {
            this.isContainsPause = MotionPausedUtils.containsPausedProcessor(context, this.processors);
            int size = this.processors.size();
            for (int i = 0; i < size; ++i) {
                processor = (IProcessor)this.processors.get(i);
                if (processor == null) continue;
                this.curProcessorIndex = i;
                boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
                if (isRecoveryProcessor && this.isNeedSkip(context, (RecoveryProcessor)processor)) continue;
                boolean processResult = processor.process(context);
                if (isRecoveryProcessor) {
                    RecoveryProcessor recoveryProcessor = (RecoveryProcessor)processor;
                    ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor(recoveryProcessor);
                }
                if (!processResult) {
                    isNormal = false;
                } else {
                    if (!this.isMotionPaused(context, processor)) continue;
                    this.createRecoveryProcessorDetail(context);
                }
                break;
            }
        }
        catch (Exception e) {
            String processorName = processor != null ? processor.getName() : "";
            logger.error((Object)"Calling processor failed. Processor: %s, Message: %s", 90160758784001L, (Object[])new String[]{processorName, ExceptionUtil.getErrorMessage((Throwable)e)});
            super.setContextErrorCode(context, e);
            isNormal = false;
        }
        return isNormal;
    }

    private boolean isNeedSkip(RecoveryProcessorContext context, RecoveryProcessor processor) {
        if (!processor.getIsEnabled().booleanValue()) {
            logger.debug((Object)"Processor %s will be skipped, because it is not enabled.", new Object[]{processor.getName()});
            return true;
        }
        return this.isContainsPause && this.checkMotionContinue(context, (IProcessor)processor);
    }

    private void createRecoveryProcessorDetail(RecoveryProcessorContext context) {
        int nextIndex = this.curProcessorIndex + 1;
        if (nextIndex == this.processors.size()) {
            return;
        }
        IProcessor processor = (IProcessor)this.processors.get(nextIndex);
        boolean isBaseRecoveryProcessor = processor instanceof BaseRecoveryProcessor;
        if (!isBaseRecoveryProcessor) {
            return;
        }
        BaseRecoveryProcessor baseRecoveryProcessor = (BaseRecoveryProcessor)processor;
        this.createProcessorDetail(baseRecoveryProcessor, context, DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED);
        context.setAttribute("PLAN_PROGRESS_COMPLETED_NUM", (Object)nextIndex);
    }

    public boolean changeProcessorDetailStatus(RecoveryProcessorContext context) {
        for (IProcessor processor : this.processors) {
            boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
            if (!isRecoveryProcessor) continue;
            BaseRecoveryProcessor baseRecoveryProcessor = (BaseRecoveryProcessor)processor;
            String processorClassName = processor.getClass().getName();
            if (processorClassName.contains("RegionBetweenRecoveryProcessor") || processorClassName.contains("RegionWithinRecoveryProcessor")) {
                if (!baseRecoveryProcessor.getIsEnabled().booleanValue()) {
                    logger.debug((Object)"The processor %s is not enable.", new Object[]{baseRecoveryProcessor.getProcName()});
                    continue;
                }
                this.resetChildProcDetailStatus(context, baseRecoveryProcessor);
                logger.info((Object)"The processor %s do resetChildProcDetailStatus finished.", new Object[]{baseRecoveryProcessor.getProcName()});
                return false;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() != baseRecoveryProcessor.getProcStatus()) continue;
            this.createProcessorDetail(baseRecoveryProcessor, context, DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED);
        }
        return false;
    }

    private void resetChildProcDetailStatus(RecoveryProcessorContext context, BaseRecoveryProcessor baseProcessor) {
        baseProcessor.setContextRef(context);
        baseProcessor.beforeExecRecoveryProcessor();
        this.createProcessorDetail(baseProcessor, context, DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED);
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        IRecoveryPlanBaseService recoveryPlanService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        Map<String, List<RecoveryProcessorDetail>> details = recoveryPlanService.getRecoveryProcessorDetailsByLogId(context.getRecoveryPlan().getPlanId(), context.getRecoveryLogId()).stream().filter(detail -> !VerifyUtil.isEmpty((Collection)detail.getChildDetails())).flatMap(detail -> detail.getChildDetails().stream()).filter(detail -> DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() != detail.getProcessStatus()).collect(Collectors.groupingBy(RecoveryProcessorDetail::getProcId));
        for (RecoveryProcessor child : baseProcessor.getChildProc()) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() != child.getProcStatus() && DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED.getValue() != child.getProcStatus()) {
                logger.debug((Object)"The procStatus %s of child processor %s no need to update.", new Object[]{String.valueOf(child.getProcStatus()), child.getProcName()});
                continue;
            }
            if (!(child instanceof BaseRecoveryProcessor)) {
                logger.debug((Object)"The child processor %s is not instanceof BaseRecoveryProcessor.", new Object[]{child.getProcName()});
                continue;
            }
            List<RecoveryProcessorDetail> childDetails = details.get(child.getProcId());
            if (VerifyUtil.isEmpty(childDetails)) {
                this.createProcessorDetail((BaseRecoveryProcessor)child, context, DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED);
                continue;
            }
            for (RecoveryProcessorDetail recoveryProcessorDetail : childDetails) {
                recoveryProcessorDetail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                recoveryProcessService.updateRecoveryProcessDetail(recoveryProcessorDetail);
            }
        }
        recoveryProcessService.updateRecoveryProcessor((RecoveryProcessor)baseProcessor);
    }

    private void createProcessorDetail(BaseRecoveryProcessor baseRecoveryProcessor, RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteResultE status) {
        String parentDetailId = null;
        if (baseRecoveryProcessor.getParentProc() != null) {
            parentDetailId = baseRecoveryProcessor.getParentProc().getCurProcessDetail().getDetailId();
        }
        RecoveryProcessor preProcessor = RecoveryProcessBaseUtil.getValidPreviousProcessor(baseRecoveryProcessor);
        RecoveryProcessor nextProcessor = RecoveryProcessBaseUtil.getValidNextProcessor(baseRecoveryProcessor);
        String previousProcId = preProcessor != null ? preProcessor.getProcId() : null;
        String nextProcId = nextProcessor != null ? nextProcessor.getProcId() : null;
        RecoveryProcessorDetail procDetail = new RecoveryProcessorDetail();
        procDetail.setLogId(context.getRecoveryLogId());
        procDetail.setProcessName(baseRecoveryProcessor.getProcName());
        procDetail.setNextProcId(nextProcId);
        procDetail.setPreviousProcId(previousProcId);
        procDetail.setParentDetailId(parentDetailId);
        procDetail.setProcId(baseRecoveryProcessor.getProcId());
        procDetail.setProcessStatus(status.getValue());
        baseRecoveryProcessor.createRecoveryProcessorDetail(procDetail);
    }

    @Override
    protected boolean checkMotionContinue(RecoveryProcessorContext context, IProcessor recoveryProcessor) {
        boolean isBeginRecoveryProcessor = this.isBeginRecoveryProcessor(recoveryProcessor);
        return this.isMotionContinue(context, recoveryProcessor) && !isBeginRecoveryProcessor;
    }

    private boolean isMotionContinue(RecoveryProcessorContext context, IProcessor processor) {
        boolean isSupportMotion;
        DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)context.getAttribute("PLAN_EXEXUTE_TYPE");
        boolean bl = isSupportMotion = DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)recoveryPlanExecuteType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.equals((Object)recoveryPlanExecuteType);
        if (!isSupportMotion) {
            return false;
        }
        if (!Boolean.parseBoolean(String.valueOf(context.getAttribute("IS_CONTINUE_PROCESS")))) {
            return false;
        }
        if (this.isAfterPause) {
            return false;
        }
        if (MotionPausedUtils.isPausedProcessor(context, processor)) {
            this.isAfterPause = true;
        }
        logger.debug((Object)"Processor %s will be skipped, because it was executed before pausing.", new Object[]{processor.getName()});
        return true;
    }

    public boolean checkMotionCancel(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        if (context == null) {
            return false;
        }
        if (!(context.getAttribute("PLAN_EXEXUTE_TYPE") instanceof DrmEnumDefine.RecoveryPlanExecuteTypeE)) {
            logger.debug((Object)"PlanExecuteType is not valid.");
            return false;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)context.getAttribute("PLAN_EXEXUTE_TYPE");
        boolean isContinue = Boolean.parseBoolean(String.valueOf(context.getAttribute("IS_CONTINUE_PROCESS")));
        boolean isPaused = DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_PAUSED.getValue() == recoveryPlan.getPlanStatus();
        return (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)recoveryPlanExecuteType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.equals((Object)recoveryPlanExecuteType)) && !isContinue && isPaused;
    }

    private boolean isMotionPaused(RecoveryProcessorContext context, IProcessor processor) {
        if (!MotionPausedUtils.isMotionPaused(context) || !MotionPausedUtils.isPausedProcessor(context, processor)) {
            logger.error((Object)"Processor is %s.", new Object[]{processor.getName()});
            return false;
        }
        if (!MotionPausedUtils.isOpenMotionPaused(context)) {
            logger.error((Object)"PlanedMotion paused config is close.");
            return false;
        }
        if (!(processor instanceof RecoveryProcessor)) {
            logger.error((Object)"Processor is not RecoveryProcessor.");
            context.setAttribute("PLAN_PROGRESS_RATIO", (Object)100);
            return false;
        }
        RecoveryProcessor recoveryProcessor = (RecoveryProcessor)processor;
        RecoveryProcessor nextProcessor = recoveryProcessor.getNextProcessor();
        int procStatus = Optional.ofNullable(nextProcessor).map(RecoveryProcessor::getProcStatus).orElse(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        logger.info((Object)String.format(Locale.ROOT, "Processor status is %s.", procStatus));
        if (procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() || procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() || procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue()) {
            logger.error((Object)String.format(Locale.ROOT, "Processor status is %s and should not be paused.", procStatus));
            return false;
        }
        context.setAttribute("PLAN_PROGRESS_RATIO", (Object)Math.max(recoveryProcessor.getProgressRatio(), 0));
        context.setAttribute("IS_PAUSED_PROCESS", (Object)true);
        logger.info((Object)String.format(Locale.ROOT, "Processor status is %s.", procStatus));
        return true;
    }
}

