/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MotionPausedUtils {
    private static final Log LOGGER = LogFactory.getInstance(MotionPausedUtils.class);
    private static final Set<String> PAUSED_PROCESSORS = Stream.of("com.huawei.ism.drm.openstack.recovery.processor.OpenStackPowerOnVmsProcessor", "com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRefactorNasProcessor", "com.huawei.ism.drm.galax.recovery.process.StartVmRecoveryProcessor").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    private static final Set<String> BMS_PAUSED_PROCESSORS = Collections.singleton("com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachVolProcessor");
    private static final String OPENSTACK_VM_TYPE = "vm_type";
    private static final String OPENSTACK_VM_TYPE_BMS = "BMS";
    private static final String IS_CONFIRM_DEL_PROD_VM = "is_confirm_del_prod_vm";
    public static final String IS_CONFIRM_REPROTECTION = "is.confirm.reprotection";

    private MotionPausedUtils() {
    }

    public static boolean isOpenMotionPaused(RecoveryProcessorContext context) {
        boolean interfaceSettingValue;
        boolean configSettingValue;
        if (context.getAttributeKeys().contains(IS_CONFIRM_DEL_PROD_VM)) {
            configSettingValue = LegoBaseConfig.getInstance().getBoolean(IS_CONFIRM_DEL_PROD_VM, Boolean.valueOf(true));
            interfaceSettingValue = Boolean.parseBoolean(String.valueOf(context.getAttribute(IS_CONFIRM_DEL_PROD_VM)));
        } else {
            configSettingValue = LegoBaseConfig.getInstance().getBoolean(IS_CONFIRM_REPROTECTION, Boolean.valueOf(true));
            Object confirmInterface = context.getAttribute("IS_CONFIRM_REPROTECTION");
            interfaceSettingValue = confirmInterface != null && Boolean.parseBoolean(String.valueOf(confirmInterface));
        }
        LOGGER.info((Object)"Interface isConfirmDelProdVm = %s, config isConfirmDelProdVm = %s.", new Object[]{interfaceSettingValue, configSettingValue});
        DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)context.getAttribute("PLAN_EXEXUTE_TYPE");
        return configSettingValue && interfaceSettingValue && recoveryPlanExecuteType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
    }

    public static boolean isMotionPaused(RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)context.getAttribute("PLAN_EXEXUTE_TYPE");
        boolean isConfirmReprotection = LegoBaseConfig.getInstance().getBoolean(IS_CONFIRM_REPROTECTION, Boolean.valueOf(true));
        Object confirmInterface = context.getAttribute("IS_CONFIRM_REPROTECTION");
        boolean isConfirmInterface = confirmInterface != null && Boolean.parseBoolean(String.valueOf(confirmInterface));
        LOGGER.info((Object)"isConfirmInterface is %s,isConfirmReprotection is %s.", new Object[]{isConfirmInterface, isConfirmReprotection});
        return isConfirmReprotection && isConfirmInterface && recoveryPlanExecuteType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
    }

    public static boolean isPausedProcessor(RecoveryProcessorContext context, IProcessor processor) {
        if (MotionPausedUtils.isBareMetalServer(context)) {
            return BMS_PAUSED_PROCESSORS.contains(processor.getName());
        }
        return PAUSED_PROCESSORS.contains(processor.getName());
    }

    public static boolean containsPausedProcessor(RecoveryProcessorContext context, List<IProcessor> processors) {
        if (VerifyUtil.isEmpty(processors)) {
            return false;
        }
        Set<String> pausedProcessors = MotionPausedUtils.isBareMetalServer(context) ? BMS_PAUSED_PROCESSORS : PAUSED_PROCESSORS;
        return processors.stream().map(IProcessor::getName).anyMatch(pausedProcessors::contains);
    }

    private static boolean isBareMetalServer(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist());
        String vmType = (String)po.getProps().get(OPENSTACK_VM_TYPE);
        LOGGER.debug((Object)"Check recovery plan processor, vm type: %s", new Object[]{vmType});
        return OPENSTACK_VM_TYPE_BMS.equals(vmType);
    }
}

