/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.security.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.security.sdk.service.ISecurityService;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.cbb.user.service.security.IAuthorityService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import java.util.Date;
import java.util.List;

@Service(name="ISecurityService", desc="", interfaceClass=ISecurityService.class)
public class SecurityServiceImpl
extends DrmBaseService
implements ISecurityService {
    private static final Log logger = LogFactory.getInstance(SecurityServiceImpl.class);
    private static final int DAY_MS = 86400000;
    private static final String SYNC_ADMIN = "SyncAdmin";
    private IAuthorityService authorityService;

    public IAuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public void setAuthorityService(IAuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public boolean isValidUser(String userName, String pwd) {
        if (VerifyUtil.isEmpty((String)userName) || VerifyUtil.isEmpty((String)pwd)) {
            logger.error((Object)"The parameter is invalid.", 90160758784001L);
            return false;
        }
        String hql = "FROM UserInfo u where u.userName =?";
        List allUserList = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{userName});
        UserInfo userInfo = null;
        if (null != allUserList && !allUserList.isEmpty()) {
            userInfo = (UserInfo)allUserList.get(0);
        }
        if (null == userInfo) {
            logger.error((Object)"The user or password is incorrect. Name: %s", new Object[]{userName});
            return false;
        }
        if (userInfo.isLock()) {
            logger.error((Object)"The user is locked. Name: %s", new Object[]{userName});
            throw new LegoCheckedException(293L);
        }
        IUserMgrBaseService mgr = (IUserMgrBaseService)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        if (!KmcCompatible.isDataSame((String)pwd, (String)userInfo.getUserPwdSalt(), (String)userInfo.getUserPwd())) {
            logger.error((Object)"The user or password is incorrect. Name: %s", new Object[]{userName});
            return false;
        }
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        if (this.checkChangePolicy(userInfo, usrPolicy)) {
            Date passChangeDate = new Date(userInfo.getSetTime());
            Date date = new Date();
            long betweenDate = (passChangeDate.getTime() - date.getTime()) / 86400000L + (long)usrPolicy.getUsefulLife().intValue();
            if (betweenDate <= 0L && !SYNC_ADMIN.equals(userName)) {
                logger.info((Object)"passwordExpired", 653110169894912L);
                throw new LegoCheckedException(304L, "passwordExpired");
            }
        }
        return true;
    }

    private boolean checkChangePolicy(UserInfo currentUser, UserSecPolicy usrPolicy) {
        return currentUser.getPasswordModel() == 0 && usrPolicy.getUnseal() == 1 && currentUser.getSetTime() > 0L;
    }

    public void checkLock(String userName, String userPwd, boolean modify) {
        this.authorityService.checkLock(userName, userPwd, modify);
    }
}

