/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.syslogj;

import com.huawei.ism.drm.constant.coreenum.SyslogEncryptionModeEnum;
import com.huawei.ism.drm.system.syslogj.SyslogConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.SyslogAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.StringMatchFilter;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;

public class SysLogTcpClient {
    private static final com.huawei.lego.core.sdk.log.Log logger = LogFactory.getInstance(SysLogTcpClient.class);
    private static final String SYSLOG_NAME = SysLogTcpClient.class.getCanonicalName();
    private static final String COMPONENT_NAME = "eReplication";
    private static final int CONNECT_TIMEOUT_MILLIS = 5000;
    private static final int RECONNECT_DELAY_MILLIS = 1000;
    private static Log sysLogClient;
    private SyslogConfig syslogConfig;

    public SysLogTcpClient(LogNotifyServer logServer) {
        this.initSyslogClient(logServer);
    }

    private void initSyslogClient(LogNotifyServer logServer) {
        this.syslogConfig = new SyslogConfig(logServer);
        org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((boolean)false);
        if (context == null || !(context instanceof LoggerContext)) {
            logger.error((Object)"LoggerContext is not supported.");
            throw new LegoCheckedException(0x200909L);
        }
        LoggerContext ctx = (LoggerContext)context;
        Configuration config = ctx.getConfiguration();
        SyslogAppender appender = SysLogTcpClient.buildNewSysLogAppender(config, this.syslogConfig);
        SysLogTcpClient.updateSyslogClient(ctx, config, appender);
    }

    private static SSLContext createSSLContext(String ip, boolean isForceCheckCert) {
        return SysLogTcpClient.createSSLContext(ip, SyslogEncryptionModeEnum.TLS_TCP, isForceCheckCert);
    }

    private static SSLContext createSSLContext(String ip, SyslogEncryptionModeEnum encryptionMode, boolean isForceCheckCert) {
        SSLContext sslContext = null;
        if (SyslogEncryptionModeEnum.TCP.equals((Object)encryptionMode)) {
            return sslContext;
        }
        try {
            sslContext = SSLContext.getInstance(encryptionMode.getProtocol());
            TrustManager[] tms = new TrustManager[]{new BcmX509TrustManager(ip, isForceCheckCert)};
            sslContext.init(null, tms, SecureRandomFactory.getInstanceStrongWithDRBG());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error((Object)"Create ssl context failed!");
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return sslContext;
    }

    public void log(int level, String message) {
        if (sysLogClient == null) {
            logger.error((Object)"The sysLogClient is empty, upload sys logs failed:%s.", new Object[]{message});
            return;
        }
        switch (level) {
            case 4: 
            case 5: {
                sysLogClient.warn((Object)message);
                break;
            }
            case 2: {
                sysLogClient.error((Object)message);
                break;
            }
            default: {
                sysLogClient.info((Object)message);
            }
        }
    }

    public void stop() {
        sysLogClient = null;
    }

    public static void checkConnection(String ip, String port, String encrytionMode) {
        try {
            int intPort = Integer.parseInt(port);
            SysLogTcpClient.checkConnection(ip, intPort, encrytionMode, Boolean.FALSE);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Input port is %s, which is not a legal integer", new Object[]{port});
            throw e;
        }
    }

    public static void checkConnection(String ip, int port, String encrytionMode, boolean isForceCheckCert) {
        SSLContext sslContext = SysLogTcpClient.createSSLContext(encrytionMode, isForceCheckCert);
        if (sslContext == null) {
            logger.error((Object)"Create SSL context failed.");
            throw new LegoCheckedException(-1L);
        }
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        try (Socket server = socketFactory.createSocket();){
            InetSocketAddress address = new InetSocketAddress(ip, port);
            server.connect(address, 5000);
        }
        catch (IOException e) {
            logger.error((Object)"CheckSysLogSeverConnection failed ip: %s, port: %s.", new Object[]{ip, port});
            throw new LegoCheckedException(1073947407L);
        }
    }

    public boolean isAvaliable(boolean isForceCheckCert) {
        boolean available = true;
        try {
            SysLogTcpClient.checkConnection(this.syslogConfig.getServerIp(), this.syslogConfig.getPort(), this.syslogConfig.getEncryptionMode(), isForceCheckCert);
        }
        catch (LegoCheckedException e) {
            available = false;
        }
        return available;
    }

    private static SyslogAppender buildNewSysLogAppender(Configuration config, SyslogConfig syslogConfig) {
        Protocol protocol;
        logger.info((Object)"Update syslog appender.");
        SyslogAppender.Builder builder = ((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)SyslogAppender.newSyslogAppenderBuilder().setName(SYSLOG_NAME)).setAppName(COMPONENT_NAME).setEnterpriseNumber(COMPONENT_NAME).setFacility(Facility.USER).setHost(syslogConfig.getServerIp())).setPort(syslogConfig.getPort())).setCharsetName(StandardCharsets.UTF_8).setFormat("RFC3164").setConnectTimeoutMillis(5000)).setReconnectDelayMillis(1000)).setIgnoreExceptions(false)).setImmediateFlush(true)).setImmediateFail(false)).setFilter((Filter)new StringMatchFilter.Builder().setMatchString("trace_name_cn").build())).setNewLine(true);
        SyslogAppender appender = (SyslogAppender)config.getAppender(SYSLOG_NAME);
        if (appender != null) {
            appender.stop(1L, TimeUnit.MINUTES);
            config.getAppenders().remove(SYSLOG_NAME);
        }
        String encrytionMode = syslogConfig.getEncryptionMode();
        if (SyslogEncryptionModeEnum.TCP.getName().equalsIgnoreCase(encrytionMode)) {
            protocol = Protocol.TCP;
        } else if (SyslogEncryptionModeEnum.SSL_TCP.getName().equalsIgnoreCase(encrytionMode) || SyslogEncryptionModeEnum.TLS_TCP.getName().equalsIgnoreCase(encrytionMode)) {
            protocol = Protocol.SSL;
            SSLContext.setDefault(SysLogTcpClient.createSSLContext(syslogConfig.getServerIp(), Boolean.FALSE));
            SslConfiguration sslConfig = SslConfiguration.createSSLConfiguration((String)protocol.toString(), null, null);
            builder.setSslConfiguration(sslConfig);
        } else {
            logger.error((Object)"EncrytionMode %s is not supported", new Object[]{encrytionMode});
            throw new LegoCheckedException(1073947393L);
        }
        builder.setProtocol(protocol);
        appender = builder.build();
        appender.start();
        return appender;
    }

    private static void updateSyslogClient(LoggerContext ctx, Configuration config, SyslogAppender appender) {
        LoggerConfig logConfig = config.getLoggerConfig(SYSLOG_NAME);
        logConfig.removeAppender(SYSLOG_NAME);
        logConfig.addAppender((Appender)appender, Level.ALL, null);
        logConfig.setAdditive(false);
        config.addLogger(SYSLOG_NAME, logConfig);
        ctx.updateLoggers(config);
        sysLogClient = org.apache.commons.logging.LogFactory.getLog((String)SYSLOG_NAME);
    }
}

